/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public final class FreeRectangularAnchor
extends Anchor {
    private boolean includeBorders;

    public FreeRectangularAnchor(Widget widget, boolean bl) {
        super(widget);
        this.includeBorders = bl;
    }

    @Override
    public Anchor.Result compute(Anchor.Entry entry) {
        float f;
        ConnectionWidget connectionWidget = entry.getAttachedConnectionWidget();
        assert (connectionWidget != null);
        Point point = this.getRelatedSceneLocation();
        Widget widget = this.getRelatedWidget();
        List<Point> list = connectionWidget.getControlPoints();
        Point point2 = list.size() < 2 ? this.getOppositeSceneLocation(entry) : (entry.isAttachedToConnectionSource() ? list.get(1) : list.get(list.size() - 2));
        Rectangle rectangle = widget.getBounds();
        if (!this.includeBorders) {
            Insets insets = widget.getBorder().getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        }
        if ((rectangle = widget.convertLocalToScene(rectangle)).isEmpty() || point.equals(point2)) {
            return (Anchor)this.new Anchor.Result(point, Anchor.DIRECTION_ANY);
        }
        float f2 = point2.x - point.x;
        float f3 = point2.y - point.y;
        float f4 = Math.abs(f2) / (float)rectangle.width;
        Anchor.Direction direction = f4 >= (f = Math.abs(f3) / (float)rectangle.height) ? (f2 >= 0.0f ? Anchor.Direction.RIGHT : Anchor.Direction.LEFT) : (f3 >= 0.0f ? Anchor.Direction.BOTTOM : Anchor.Direction.TOP);
        float f5 = 0.5f / Math.max(f4, f);
        Point point3 = new Point(Math.round((float)point.x + f5 * f2), Math.round((float)point.y + f5 * f3));
        return (Anchor)this.new Anchor.Result(point3, direction);
    }
}

