#include "draw3d.h"
#include "tables.h"
#include "o3d.h"
#include "chess.h"

extern void userAction();
extern u8 reset;
extern GPDRAWSURFACE	gpDraw[2];
extern int				backbuf;

extern Board curboard;

extern void gm_flip();
extern void waitNoKey();

#define SQ_SIZE 24
#define SQ_CENTER 88

const OBJECT3D *objects[2][7] = {
	{
		&chess_PAWN,
		&chess_PAWN,
		&chess_ROOK,
		&chess_BISHOP,
		&chess_QUEEN,
		&chess_KNIGHT,
		&chess_KING
	},
	{
		&chess_PAWN8,
		&chess_PAWN8,
		&chess_ROOK8,
		&chess_BISHOP8,
		&chess_QUEEN8,
		&chess_KNIGHT8,
		&chess_KING8
	}
};

const NODE3D_TYPE obj_types[2][7] = {
	{
		CHESS_PAWN_TYPE,
		CHESS_PAWN_TYPE,
		CHESS_ROOK_TYPE,
		CHESS_BISHOP_TYPE,
		CHESS_QUEEN_TYPE,
		CHESS_KNIGHT_TYPE,
		CHESS_KING_TYPE
	},
	{
		CHESS_PAWN8_TYPE,
		CHESS_PAWN8_TYPE,
		CHESS_ROOK8_TYPE,
		CHESS_BISHOP8_TYPE,
		CHESS_QUEEN8_TYPE,
		CHESS_KNIGHT8_TYPE,
		CHESS_KING8_TYPE
	}
};

SCENE3D myscene,scene;
VECTOR3D *light;
NODE3D *scene_ptr;

NODE3D *nodes[8][8];
NODE3D *squares[8][8];

COLOR3D colBlack = {63,63,159};
COLOR3D colWhite = {159,159,159};
TRIANGLE3D_DATA colWData;
TRIANGLE3D_DATA colBData;

COLOR3D colSBlack = {95,95,127};
COLOR3D colSWhite = {159,159,159};
TRIANGLE3D_DATA colSWData;
TRIANGLE3D_DATA colSBData;

COLOR3D colSel0 = {255,0,0};
COLOR3D colSel1 = {255,255,0};
TRIANGLE3D_DATA colSel0Data;
TRIANGLE3D_DATA colSel1Data;

u16 buffer[SIZE];

u16 *bkgrnd16 = NULL;

u8 firstDraw;

extern u8 pieceSet;

void updateFrame3D(u8 doflip)
{
	gm_memcpy(buffer,bkgrnd16,sizeof(buffer));
	o3d_computeFrame((u16*)buffer);
	if (doflip)
	{
		gm_memcpy(gpDraw[backbuf].ptbuffer,buffer,sizeof(buffer));
		gm_flip();
	}
}

void drawBoard3D(Board b,u8 src,u8 dst)
{
	int i,j,k=56,l=1;

	if (firstDraw)
	{
		scene_ptr->rot.rx = 464;
		firstDraw = 0;
	}
	scene.count = 0;
	for (i=0;i<8;i++)
	{
		for (j=0;j<8;j++)
		{
			u8 p = b->board[k+j],t;
			squares[j][7-i] = o3d_addNode(&scene,&chess_Plane,CHESS_PLANE_TYPE,SQ_CENTER-SQ_SIZE*j,SQ_CENTER-SQ_SIZE*i,0,0,0,0);
			squares[j][7-i]->overload = (k+j==src)?&colSel1Data:((k+j==dst)?&colSel0Data:(l?&colSWData:&colSBData));
			l = 1-l;
			if (p==DEAD)
			{
				nodes[j][7-i] = NULL;
				continue;
			}
			t = b->types[p];
			nodes[j][7-i] = o3d_addNode(&scene,(OBJECT3D*)objects[pieceSet][t],obj_types[pieceSet][t],SQ_CENTER-SQ_SIZE*j-1,SQ_CENTER-SQ_SIZE*i,0,0,0,(COLOR(p)==WHITE)?PRECISION>>1:0);
			nodes[j][7-i]->overload = (COLOR(p)==WHITE)?&colWData:&colBData;
		}
		l=1-l;
		k-=8;
	}
	updateFrame3D(1);
}

void initGfx3D(u8*img,u16*pal,u32 l)
{
	o3d_init(&myscene,1000);
	light = o3d_setLightPos(1000,1000,-700);
	o3d_setLightColor(127,127,127);
	o3d_setGDMin(-1000);
	o3d_setDepths(-1500,500);
	o3d_setShading(FLAT);
	myscene.count = 0;
	colWData.c = &colWhite;
	colBData.c = &colBlack;
	colSWData.c = &colSWhite;
	colSBData.c = &colSBlack;
	colSel0Data.c = &colSel0;
	colSel1Data.c = &colSel1;
	scene_ptr = o3d_addNode(&myscene,&scene,SCENE,0,0,0,0,0,0);
	firstDraw = 1;
	if (bkgrnd16==NULL)
	{
		u32 i;
		bkgrnd16 = gm_malloc(l*sizeof(u16));
		for (i=0;i<l;i++)
			bkgrnd16[i] = pal[img[i]];
	}
}

extern u8 view2d;

u8 selPos3D(u8 src)
{
	int key = 0;
	u16 rx ,ry;
	u8 x=4,y=3,nx=x,ny=y,sx=0,sy=0;
	u8 ret;

	if (src!=DEAD)
	{
		sx = x = nx = COL(src);
		sy = y = ny = 7-ROW(src);
	}
	drawBoard3D(curboard,src,POS(7-y,x));
	while (!(key & (GPC_VK_FA|GPC_VK_FB)))
	{
		key = GpKeyGet();
		if (key & GPC_VK_FL)
		{
			rx = scene_ptr->rot.rx;
			ry = scene_ptr->rot.ry;
			if (key & GPC_VK_LEFT)	ry = (ry+4)&PMASK;
			if (key & GPC_VK_RIGHT)	ry = (ry-4)&PMASK;
			if (key & GPC_VK_UP)	rx = (rx-4)&PMASK;
			if (key & GPC_VK_DOWN)	rx = (rx+4)&PMASK;
			if (rx!=scene_ptr->rot.rx || ry!=scene_ptr->rot.ry)
			{
				scene_ptr->rot.rx = rx;
				scene_ptr->rot.ry = ry;
				drawBoard3D(curboard,src,POS(7-y,x));
			}
		}
		else
		{
			if ((key & GPC_VK_LEFT) && x>0)  nx--;
			if ((key & GPC_VK_RIGHT) && x<7) nx++;
			if ((key & GPC_VK_UP) && y>0)    ny--;
			if ((key & GPC_VK_DOWN) && y<7)  ny++;
			userAction();
			if (reset||view2d)
				return DEAD;
			if (x!=nx||y!=ny)
			{
				x = nx;
				y = ny;
				drawBoard3D(curboard,src,POS(7-y,x));
			}
		}
	}
	ret = (key&GPC_VK_FB)?DEAD:POS(7-y,x);
	while (key & (GPC_VK_FA|GPC_VK_FB))
		key = GpKeyGet();
	return ret;
}

void intro3D()
{
	NODE3D *node0,*node1;
	int key = 0,i;
	int random_idx=0;

	scene.count = 0;
	node0 = o3d_addNode(&scene,&chess_KNIGHTEX,CHESS_KNIGHTEX_TYPE,-192,-10,0,128,0,0);
	node1 = o3d_addNode(&scene,&chess_KNIGHTEX,CHESS_KNIGHTEX_TYPE,192,-10,0,128,0,0);

	for (i=0;i<192 && !(key&GPC_VK_START);i++)
	{
		node0->pos.x+=1;
		node0->rot.rx = (node0->rot.rx+4)&PMASK;
		node0->rot.ry = (node0->rot.ry+4)&PMASK;
		node1->pos.x-=1;
		node1->rot.rx = (node1->rot.rx-4)&PMASK;
		node1->rot.ry = (node1->rot.ry-4)&PMASK;
		updateFrame3D(1);
		key = GpKeyGet();
		random_idx++;
	}
	i = key;
	while (key&GPC_VK_START)
		key = GpKeyGet();
	if (!(i&GPC_VK_START))
	{
		scene.count = 1;
		while (!(key&GPC_VK_START))
		{
			node0->rot.ry = (node0->rot.ry+4)&PMASK;
			updateFrame3D(1);
			key = GpKeyGet();
			if (key&GPC_VK_LEFT)
				node0->rot.rx = (node0->rot.rx+4)&PMASK;
			else if (key&GPC_VK_RIGHT)
				node0->rot.rx = (node0->rot.rx-4)&PMASK;
			if (key&GPC_VK_UP)
				node0->rot.rz = (node0->rot.rz+4)&PMASK;
			else if (key&GPC_VK_DOWN)
				node0->rot.rz = (node0->rot.rz-4)&PMASK;
			random_idx++;
		}
		while (key&GPC_VK_START)
			key = GpKeyGet();
	}
	GpSrand(random_idx);
	scene_ptr->rot.rx = 448;
}

const u8 promos3D[] = {T_QUEEN,T_ROOK,T_BISHOP,T_KNIGHT};

u8 getPromotion3D(Board b,u8 pos)
{
	int key = 0;
	u8 p = 0,i = b->board[pos],np = p;

	drawBoard3D(b,pos,DEAD);
	while (!(key & GPC_VK_FA))
	{
		key = GpKeyGet();
		if ((key & GPC_VK_LEFT)||(key & GPC_VK_UP))
			np = p>0?p-1:3;
		if ((key & GPC_VK_RIGHT) || (key & GPC_VK_DOWN))
			np = p<3?p+1:0;
		userAction();
		if (np!=p)
		{
			p = np;
			b->types[i] = promos3D[p];
			drawBoard3D(b,pos,DEAD);
		}
	}
	waitNoKey();
	return promos3D[p];
}

void animateMove3D(u8 src,u8 dst)
{
/*
	u8 i,sx=COL(src),sy=ROW(src),dx=COL(dst),dy=ROW(dst);
	VECTOR3D *sp = &nodes[sx][sy]->pos;
	VECTOR3D *dp = &squares[dx][dy]->pos;
	for (i=0;i<16;i++)
	{
		sp->z+=4;
		updateFrame3D(1);
	}
	while (sp->x!=dp->x || sp->y!=dp->y)
	{
		if (sp->x>dp->x)
			sp->x-=1;
		if (sp->x<dp->x)
			sp->x+=1;
		if (sp->y>dp->y)
			sp->y-=1;
		if (sp->y<dp->y)
			sp->y+=1;
		updateFrame3D(1);
	}
	for (i=0;i<16;i++)
	{
		sp->z-=4;
		updateFrame3D(1);
	}
*/
	drawBoard3D(curboard,DEAD,DEAD);
}
