#ifndef _O3D_H_
#define _O3D_H_

#define WIDTH	320
#define HEIGHT	240
#define SIZE	(WIDTH*HEIGHT)

#define WIDTH2	160
#define HEIGHT2	120

#define MAX_VERTICES	6000
#define MAX_TRIANGLES	9000
#define MAX_NODES_SCENE	100

#define MAX_STARS	1000

typedef enum
	{
		VAL = 0,
		ROTX,
		ROTY,
		ROTZ,
		ROTXYZ,
		SCALE,
		TRANS,
		IDENT,
		PROJ
	} MATRIX_TYPE;

#define _MATRIX3D(m) int m[16]

typedef int* MATRIX3D;

typedef struct
	{
		int x,y;
	} VECTOR2D;

typedef struct
	{
		int x,y,z;
	} VERTEX3D;

#define VECTOR3D VERTEX3D

typedef enum
	{
		FLAT = 1,
		GOURAUD,
		TEXTURED_F,
		TEXTURED_G,
		COLORED,
		TEXTURED
	} TRIANGLE3D_TYPE;

typedef struct
	{
		unsigned char r,g,b;
	} COLOR3D;

typedef struct Texture3D
	{
		unsigned char	w,h; /* -1 */
		unsigned char	nbc; /* nb colors in pal -1 */
		COLOR3D			*pal;
		unsigned short	*gpal;
		unsigned char	*pix;
		unsigned char	trans;
	} TEXTURE3D;

typedef struct
	{
		unsigned char	x[3];
		unsigned char	y[3];
		TEXTURE3D		*t;
	} TEXTURE3D_DATA;

typedef union
	{
		void			*data;
		COLOR3D			*c;
		TEXTURE3D_DATA	*td;
	} TRIANGLE3D_DATA;

struct Object3D;

typedef struct
	{
		unsigned short	a,b,c;
		TRIANGLE3D_TYPE type;
		TRIANGLE3D_DATA	data;
	} TRIANGLE3D;

typedef struct
	{
		unsigned short	a,b,c;
		TRIANGLE3D		*orig;
	} REFTRI3D;

typedef struct
	{
		unsigned short rx,ry,rz;
	} ROTATION3D;

typedef struct Object3D
	{
		unsigned short	nbv;
		VERTEX3D		*vert;
		VECTOR3D		*vnorm;
		unsigned short	nbt;
		TRIANGLE3D		*tri;
		VECTOR3D		*tnorm;
		VERTEX3D		*bbox;
	} OBJECT3D;

typedef enum
	{
		OBJECT = 0,
		SPRITE,
		SCENE
	} NODE3D_TYPE;

struct Scene3D;

typedef union
	{
		struct Object3D		*o;
		struct Scene3D		*s;
		struct Texture3D	*t;
		void				*n;
	} NODE3D_DATA;

typedef struct
	{
		NODE3D_TYPE	type;
		NODE3D_DATA	data;
		VECTOR3D	pos;
		ROTATION3D	rot;
		_MATRIX3D	(m);
		unsigned char vis;
		TRIANGLE3D_DATA	*overload;
	} NODE3D;

typedef struct Scene3D
	{
		unsigned short	count;
		NODE3D			nodes[MAX_NODES_SCENE];
	} SCENE3D;

/*
 * Public usage
 */

NODE3D*		o3d_init			(SCENE3D*,int);
VECTOR3D*	o3d_setLightPos		(int,int,int);
COLOR3D*	o3d_setLightColor	(unsigned char,unsigned char,unsigned char);
NODE3D* 	o3d_addObject		(SCENE3D*,OBJECT3D*,int,int,int,unsigned short,unsigned short,unsigned short);
NODE3D* 	o3d_addScene		(SCENE3D*,SCENE3D*,int,int,int,unsigned short,unsigned short,unsigned short);
NODE3D*		o3d_addSprite		(SCENE3D*,TEXTURE3D*,int,int,int);
NODE3D* 	o3d_addNode			(SCENE3D*,void*,NODE3D_TYPE,int,int,int,unsigned short,unsigned short,unsigned short);
void		o3d_setGDMin		(int);
void		o3d_setDepths		(int,int);
void 		o3d_computeFrame	(unsigned short *);
void		o3d_initStars		(int,int);
void		o3d_setShading		(TRIANGLE3D_TYPE);

/*
 * Private usage
 */

void initMatrix(MATRIX3D,MATRIX_TYPE,short,short,short);
void initRotTransMatrix(MATRIX3D,ROTATION3D *,VECTOR3D*);
void multiplyMatrix(MATRIX3D,MATRIX3D,MATRIX3D);
void multiplyVector(MATRIX3D,VECTOR3D*,VECTOR3D*);
void normalize(VECTOR3D *);

void transformNode(NODE3D*,MATRIX3D);
void transformVertices(NODE3D*);

int  computeLight(VERTEX3D*,VECTOR3D*n);
void computeLights(unsigned short,unsigned short,int*,int*,int*,COLOR3D*);
void computeColor(int,COLOR3D*,COLOR3D*);
int  determinate(int*,int*,int*);
void drawFlatTriangle(unsigned short,unsigned short,unsigned short,COLOR3D*);
void drawGouraudTriangle(unsigned short,unsigned short,unsigned short,COLOR3D*);
void drawFlatTexturedTriangle(unsigned short,unsigned short,unsigned short,unsigned char,unsigned char,unsigned char,int l,TEXTURE3D_DATA*);
void drawGouraudTexturedTriangle(unsigned short,unsigned short,unsigned short,unsigned char,unsigned char,unsigned char,TEXTURE3D_DATA*);
void drawTriangle(unsigned short);
void line(int,int,int,int,int*);

void showStars();

#endif
