
   #include <mygba.h>

   #include "mode7.h"
   #include "samples.h"
   #include "objects.h"
   #include "tables.c"
   #include "events.c"

   #include "Map/object.pal.c"
   #include "Map/shiphero.raw.c"
   #include "Map/shoot.raw.c"
   #include "Map/shootenemy.raw.c"
   #include "Map/satelitehero.raw.c"
   // enemies //
   #include "Map/mine.raw.c"
   #include "Map/sphere.raw.c"
   #include "Map/killer.raw.c"
   #include "Map/killer2.raw.c"
   #include "Map/planed.raw.c"
   #include "Map/jet.raw.c"
   #include "Map/bigl.raw.c"
   #include "Map/bigr.raw.c"
   #include "Map/bigmid.raw.c"
   #include "Map/rot.raw.c"
   #include "Map/abi.raw.c"
   // smoke //
   #include "Map/smoke.raw.c"
   #include "Map/explosion.raw.c"
   #include "Map/scrap1.raw.c"
   // intro hero //
   #include "Map/shipintro.raw.c"

   #include "Map/bonus.raw.c"



   void SoundPlay( u16 Sound ){
   	unsigned int chandle = 0;
   	kramPlayExt(samples[ Sound ], TRUE, chandle, 8363, 64, 0 );
   	//kramPlay(samples[ Sound ], TRUE, chandle );
   }

   void smokeElapse( ){
      u8 i = smokeMax;
      Tsmoke *pSmoke;
      pSmoke = &smoke[0];
      while (i--){
         if ( pSmoke->exist ){
            pSmoke->X+=pSmoke->dX;
            pSmoke->Y+=pSmoke->dY;
            ham_SetObjXY( pSmoke->sprite, pSmoke->X, pSmoke->Y-bkg.Y );
            if ( ++pSmoke->framePsCnt == pSmoke->framePs ){
               if ( ++pSmoke->frame < pSmoke->frameNo ){
                  pSmoke->framePsCnt = 0;
                  ham_SetObjGfxSlot( pSmoke->sprite, *(pSmoke->pSpriteSlot+pSmoke->frame), pSmoke->palNo );
               } else {
                  pSmoke->exist = FALSE;
                  ham_DeleteObj( pSmoke->sprite );
               }
            }
         }
         pSmoke++;
      }
   }
   void smokeFactory( s16 X, s16 Y, u8 Slot ){
      u8 i = smokeMax;
      Tsmoke *pSmoke;
      pSmoke = &smoke[0];
      const TsmokeFactory *pSlot;
      pSlot = smokeFactoryTable+Slot;
      while (i--){
         if ( !pSmoke->exist ){
            pSmoke->exist = TRUE;
            pSmoke->frame = 0;      // anim frame
            pSmoke->frameOld = 0;   // anim frame old
            pSmoke->framePsCnt = 0; // counter
            pSmoke->X = X + (pSlot->rX>>1) - (rand()%pSlot->rX);
            pSmoke->Y = Y + (pSlot->rY>>1) - (rand()%pSlot->rY);
            pSmoke->dX = pSlot->dX;
            pSmoke->dY = pSlot->dY;
            pSmoke->framePs = pSlot->framePs;
            pSmoke->frameNo = pSlot->frameNo;
            pSmoke->spriteShape = pSlot->spriteShape;
            pSmoke->spriteSize = pSlot->spriteSize;
            pSmoke->pSpriteSlot = pSlot->pSpriteSlot;
            pSmoke->palNo = pSlot->palNo;
            pSmoke->sprite = ham_CreateObjFromGfxSlot( *pSmoke->pSpriteSlot, pSmoke->spriteShape, pSmoke->spriteSize, 0, 0, pSmoke->palNo, 0, 0, 0, 1, 0, 200, 200 );
            break;
         }
         pSmoke++;
      }
   }

   void badShootElapse(void){
      u8 i = badShootMax;
      Tshoot *pBadShoot;
      pBadShoot = &badshoot[0];
      while (i--){
         if ( pBadShoot->exist ){
            // collisions //
            if ( !heroship.hitCnt && abs(heroship.X-pBadShoot->X-8)<4+8 && abs(heroship.Y+bkg.Y-pBadShoot->Y-8)<4+8 ){
               heroship.hitCnt = 4;
               ham_SetObjGfxSlot( heroship.sprite, factory.shipSlot[heroship.frame], 0 );
               pBadShoot->exist = FALSE;
               ham_DeleteObj( pBadShoot->sprite );
               SoundPlay( SAMPLE_HIT );
               return;
            } else {
               // elapse //
               if ( pBadShoot->X < 232 && pBadShoot->X > 0  && pBadShoot->Y-bkg.Y < 152 && pBadShoot->Y-bkg.Y > 0 ){
                  pBadShoot->X+=pBadShoot->dX;
                  pBadShoot->Y+=pBadShoot->dY;
                  ham_SetObjXY( pBadShoot->sprite, pBadShoot->X, pBadShoot->Y-bkg.Y );
               } else {
                  pBadShoot->exist = FALSE;
                  ham_DeleteObj( pBadShoot->sprite );
               }
            }
         }
         pBadShoot++;
      }
   }
   void badShootCreate( s16 X, s16 Y, s8 dX, s8 dY ){
      u8 i = badShootMax;
      Tshoot *pBadShoot;
      pBadShoot = &badshoot[0];
      while (i--){
         if ( !pBadShoot->exist ){
            pBadShoot->exist = TRUE;
            pBadShoot->frame = 0;
            pBadShoot->dX = dX;
            pBadShoot->dY = dY;
            pBadShoot->X = X;
            pBadShoot->Y = Y;// + bkg.Y;
            pBadShoot->sprite = ham_CreateObjFromGfxSlot( factory.enemyshootSlot[0], OBJ_SIZE_8X8, 0, 0, 14, 0, 0, 0, 1, 0, 200, 200);
            //break;
            return;
         }
         pBadShoot++;
      }
   }

   void bonusCreate( s16 X, s16 Y ){
      u8 i = bonusMax;
      Tshoot *pBonus;
      pBonus = &bonus[0];
      while (i--){
         if ( !pBonus->exist ){
            pBonus->exist = TRUE;
            pBonus->frame = (u8)rand()%3;
            pBonus->dX = rand()%256;
            pBonus->X = X;
            pBonus->Y = pBonus->dY = Y;
            pBonus->sprite = ham_CreateObjFromGfxSlot( factory.bonusSlot[pBonus->frame], OBJ_SIZE_16X16, 0, 0, 15, 0, 0, 0, 1, 0, 200, 200);
            return;
         }
         pBonus++;
      }
   }
   void bonusElapse(void){
      u8 i = bonusMax;
      Tshoot *pBonus;
      pBonus = &bonus[0];
      while (i--){
         if ( pBonus->exist ){
            // collisions //
            if ( !heroship.hitCnt && abs(heroship.X-pBonus->X-8)<4+8 && abs(heroship.Y+bkg.Y-pBonus->Y-8)<4+8 ){
               pBonus->exist = FALSE;
               ham_DeleteObj( pBonus->sprite );
               heroShootSetType( pBonus->frame );
               SoundPlay( SAMPLE_BONUS );
               return;
            }

            // elapse //
            if ( pBonus->X < 240 && pBonus->X > -16  && pBonus->Y-bkg.Y < 160 && pBonus->Y-bkg.Y > -16 ){
               pBonus->X-=1;
               pBonus->Y = pBonus->dY+sateliteSinTab[128+pBonus->dX++];
               //pBonus->Y+=pBonus->dY;
               ham_SetObjXY( pBonus->sprite, pBonus->X, pBonus->Y-bkg.Y );
            } else {
               pBonus->exist = FALSE;
               ham_DeleteObj( pBonus->sprite );
            }
         }
         pBonus++;
      }
   }


   void heroShootElapse(void){
      u8 i = heroShootMax;
      Tshoot *pHeroShoot;
      pHeroShoot = &heroshoot[0];
      while (i--){
         if ( pHeroShoot->exist ){
            // collisions //
            u8 j = badMax;
            Tbad *pBad;
            pBad = &bad[0];
            bool bumm = FALSE;
            while (j--){
               if ( pBad->exist ){
                  if ( abs(pHeroShoot->X+4-pBad->X-(pBad->sizeX>>1))<pBad->sizeX>>1 && abs(pHeroShoot->Y+4-pBad->Y-(pBad->sizeY>>1))<pBad->sizeY>>1 ){
                     pHeroShoot->exist = FALSE;
                     ham_DeleteObj( pHeroShoot->sprite );
                     badHit( pBad );
                     bumm = TRUE;
                     break;
                  }
               }
               pBad++;
            }
            if (!bumm){
               // elapse //
               if ( pHeroShoot->X < 232 && pHeroShoot->X > 0  && pHeroShoot->Y-bkg.Y < 152 && pHeroShoot->Y-bkg.Y > 0 ){
                  pHeroShoot->X+=pHeroShoot->dX;
                  pHeroShoot->Y+=pHeroShoot->dY;
                  ham_SetObjXY( pHeroShoot->sprite, pHeroShoot->X, pHeroShoot->Y-bkg.Y );
               } else {
                  pHeroShoot->exist = FALSE;
                  ham_DeleteObj( pHeroShoot->sprite );
               }
            }
         }
         pHeroShoot++;
      }
   }
   void heroShootCreate( s16 X, s16 Y, s8 dX, s8 dY ){
      u8 i = heroShootMax;
      Tshoot *pHeroShoot;
      pHeroShoot = &heroshoot[0];
      while (i--){
         if ( !pHeroShoot->exist ){
            pHeroShoot->exist = TRUE;
            pHeroShoot->frame = 0;
            pHeroShoot->dX = dX;
            pHeroShoot->dY = dY;
            pHeroShoot->X = X;
            pHeroShoot->Y = Y + bkg.Y;
            pHeroShoot->sprite = ham_CreateObjFromGfxSlot( factory.shootSlot[0], OBJ_SIZE_8X8, 0, 0, 14, 0, 0, 0, 1, 0, 200, 200);
            return;
            //break;
         }
         pHeroShoot++;
      }
   }
   void heroShootCreatePower(void){
      if ( !(heroship.shootCnt&7) || !heroship.fireB ){
         heroship.fireB = TRUE;
         heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 0);
         SoundPlay( SAMPLE_SHOOT_POWER );
      }
   }
   void heroShootCreateDouble(void){
      if (!heroship.fireB ){
         heroship.fireB = TRUE;
         heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 0);
         SoundPlay( SAMPLE_SHOOT_DOUBLE );
      } else
      if ( !(heroship.shootCnt&3) ){
         if ( !(heroship.shootCnt&7) ){
            heroShootCreate( heroship.X + 4, heroship.Y-2, 8, 0);
         } else {
            heroShootCreate( heroship.X + 4, heroship.Y-10, 8, 0);
         }
         SoundPlay( SAMPLE_SHOOT_DOUBLE );
      }
   }
   void heroShootCreateWide0(void){
      if ( !(heroship.shootCnt&7)  || !heroship.fireB ){
         heroship.fireB = TRUE;
         if ( !(heroship.shootCnt&15) ){
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 0);
         } else {
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8,-2);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 2);
         }
         SoundPlay( SAMPLE_SHOOT_WIDE );
      }
   }
   void heroShootCreateWide1(void){
      if ( !(heroship.shootCnt&7)  || !heroship.fireB ){
         heroship.fireB = TRUE;
         if ( !(heroship.shootCnt&15) ){
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 0);
         } else {
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8,-2);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 2);
         }
         SoundPlay( SAMPLE_SHOOT_WIDE );
      }
   }
   void heroShootCreateWide2(void){
      if ( !(heroship.shootCnt&7)  || !heroship.fireB ){
         heroship.fireB = TRUE;
         if ( !(heroship.shootCnt&15) ){
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 0);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8,-4);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 4);
         } else {
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8,-2);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 2);
         }
         SoundPlay( SAMPLE_SHOOT_WIDE );
      }
   }
   void heroShootCreateWide3(void){
      if ( !(heroship.shootCnt&7)  || !heroship.fireB ){
         heroship.fireB = TRUE;
         if ( !(heroship.shootCnt&15) ){
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 0);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8,-4);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 4);
         } else {
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8,-2);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 2);
         }
         SoundPlay( SAMPLE_SHOOT_WIDE );
      }
   }
   void heroShootCreateWide4(void){
      if ( !(heroship.shootCnt&7)  || !heroship.fireB ){
         heroship.fireB = TRUE;
         if ( !(heroship.shootCnt&15) ){
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 0);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8,-4);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 4);
         } else {
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8,-2);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 2);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8,-6);
            heroShootCreate( heroship.X + 4, heroship.Y-6, 8, 6);
         }
         SoundPlay( SAMPLE_SHOOT_WIDE );
      }
   }


   void heroShootReset(void){
      // delete all current shots //
      u8 i = heroShootMax;
      Tshoot *pHeroShoot;
      pHeroShoot = &heroshoot[0];
      while (i--){
         if ( pHeroShoot->exist ){
               smokeFactory( pHeroShoot->X, pHeroShoot->Y, SMOKE_SMOKE );
               pHeroShoot->exist = FALSE;
               ham_DeleteObj( pHeroShoot->sprite );
         }
         pHeroShoot++;
      }
   }

   void heroShootPowerUp(void){
      if ( heroship.shootPower < 4 ){
         heroship.shootPower++;
         heroship.shootDamage*=2;
         heroShootReset();
         // reload gfx slot //
         ham_DeleteObjGfx( factory.shootSlot[0] );
         factory.shootSlot[0] = ham_CreateObjGfx( (void *)&shoot_Bitmap[5*heroship.shootType*((8*8)/2)+heroship.shootPower*((8*8)/2)], OBJ_SIZE_8X8, 0 );
         // wide shoot has specific factory //
         if ( heroship.shootType == 2 ){
            if ( heroship.shootPower == 0 ){
               heroship.pheroShootF = heroShootCreateWide0;
            } else
            if ( heroship.shootPower == 1 ){
               heroship.pheroShootF = heroShootCreateWide1;
            } else
            if ( heroship.shootPower == 2 ){
               heroship.pheroShootF = heroShootCreateWide2;
            } else
            if ( heroship.shootPower == 3 ){
               heroship.pheroShootF = heroShootCreateWide3;
            } else
            if ( heroship.shootPower == 4 ){
               heroship.pheroShootF = heroShootCreateWide4;
            }
         }
      }
   }

   void heroShootSetType( u8 type ){
      if (heroship.shootType == type) {
         heroShootPowerUp();
      } else {
         heroship.shootPower = 0;
         heroship.shootType = type;
         heroShootReset();

         // reload gfx slot //
         ham_DeleteObjGfx( factory.shootSlot[0] );
         factory.shootSlot[0] = ham_CreateObjGfx( (void *)&shoot_Bitmap[5*heroship.shootType*((8*8)/2)+heroship.shootPower*((8*8)/2)], OBJ_SIZE_8X8, 0 );

         if ( type == 0 ){   // power type //
            heroship.shootDamage = 3;
            heroship.pheroShootF = heroShootCreatePower;
         } else
         if ( type == 1 ){   // double type //
            heroship.shootDamage = 2;
            heroship.pheroShootF = heroShootCreateDouble;
         } else
         if ( type == 2 ){   // wide type //
            heroship.shootDamage = 1;
            heroship.pheroShootF = heroShootCreateWide0;
         }
      }
   }

   void heroShootInit(void){
      heroship.shootPower = 0;
      heroship.shootType = 0;
      heroShootReset();

      // reload gfx slot //
      ham_DeleteObjGfx( factory.shootSlot[0] );
      factory.shootSlot[0] = ham_CreateObjGfx( (void *)&shoot_Bitmap[5*heroship.shootType*((8*8)/2)+heroship.shootPower*((8*8)/2)], OBJ_SIZE_8X8, 0 );

      heroship.shootDamage = 3;
      heroship.pheroShootF = heroShootCreatePower;
   }



   void badFactory( u16 slot ){
      if (slot == 0) return;
      u8 i = badMax;
      Tbad *pBad;
      pBad = &bad[0];
      const TbadFactory *pSlot;
      pSlot = badFactoryTable+slot;

      while (i--){
         if ( !pBad->exist ){
            pBad->exist = TRUE;
            pBad->visible = TRUE;
            pBad->frame = 0;
            pBad->frameCnt = rand()%256;
            pBad->framePs = pSlot->framePs;
            pBad->framePsCnt = 0;
            pBad->berserk = 0;
            pBad->boss = pSlot->boss;
            pBad->X = pBad->bX = pSlot->X + (pSlot->rX>>1) - (rand()%pSlot->rX);
            pBad->Y = pBad->bY = pSlot->Y + ((pSlot->rY+pSlot->sizeY)>>1) - ((rand()%pSlot->rY)+pSlot->sizeY);
            pBad->dX = pSlot->dX;
            pBad->dY = pSlot->dY;
            pBad->frameNo = pSlot->frameNo;
            pBad->sizeX = pSlot->sizeX;
            pBad->sizeY = pSlot->sizeY;
            pBad->spriteSize = pSlot->spriteSize;
            pBad->spriteShape = pSlot->spriteShape;
            pBad->pSpriteSlot = pSlot->pSpriteSlot;
            pBad->life = pSlot->life;
            pBad->palNo = pSlot->palNo;
            pBad->pBadAnimF = pSlot->pBadAnimF;
            pBad->sprite = ham_CreateObjFromGfxSlot( *pBad->pSpriteSlot, pBad->spriteShape, pBad->spriteSize, 0, 0/*col mode*/, pBad->palNo, 0, 0, 0, 2, 0, 200, 200);

            //if ( abs(120-pBad->X-(pBad->sizeX>>1))<(pBad->sizeX>>1)+121
            //&& abs(80-pBad->Y-(pBad->sizeY>>1))<(pBad->sizeY>>1)+121 ){
            if (pBad->X + pBad->sizeX < 0) pBad->X = -pBad->sizeX;
            if (pBad->X > 240) pBad->X = 240;
            if (pBad->Y + pBad->sizeY < -40) pBad->Y = -40-pBad->sizeY;
            if (pBad->Y > 160+40) pBad->Y = 160+40;

            return;
            //break;
         }
         pBad++;
      }
   }

   void badFactoryAt( u16 slot, s16 X, s16 Y ){
      if (slot == 0) return;
      u8 i = badMax;
      Tbad *pBad;
      pBad = &bad[0];
      const TbadFactory *pSlot;
      pSlot = badFactoryTable+slot;

      while (i--){
         if ( !pBad->exist ){
            pBad->exist = TRUE;
            pBad->visible = TRUE;
            pBad->frame = 0;
            pBad->frameCnt = rand()%256;
            pBad->framePs = pSlot->framePs;
            pBad->framePsCnt = 0;
            pBad->berserk = 0;
            pBad->boss = pSlot->boss;
            pBad->X = pBad->bX = X;//pSlot->X + (pSlot->rX>>1) - (rand()%pSlot->rX);
            pBad->Y = pBad->bY = Y;//pSlot->Y + ((pSlot->rY+pSlot->sizeY)>>1) - ((rand()%pSlot->rY)+pSlot->sizeY);
            pBad->dX = pSlot->dX;
            pBad->dY = pSlot->dY;
            pBad->frameNo = pSlot->frameNo;
            pBad->sizeX = pSlot->sizeX;
            pBad->sizeY = pSlot->sizeY;
            pBad->spriteSize = pSlot->spriteSize;
            pBad->spriteShape = pSlot->spriteShape;
            pBad->pSpriteSlot = pSlot->pSpriteSlot;
            pBad->life = pSlot->life;
            pBad->palNo = pSlot->palNo;
            pBad->pBadAnimF = pSlot->pBadAnimF;
            pBad->sprite = ham_CreateObjFromGfxSlot( *pBad->pSpriteSlot, pBad->spriteShape, pBad->spriteSize, 0, 0/*col mode*/, pBad->palNo, 0, 0, 0, 2, 0, 200, 200);

            //if ( abs(120-pBad->X-(pBad->sizeX>>1))<(pBad->sizeX>>1)+121
            //&& abs(80-pBad->Y-(pBad->sizeY>>1))<(pBad->sizeY>>1)+121 ){

            if (pBad->X + pBad->sizeX < 0) pBad->X = -pBad->sizeX;
            if (pBad->X > 240) pBad->X = 240;
            if (pBad->Y + pBad->sizeY < -40) pBad->Y = -40-pBad->sizeY;
            if (pBad->Y > 160+40) pBad->Y = 160+40;

            return;
            //break;
         }
         pBad++;
      }
   }

   
   void badElapse(void){
      u8 i = badMax;
      Tbad *pBad;
      pBad = &bad[0];
      while (i--){
         if ( pBad->exist ){
            if ( abs(120-pBad->X-(pBad->sizeX>>1))<(pBad->sizeX>>1)+121 && abs(80-pBad->Y-(pBad->sizeY>>1))<(pBad->sizeY>>1)+121 ){
               pBad->pBadAnimF(pBad);
               if ( abs(80+bkg.Y-pBad->Y-(pBad->sizeY>>1))<(pBad->sizeY>>1)+81){
                  if ( !pBad->visible ){
                     pBad->visible = TRUE;
                     ham_SetObjVisible( pBad->sprite, 1 );
                  }
               } else {
                  if ( pBad->visible ){
                     pBad->visible = FALSE;
                     ham_SetObjVisible( pBad->sprite, 0 );
                  }
               }
            } else {
               pBad->exist = FALSE;
               ham_DeleteObj( pBad->sprite );
            }
         }
         pBad++;
      }
   }

   void badHit( Tbad *pBad ){
      pBad->life-=heroship.shootDamage;
      if ( pBad->life > 0 ){
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_REDSMOKE );
         ham_SetObjGfxSlot( pBad->sprite, *(pBad->pSpriteSlot+pBad->frame), 0 );
         SoundPlay( SAMPLE_HIT );
      } else {
         pBad->exist = FALSE;
         ham_DeleteObj( pBad->sprite );
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_EXPLOSION );
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_SCRAPU );
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_SCRAPD );
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_SCRAPL );
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_SCRAPR );
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_SCRAPF );
         SoundPlay( SAMPLE_EXPLOSION );
         heroship.bonusCnt++;
         if (heroship.bonusCnt > 10){
            heroship.bonusCnt = 0;
            bonusCreate(pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8);
         }
      }
   }

   void badHitMax( Tbad *pBad ){
      if (pBad->boss) return;
      pBad->life-=20;
      if ( pBad->life > 0 ){
         ham_SetObjGfxSlot( pBad->sprite, *(pBad->pSpriteSlot+pBad->frame), 0 );
         SoundPlay( SAMPLE_HIT );
      } else {
         pBad->exist = FALSE;
         ham_DeleteObj( pBad->sprite );
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_EXPLOSION );
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_SCRAPU );
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_SCRAPD );
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_SCRAPL );
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_SCRAPR );
         smokeFactory( pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, SMOKE_SCRAPF );
         SoundPlay( SAMPLE_EXPLOSION );
         heroship.bonusCnt++;
      }
   }

   void heroShipInit(void){
      heroship.sprite = ham_CreateObjFromGfxSlot( factory.shipSlot[0*((32*16)/2)], OBJ_SIZE_32X16, 0, 0, 14, 0, 0, 0, 1, 0, 200, 200);
      heroship.sateliteSpriteU = ham_CreateObjFromGfxSlot( factory.sateliteSlot[0], OBJ_SIZE_8X8, 0, 0, 14, 0, 0, 0, 1, 0, 200, 200);
      heroship.sateliteSpriteD = ham_CreateObjFromGfxSlot( factory.sateliteSlot[0], OBJ_SIZE_8X8, 0, 0, 14, 0, 0, 0, 1, 0, 200, 200);
      heroship.X = 80;
      heroship.Y = 80;
      heroship.speedRes = 2;
      heroship.speedMax = 32;
      heroship.bonusCnt = 0;
      ham_SetObjXY( heroship.sprite, heroship.X-16, heroship.Y-8 );
      
      heroship.frame =(heroship.Y>>3)-6+(heroship.speedY>>3);
      if (heroship.frame < 0) heroship.frame = 0;
      if (heroship.frame > 8) heroship.frame = 8;
      heroship.frameOld = heroship.frame;
      ham_SetObjGfxSlot( heroship.sprite, factory.shipSlot[heroship.frame], 14 );
   }
   
   void heroShipPreInit(void){
      heroship.X = 80;
      heroship.Y = 80;
      heroship.introzoom = 0x80;
      bkg.Y = -32;
   }
   
   void heroShipElapse(void){
      if ( heroship.speedX > 0 ) heroship.speedX-=heroship.speedRes;
      else if ( heroship.speedX < 0 ) heroship.speedX+=heroship.speedRes;

      if ( heroship.speedY > 0 ) heroship.speedY-=heroship.speedRes;
      else if ( heroship.speedY < 0 ) heroship.speedY+=heroship.speedRes;

      if (heroship.speedX > heroship.speedMax) heroship.speedX = heroship.speedMax;
      if (heroship.speedX < -heroship.speedMax) heroship.speedX = -heroship.speedMax;

      if (heroship.speedY > heroship.speedMax) heroship.speedY = heroship.speedMax;
      if (heroship.speedY < -heroship.speedMax) heroship.speedY = -heroship.speedMax;

      if (heroship.hitCnt==4){
         heroship.X-=1;
         paletteInit(2);
      }else if (heroship.hitCnt==0){
         paletteInit(0);
      }

      heroship.X+=(heroship.speedX/16);
      heroship.Y+=(heroship.speedY/16);

      if (heroship.Y < 16) heroship.Y = 16;
      if (heroship.Y > 160-16) heroship.Y = 160-16;
      if (heroship.X < 16) heroship.X = 16;
      if (heroship.X > 240-16) heroship.X = 240-16;

      // ship gfx //
      heroship.frame =(heroship.Y>>3)-6+(heroship.speedY>>3);
      if (heroship.frame < 0) heroship.frame = 0;
      if (heroship.frame > 8) heroship.frame = 8;
      if (heroship.frame != heroship.frameOld) {
         heroship.frameOld = heroship.frame;
         ham_SetObjGfxSlot( heroship.sprite, factory.shipSlot[heroship.frame], 14 );
      } else {
         if ( heroship.hitCnt > 0 ){
            heroship.hitCnt--;
         } else {
           ham_SetObjGfxSlot( heroship.sprite, factory.shipSlot[heroship.frame], 14 );
         }
      }
      ham_SetObjXY( heroship.sprite, heroship.X-16, heroship.Y-8 );

      // satelite //
      heroship.sateliteCnt++;
      s16 sX = heroship.X+sateliteCosTab[heroship.sateliteCnt];
      s16 sYU = heroship.Y-28+sateliteSinTab[heroship.sateliteCnt];
      s16 sYD = heroship.Y+20-sateliteSinTab[heroship.sateliteCnt];
      ham_SetObjXY( heroship.sateliteSpriteU, sX, sYU );
      ham_SetObjXY( heroship.sateliteSpriteD, sX, sYD );
      sYU+=bkg.Y;
      sYD+=bkg.Y;

      // collisions //
      u8 j = badMax;
      Tbad *pBad;
      pBad = &bad[0];
      while (j--){
         if ( pBad->exist ){
            if ( abs(sX+4-pBad->X-(pBad->sizeX>>1))<pBad->sizeX>>1 && (abs(sYU+4-pBad->Y-(pBad->sizeY>>1))<pBad->sizeY>>1 || abs(sYD+4-pBad->Y-(pBad->sizeY>>1))<pBad->sizeY>>1) ){
               badHitMax( pBad );
            } else if ( !heroship.hitCnt && abs(heroship.X-pBad->X-(pBad->sizeX>>1))<(pBad->sizeX>>1)+8 && abs(heroship.Y+bkg.Y-pBad->Y-(pBad->sizeY>>1))<(pBad->sizeY>>1)+8 ){
               heroship.hitCnt = 4;
               ham_SetObjGfxSlot( heroship.sprite, factory.shipSlot[heroship.frame], 0 );
               badHitMax( pBad );
            }
         }
         pBad++;
      }
      if ( !(g_FrameCnt&3) ) smokeFactory( heroship.X - 8, heroship.Y - 6 + bkg.Y, SMOKE_SMOKE );
   }

   void factoryInit(void){
      ham_LoadObjPal((void *)&object_Palette, SIZEOF_16BIT(object_Palette));

      u8 i;
      for (i=0; i<shipSlotMax; i++) factory.shipSlot[i] = ham_CreateObjGfx( (void *)&shiphero_Bitmap[i*((32*16)/2)], OBJ_SIZE_32X16, 0 );
      for (i=0; i<sateliteSlotMax; i++) factory.sateliteSlot[i] = ham_CreateObjGfx( (void *)&satelitehero_Bitmap[i*((8*8)/2)], OBJ_SIZE_8X8, 0 );

      for ( i=0; i<badSlot1Max; i++ ) factory.badSlot1[i] = ham_CreateObjGfx( (void *)&mine_Bitmap[i*((32*32)/2)], OBJ_SIZE_32X32, 0 );
      for ( i=0; i<badSlot2Max; i++ ) factory.badSlot2[i] = ham_CreateObjGfx( (void *)&sphere_Bitmap[i*((16*16)/2)], OBJ_SIZE_16X16, 0 );
      for ( i=0; i<badSlot3Max; i++ ) factory.badSlot3[i] = ham_CreateObjGfx( (void *)&killer_Bitmap[i*((32*16)/2)], OBJ_SIZE_32X16, 0 );
      for ( i=0; i<badSlot4Max; i++ ) factory.badSlot4[i] = ham_CreateObjGfx( (void *)&planed_Bitmap[i*((16*16)/2)], OBJ_SIZE_16X16, 0 );
      for ( i=0; i<badSlot5Max; i++ ) factory.badSlot5[i] = ham_CreateObjGfx( (void *)&killer2_Bitmap[i*((32*16)/2)], OBJ_SIZE_32X16, 0 );
      for ( i=0; i<badSlot6Max; i++ ) factory.badSlot6[i] = ham_CreateObjGfx( (void *)&jet_Bitmap[i*((32*8)/2)], OBJ_SIZE_32X8, 0 );
      for ( i=0; i<badSlot7Max; i++ ) factory.badSlot7[i] = ham_CreateObjGfx( (void *)&bigl_Bitmap[i*((32*32)/2)], OBJ_SIZE_32X32, 0 );
      for ( i=0; i<badSlot8Max; i++ ) factory.badSlot8[i] = ham_CreateObjGfx( (void *)&bigr_Bitmap[i*((32*32)/2)], OBJ_SIZE_32X32, 0 );
      for ( i=0; i<badSlot9Max; i++ ) factory.badSlot9[i] = ham_CreateObjGfx( (void *)&bigmid_Bitmap[i*((16*16)/2)], OBJ_SIZE_16X16, 0 );
      for ( i=0; i<badSlot10Max; i++ ) factory.badSlot10[i] = ham_CreateObjGfx( (void *)&rot_Bitmap[i*((32*32)/2)], OBJ_SIZE_32X32, 0 );
      for ( i=0; i<badSlot11Max; i++ ) factory.badSlot11[i] = ham_CreateObjGfx( (void *)&abi_Bitmap[i*((32*32)/2)], OBJ_SIZE_32X32, 0 );

      // smoke //
      for (i=0; i<smokeSlotMax; i++) factory.smokeSlot[i] = ham_CreateObjGfx( (void *)&smoke_Bitmap[i*((8*8)/2)], OBJ_SIZE_8X8, 0 );
      for (i=0; i<explosionSlotMax; i++) factory.explosionSlot[i] = ham_CreateObjGfx( (void *)&explosion_Bitmap[i*((32*16)/2)], OBJ_SIZE_32X16, 0 );
      for (i=0; i<scrapSlotMax; i++) factory.scrapSlot[i] = ham_CreateObjGfx( (void *)&scrap1_Bitmap[i*((8*8)/2)], OBJ_SIZE_8X8, 0 );

      for ( i=0; i<bonusSlotMax; i++ ) factory.bonusSlot[i] = ham_CreateObjGfx( (void *)&bonus_Bitmap[i*((16*16)/2)], OBJ_SIZE_16X16, 0 );

      factory.shootSlot[0] = ham_CreateObjGfx( (void *)&shoot_Bitmap[0*8*8], OBJ_SIZE_8X8, 0 );
      factory.enemyshootSlot[0] = ham_CreateObjGfx( (void *)&shootenemy_Bitmap[0*8*8], OBJ_SIZE_8X8, 0 );

      heroship.pheroShootF = heroShootCreatePower;
   }

   void shipIntroInit(void){
      ham_LoadObjPal((void *)&object_Palette, SIZEOF_16BIT(object_Palette));
      heroship.introsprite = ham_CreateObj((void *)&shipintro_Bitmap[0], 1, 3, OBJ_MODE_SEMITRANSPARENT, 0, 14, 0, 0, 0, 1, 1, 200, 200);
      ham_SetObjRotEnable(heroship.introsprite, 1);
      ham_SetObjRotSetSelect(heroship.introsprite, 3);
      ham_RotObjDefineSet(3, 0, heroship.introzoom, heroship.introzoom);
      ham_SetObjXY( heroship.introsprite, heroship.X-16-32-16, heroship.Y-8-16-8 );
      ham_SetFxMode(FX_LAYER_SELECT(0,0,0,0,1,0), FX_LAYER_SELECT(0,0,1,1,0,0), FX_MODE_ALPHABLEND);
      u8  g_EffectValueA=0;
      ham_SetFxAlphaLevel(g_EffectValueA, 16-g_EffectValueA);
   }
   void shipIntroDeInit(void){
      ham_DeleteObj(heroship.introsprite);
   }

   u8 shipIntroElapse(void){
      bool gameState = TRUE;
      heroship.introzoom+=10;
      u8  g_EffectValueA=heroship.introzoom>>5;
      if (heroship.introzoom > 0x200){ heroship.introzoom = 0x200; gameState = FALSE; }
      ham_RotObjDefineSet(3, 0, heroship.introzoom, heroship.introzoom);
      ham_SetObjXY( heroship.introsprite, heroship.X-16-32-16, heroship.Y-8-16-8 );
      ham_SetFxAlphaLevel(g_EffectValueA, 16-g_EffectValueA);
      if (bkg.Y< 0) bkg.Y++;
      return gameState;
   }

   // events - wave Factory //
   bool eventFactory(){

         // make bad //
         if ( bkg.waveTime > 0 ){   // no of enemies
            if ( bkg.waveRatio > 0 ){
               bkg.waveRatio--;
            } else {
               bkg.waveRatio = events[bkg.waveSlot].ratio;
               bkg.waveTime--;
               badFactory( events[bkg.waveSlot].enemy );
            }
         }

         // move slot //
         if ( bkg.waveCurMark == bkg.waveMarkPlace ){
            bkg.waveSlot++;
            badFactory(events[bkg.waveSlot].enemy);
            bkg.waveMarkPlace = events[bkg.waveSlot+1].mark;
            bkg.waveTime = events[bkg.waveSlot].time;
            bkg.waveRatio = events[bkg.waveSlot].ratio;
         }

         if (bkg.waveCurMark < 13000) return TRUE;
         else return FALSE;
   }



/////////////////// beh ///////
   void badAnimDelta( Tbad *pBad ){
      pBad->X+=pBad->dX;
      pBad->Y+=pBad->dY;
      ham_SetObjXY( pBad->sprite, pBad->X, pBad->Y-bkg.Y);
      if ( ++pBad->framePsCnt == pBad->framePs ){
         pBad->framePsCnt = 0;
         pBad->frame++;
         pBad->frame%=pBad->frameNo;
         ham_SetObjGfxSlot( pBad->sprite, *(pBad->pSpriteSlot+pBad->frame), pBad->palNo );
      }
   }

   void badAnimDeltaAbi( Tbad *pBad ){
      pBad->X+=pBad->dX;
      pBad->Y+=pBad->dY;
      
      if ( !(g_FrameCnt&16) ){
         badShootCreate( pBad->X -2, pBad->Y , -8, 0);
         badShootCreate( pBad->X -2, pBad->Y +24, -8, 0);
      }
      if ( !(g_FrameCnt&15) ){
         SoundPlay( SAMPLE_SHOOT_ENEMY );
      }
      
      if ( !(g_FrameCnt&3) ){
         smokeFactory( pBad->X + 28, pBad->Y + 2, SMOKE_SLOW );
         smokeFactory( pBad->X + 28, pBad->Y +22, SMOKE_SLOW );
      }

      ham_SetObjXY( pBad->sprite, pBad->X, pBad->Y-bkg.Y);
      if ( ++pBad->framePsCnt == pBad->framePs ){
         pBad->framePsCnt = 0;
         pBad->frame++;
         pBad->frame%=pBad->frameNo;
         ham_SetObjGfxSlot( pBad->sprite, *(pBad->pSpriteSlot+pBad->frame), pBad->palNo );
      }
   }


   void badAnimDeltaSlow( Tbad *pBad ){
      if (!(g_FrameCnt&3)){
         pBad->X+=pBad->dX;
         pBad->Y+=pBad->dY;
      }
      ham_SetObjXY( pBad->sprite, pBad->X, pBad->Y-bkg.Y);
      if ( ++pBad->framePsCnt == pBad->framePs ){
         pBad->framePsCnt = 0;
         pBad->frame++;
         pBad->frame%=pBad->frameNo;
         ham_SetObjGfxSlot( pBad->sprite, *(pBad->pSpriteSlot+pBad->frame), pBad->palNo );
      }
   }

   void badAnimDeltaSlowMaker( Tbad *pBad ){
      if (!(g_FrameCnt&3)){
         pBad->X+=pBad->dX;
         pBad->Y+=pBad->dY;
      }
      if (!(g_FrameCnt&127)){
         badFactoryAt(14, pBad->X, pBad->Y);
      }
      ham_SetObjXY( pBad->sprite, pBad->X, pBad->Y-bkg.Y);
      if ( ++pBad->framePsCnt == pBad->framePs ){
         pBad->framePsCnt = 0;
         pBad->frame++;
         pBad->frame%=pBad->frameNo;
         ham_SetObjGfxSlot( pBad->sprite, *(pBad->pSpriteSlot+pBad->frame), pBad->palNo );
      }
   }

   void badAnimFloatX( Tbad *pBad ){
      if (!(g_FrameCnt&3)){
         pBad->bX+= pBad->dX; // tylk
      }
      pBad->X = pBad->bX+sateliteSinTab[pBad->frameCnt++];
      pBad->Y+= pBad->dY;
      ham_SetObjXY( pBad->sprite, pBad->X, pBad->Y-bkg.Y);
      if ( ++pBad->framePsCnt == pBad->framePs ){
         pBad->framePsCnt = 0;
         pBad->frame++;
         pBad->frame%=pBad->frameNo;
         ham_SetObjGfxSlot( pBad->sprite, *(pBad->pSpriteSlot+pBad->frame), pBad->palNo );
      }
   }

   void badAnimFloatY( Tbad *pBad ){
      pBad->X+= pBad->dX;
      if (!(g_FrameCnt&3)){
         pBad->bY+= pBad->dY; // tylk
      }
      pBad->Y = pBad->bY+sateliteSinTab[pBad->frameCnt++];
      ham_SetObjXY( pBad->sprite, pBad->X, pBad->Y-bkg.Y);
      if ( ++pBad->framePsCnt == pBad->framePs ){
         pBad->framePsCnt = 0;
         pBad->frame++;
         pBad->frame%=pBad->frameNo;
         ham_SetObjGfxSlot( pBad->sprite, *(pBad->pSpriteSlot+pBad->frame), pBad->palNo );
      }
   }

   void badAnimFloatYShoot( Tbad *pBad ){
      if (!(g_FrameCnt&3)){
         pBad->X+= pBad->dX;
         pBad->bY+= pBad->dY; // tylk
      }
      if (pBad->berserk-- <= 0){
         badShootCreate(pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, -2, 0);
         badShootCreate(pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8,  2, 0);
         badShootCreate(pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8,  0,-2);
         badShootCreate(pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8,  0, 2);
         badShootCreate(pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, -2,-2);
         badShootCreate(pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, -2, 2);
         badShootCreate(pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8,  2,-2);
         badShootCreate(pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8,  2, 2);
         SoundPlay( SAMPLE_SHOOT_ENEMY );
         pBad->berserk = 31;
      }
      
      pBad->Y = pBad->bY+sateliteSinTab[pBad->frameCnt++];
      ham_SetObjXY( pBad->sprite, pBad->X, pBad->Y-bkg.Y);
      if ( ++pBad->framePsCnt == pBad->framePs ){
         pBad->framePsCnt = 0;
         pBad->frame++;
         pBad->frame%=pBad->frameNo;
         ham_SetObjGfxSlot( pBad->sprite, *(pBad->pSpriteSlot+pBad->frame), pBad->palNo );
      }
   }


   void badAnimFlyDown( Tbad *pBad ){
      //pBad->X+=pBad->dX;
      pBad->X = pBad->bX+sateliteSinTab[(pBad->frameCnt++)>>1];
      pBad->Y+= pBad->dY;
      ham_SetObjXY( pBad->sprite, pBad->X, pBad->Y-bkg.Y);
      if ( ++pBad->framePsCnt == pBad->framePs ){
         pBad->framePsCnt = 0;
         pBad->frame++;
         pBad->frame%=pBad->frameNo;
         ham_SetObjGfxSlot( pBad->sprite, *(pBad->pSpriteSlot+pBad->frame), pBad->palNo );
      }
   }

   void badAnimKiller( Tbad *pBad ){
      if (pBad->berserk == 0){
         pBad->X-=1;
         if (abs(heroship.Y+bkg.Y-pBad->Y-(pBad->sizeY>>1))<(pBad->sizeY>>1)+8 ){
            pBad->berserk = 1;
            SoundPlay( SAMPLE_FLY );
         }
      } else {
         if ( !(g_FrameCnt&3) ) smokeFactory( pBad->X + 32, pBad->Y + 4, SMOKE_SMOKE );
         pBad->X+=pBad->dX;
      }
      pBad->Y+=pBad->dY;
      ham_SetObjXY( pBad->sprite, pBad->X, pBad->Y-bkg.Y);
      if ( ++pBad->framePsCnt == pBad->framePs ){
         pBad->framePsCnt = 0;
         pBad->frame++;
         pBad->frame%=pBad->frameNo;
         ham_SetObjGfxSlot( pBad->sprite, *(pBad->pSpriteSlot+pBad->frame), pBad->palNo );
      }
   }

   void badAnimKillerShoot( Tbad *pBad ){
      if (pBad->berserk == 0){
         pBad->X+=pBad->dX;
         if (abs(heroship.Y+bkg.Y-pBad->Y-(pBad->sizeY>>1))<(pBad->sizeY>>1)+8 ){
            pBad->berserk++;
            badShootCreate(pBad->X+(pBad->sizeX>>1)-8, pBad->Y+(pBad->sizeY>>1)-8, -2, 0);
            SoundPlay( SAMPLE_SHOOT_ENEMY );
         }
      } else {
         pBad->X+=pBad->dX;
            pBad->berserk++;
            if (pBad->berserk > 10) pBad->berserk = 0;
      }
      pBad->Y+=pBad->dY;
      ham_SetObjXY( pBad->sprite, pBad->X, pBad->Y-bkg.Y);
      if ( ++pBad->framePsCnt == pBad->framePs ){
         pBad->framePsCnt = 0;
         pBad->frame++;
         pBad->frame%=pBad->frameNo;
         ham_SetObjGfxSlot( pBad->sprite, *(pBad->pSpriteSlot+pBad->frame), pBad->palNo );
      }
   }



