//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using


namespace Framefield.Core.ID727de282_bae4_4a11_a180_bf3dcac63d15
{
    public class Class_BlendState : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            BlendEnabled = 1,
            SrcBlend = 2,
            DestBlend = 3,
            BlendOp = 4,
            SrcBlendAlpha = 5,
            DestBlendAlpha = 6,
            BlendOpAlpha = 7,
            RenderTargetWriteMask = 8,
            AlphaToCoverageEnable = 9,
            BlendFactorR = 10,
            BlendFactorG = 11,
            BlendFactorB = 12,
            BlendFactorA = 13
        }
        //<<< _inputids

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _blendState);
            base.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            var BlendEnabled = (int) inputs[(int)InputId.BlendEnabled].Eval(context).Value;
            var SrcBlend = (int) inputs[(int)InputId.SrcBlend].Eval(context).Value;
            var DestBlend = (int) inputs[(int)InputId.DestBlend].Eval(context).Value;
            var BlendOp = (int) inputs[(int)InputId.BlendOp].Eval(context).Value;
            var SrcBlendAlpha = (int) inputs[(int)InputId.SrcBlendAlpha].Eval(context).Value;
            var DestBlendAlpha = (int) inputs[(int)InputId.DestBlendAlpha].Eval(context).Value;
            var BlendOpAlpha = (int) inputs[(int)InputId.BlendOpAlpha].Eval(context).Value;
            var RenderTargetWriteMask = inputs[(int)InputId.RenderTargetWriteMask].Eval(context).Value;
            var AlphaToCoverageEnable = (int) inputs[(int)InputId.AlphaToCoverageEnable].Eval(context).Value;
            var BlendFactorR = inputs[(int)InputId.BlendFactorR].Eval(context).Value;
            var BlendFactorG = inputs[(int)InputId.BlendFactorG].Eval(context).Value;
            var BlendFactorB = inputs[(int)InputId.BlendFactorB].Eval(context).Value;
            var BlendFactorA = inputs[(int)InputId.BlendFactorA].Eval(context).Value;
            var BlendFactor = new Color4(BlendFactorR, BlendFactorG, BlendFactorB, BlendFactorA);
            //<<< _params

            if (Changed)
            {
                var blendDescription = new BlendStateDescription();

                blendDescription.RenderTarget[0].IsBlendEnabled = BlendEnabled > 0.5f ? true : false;
                blendDescription.RenderTarget[0].SourceBlend = (BlendOption)SrcBlend;
                blendDescription.RenderTarget[0].DestinationBlend = (BlendOption)DestBlend;
                blendDescription.RenderTarget[0].BlendOperation = (BlendOperation)BlendOp;
                blendDescription.RenderTarget[0].SourceAlphaBlend = (BlendOption)SrcBlendAlpha;
                blendDescription.RenderTarget[0].DestinationAlphaBlend = (BlendOption)DestBlendAlpha;
                blendDescription.RenderTarget[0].AlphaBlendOperation = (BlendOperation)BlendOpAlpha;
                blendDescription.RenderTarget[0].RenderTargetWriteMask = ColorWriteMaskFlags.All;
                //blendDescription.IsAlphaToCoverageEnabled = AlphaToCoverageEnable > 0.5f ? true : false;

                Utilities.DisposeObj(ref _blendState);
                _blendState = new BlendState(context.D3DDevice, blendDescription);
                _blendFactor = BlendFactor;
                Changed = false;
            }

            var prevBlendState = context.BlendState;
            var prevBlendFactor = context.BlendFactor;
            context.BlendState = _blendState;
            context.BlendFactor = _blendFactor;

            SceneInput.Eval(context);

            context.BlendState = prevBlendState;
            context.BlendFactor = prevBlendFactor;

            return context;
        }

        private BlendState _blendState;
        private Color4 _blendFactor;
    }
}
