//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID44ebd8a7_1ccd_403a_af14_d5be95a6dc1f
{
    public class Class_ChromaticAberration : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image1 = 1,
            Radius = 2,
            SizeX = 3,
            SizeY = 4,
            SampleCount = 5
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image1 = inputs[(int)InputId.Image1].Eval(context).Image; // Needs to be checked for null!
            var Radius = inputs[(int)InputId.Radius].Eval(context).Value;
            var SizeX = inputs[(int)InputId.SizeX].Eval(context).Value;
            var SizeY = inputs[(int)InputId.SizeY].Eval(context).Value;
            var Size = new Vector2(SizeX, SizeY);
            var SampleCount = inputs[(int)InputId.SampleCount].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var Image1View = new ShaderResourceView(context.D3DDevice, Image1))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image1").AsShaderResource().SetResource(Image1View);
                    _effect.GetVariableByName("Radius").AsScalar().Set(Radius);
                    _effect.GetVariableByName("Size").AsVector().Set(new Vector2(SizeX, SizeY));
                    _effect.GetVariableByName("SampleCount").AsScalar().Set(SampleCount);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

