; Procedury obsługi przerwań niemaskowalnych w trybie IM 1
; W przerwaniu ramki ustawiana jest paleta dla napisów



				ORG 56				; stały adres procedury obsługi przerwań niemaskowalnych dla trybu IM 1
				PUSH AF				; zamapiętanie na stosie tylko tych rejestrów, które są wykorzystywane przed rozgałęzieniem procedury
				PUSH BC				; w zależności od typu przerwania
				IN A,(lineint)		; sprawdzenie typu przerwania
				LD (int_type),A		; zapamiętanie go w zmiennej
				BIT 0,A				; sprawdzenie bitu 0 - jeżeli bit 0 = 0, to przerwanie linii
	skok_int:	JP Z,line_int0		; skok do przerwania linii - adres modyfikowany dynamicznie. 

; --------------- frameint ---------------
frame_int:
				LD A,0				; kolor tła, zmieniany przez głowny program
				LD BC,clut
				OUT (c),A			; ustawienie koloru tła (koloru nr 0)
	ekran_gora:	LD A,96+30			; przełączenie się na ekran główny, na początku jest to ekran SCREEN 1 z BASIC-a
				OUT (vmpr),A		; później, po wyczyszczeniu strony 0, przełączy się na ekran w banku 0
	linia_gora:	LD A,200			; numer linii do wywołania przerwania linii. jeżeli >191, to przerwanie linii wyłączone
				OUT (lineint),A		; na początku jest wyłaczone, później ten numer będzie zmienny
				PUSH DE				; zapamiętanie wszystkich pozostałych, używanych przez procedurę rejestrów
				PUSH HL
				EXX
				EX AF,AF'
				PUSH AF
				PUSH BC
				PUSH DE
				PUSH HL
	muzyka:		NOP					; wywołanie muzyki (tylko wtedy, gdy ma grać. jak nie, to NOP-y)
				NOP
				NOP
				POP HL				; przywrócenie wartości wszystkich rejestrów
				POP DE
				POP BC
                POP AF
				EXX
				EX AF,AF'
				POP HL
				POP DE
				POP BC
                POP AF
                EI
                RETI
			
; --------------- lineint ---------------				
line_int1:		; procedura obsługi przerwania linii dla górnej białej kreski
				PUSH HL				; dodatkowo wykorzystujemy tylko rejestr HL, trzeba go zapamiętać
				LD HL,line_int2		; następne przerwanie linii ma skoczyć do procedury dotyczącej dolnej linii
				LD (skok_int+1),HL
				LD B,12				; opóźnienie o dobraną eksperymentalnie ilość taktów procesora		
				DJNZ $				; aby zmienić kolor dokładnie na początku następnej linii
				NOP
	linia_dol:	LD A,22+66			; wartość zmienna - linia, w której będzie wywołane następne przerwanie linii, czyli dolna linia
				OUT (lineint),A
				LD A,127			; ustawienie koloru 0 na biały
				LD BC,clut
				OUT (c),A
				LD B,22				; opóźnienie w celu przesunięcia się o jedną linię
				DJNZ $
				XOR A				; ustawienie koloru tła na czarny (kolor 0 na 0)
				OUT (c),A
	nr_ekranu:	LD A,16+96			; przełączenie się na ekran o odpowiednim numerze, 96 = MODE 4 
				OUT (vmpr),A
				ADD A,2				; ustawienie kolejnego ekranu, czyli o numerze o 2 większym
				AND 31
				OR 16+96
				LD (nr_ekranu+1),A
				POP HL				
				JP wyj_int
line_int2:		; procedura obsługi przerwania linii dla dolnej białej kreski
				PUSH HL				; dodatkowo wykorzystujemy tylko rejestr HL, trzeba go zapamiętać
				LD HL,line_int1		; następne przerwanie linii ma skoczyć do procedury dotyczącej górnej linii
				LD (skok_int+1),HL
				LD B,11				; opóźnienie o dobraną eksperymentalnie ilość taktów procesora	
				DJNZ $				; aby zmienić kolor dokładnie na początku następnej linii
				LD A,96				; przełączenie się na ekran w banku 0, czyli na napis vs THE EMPIRE
				OUT (vmpr),A
				LD A,127			; ustawienie koloru tła na biały (kolor poziomej kreski)
				LD BC,clut
				OUT (c),A
				LD B,22				; opóźnienie w celu przesunięcia się o jedną linię				
				DJNZ $
				LD A,kolor_tla		; ustawienie koloru tła na kolor_tła (ciemny niebieski)
				OUT (c),A
				POP HL
				JP wyj_int
line_int0:		; procedura obsługi przerwania linii dla jednej grubej linii na środku ekranu
				LD B,19		; opóźnienie o dobraną eksperymentalnie ilość taktów procesora
				DJNZ $		; aby zmienić kolor dokładnie na początku następnej linii
				LD A,127	; ustawienie koloru 0 na biały
				LD BC,clut
				OUT (c),A
				LD B,46		; opóźnienie w celu przesunięcia się o dwie linię
				DJNZ $		
				LD A,kolor_tla	; ustawienie z powrotem koloru tła (ciemny niebieski)
				OUT (c),A
	wyj_int:
				POP BC
                POP  AF
                EI
                RETI

int_type:		DEFB 0		; zmienna zapamiętująca typ ostatnio wywołanego przerwania niemaskowalnego
