#version 300 es
#ifdef GL_ES
precision mediump float;
#endif
uniform vec2 u_resolution;
uniform vec4 u_mouse;
uniform float u_time;
uniform sampler2D audioSampler;
uniform sampler2D u_credits0;
uniform sampler2D u_credits1;
#define MAX_STEPS 100
#define SURFACE_DIST 0.001
#define MAX_DIST 100.0
#define PI 3.1415926535897932384626433832795

float t;
// Probably something better exists... but should be OK for now, overflow bit magic...
float hash( in ivec2 q )
{
    int n = q.x*131 + q.y*57;
    n = (n << 13) ^ n;
    n = n * (n * n * 15731 + 789221) + 1376312589;
    return float((n>>8)&0x007fffff)/float(0x007fffff);
}
// Periodic value noise, domain aligned
float noise( in vec2 x, in int p )
{
    ivec2 i = ivec2(floor(x));
     vec2 f =       fract(x);
    
    f = f*f*(3.0-2.0*f);
    
    return mix(mix( hash((i+ivec2(0,0))&(p-1)), 
                    hash((i+ivec2(1,0))&(p-1)),f.x),
               mix( hash((i+ivec2(0,1))&(p-1)), 
                    hash((i+ivec2(1,1))&(p-1)),f.x),f.y);
}
// calculate fractal noise
float fbm( in vec2 x, in int p )
{
    float f = 0.0;
    float s = 0.5;
    for( int i=0; i<9; i++ )
    {
        f += s*noise( x, p );
        s *= 0.5;
        x *= 2.0;
        p *= 2;
    }
    return f/1.9;
}


mat2 Rot2d(float a) {
  float s = sin(a);
  float c = cos(a);
  return mat2(c, - s, s, c);
}

vec3 TransformCube(vec3 p, float t){
  p.xy *= Rot2d(t);
  p.zy *= Rot2d(t);
  return p;
}

float differenceSdf(float a, float b){
  return max(a,-b);
}

float intersectSdf(float a, float b){
  return max(a, b);
}

float unionSdf(float a, float b){
  return min(a, b);
}

float sdSphere(vec3 p, vec4 sphere) {
  return length(p - sphere.xyz) - sphere.w;
}

float sdBox(vec3 p, vec3 box) {
  p = abs(p) - box;
  return length(max(p, 0.0)) + min(max(p.x, max(p.y, p.z)), 0.0);
}

float sdGyroid(vec3 p, float scale, float thickness, float bias) {
  p *= scale;
  return abs(dot(sin(p), cos(p.zxy)) + bias) / scale - thickness;
}

float sdAAPlane(vec3 p){
  return p.y;
}
//
vec3 Transform(vec3 p) {
  return p;
}

float GetDistScape(vec3 p) {
  p.z += u_time * .1;
  float d = sdAAPlane(p + vec3(0, -.1, 0));
  float d2 = sdAAPlane(vec3(p.x, p.y-2.0, p.z));
  d += pow(sin(p.x)+cos(p.z),3.)*.09;
  d -= fbm(p.xz/6., 5)*6.2;
  d2 -= fbm(p.xz,8)*0.2;
  d2 -= fbm(p.xz,16)*0.1;
  return min(d, d2)*.8;
}

float GetDist(vec3 p, int scene){
  float d = 0.0001;
  if(scene == 0){
    d = sdBox(p, vec3(1.5))-.075;
  }
  if(scene == 1){
    return GetDistScape(p);
  }
  return d;
}

vec3 GetNormal(vec3 p, int scene) {
  vec2 e = vec2(0.02, 0);
  float d = GetDist(p, scene);
  vec3 n = d-vec3(GetDist(p - e.xyy, scene), GetDist(p - e.yxy, scene), GetDist(p - e.yyx, scene));
  return normalize(n);
}

vec3 GetRayDir(vec2 uv, vec3 p, vec3 l, float z) {
  vec3 f = normalize(l - p),
  r = normalize(cross(vec3(0, 1, 0), f)),
  u = cross(f, r),
  c = p+f * z,
  i = c+uv.x * r+uv.y * u,
  d = normalize(i - p);
  return d;
}

float RayMarch(vec3 ro, vec3 rd, float t, int scene) {
  float dO = 0.0;
  for(int i = 0; i < MAX_STEPS; i ++ ) {
    vec3 p = ro + dO * rd;
    if(scene == 0)
    p = TransformCube(ro + dO * rd, t);
  
    float ds = GetDist(p, scene);
    dO += ds;
    if (dO < SURFACE_DIST||dO > MAX_DIST) {
      break;
    }
  }
  return dO;
}
vec3 hsl2rgb(vec3 hsl) {
  float hue = hsl.x;
  float lightness = hsl.z;
  float saturation = hsl.y;
  
  float chroma = (1.0 - abs(2.0 * lightness - 1.0)) * saturation;
  float hue_ = hue * 6.0;
  float x = chroma * (1.0 - abs(mod(hue_, 2.0) - 1.0));
  float m = lightness - 0.5 * chroma;
  
  vec3 rgb;
  if (hue_ < 1.0) {
    rgb = vec3(chroma, x, 0.0);
  } else if (hue_ < 2.0) {
    rgb = vec3(x, chroma, 0.0);
  } else if (hue_ < 3.0) {
    rgb = vec3(0.0, chroma, x);
  } else if (hue_ < 4.0) {
    rgb = vec3(0.0, x, chroma);
  } else if (hue_ < 5.0) {
    rgb = vec3(x, 0.0, chroma);
  } else {
    rgb = vec3(chroma, 0.0, x);
  }
  
  rgb = rgb + m;
  return rgb;
}
vec3 tunnel(vec2 p, float t){
  p /= 2.;
  p.y += 0.2*sin(t*4.);
  p.x += 0.2*cos(t*2.);
  float a = atan(p.y,p.x); // angle of each pixel towards center of screen - for cylindrical space projection
  float r = length(p);
  vec2 uv = vec2(0.3/r+0.2*t, a/PI);
  const int period = 4;
  float f = fbm(2.*uv.yx+t*1.7, period);
  float f2 = fbm(4.*uv+t*2.9, period);
  float f3 = fbm(2.*(uv+t*1.5), period);
  vec3 col = vec3(f);
  col += f3*f3*f3*f3*f3*f3;
  col.yz += f2;
  col.y -=f3*f3*f;
  float fft = texelFetch(audioSampler, ivec2(0.002, 0), 0).x;
  float c = pow(fft,2.);

  // float c = (1.-r)*pow(fft,0.6);
  // col = col *col+1.-r +-.5*(r*c);
  // col = hsl2rgb(vec3(c, 1., .5));
  // col *= .9-abs(r);
  // col += r*c*r;
  // col *= 1.-r*r;
  // col += (1.-r);
  col = col *col+1.-r +-.5*(r*c);
  col *= .9-r*1./c*c*2.;
  col.b += r*c;
  col.r -= 0.1*r*c;
  col.g -= .15*r*c;
  col += r*r*c;
  // col *= c*c;
  // col = vec3(c);
  return col;
}

vec3 Julia(vec2 uv, float t){
    vec2 z = uv;
    vec2 c = vec2(-.45+sin(t), -.5+cos(t));
    float d = 1e20;
    vec2 ddmin = vec2(10.0);
    for(int i = 0; i < 200; i++) {
        z = vec2(z.x*z.x - z.y*z.y, 2.0*z.x*z.y) + c;
        d = min(d, dot(z, z));
        ddmin = min(ddmin, vec2(abs(0.0+z.y + 0.5*sin(z.x*2.)), dot(z, z)));
    }
    float r = sqrt(z.x * z.x + z.y * z.y);
    float theta = atan(z.y, z.x) + 3.0 * t;
    vec3 color = vec3(0.0);
    for(int i = 0; i < 3; i++) {
        float h = (theta + 2.0 * 3.14159 * float(i) / 3.0) / (2.0 * 3.14159);
        h = fract(h + 0.5);
        float s = smoothstep(0.05, 0.35, r);
        float l = mix(0.4, 1.0, smoothstep(0.0, 0.15, d));
        //color += hsl2rgb(vec3(h, s, l));
    }
    color /= 20.0;
    color = mix(color, vec3(0.1,.99,.2), pow(ddmin.x, 0.32)).xyy;
    color = mix(color, vec3(0.1, 0.5, 0.2), pow(ddmin.y, 0.22)).yzx;
    color += hsl2rgb(vec3(sin(t), .5, .4));
    return color;
}

vec3 Julia2(vec2 nuv, vec2 uv, float time){
	vec2 cc = 1.1*vec2( 0.35*cos(1.1*time) - 0.25*cos(0.2*time), 
	                    0.5*sin(0.1*time) - 0.25*sin(0.2*time) );
	vec4 dmin = vec4(10.0);
    vec2 z = nuv;
    for( int i=0; i<14; i++ )
    {
        z = cc + vec2( z.x*z.x - z.y*z.y, 2.0*z.x*z.y );

		dmin=min(dmin, vec4(abs(0.0+z.y + 0.5*sin(z.x)), 
							abs(1.0+z.x + 0.5*sin(z.y)), 
							dot(z,z),
						    length( fract(z)-.55) ) );
    }
    
    vec3 col = vec3( dmin.z );
	col = mix( col, vec3(1.00,0.10,0.60),     min(1.0,pow(dmin.x*0.25,0.20)) );
    col = mix( col, vec3(0.2,0.70,0.60),     min(1.0,pow(dmin.y*0.50,0.20)) );
	col = mix( col, vec3(.5,.80,1.00), 1.0-min(1.0,pow(dmin.w*1.00,0.15) ));

	col = 1.25*col*col;
    col = col*col*(3.0-2.0*col);
	
	col *= 0.5 + 0.5*pow(16.0*uv.x*(1.0-uv.x)*uv.y*(1.0-uv.y),0.15);
	return col;
}

#define MAXITER 500

vec3 Mandel(vec2 uv, float time){
	uv.x += -.6;
  time *= 16.;\
	vec2 c = uv;
  vec2 z = c;
	vec4 dmin = vec4(10.0);
  for(int i = 0;i<MAXITER;i++){
  float tempx = z.x*z.x - z.y * z.y + c.x;
      z.y = 2. * z.x * z.y + c.y;
      z.x = tempx;
		  dmin=min(dmin, vec4(abs(0.0+z.y + 0.5*sin(z.x+time)), 
							abs(1.0+z.x + 0.5*sin(z.y+time)), 
							dot(z,z*(sin(time)+1.5)),
						    length( fract(z)-.5) ) );
        if(length(z)>2.){
            break;
        }
    }
	vec3 col = vec3( dmin.z );
	col = mix( col, vec3(1.00,0.10,0.60),     min(1.0,pow(dmin.x*0.25,0.20)) );
  col = mix( col, vec3(1.2,0.70,0.60),     min(1.0,pow(dmin.y*0.50,0.20)) );
	col = mix( col, vec3(.5,.80,1.00), 1.0-min(1.0,pow(dmin.w*1.00,0.15) ));
	return col;
}

vec3 quantumdot(vec2 uv, float t){
    float freq = texelFetch(audioSampler, ivec2(0.9, 0), 0).x+.08;
    float freq1 = pow(freq, 5.9);
    t = 100.+t;

    float d = 1.-length(uv);
    d = smoothstep(.9-clamp(sin(freq*freq*freq*freq),0.,.5),1.,d);
    float d3 = smoothstep(freq*freq1, 1., d);
    float d2 =(1.-length(sin(uv*mod(t*freq, t*sin(freq)))+cos(uv*mod(freq*t, sin(freq1)*t)+t)))*pow(freq, 1.2);
        //cos(fract(uv.x)*20.)*cos(bt*uv.y+bt*uv.x);
    d2 = mix(0., d2, d*12.);
    vec3 col = vec3(clamp(abs(d2),0.,.9)+d, clamp(abs(d2)*d,0.,1.)+d, clamp(d*d2*d, 0., 1.));
    return col;
}

vec3 render_cube(vec2 uv, float time){
  vec3 color = vec3(0);
  
  // camera
  vec3 camO = vec3(0, 3, -3);
  vec3 lookAt = vec3(0, 0, 0);
  camO.yz *= Rot2d(-u_mouse.y*3.14+1.);
  camO.xz *= Rot2d(-u_mouse.x*6.2831);
  vec3 rd = GetRayDir(uv, camO, lookAt, 1.0);
  
  // trace scene
  float d = RayMarch(camO, rd, time, 0);

  // material
  if (d < MAX_DIST) {
    vec3 p = TransformCube(camO + rd * d,time); // surface point
    vec3 n = GetNormal(p, 0);
    float height = p.y;
    float dif = dot(n, normalize(vec3(1,20,3)))*.5+.5;
    // color += Julia(uuv, time);
    vec3 colorXY = Julia(p.xy, time);
    vec3 colorXZ = Julia2(p.xz, (p.xz+2.)/4., time);
    vec3 colorYZ = Mandel(p.yz, time);
    n = abs(n);
    color = colorXZ;
    color = colorXY * n.z + colorXZ * n.y + colorYZ * n.x;
    color *= dif;

  }
  return color;
}

vec3 GetAmbienOcclusion(vec3 p, vec3 n, int scene) {
  float occ = 0.0;
  float sca = 1.0;
  for(int i = 0; i < 5; i++) {
    float hr = 0.01 + 0.12 * float(i) / 4.0;
    vec3 aop = p + n * hr;
    float dd = GetDist(aop, scene);
    occ += -(dd - hr) * sca;
    sca *= 0.95;
  }
  return vec3(1.0) - clamp(occ, 0.0, 1.0);
}
vec3 GetSoftShadow(vec3 ro, vec3 rd, float k, int scene) {
  float res = 1.0;
  float t = SURFACE_DIST;
  for(int i = 0; i < 32; i++) {
    float h = GetDist(ro + rd * t, scene);
    res = min(res, k * h / t);
    t += clamp(h, 0.02, 0.10);
  }
  return vec3(res);
}

vec3 render_scape(vec2 uv, float time){
  vec3 color = vec3(0);

  // camera
  vec3 camO = vec3(0, 0, -3);
  vec3 lookAt = vec3(0, 0, 400.);
  camO.yz *= Rot2d(-u_mouse.y * 3.14 + 1.);
  camO.xz *= Rot2d(-u_mouse.x * 6.2831);
  vec3 rd = GetRayDir(uv, camO, lookAt, 1.0);

  // trace scene
  float d = RayMarch(camO, rd,time, 1);
  vec3 marsSkyColor = vec3(0.78, 0.2, 0.23);
  vec3 marsAtmosphereColor = vec3(0.8, 0.6, 0.4);

  color = mix(marsSkyColor, marsAtmosphereColor, 1. - uv.y);
  // material
  vec3 lightPos = vec3( 45., 20. ,200.);

  if(d < MAX_DIST) {
    vec3 p = camO + rd * d;
    vec3 n = GetNormal(p, 1);
    float dif = dot(n, normalize(lightPos)) * .5 + .5;
    color *= dif;
    vec3 ao = GetAmbienOcclusion(p, n, 1);
    color *= ao*.6;
    vec3 shadow = GetSoftShadow(p, normalize(lightPos), 6.5, 1);
    color *= shadow;
    float fog = 1.0 - exp(-d * 0.05);
    color = mix(color, marsAtmosphereColor, fog);
  } else {
   
    float sundisc = smoothstep(0.001, 0.002, 1.0 - dot(normalize(lightPos), rd));
    color += mix(vec3(0), vec3(1.,.4,.5), 1. - sundisc);
    
  }
  float sundisc2 = smoothstep(-0.02, 0.0220, 1.0 - dot(normalize(lightPos), rd));
  color += mix(vec3(0), vec3(1.,.9,.5)*.4, 1. - sundisc2*sundisc2);
  return color;
}


vec3 pond(vec2 nuv, float start, float t){
    float freq = 9.0;
    float period = 10.0;
    float speed = 1.0;
    float fade = 2.0;
    float disp = -0.2;
    
    float to = start + period;
    float dist = 0.;
    float time = 0.;
    if(t > start && t < to){
        time = t-start;
        dist = length(nuv);
        
    }
    float ft = mod(time * speed, period);
    float pt = max(0.0, ft - dist);
    float wh = (cos(pt * freq) + 1.0) / 2.0;
    float ws = (1.0 - min(1.0, pt / fade));
    float frac = wh * ws;
    if (mod(time * speed, period * 2.0) > period)
    {
        frac = 1. - frac;
    }
    float fac = sin(pt*freq)+cos(pt*freq);//img1(nuv*pt, freq).x;//sin(pt * freq);
    vec2 coord = nuv + ((nuv / dist) * -((fac / fade) * ws) * disp);
    if(t > to){
        frac = 0.0;
        coord = nuv;
    }
    if(t < start){
        frac = 1.;
        coord = nuv;
    }
    
    return vec3(coord.x, coord.y, frac);
}
vec3 mixJulia(vec2 uv, vec2 uv2, float t, float fft){
  vec3 a = Julia(uv, t);
  vec3 b = Julia2(uv, uv2,t);
  return mix(a, b, fft);
}

out vec4 fragColor;
void main() {

    vec2 uv = (2.0*gl_FragCoord.xy-u_resolution.xy)/u_resolution.y;
    t = u_time / 25.0;
    vec2 p = (u_resolution.xy * uv + u_resolution.xy) / 2.0;
    p = gl_FragCoord.xy/u_resolution.xy;
    float s = floor(u_time);
    vec3 col = vec3(0);
    vec3 fade = vec3(0.);
    if(s >= 0. && s < 30.){
      fade = pond(uv, 4., u_time);
      col = mix(quantumdot(fade.xy, u_time), col, fade.z);
    }
    if(s >= 30. && s < 46.){
      fade = pond(uv, 30., u_time);
      col = mix(Julia(fade.xy, u_time), quantumdot(uv, u_time), fade.z);
    }

    if(s >= 46. && s < 60.){
      fade = pond(uv, 46., u_time);
      col = mix(Julia2(fade.xy, p, u_time), Julia(uv, u_time), fade.z);
    }
    if(s >= 60. && s < 72.){
      fade = pond(uv, 60., u_time);
      col = mix(Mandel(fade.xy, u_time*.2), Julia2(uv,p, u_time), fade.z);
    }
    if(s >= 72. && s < 100.){
      
      float freq = texelFetch(audioSampler, ivec2(0.9, 0), 0).x+.08;
      float freq1 = pow(freq, 5.9);
      if(s >= 72. && s < 85.){
        fade = pond(uv, 72., u_time);
        col = mix(mixJulia(fade.xy, p, u_time, freq1), Mandel(uv, u_time*.2), fade.z);
      } else {
        fade = pond(uv, 85., u_time);
        vec3 a = Julia(uv, u_time);
        vec3 b = Julia2(uv, p, u_time);
        col = mix(render_cube(fade.xy, u_time),mix(a, b, freq1),  fade.z);
      }
    }
    if(s >= 100. && s < 115.){
      fade = pond(uv, 100., u_time);
      col = mix(tunnel(fade.xy, u_time), render_cube(uv, u_time), fade.z);
    }
    if(s >= 115. && s < 135.){
      fade = pond(uv, 115., u_time);
      col = mix(render_scape(fade.xy, u_time),tunnel(uv, u_time), fade.z);
    }
    vec2 uv2 = gl_FragCoord.xy/u_resolution.xy;
    if(s >= 135. && s < 144.){
      
      fade = pond(uv2, 135., u_time);
      col = mix(texture(u_credits1, fade.xy).rgb,render_scape(uv, u_time), fade.z);
    }
    if(s >= 144. && s < 152.){
      fade = pond(uv2, 144., u_time);
      col = mix(texture(u_credits0, fade.xy).rgb,texture(u_credits1, uv2).rgb, fade.z);
    }
    if(s >= 152. && s < 155.){
      fade = pond(uv2, 152., u_time);
      col = mix(vec3(0), texture(u_credits0, uv2).rgb, fade.z);
    }

    vec4 final = vec4(col, 1.0);
    fragColor = final;
}