#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform float kaleidoscopeXangle = 4.0;
#define M_PI 3.1415926535897932384626433832795
uniform vec4 color = vec4(1.0);

vec2 kaleidoscope(vec2 coord, float angle) {
    float a = abs(mod(atan(coord.s,coord.t),angle*2.0)-angle);
    float dist = length(coord);
    coord.s = sin(a)*dist;
    coord.t = cos(a)*dist;
    return coord;
}

void main()
{
    vec2 coord = kaleidoscope((2.0 * texCoord - 1.0),  M_PI / kaleidoscopeXangle);
    //coord.x = -coord.x;
    //coord.y = -coord.y;
    coord.xy = coord.yx;
    fragColor = texture(texture0, coord) * color;
}
