/**************************
***** Compiler Parameters *****
***************************
@P EffectName: TextureFXEffect
@P   - EffectNodeBase.EffectNodeBaseShader: mixin Transform_TextureFX [{Control = mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Default_0> [{Value = InputFloat4<ShaderFX.InputValueFloat4,PerUpdate>}]]}]}, {Value = GetVarFloat4<Default_0>}]}]
@P Control: mixin DoFloat4 [{Before = mixin ComputeOrder [{Computes = [mixin AssignVarFloat4<Default_0> [{Value = InputFloat4<ShaderFX.InputValueFloat4,PerUpdate>}]]}]}, {Value = GetVarFloat4<Default_0>}]
***************************
****  ConstantBuffers  ****
***************************
cbuffer PerDraw [Size: 64]
@C    MatrixTransform_id73 => SpriteBase.MatrixTransform
cbuffer PerUpdate [Size: 16]
@C    InputValue_id98 => ShaderFX.InputValueFloat4
cbuffer Globals [Size: 160]
@C    Texture0TexelSize_id15 => Texturing.Texture0TexelSize
@C    Texture1TexelSize_id17 => Texturing.Texture1TexelSize
@C    Texture2TexelSize_id19 => Texturing.Texture2TexelSize
@C    Texture3TexelSize_id21 => Texturing.Texture3TexelSize
@C    Texture4TexelSize_id23 => Texturing.Texture4TexelSize
@C    Texture5TexelSize_id25 => Texturing.Texture5TexelSize
@C    Texture6TexelSize_id27 => Texturing.Texture6TexelSize
@C    Texture7TexelSize_id29 => Texturing.Texture7TexelSize
@C    Texture8TexelSize_id31 => Texturing.Texture8TexelSize
@C    Texture9TexelSize_id33 => Texturing.Texture9TexelSize
@C    Transform_id94 => Transform_TextureFX.Transform
@C    InterpolationMode_id96 => Transform_TextureFX.InterpolationMode
***************************
******  Resources    ******
***************************
@R    PerDraw => PerDraw [Stage: Vertex, Slot: (0-0)]
@R    Sampler0_id52 => Texturing.Sampler0 [Stage: Pixel, Slot: (0-0)]
@R    CustomSampler_id95 => Transform_TextureFX.CustomSampler [Stage: Pixel, Slot: (1-1)]
@R    Texture0_id14 => Texturing.Texture0 [Stage: Pixel, Slot: (0-0)]
@R    PerUpdate => PerUpdate [Stage: Pixel, Slot: (0-0)]
@R    Globals => Globals [Stage: Pixel, Slot: (1-1)]
***************************
*****     Sources     *****
***************************
@S    Transform_TextureFX => 18ed106e48c38710a43ccd9fe730c47c
@S    FilterBase => 5bd9cb7e7eb80aa436e148c74d845c07
@S    TextureFX => 27bb4f1f808a5eedf6dfeaa75c669c29
@S    ImageEffectShader => 8064e30cc02e5eb4052f420259dbf05e
@S    SpriteBase => 5a7aa9dfd5b5c7613053f4f66c79ca0d
@S    ShaderBase => 4ecbcd2528b64a79eebe81a863892d8c
@S    ShaderBaseStream => b705b699a7385d39c7de52a8d13f3978
@S    Texturing => 91ef3011c1071c2e5d41cd3ee0418b18
@S    Camera => f5d1a113ef7a27319900e8cc2e11ae0d
@S    ShaderUtils => 27e27e08e991883f970444d1aebe3b58
@S    ComputeFloat4 => f871947e9f604da432ea9fc3c9cb4363
@S    ComputeColor => c875a0e093379dd74cd9a5a73aca830f
@S    TextureUtils => 3b321ac8393acfe8eb5c1ca710073e6b
@S    DoFloat4 => 312f1c610231ffe618620ce43634d0aa
@S    ComputeVoid => b62583a94b8503c79e9107f4b5bc9392
@S    ComputeOrder => 1d9b1cd3f5e3ad3f3f10e4fc88326cc7
@S    AssignVarFloat4 => 3a0c495ce724365e837c33156190acbe
@S    StreamVariableFloat4 => 2bfe58666cb67eed05b9410465550725
@S    InputFloat4 => f6891eacc9ea2d912dcfded49ea96a71
@S    DeclFloat4 => 03cb445d0e450d0a37ad5f24c8a93feb
@S    GetVarFloat4 => 2805d4f95c82389ce488a02bbf6e99f5
***************************
*****     Stages      *****
***************************
@G    Vertex => 79eb7ff071584feaa45b858a38e87b6a
//
// Generated by Microsoft (R) HLSL Shader Compiler 10.1
//
//
// Buffer Definitions: 
//
// cbuffer PerDraw
// {
//
//   float4x4 MatrixTransform_id73;     // Offset:    0 Size:    64
//
// }
//
//
// Resource Bindings:
//
// Name                                 Type  Format         Dim      HLSL Bind  Count
// ------------------------------ ---------- ------- ----------- -------------- ------
// PerDraw                           cbuffer      NA          NA            cb0      1 
//
//
//
// Input signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// POSITION                 0   xyzw        0     NONE   float   xyzw
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
//
// Output signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Position              0   xyzw        0      POS   float   xyzw
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
vs_5_0
dcl_globalFlags refactoringAllowed
dcl_constantbuffer CB0[4], immediateIndexed
dcl_input v0.xyzw
dcl_input v1.xy
dcl_output_siv o0.xyzw, position
dcl_output o1.xy
//
// Initial variable locations:
//   v0.x <- __input__.Position_id72.x; v0.y <- __input__.Position_id72.y; v0.z <- __input__.Position_id72.z; v0.w <- __input__.Position_id72.w; 
//   v1.x <- __input__.TexCoord_id62.x; v1.y <- __input__.TexCoord_id62.y; 
//   o1.x <- <VSMain return value>.TexCoord_id62.x; o1.y <- <VSMain return value>.TexCoord_id62.y; 
//   o0.x <- <VSMain return value>.ShadingPosition_id0.x; o0.y <- <VSMain return value>.ShadingPosition_id0.y; o0.z <- <VSMain return value>.ShadingPosition_id0.z; o0.w <- <VSMain return value>.ShadingPosition_id0.w
//
#line 283 "C:\Users\alex\Documents\vvvv\gamma\Exports\5sun2\log\shader_TextureFXEffect_db2b3813b138713fc8f1fe59e954f975.hlsl"
dp4 o0.x, v0.xyzw, cb0[0].xyzw
dp4 o0.y, v0.xyzw, cb0[1].xyzw
dp4 o0.z, v0.xyzw, cb0[2].xyzw
dp4 o0.w, v0.xyzw, cb0[3].xyzw

#line 287
mov o1.xy, v1.xyxx
ret 
// Approximately 6 instruction slots used
@G    Pixel => 2aaa4e8741e80eb84e77ca2476dbb207
//
// Generated by Microsoft (R) HLSL Shader Compiler 10.1
//
//
// Buffer Definitions: 
//
// cbuffer PerUpdate
// {
//
//   float4 InputValue_id98;            // Offset:    0 Size:    16
//
// }
//
// cbuffer Globals
// {
//
//   float2 Texture0TexelSize_id15;     // Offset:    0 Size:     8 [unused]
//   float2 Texture1TexelSize_id17;     // Offset:    8 Size:     8 [unused]
//   float2 Texture2TexelSize_id19;     // Offset:   16 Size:     8 [unused]
//   float2 Texture3TexelSize_id21;     // Offset:   24 Size:     8 [unused]
//   float2 Texture4TexelSize_id23;     // Offset:   32 Size:     8 [unused]
//   float2 Texture5TexelSize_id25;     // Offset:   40 Size:     8 [unused]
//   float2 Texture6TexelSize_id27;     // Offset:   48 Size:     8 [unused]
//   float2 Texture7TexelSize_id29;     // Offset:   56 Size:     8 [unused]
//   float2 Texture8TexelSize_id31;     // Offset:   64 Size:     8 [unused]
//   float2 Texture9TexelSize_id33;     // Offset:   72 Size:     8 [unused]
//   float4x4 Transform_id94;           // Offset:   80 Size:    64
//   uint InterpolationMode_id96;       // Offset:  144 Size:     4
//      = 0x00000000 
//
// }
//
//
// Resource Bindings:
//
// Name                                 Type  Format         Dim      HLSL Bind  Count
// ------------------------------ ---------- ------- ----------- -------------- ------
// Sampler0_id52                     sampler      NA          NA             s0      1 
// CustomSampler_id95                sampler      NA          NA             s1      1 
// Texture0_id14                     texture  float4          2d             t0      1 
// PerUpdate                         cbuffer      NA          NA            cb0      1 
// Globals                           cbuffer      NA          NA            cb1      1 
//
//
//
// Input signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Position              0   xyzw        0      POS   float       
// TEXCOORD                 0   xy          1     NONE   float   xy  
//
//
// Output signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// SV_Target                0   xyzw        0   TARGET   float   xyzw
//
ps_5_0
dcl_globalFlags refactoringAllowed
dcl_constantbuffer CB0[1], immediateIndexed
dcl_constantbuffer CB1[10], immediateIndexed
dcl_sampler s0, mode_default
dcl_sampler s1, mode_default
dcl_resource_texture2d (float,float,float,float) t0
dcl_input_ps linear v1.xy
dcl_output o0.xyzw
dcl_temps 10
//
// Initial variable locations:
//   v0.x <- __input__.ShadingPosition_id0.x; v0.y <- __input__.ShadingPosition_id0.y; v0.z <- __input__.ShadingPosition_id0.z; v0.w <- __input__.ShadingPosition_id0.w; 
//   v1.x <- __input__.TexCoord_id62.x; v1.y <- __input__.TexCoord_id62.y; 
//   o0.x <- <PSMain return value>.ColorTarget_id2.x; o0.y <- <PSMain return value>.ColorTarget_id2.y; o0.z <- <PSMain return value>.ColorTarget_id2.z; o0.w <- <PSMain return value>.ColorTarget_id2.w
//
#line 262 "C:\Users\alex\Documents\vvvv\gamma\Exports\5sun2\log\shader_TextureFXEffect_db2b3813b138713fc8f1fe59e954f975.hlsl"
sample_l_indexable(texture2d)(float,float,float,float) r0.xyzw, v1.xyxx, t0.xyzw, s0, l(0.000000)  // r0.x <- <InTex0_id26 return value>.x; r0.y <- <InTex0_id26 return value>.y; r0.z <- <InTex0_id26 return value>.z; r0.w <- <InTex0_id26 return value>.w

#line 247
mad r1.xy, v1.xyxx, l(1.000000, -1.000000, 0.000000, 0.000000), l(-0.500000, 0.500000, 0.000000, 0.000000)
mov r1.z, l(1.000000)
dp3 r2.x, r1.xyzx, cb1[5].xywx
dp3 r2.y, r1.xyzx, cb1[6].xywx
mad r1.xyzw, r2.xyxy, l(1.000000, -1.000000, 1.000000, -1.000000), l(0.500000, 0.500000, 0.500000, 0.500000)  // r1.z <- uv.x; r1.w <- uv.y

#line 248
switch cb1[9].x

#line 251
  case l(0)

#line 252
  sample_indexable(texture2d)(float,float,float,float) r2.xyzw, r1.zwzz, t0.xyzw, s1  // r2.x <- <Filter_id44 return value>.x; r2.y <- <Filter_id44 return value>.y; r2.z <- <Filter_id44 return value>.z; r2.w <- <Filter_id44 return value>.w
  mov r3.x, l(-1)
  break 

#line 253
  case l(1)

#line 237
  resinfo_indexable(texture2d)(float,float,float,float) r3.yz, l(0), t0.zxyw  // r3.y <- w; r3.z <- h

#line 196
  div r4.xy, l(1.000000, 1.000000, 1.000000, 1.000000), r3.yzyy  // r4.x <- pix.x; r4.y <- pix.y

#line 197
  mad r3.yz, r1.zzwz, r3.yyzy, l(0.000000, -0.500000, -0.500000, 0.000000)  // r3.y <- w.x; r3.z <- w.y

#line 149
  frc r3.yz, r3.yyzy  // r3.z <- x

#line 150
  add r3.yz, -r3.yyzy, l(0.000000, 1.000000, 1.000000, 0.000000)

#line 151
  mul r5.xyzw, r3.yyzz, r3.yyzz  // r5.w <- x2

#line 152
  mul r6.xyzw, r3.yyyz, r5.yyyw  // r6.w <- x3

#line 154
  mul r7.xyzw, r5.xyzw, l(3.000000, 6.000000, 3.000000, 6.000000)

#line 153
  mad r5.xy, r5.xzxx, l(3.000000, 3.000000, 0.000000, 0.000000), -r6.zwzz
  mad r5.xy, -r3.yzyy, l(3.000000, 3.000000, 0.000000, 0.000000), r5.xyxx

#line 154
  mul r3.w, r6.z, l(0.166667)  // r3.w <- w3
  mad r5.zw, r6.xxxw, l(0.000000, 0.000000, 3.000000, 3.000000), -r7.yyyw

#line 153
  add r5.xyzw, r5.xyzw, l(1.000000, 1.000000, 4.000000, 4.000000)

#line 154
  mul r5.zw, r5.zzzw, l(0.000000, 0.000000, 0.166667, 0.166667)  // r5.w <- w1

#line 155
  mad r4.w, r6.y, l(-3.000000), r7.x
  mad r4.w, r3.y, l(3.000000), r4.w
  add r4.w, r4.w, l(1.000000)

#line 157
  mad r5.xy, r5.xyxx, l(0.166667, 0.166667, 0.000000, 0.000000), r5.zwzz
  div r5.zw, r5.zzzw, r5.xxxy
  add r5.zw, r3.yyyz, -r5.zzzw

#line 158
  mad r4.w, r4.w, l(0.166667), r3.w
  div r3.w, r3.w, r4.w
  add r3.w, r3.w, l(1.000000)
  add r3.y, -r3.y, r3.w  // r3.y <- h1; r3.y <- h1

#line 156
  mul r3.w, r6.w, l(0.166667)  // r3.w <- w3

#line 155
  mad r4.w, r6.w, l(-3.000000), r7.z
  mad r4.w, r3.z, l(3.000000), r4.w
  add r4.w, r4.w, l(1.000000)

#line 157
  add r5.zw, r5.zzzw, l(0.000000, 0.000000, 1.000000, 1.000000)  // r5.w <- h0

#line 158
  mad r4.w, r4.w, l(0.166667), r3.w
  div r3.w, r3.w, r4.w
  add r3.w, r3.w, l(1.000000)
  add r3.z, -r3.z, r3.w  // r3.z <- h1

#line 202
  mul r6.x, r4.x, r5.z

#line 203
  mov r6.yw, l(0,0,0,0)

#line 202
  add r6.xy, r1.zwzz, r6.xyxx  // r6.x <- coord_source10.x; r6.y <- coord_source10.y

#line 203
  mul r6.z, r4.x, r3.y
  add r3.yw, r1.zzzw, -r6.zzzw  // r3.y <- coord_source00.x; r3.w <- coord_source00.y

#line 204
  mov r4.z, l(0)
  mad r4.xw, r5.wwww, r4.zzzy, r6.xxxy  // r4.x <- coord_source11.x; r4.w <- coord_source11.y

#line 205
  mad r5.zw, r5.wwww, r4.zzzy, r3.yyyw  // r5.z <- coord_source01.x; r5.w <- coord_source01.y

#line 206
  mad r6.xy, -r3.zzzz, r4.zyzz, r6.xyxx

#line 207
  mad r3.yz, -r3.zzzz, r4.zzyz, r3.yywy  // r3.z <- coord_source00.y

#line 208
  sample_l_indexable(texture2d)(float,float,float,float) r7.xyzw, r3.yzyy, t0.xyzw, s1, l(0.000000)  // r7.x <- tex_source00.x; r7.y <- tex_source00.y; r7.z <- tex_source00.z; r7.w <- tex_source00.w

#line 209
  sample_l_indexable(texture2d)(float,float,float,float) r6.xyzw, r6.xyxx, t0.xyzw, s1, l(0.000000)  // r6.x <- tex_source10.x; r6.y <- tex_source10.y; r6.z <- tex_source10.z; r6.w <- tex_source10.w

#line 210
  sample_l_indexable(texture2d)(float,float,float,float) r8.xyzw, r5.zwzz, t0.xyzw, s1, l(0.000000)  // r8.x <- tex_source01.x; r8.y <- tex_source01.y; r8.z <- tex_source01.z; r8.w <- tex_source01.w

#line 211
  sample_l_indexable(texture2d)(float,float,float,float) r4.xyzw, r4.xwxx, t0.xyzw, s1, l(0.000000)  // r4.x <- tex_source11.x; r4.y <- tex_source11.y; r4.z <- tex_source11.z; r4.w <- tex_source11.w

#line 212
  add r8.xyzw, -r7.xyzw, r8.xyzw
  mad r7.xyzw, r5.yyyy, r8.xyzw, r7.xyzw

#line 213
  add r4.xyzw, -r6.xyzw, r4.xyzw
  mad r4.xyzw, r5.yyyy, r4.xyzw, r6.xyzw  // r4.x <- tex_source10.x; r4.y <- tex_source10.y; r4.z <- tex_source10.z; r4.w <- tex_source10.w

#line 214
  add r4.xyzw, -r7.xyzw, r4.xyzw
  mad r2.xyzw, r5.xxxx, r4.xyzw, r7.xyzw  // r2.x <- tex_source00.x; r2.y <- tex_source00.y; r2.z <- tex_source00.z; r2.w <- tex_source00.w

#line 254
  mov r3.x, l(-1)
  break 

#line 255
  case l(2)

#line 231
  resinfo_indexable(texture2d)(float,float,float,float) r3.yz, l(0), t0.zxyw  // r3.y <- w; r3.z <- h

#line 168
  mad r4.xy, r1.zwzz, r3.yzyy, l(-0.500000, -0.500000, 0.000000, 0.000000)
  round_ni r4.xy, r4.xyxx

#line 176
  add r5.xyzw, r4.xyxy, l(0.500000, 0.500000, -0.500000, -0.500000)  // r5.x <- texPos1.x; r5.y <- texPos1.y; r5.z <- texPos0.x; r5.w <- texPos0.y

#line 169
  mad r1.xyzw, r1.xyzw, r3.yzyz, -r5.xyxy  // r1.z <- f.x; r1.w <- f.y

#line 172
  mad r6.xyzw, -r1.zwzw, l(0.500000, 0.500000, 1.500000, 1.500000), l(1.000000, 1.000000, 2.000000, 2.000000)
  mad r6.xyzw, r1.zwzw, r6.xyzw, l(-0.500000, -0.500000, 0.500000, 0.500000)

#line 171
  mul r7.xyzw, r1.zwzw, r1.zwzw

#line 173
  mad r8.xyzw, r1.zwzw, l(1.500000, 1.500000, 0.500000, 0.500000), l(-2.500000, -2.500000, -0.500000, -0.500000)
  mul r4.zw, r7.zzzw, r8.zzzw  // r4.z <- w3.x; r4.w <- w3.y

#line 171
  mad r7.xy, r7.xyxx, r8.xyxx, l(1.000000, 1.000000, 0.000000, 0.000000)  // r7.x <- w1.x; r7.y <- w1.y

#line 172
  mul r8.xyzw, r1.xyzw, r6.xyzw  // r8.x <- w0.x; r8.y <- w0.y; r8.z <- w2.x; r8.w <- w2.y

#line 174
  mad r1.xy, r1.zwzz, r6.zwzz, r7.xyxx  // r1.x <- w12.x; r1.y <- w12.y

#line 175
  div r1.zw, r8.zzzw, r1.xxxy  // r1.z <- offset12.x; r1.w <- offset12.y

#line 177
  add r4.xy, r4.xyxx, l(2.500000, 2.500000, 0.000000, 0.000000)  // r4.x <- texPos3.x; r4.y <- texPos3.y

#line 178
  add r1.zw, r1.zzzw, r5.xxxy  // r1.z <- texPos12.x; r1.w <- texPos12.y

#line 179
  div r5.xw, r5.zzzw, r3.yyyz  // r5.x <- texPos0.x

#line 180
  div r6.xy, r4.xyxx, r3.yzyy  // r6.x <- texPos3.x; r6.y <- texPos3.y

#line 181
  div r5.yz, r1.wwzw, r3.zzyz  // r5.y <- texPos12.y; r5.z <- texPos12.x

#line 183
  sample_l_indexable(texture2d)(float,float,float,float) r7.xyzw, r5.xwxx, t0.xyzw, s1, l(0.000000)
  mul r7.xyzw, r8.xxxx, r7.xyzw

#line 184
  sample_l_indexable(texture2d)(float,float,float,float) r9.xyzw, r5.zwzz, t0.xyzw, s1, l(0.000000)
  mul r9.xyzw, r1.xxxx, r9.xyzw
  mul r9.xyzw, r8.yyyy, r9.xyzw
  mad r7.xyzw, r7.xyzw, r8.yyyy, r9.xyzw  // r7.x <- result.x; r7.y <- result.y; r7.z <- result.z; r7.w <- result.w

#line 188
  mov r6.zw, r5.wwwy

#line 185
  sample_l_indexable(texture2d)(float,float,float,float) r9.xyzw, r6.xzxx, t0.xyzw, s1, l(0.000000)
  mul r9.xyzw, r4.zzzz, r9.xyzw
  mad r7.xyzw, r9.xyzw, r8.yyyy, r7.xyzw

#line 186
  sample_l_indexable(texture2d)(float,float,float,float) r9.xyzw, r5.xyxx, t0.xyzw, s1, l(0.000000)
  mul r9.xyzw, r8.xxxx, r9.xyzw
  mad r7.xyzw, r9.xyzw, r1.yyyy, r7.xyzw

#line 187
  sample_l_indexable(texture2d)(float,float,float,float) r9.xyzw, r5.zyzz, t0.xyzw, s1, l(0.000000)
  mul r9.xyzw, r1.xxxx, r9.xyzw
  mad r7.xyzw, r9.xyzw, r1.yyyy, r7.xyzw

#line 188
  sample_l_indexable(texture2d)(float,float,float,float) r9.xyzw, r6.xwxx, t0.xyzw, s1, l(0.000000)
  mul r9.xyzw, r4.zzzz, r9.xyzw
  mad r7.xyzw, r9.xyzw, r1.yyyy, r7.xyzw

#line 189
  mov r5.y, r6.y
  sample_l_indexable(texture2d)(float,float,float,float) r9.xyzw, r5.xyxx, t0.xyzw, s1, l(0.000000)
  mul r8.xyzw, r8.xxxx, r9.xyzw
  mad r7.xyzw, r8.xyzw, r4.wwww, r7.xyzw

#line 190
  sample_l_indexable(texture2d)(float,float,float,float) r5.xyzw, r5.zyzz, t0.xyzw, s1, l(0.000000)
  mul r1.xyzw, r1.xxxx, r5.xyzw
  mad r1.xyzw, r1.xyzw, r4.wwww, r7.xyzw  // r1.x <- result.x; r1.y <- result.y; r1.z <- result.z; r1.w <- result.w

#line 191
  sample_l_indexable(texture2d)(float,float,float,float) r5.xyzw, r6.xyxx, t0.xyzw, s1, l(0.000000)
  mul r5.xyzw, r4.zzzz, r5.xyzw
  mad r2.xyzw, r5.xyzw, r4.wwww, r1.xyzw  // r2.x <- result.x; r2.y <- result.y; r2.z <- result.z; r2.w <- result.w

#line 256
  mov r3.x, l(-1)
  break   // r1.z <- uv.x; r1.w <- uv.y

#line 257
  default 
  mov r3.x, l(0)
  break 
endswitch   // r2.x <- <Filter_id44 return value>.x; r2.y <- <Filter_id44 return value>.y; r2.z <- <Filter_id44 return value>.z; r2.w <- <Filter_id44 return value>.w

#line 258
movc r1.xyzw, r3.xxxx, r2.xyzw, l(1.000000,1.000000,1.000000,1.000000)  // r1.x <- <Filter_id44 return value>.x; r1.y <- <Filter_id44 return value>.y; r1.z <- <Filter_id44 return value>.z; r1.w <- <Filter_id44 return value>.w

#line 267
add r1.xyzw, -r0.xyzw, r1.xyzw
mad o0.xyzw, cb0[0].xyzw, r1.xyzw, r0.xyzw

#line 276
ret 
// Approximately 126 instruction slots used
***************************
*************************/
struct PS_STREAMS 
{
    float2 TexCoord_id62;
    float4 Default_0_id97;
    float4 ColorTarget_id2;
};
struct PS_OUTPUT 
{
    float4 ColorTarget_id2 : SV_Target0;
};
struct PS_INPUT 
{
    float4 ShadingPosition_id0 : SV_Position;
    float2 TexCoord_id62 : TEXCOORD0;
};
struct VS_STREAMS 
{
    float4 Position_id72;
    float2 TexCoord_id62;
    float4 ShadingPosition_id0;
};
struct VS_OUTPUT 
{
    float4 ShadingPosition_id0 : SV_Position;
    float2 TexCoord_id62 : TEXCOORD0;
};
struct VS_INPUT 
{
    float4 Position_id72 : POSITION;
    float2 TexCoord_id62 : TEXCOORD0;
};
cbuffer PerDraw 
{
    float4x4 MatrixTransform_id73;
};
cbuffer PerUpdate 
{
    float4 InputValue_id98;
};
cbuffer PerView 
{
    float NearClipPlane_id74 = 1.0f;
    float FarClipPlane_id75 = 100.0f;
    float2 ZProjection_id76;
    float2 ViewSize_id77;
    float AspectRatio_id78;
};
cbuffer Globals 
{
    float2 Texture0TexelSize_id15;
    float2 Texture1TexelSize_id17;
    float2 Texture2TexelSize_id19;
    float2 Texture3TexelSize_id21;
    float2 Texture4TexelSize_id23;
    float2 Texture5TexelSize_id25;
    float2 Texture6TexelSize_id27;
    float2 Texture7TexelSize_id29;
    float2 Texture8TexelSize_id31;
    float2 Texture9TexelSize_id33;
    float4x4 Transform_id94;
    uint InterpolationMode_id96 = 0;
};
Texture2D Texture0_id14;
Texture2D Texture1_id16;
Texture2D Texture2_id18;
Texture2D Texture3_id20;
Texture2D Texture4_id22;
Texture2D Texture5_id24;
Texture2D Texture6_id26;
Texture2D Texture7_id28;
Texture2D Texture8_id30;
Texture2D Texture9_id32;
TextureCube TextureCube0_id34;
TextureCube TextureCube1_id35;
TextureCube TextureCube2_id36;
TextureCube TextureCube3_id37;
Texture3D Texture3D0_id38;
Texture3D Texture3D1_id39;
Texture3D Texture3D2_id40;
Texture3D Texture3D3_id41;
SamplerState Sampler_id42;
SamplerState PointSampler_id43 
{
    Filter = MIN_MAG_MIP_POINT;
};
SamplerState LinearSampler_id44 
{
    Filter = MIN_MAG_MIP_LINEAR;
};
SamplerState LinearBorderSampler_id45 
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Border;
    AddressV = Border;
};
SamplerComparisonState LinearClampCompareLessEqualSampler_id46 
{
    Filter = COMPARISON_MIN_MAG_LINEAR_MIP_POINT;
    AddressU = Clamp;
    AddressV = Clamp;
    ComparisonFunc = LessEqual;
};
SamplerState AnisotropicSampler_id47 
{
    Filter = ANISOTROPIC;
};
SamplerState AnisotropicRepeatSampler_id48 
{
    Filter = ANISOTROPIC;
    AddressU = Wrap;
    AddressV = Wrap;
    MaxAnisotropy = 16;
};
SamplerState PointRepeatSampler_id49 
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState LinearRepeatSampler_id50 
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState RepeatSampler_id51 
{
    AddressU = Wrap;
    AddressV = Wrap;
};
SamplerState Sampler0_id52;
SamplerState Sampler1_id53;
SamplerState Sampler2_id54;
SamplerState Sampler3_id55;
SamplerState Sampler4_id56;
SamplerState Sampler5_id57;
SamplerState Sampler6_id58;
SamplerState Sampler7_id59;
SamplerState Sampler8_id60;
SamplerState Sampler9_id61;
Texture2D BicubicFilterKernel_id88;
SamplerState CustomSampler_id95;
float4 Compute_id46()
{
    return InputValue_id98;
}
float3 BSplineFilter_id32(float x)
{
    x = frac(x);
    x = 1 - x;
    float x2 = x * x;
    float x3 = x2 * x;
    float w0 = (-x3 + 3 * x2 - 3 * x + 1) / 6.0;
    float w1 = (3 * x3 - 6 * x2 + 4) / 6.0;
    float w2 = (-3 * x3 + 3 * x2 + 3 * x + 1) / 6.0;
    float w3 = x3 / 6.0;
    float h0 = 1 - w1 / (w0 + w1) + x;
    float h1 = 1 + w3 / (w2 + w3) - x;
    return float3(h0, h1, w0 + w1);
}
void Compute_id49(inout PS_STREAMS streams)
{
    streams.Default_0_id97 = Compute_id46();
}
float4 SampleTextureCatmullRom_id35(in Texture2D tex, in SamplerState linearSampler, in float2 uv, in float2 texSize)
{
    float2 samplePos = uv * texSize;
    float2 texPos1 = floor(samplePos - 0.5f) + 0.5f;
    float2 f = samplePos - texPos1;
    float2 w0 = f * (-0.5f + f * (1.0f - 0.5f * f));
    float2 w1 = 1.0f + f * f * (-2.5f + 1.5f * f);
    float2 w2 = f * (0.5f + f * (2.0f - 1.5f * f));
    float2 w3 = f * f * (-0.5f + 0.5f * f);
    float2 w12 = w1 + w2;
    float2 offset12 = w2 / w12;
    float2 texPos0 = texPos1 - 1;
    float2 texPos3 = texPos1 + 2;
    float2 texPos12 = texPos1 + offset12;
    texPos0 /= texSize;
    texPos3 /= texSize;
    texPos12 /= texSize;
    float4 result = 0.0f;
    result += tex.SampleLevel(linearSampler, float2(texPos0.x, texPos0.y), 0.0f) * w0.x * w0.y;
    result += tex.SampleLevel(linearSampler, float2(texPos12.x, texPos0.y), 0.0f) * w12.x * w0.y;
    result += tex.SampleLevel(linearSampler, float2(texPos3.x, texPos0.y), 0.0f) * w3.x * w0.y;
    result += tex.SampleLevel(linearSampler, float2(texPos0.x, texPos12.y), 0.0f) * w0.x * w12.y;
    result += tex.SampleLevel(linearSampler, float2(texPos12.x, texPos12.y), 0.0f) * w12.x * w12.y;
    result += tex.SampleLevel(linearSampler, float2(texPos3.x, texPos12.y), 0.0f) * w3.x * w12.y;
    result += tex.SampleLevel(linearSampler, float2(texPos0.x, texPos3.y), 0.0f) * w0.x * w3.y;
    result += tex.SampleLevel(linearSampler, float2(texPos12.x, texPos3.y), 0.0f) * w12.x * w3.y;
    result += tex.SampleLevel(linearSampler, float2(texPos3.x, texPos3.y), 0.0f) * w3.x * w3.y;
    return result;
}
float4 SampleTextureBicubic_id30(in Texture2D tex, in SamplerState linearSampler, in float2 uv, in float2 texSize)
{
    float2 pix = 1.0 / texSize;
    float2 w = uv * texSize - 0.5;
    float3 hg_x = BSplineFilter_id32(w.x);
    float3 hg_y = BSplineFilter_id32(w.y);
    float2 e_x = float2(pix.x, 0);
    float2 e_y = float2(0, pix.y);
    float2 coord_source10 = uv + hg_x.x * e_x;
    float2 coord_source00 = uv - hg_x.y * e_x;
    float2 coord_source11 = coord_source10 + hg_y.x * e_y;
    float2 coord_source01 = coord_source00 + hg_y.x * e_y;
    coord_source10 = coord_source10 - hg_y.y * e_y;
    coord_source00 = coord_source00 - hg_y.y * e_y;
    float4 tex_source00 = tex.SampleLevel(linearSampler, coord_source00, 0);
    float4 tex_source10 = tex.SampleLevel(linearSampler, coord_source10, 0);
    float4 tex_source01 = tex.SampleLevel(linearSampler, coord_source01, 0);
    float4 tex_source11 = tex.SampleLevel(linearSampler, coord_source11, 0);
    tex_source00 = lerp(tex_source00, tex_source01, hg_y.z);
    tex_source10 = lerp(tex_source10, tex_source11, hg_y.z);
    tex_source00 = lerp(tex_source00, tex_source10, hg_x.z);
    return tex_source00;
}
float4 Compute_id52(inout PS_STREAMS streams)
{
    return streams.Default_0_id97;
}
void Compute_id51(inout PS_STREAMS streams)
{

    {
        Compute_id49(streams);
    }
}
float4 SampleCubicCatmullRom_id36(in Texture2D tex, in SamplerState linearSampler, in float2 uv)
{
    float w, h;
    tex.GetDimensions(w, h);
    return SampleTextureCatmullRom_id35(tex, linearSampler, uv, float2(w, h));
}
float4 SampleCubicBSpline_id31(in Texture2D tex, in SamplerState linearSampler, in float2 uv)
{
    float w, h;
    tex.GetDimensions(w, h);
    return SampleTextureBicubic_id30(tex, linearSampler, uv, float2(w, h));
}
float4 Compute_id45(inout PS_STREAMS streams)
{
    Compute_id51(streams);
    return Compute_id52(streams);
}
float4 Filter_id44(inout PS_STREAMS streams, float4 tex0col)
{
    float2 uv = mul(float4((streams.TexCoord_id62 * 2 - 1) * float2(1, -1) * .5, 0, 1), Transform_id94).xy * float2(1, -1) + 0.5;
    switch (InterpolationMode_id96)

    {
        case 0:
            return Texture0_id14.Sample(CustomSampler_id95, uv);
        case 1:
            return SampleCubicBSpline_id31(Texture0_id14, CustomSampler_id95, uv);
        case 2:
            return SampleCubicCatmullRom_id36(Texture0_id14, CustomSampler_id95, uv);
    }
    return 1;
}
float4 InTex0_id26(inout PS_STREAMS streams)
{
    return Texture0_id14.SampleLevel(Sampler0_id52, streams.TexCoord_id62, 0);
}
float4 Shading_id28(inout PS_STREAMS streams)
{
    float4 col = InTex0_id26(streams);
    return lerp(col, Filter_id44(streams, col), Compute_id45(streams));
}
PS_OUTPUT PSMain(PS_INPUT __input__)
{
    PS_STREAMS streams = (PS_STREAMS)0;
    streams.TexCoord_id62 = __input__.TexCoord_id62;
    streams.ColorTarget_id2 = Shading_id28(streams);
    PS_OUTPUT __output__ = (PS_OUTPUT)0;
    __output__.ColorTarget_id2 = streams.ColorTarget_id2;
    return __output__;
}
VS_OUTPUT VSMain(VS_INPUT __input__)
{
    VS_STREAMS streams = (VS_STREAMS)0;
    streams.Position_id72 = __input__.Position_id72;
    streams.TexCoord_id62 = __input__.TexCoord_id62;
    streams.ShadingPosition_id0 = mul(streams.Position_id72, MatrixTransform_id73);
    VS_OUTPUT __output__ = (VS_OUTPUT)0;
    __output__.ShadingPosition_id0 = streams.ShadingPosition_id0;
    __output__.TexCoord_id62 = streams.TexCoord_id62;
    return __output__;
}
