#pragma include "filter_inputs.glsl"

// These access the Nth texture applied to the model.  The index matches up with
// the index used by p3d_MultiTexCoordN, p3d_TangentN, and p3d_BinormalN.
// The sampler type should be adjusted to match the type of the texture.
uniform sampler2D p3d_Texture0;
uniform sampler2D p3d_Texture1;
uniform sampler2D p3d_Texture2;
uniform sampler2D p3d_Texture3;

// Reports the frame time of the current frame, for animations.
uniform float osg_FrameTime;

out vec4 p3d_FragColor;

uniform vec2 u_TextureSize;
uniform float u_InvAspectRatio;

uniform float u_SSRRadius;

vec2 uv = gl_FragCoord.xy / u_TextureSize;
//vec2 uv = gl_FragCoord.xy / vec2(textureSize(p3d_Texture0, 0));

//ivec2 tex_Size = textureSize(p3d_Texture0, 0);   // LOD 0 = pełna rozdzielczość
//vec2 uv = gl_FragCoord.xy / vec2(tex_Size);


///  2 out, 2 in... Noise by Dave_Hoskins
vec2 hash22(vec2 p) {
	vec3 p3 = fract(vec3(p.xyx) * vec3(.1031, .1030, .0973));
    p3 += dot(p3, p3.yzx+33.33);
    return fract((p3.xx+p3.yz)*p3.zy);
//    return vec2(0.2);
}


//float computeDof(float depth, float dofFocus) {
//    if (depth < dofFocus) {
//        return 1. - smoothstep(0, dofFocus, depth);
//    } else {
//        return smoothstep(dofFocus, 1, depth);
//    }
//}

float computeDof(float depth, float dofFocusNear, float dofFocusFar) {
    float dofNear = 1.0 - smoothstep(0., dofFocusNear, depth);
    float dofFar = smoothstep(dofFocusFar, 1., depth);
    float dof = max(dofNear, dofFar);
    return dof;
}
