# Inercia Royale Jam 2025 :: Textures Setup

Inercia Royale Jam is soon ! Please find enclosed a zip file that contains the additional textures that will be during the Shader Jam : 

## How to install ? 

- Download zip and unzip to a directory
- Copy the content of the `textures` directory and paste everythning inside your Bonzomatic `textures` directory. Your Bonzomatic directory should look like this :
```
C:\Path\to\Bonzomatic
    textures\
        checker.png
        noise.png
        tex1.jpg
        [...]
        Inercia2025.png
```
- Update your `config.json` to add the texture like this :
```json
//config.json
[...]
"textures": {
    "texChecker": "textures/checker.png",
    "texNoise": "textures/noise.png",
    "texTex1": "textures/tex1.jpg",
    "texTex2": "textures/tex2.jpg",
    "texTex3": "textures/tex3.jpg",
    "texTex4": "textures/tex4.jpg",
    "texInerciaLogo2024": "textures/Inercia2025.png"
  },
  [...]
  ```

- You can use the `testTexture.glsl` to check it works. The `testTexture.glsl` also contain a helper function `getTexture` that resize the texture to the correct ratio and reverse the `Y` axis.
```glsl
vec4 getTexture(sampler2D sampler, vec2 uv){
     vec2 size = textureSize(sampler,0);
     float ratio = size.x/size.y;
     return texture(sampler,uv*vec2(1.,-1.*ratio)-.5);
}
```