/*

 TILESET.C

 Tile Source File.

 Info:
  Form                 : All tiles as one unit.
  Format               : Gameboy 4 color.
  Compression          : GB-Compress.
  Counter              : None.
  Tile size            : 8 x 8
  Tiles                : 0 to 218

  Palette colors       : Included.
  SGB Palette          : None.
  CGB Palette          : 4 Bits per entry.

  Convert to metatiles : No.

 This file was generated by GBTD v2.2

*/
#include <gb/gb.h>
#include <gb/cgb.h>
#include <gb/gbdecompress.h>

#pragma bank 255
BANKREF(aquaria_tileset)

/* CGBpalette entries. */
const palette_color_t* const tilesetCGBPal[] =
{
  /* Gameboy Color palette 0 */
  0,
  3169,
  10468,
  18823,
  /* Gameboy Color palette 1 */
  32326,
  13704,
  8421,
  3170,
  /* Gameboy Color palette 2 */
  32326,
  4233,
  19731,
  13629,
  /* Gameboy Color palette 3 */
  32326,
  7580,
  6568,
  16120,
  /* Gameboy Color palette 4 */
  3385,
  13704,
  8421,
  2187,
  /* Gameboy Color palette 5 */
  32326,
  6435,
  4550,
  7886
};

// Skip palette 6 since that's used by textboxes

const palette_color_t* const tilesetCGBPalrest[] =
{
  /* Gameboy Color palette 7 */
  32326,
  9511,
  14827,
  21136,
};

/* Start of tile array. */
const unsigned char tileset[] =
{
  0x1F,0x00,0x10,0xFF,0x46,0x00,0xFF,0x84,
  0xC1,0xFF,0xCA,0x01,0x00,0x00,0x01,0x00,
  0x07,0x07,0x08,0x1F,0x00,0x7F,0x83,0xF3,
  0xFF,0xCA,0x1F,0xC0,0x3F,0x52,0xAD,0xB0,
  0x4F,0xF2,0x0D,0xFA,0x05,0x83,0xE0,0xFF,
  0xCD,0x10,0xF0,0xA0,0x5E,0x48,0xB7,0x32,
  0xCD,0xC2,0x3D,0xC0,0x3F,0x80,0x7F,0x87,
  0x90,0xFF,0xC7,0x40,0xC0,0x00,0xE0,0x10,
  0xF0,0x98,0x78,0x89,0x80,0xFF,0xC4,0x0C,
  0x1F,0x49,0x7F,0x40,0x85,0xAF,0xFF,0x84,
  0x6B,0xFF,0xC5,0xE0,0xE0,0x30,0xF8,0x08,
  0xF8,0x89,0x60,0xFF,0xC2,0x03,0x00,0x07,
  0x83,0xA0,0xFF,0xCE,0x00,0x01,0x00,0x01,
  0x02,0x17,0x08,0xFF,0x00,0xDF,0x20,0xBF,
  0x40,0x7F,0x80,0x83,0x70,0xFF,0xFF,0xFE,
  0x01,0xFD,0x02,0xF7,0x08,0xF3,0x0C,0xF0,
  0x0F,0x08,0xF7,0xEB,0x14,0xF0,0x0F,0xA5,
  0x5A,0xEA,0x15,0xE8,0x17,0xE0,0x1F,0x00,
  0xFF,0x80,0xFF,0x1E,0xFC,0xBF,0x7F,0x3F,
  0xFF,0x7F,0xFF,0x1F,0xFF,0x0F,0xFF,0x97,
  0x7F,0x97,0x7F,0x3B,0x7F,0xFC,0xFF,0xEC,
  0xFF,0xF3,0xFF,0xF2,0xFF,0xEC,0xFF,0xB3,
  0xFF,0xB0,0xFF,0x08,0xF7,0x81,0xFE,0xD9,
  0xCA,0xF5,0xC0,0xFF,0xB0,0xFF,0x12,0xFF,
  0x1A,0xFF,0x1E,0xFF,0x0C,0xFE,0x07,0xFE,
  0x0E,0xFF,0x43,0xBF,0x03,0xFF,0x42,0xBF,
  0x51,0xAF,0x86,0x1F,0xFF,0xC0,0x00,0x02,
  0x80,0x02,0xC0,0xC0,0x00,0x02,0xE0,0xC7,
  0x01,0x00,0x03,0x00,0x0F,0x00,0x1F,0x00,
  0x83,0x14,0xFF,0xD5,0x7F,0x00,0x7F,0x00,
  0xFF,0x00,0xFA,0x05,0xF0,0x0F,0xC3,0x3C,
  0xA7,0x58,0xCF,0x30,0x9F,0x60,0x9F,0x60,
  0x7F,0x80,0x85,0x6C,0xFF,0x84,0x6A,0xFF,
  0xED,0x03,0xF3,0x0F,0xFC,0x03,0xFC,0x03,
  0xFF,0x07,0xFF,0x1F,0x9F,0x7F,0x7E,0xFF,
  0xF8,0xFF,0xC2,0xFF,0x82,0x7F,0x1C,0xFF,
  0xFC,0xFF,0xE4,0xFF,0xF8,0xFF,0xC3,0xFF,
  0x03,0xFF,0x01,0xFF,0x81,0xFE,0x24,0xFB,
  0x22,0xFD,0x0C,0xF3,0x84,0xFB,0x01,0x83,
  0xD9,0xFF,0xFB,0xFF,0x0E,0xFF,0x1F,0xFF,
  0x1D,0xFF,0x7B,0xFF,0x7C,0xFF,0xEA,0xFF,
  0xE5,0xFF,0x05,0xFF,0xC8,0xFF,0x2C,0xFF,
  0x2C,0xFF,0x30,0xFF,0x0C,0xFF,0x09,0xFE,
  0x30,0xFF,0x43,0xFC,0x16,0xFF,0x1B,0xFF,
  0x14,0xFF,0xDD,0x3F,0x9F,0x7F,0x1D,0xFF,
  0x0F,0xFF,0x0F,0xFF,0x00,0xFF,0x09,0xF7,
  0x81,0xFF,0x07,0xFF,0xBF,0xFF,0xFF,0x83,
  0xFC,0xFF,0xC3,0xFF,0x60,0xE0,0xC0,0x08,
  0xE0,0xC3,0xC0,0xE0,0xC0,0xC0,0x8B,0x20,
  0xFE,0xC2,0x07,0x00,0x0F,0x84,0x4A,0xFF,
  0xFF,0xFE,0x01,0x7E,0x01,0x7C,0x03,0x79,
  0x06,0xF8,0x07,0xFC,0x03,0x9F,0x60,0x3F,
  0xC0,0x7F,0x80,0x3F,0xC0,0x5B,0xA4,0x2C,
  0xD3,0x18,0xE7,0x70,0x8F,0xF5,0x0F,0xEA,
  0x1F,0x84,0x7F,0x30,0xFF,0x28,0xFF,0x30,
  0xFF,0x34,0xFB,0x01,0xFE,0x00,0xFF,0x28,
  0xD7,0xD2,0x2D,0x20,0xDF,0x40,0xBF,0x4D,
  0xB2,0xA2,0x5D,0x44,0xBB,0x02,0xFF,0x00,
  0xFF,0xC9,0x01,0xFF,0x00,0xFF,0x21,0xDF,
  0x01,0xFF,0x23,0xDF,0x83,0x4E,0xFF,0xF8,
  0x7E,0xFF,0x7F,0xFF,0xFA,0xFF,0xF8,0xFF,
  0xF8,0xFF,0xB9,0xFE,0xBB,0xFC,0x00,0xFF,
  0xC0,0xFF,0x20,0xFF,0x84,0xFB,0x0C,0xF3,
  0x2D,0xD2,0x3C,0xC3,0x36,0xC9,0x00,0xFF,
  0x2A,0xD5,0xCC,0x33,0xD0,0x2F,0xD0,0x2F,
  0x20,0xDF,0xD1,0x2F,0xC3,0x3F,0x1F,0xFF,
  0x1F,0xFF,0x3F,0xFF,0x1F,0xFF,0x7F,0xFF,
  0x7F,0x84,0xA5,0xFD,0xC1,0xC0,0xC0,0x07,
  0x80,0xC4,0xC0,0xC0,0xF0,0xE0,0xB0,0x88,
  0x10,0xFE,0x83,0x98,0xFE,0xC6,0x07,0x00,
  0x07,0x00,0x1F,0x00,0x3F,0x84,0x9A,0xFE,
  0x87,0x88,0xFD,0x42,0xFE,0x01,0xC2,0xFF,
  0x00,0xFD,0x83,0x77,0xFF,0xFF,0x00,0xF9,
  0x06,0xE1,0x1E,0xE0,0x1F,0xF4,0x0B,0xF0,
  0x0F,0xE2,0x1D,0xE0,0x1F,0xE1,0x1F,0x80,
  0x7F,0x03,0xFC,0x90,0x6F,0x4C,0xF3,0x03,
  0xFC,0x2D,0xD2,0x8C,0xF3,0x34,0xCB,0x73,
  0x8C,0x50,0xAF,0xC8,0x37,0x0C,0xF3,0x4C,
  0xB3,0x28,0xD7,0xB5,0x4A,0xA2,0x5D,0x20,
  0xDF,0x27,0xDF,0x06,0xFF,0x8E,0x7F,0x0C,
  0xFF,0x18,0xFF,0x1E,0xF9,0x06,0xFF,0xF9,
  0x2D,0xF3,0x1A,0xFD,0x19,0xFE,0x31,0xFE,
  0x32,0xFD,0xB8,0x7F,0x7B,0xFC,0xFB,0xFC,
  0xFA,0xFD,0x6A,0x95,0x0A,0xF5,0x0C,0xF3,
  0x11,0xEE,0x10,0xEF,0x30,0xCF,0xA0,0x5F,
  0x40,0xBF,0x85,0x7F,0x47,0xBF,0x07,0xFF,
  0x37,0xFF,0x07,0xFF,0x57,0xFF,0x57,0xFF,
  0x0F,0xFF,0xFC,0xFF,0xF2,0xFF,0xEB,0xFF,
  0xA8,0xFF,0xA8,0xFF,0xC0,0xFF,0x82,0xC6,
  0xFD,0x8D,0xF2,0xB2,0xFE,0x53,0xFF,0x83,
  0xEC,0xFE,0xC7,0x10,0xEF,0x40,0xBF,0x04,
  0xFB,0x50,0xAF,0x83,0xD4,0xFD,0xCB,0xC0,
  0xC0,0x20,0xE0,0xA8,0xF0,0x18,0xF8,0x88,
  0xF8,0x48,0xF8,0x83,0x3C,0xFF,0x42,0x0F,
  0x00,0x83,0xCC,0xFD,0xC0,0x0F,0x8A,0xC2,
  0xFC,0xD6,0xFA,0x05,0xF8,0x07,0xF0,0x0F,
  0xF9,0x07,0xF2,0x0F,0xEC,0x1F,0xD0,0x3F,
  0xC7,0x38,0x5C,0xE3,0xBF,0xC0,0x7C,0x83,
  0x06,0x84,0x16,0xFE,0xFF,0x93,0x7C,0x0F,
  0xF8,0x17,0xF8,0x7F,0xE0,0x2F,0xF0,0x93,
  0x6C,0xF3,0x0C,0x75,0x8A,0xF3,0x0C,0xFC,
  0x03,0xDE,0x21,0xD5,0x2A,0xFE,0x01,0x4C,
  0xB3,0x34,0xCB,0x31,0xCE,0xAA,0x55,0x83,
  0x7C,0xC0,0x3F,0x00,0xFF,0xC0,0x3F,0xAD,
  0x73,0xAB,0x77,0x1F,0xFF,0x6F,0x9F,0xFF,
  0x0F,0xE7,0x1F,0xBF,0x47,0x1B,0xE7,0xF8,
  0xFF,0xFC,0xFF,0xFE,0xFF,0xCA,0xF6,0xFF,
  0xEE,0xFF,0xDF,0xFF,0xDF,0xFF,0xFE,0xFF,
  0x80,0x88,0xC3,0xFE,0xC4,0x10,0xFF,0x02,
  0xFF,0x81,0x84,0xCC,0xFD,0xFB,0x17,0xFF,
  0x0F,0xFF,0x1F,0xFF,0x5F,0xFF,0x7F,0xFF,
  0xBA,0xFF,0x0E,0xF1,0x8C,0xF3,0x8D,0xF2,
  0x00,0xFF,0x85,0xFA,0x03,0xFC,0x80,0xFF,
  0x80,0xFF,0xA0,0x5F,0x81,0x7F,0x2A,0xD5,
  0xC0,0x3F,0x24,0xDB,0x2C,0xD3,0xCD,0x33,
  0x30,0xCF,0x2C,0xF8,0x54,0xFC,0x34,0xFE,
  0x4E,0xFE,0x52,0xFE,0x0E,0xFF,0x37,0xFF,
  0x03,0xFF,0x45,0x1F,0x00,0x83,0x28,0xFF,
  0xC3,0xF0,0x0F,0xF0,0x0F,0x83,0x86,0xFE,
  0x83,0x24,0xFC,0xDA,0x90,0x6F,0x04,0xFB,
  0x7E,0x81,0x7F,0x81,0x01,0xFF,0x43,0xBF,
  0x0E,0xFF,0x30,0xFF,0x41,0xFF,0x40,0xFF,
  0x5F,0xE0,0x3F,0xC0,0xBF,0xC0,0xFF,0x42,
  0x80,0x7F,0xDC,0x80,0xBF,0xC0,0x9C,0x63,
  0x8D,0x72,0x8E,0x71,0x5C,0xA3,0xBB,0x44,
  0xCC,0x33,0xD3,0x2C,0xEC,0x13,0xC1,0x3F,
  0x00,0xFF,0xA3,0x5F,0x01,0xFF,0x20,0xDF,
  0x85,0xA7,0xFB,0xEE,0xC5,0xFB,0xF5,0xFB,
  0x38,0xFF,0x32,0xFD,0x7C,0xFF,0x1D,0xFE,
  0x1E,0xFF,0x1E,0xFF,0xBF,0xFF,0xBF,0xFF,
  0x87,0xFF,0x31,0xCF,0xD0,0x2F,0x6C,0x93,
  0x3E,0xC1,0xBE,0x41,0xF3,0xFF,0xCF,0xFF,
  0xEF,0xFF,0xFB,0xFF,0xFA,0xFF,0x6D,0xFF,
  0x1F,0xFF,0x01,0x84,0xBA,0xFD,0xC2,0x7F,
  0xFF,0xAF,0x86,0x59,0xFB,0xC2,0x3F,0xFF,
  0xFC,0x84,0x00,0xFF,0x83,0xFA,0xFF,0xEE,
  0xF3,0xFF,0xFC,0xFF,0xEB,0xFF,0xC0,0xFF,
  0xF0,0xFF,0xF8,0xFF,0xB6,0xFF,0xDC,0xFF,
  0xFA,0xFF,0xCE,0xFF,0xFF,0xFF,0x20,0xDF,
  0x20,0xDF,0x06,0xFF,0x00,0xFF,0xC1,0xFF,
  0xB1,0xFF,0xFD,0xFF,0x7F,0xFF,0x23,0xFF,
  0xCF,0xFF,0x37,0xFF,0x8F,0xFF,0xDF,0x87,
  0x21,0xFB,0xCE,0x80,0x80,0x80,0x00,0x80,
  0x00,0x80,0xC0,0xE0,0xF0,0xF8,0x90,0xFC,
  0x8E,0xFE,0x89,0x70,0xFD,0xC0,0x01,0x42,
  0x00,0x07,0xC0,0x08,0x83,0x02,0xFC,0x89,
  0x6E,0xFD,0x83,0x20,0xFC,0xFF,0xFA,0x05,
  0xFC,0x03,0xF8,0x07,0xF9,0x06,0xF3,0x0C,
  0xF6,0x09,0x04,0xFB,0x08,0xF7,0x02,0xFD,
  0x13,0xEC,0x0C,0xF3,0x0F,0xF0,0x0C,0xF3,
  0x8D,0x72,0x1F,0xE0,0x46,0xF9,0x40,0xFF,
  0x5D,0xFF,0x93,0x7F,0x84,0x7F,0xC0,0x3F,
  0x3C,0xC3,0xFC,0x03,0xA0,0x5F,0xC0,0x3F,
  0x0F,0xFF,0xF3,0xFF,0xCD,0xFF,0x08,0xFF,
  0xC0,0x3F,0x9C,0xE3,0x01,0xFE,0xCD,0x90,
  0xEF,0xC0,0xFF,0x01,0xFF,0xA4,0xFF,0xC4,
  0xFF,0x45,0xFF,0x2E,0xFF,0x83,0x0A,0xFF,
  0xD1,0xDE,0xFF,0x3E,0xFF,0x3E,0xFF,0xFE,
  0xFF,0x7F,0xFE,0x0F,0xF0,0x7C,0x83,0x3F,
  0xC0,0x7E,0x81,0x43,0x3F,0xC0,0x83,0x30,
  0xFE,0xD4,0x40,0xBF,0xC8,0x37,0xC8,0x37,
  0x36,0xC9,0xCC,0x33,0xA8,0x57,0x1F,0xFF,
  0x6F,0xFF,0x3F,0xFF,0x5F,0xFF,0xDF,0x84,
  0xA8,0xFC,0xD1,0x7F,0xFF,0x12,0xFE,0x2C,
  0xFE,0x2C,0xFF,0x33,0xFF,0x4C,0xFF,0x0D,
  0xFF,0x0D,0xFF,0x0E,0xFF,0x83,0x54,0xFB,
  0x83,0xBE,0xFC,0x85,0x54,0xFB,0xEB,0xFF,
  0x00,0xE7,0x18,0xC7,0x38,0xCF,0x30,0xEF,
  0x10,0xCF,0x30,0xDF,0x20,0xFF,0x00,0x9F,
  0x60,0x52,0xAD,0x0C,0xF3,0x28,0xD7,0x0C,
  0xF3,0x01,0xFE,0x0F,0xFF,0x85,0x7F,0x96,
  0x7F,0xCC,0x33,0xCB,0x34,0xD2,0x2D,0xFB,
  0x04,0x0C,0xF3,0x85,0x05,0xFA,0xDC,0x21,
  0xDF,0x43,0xBF,0x81,0x7F,0x43,0xBF,0x07,
  0xFF,0x3F,0xFF,0xFF,0xFF,0xFE,0xFF,0xA3,
  0xFF,0x05,0xFF,0x83,0xFF,0xC1,0xFF,0x47,
  0xFF,0x87,0xFF,0x07,0x84,0xF0,0xFC,0x85,
  0x8E,0xFE,0x87,0xD8,0xF9,0x85,0x18,0xFE,
  0xD1,0x7C,0x83,0x39,0xC6,0x80,0xFF,0xED,
  0xFF,0x8F,0xFF,0xC8,0x37,0xC1,0x3F,0xC1,
  0x3F,0xA5,0x5F,0x83,0xC0,0xFC,0x83,0x56,
  0xFE,0x88,0xD8,0xFF,0xC5,0xFF,0xDF,0xFF,
  0x5F,0xFF,0x4F,0x8A,0xA1,0xF9,0x83,0x4A,
  0xFD,0xC0,0xFC,0x8C,0xF0,0xFF,0xC3,0xB4,
  0xFF,0xCC,0xFF,0x83,0x30,0xFD,0xDB,0xF1,
  0xFF,0xF0,0xFF,0xF0,0xFF,0x80,0xFF,0xB9,
  0xFF,0x15,0xFF,0x3E,0xFE,0xEE,0xFE,0xDA,
  0xFE,0x4E,0xFE,0x5E,0xFE,0xBE,0xFE,0x78,
  0xFE,0xC8,0xFC,0x87,0x70,0xF9,0xC7,0x7F,
  0x00,0x1F,0x60,0x0F,0x70,0x07,0x18,0x8D,
  0xD6,0xFB,0xC1,0xFD,0x03,0x83,0x6C,0xFA,
  0xEC,0xBF,0x40,0xCD,0x72,0xE3,0xFC,0x20,
  0xFF,0xA0,0xFF,0xAB,0xFF,0xC3,0x3F,0xC1,
  0x3F,0x50,0xBF,0xC1,0x3F,0xC0,0x3F,0xC5,
  0x3F,0x03,0xFF,0x37,0xFF,0xFE,0xFF,0xFA,
  0xFF,0xFA,0xFF,0xF2,0xFF,0xAC,0xFF,0xDC,
  0xFF,0x51,0xFE,0xD1,0xFE,0x0F,0x42,0xFF,
  0x07,0xCF,0xFF,0x31,0xCF,0xCB,0x37,0xB1,
  0x4F,0xA9,0x57,0xBF,0xFF,0xBC,0xFF,0xFF,
  0xFF,0xCE,0x84,0x66,0xFA,0xC3,0x09,0xFE,
  0x8B,0x7C,0x87,0xF0,0xF8,0xFF,0x5F,0xFF,
  0x08,0xFF,0x80,0x7F,0xFA,0x05,0xFD,0xFF,
  0xF8,0xFF,0xFA,0xFF,0xE0,0xFF,0x04,0xFF,
  0x08,0xFF,0x08,0xFF,0x02,0xFF,0x0F,0xFF,
  0xB7,0xFF,0x13,0xFF,0x17,0xFF,0x0B,0xFF,
  0x4F,0xFF,0x32,0xFF,0xAE,0xFF,0x8F,0xFF,
  0x8B,0xFF,0xEC,0xFF,0xDC,0xFF,0xFF,0xFF,
  0xB2,0xFF,0xFA,0xFF,0xFF,0xFF,0x30,0xFF,
  0x21,0xFF,0xD6,0xFF,0xC2,0xFF,0xD0,0x2F,
  0xFF,0xBB,0xFF,0xB3,0xFF,0xD7,0xFF,0x0E,
  0xFF,0x13,0xFF,0x3F,0xFF,0x2D,0xFF,0x33,
  0x86,0x97,0xF8,0x03,0xF8,0xC3,0x78,0xF8,
  0xF0,0xF0,0x83,0x3B,0xFA,0xCF,0x80,0xC0,
  0x80,0x80,0x01,0x1E,0x01,0x1E,0x00,0x0F,
  0x00,0x07,0x04,0x07,0x01,0x03,0x83,0x54,
  0xF8,0xE9,0xFB,0x07,0xE7,0x1F,0x0F,0xFF,
  0x81,0x7F,0x00,0xFF,0x51,0xFF,0x00,0x0F,
  0x04,0x07,0xE9,0xFF,0x24,0xFF,0x0A,0xFF,
  0x24,0xFF,0x89,0xF7,0x12,0xED,0xA7,0xD8,
  0x27,0xD8,0x35,0xFF,0xEB,0xFF,0xCB,0xFF,
  0xFF,0xFF,0x0B,0xFF,0x83,0x30,0xFE,0xC1,
  0xC9,0x37,0x89,0x40,0xF8,0xDB,0xBF,0xFF,
  0x33,0xFF,0x0D,0xFF,0x59,0xFE,0x28,0xFF,
  0xCA,0xFD,0xCC,0xFB,0xF3,0xFC,0xF3,0xFC,
  0xF9,0xFE,0x7C,0xFF,0xF0,0x0F,0xEC,0x13,
  0xF8,0x07,0x83,0x76,0xFB,0xC5,0x70,0x8F,
  0xF0,0x0F,0x21,0xDF,0x42,0x7F,0xFE,0xD9,
  0x3D,0xFE,0x78,0xFF,0x78,0xFF,0xFA,0xFD,
  0xFE,0xF9,0x09,0xFE,0xCF,0x3C,0xCD,0x3E,
  0xDE,0x3F,0xBE,0x5F,0xDF,0x3F,0xCF,0x3F,
  0xDF,0x3F,0x83,0x98,0xF8,0xCC,0xEF,0x10,
  0x36,0xC9,0x1C,0xE3,0x90,0xEF,0xE0,0xFF,
  0xFC,0xFF,0x03,0x84,0x9E,0xFB,0xD2,0x80,
  0x7F,0x04,0xFF,0x04,0xFF,0x03,0xFF,0x43,
  0xBF,0x35,0xFF,0xDF,0xFF,0xF7,0xFF,0x2F,
  0xFF,0xDF,0x86,0x1E,0xFA,0x03,0xFE,0xC9,
  0xFC,0xFC,0xF8,0xF8,0xF0,0xF8,0xE0,0xE0,
  0x80,0x80,0x84,0x39,0xF8,0xC1,0x01,0x01,
  0x8A,0x8B,0xF7,0xE7,0x0E,0xF1,0x0B,0xF4,
  0x16,0xE9,0xCF,0xB0,0x2F,0x50,0x73,0x4C,
  0x18,0x67,0x02,0x3F,0xF1,0x0F,0xA8,0x57,
  0xF8,0x07,0xF1,0x0E,0xD1,0x2E,0xC8,0x37,
  0xF8,0x07,0x08,0xFF,0x03,0xFF,0x21,0xDF,
  0x68,0x97,0xB2,0x4D,0x83,0x0C,0xFA,0xC6,
  0xF6,0x09,0xFE,0x01,0xFE,0xFF,0x7E,0x84,
  0xBE,0xF9,0xCE,0x9F,0x7F,0x1F,0xFF,0xEF,
  0x1F,0xA7,0x5F,0x11,0xEF,0x01,0xFF,0x83,
  0xFF,0x97,0x88,0x59,0xF7,0xCF,0xF7,0xF8,
  0xF3,0xFC,0xEF,0xF0,0xFF,0xE0,0xFF,0xE0,
  0xFF,0xC0,0x9F,0xE0,0xBE,0xC1,0x42,0x1F,
  0xFF,0xC1,0xDF,0x3F,0x83,0xFC,0xFF,0xC7,
  0x9F,0x7F,0xBF,0x7F,0xFC,0xFF,0xF9,0xFE,
  0x83,0x4E,0xFE,0xC6,0xEF,0xFF,0xEB,0xFF,
  0xF5,0xFF,0xF0,0x84,0xDA,0xFC,0xC2,0x17,
  0xFF,0x8F,0x88,0x67,0xFD,0x0F,0xFE,0xC5,
  0x05,0x1F,0x04,0x07,0x01,0x07,0x89,0xDA,
  0xF6,0xD1,0xF3,0xFE,0xF1,0xFE,0xF1,0xFE,
  0x21,0xFE,0x09,0x76,0x0C,0x73,0x1A,0x65,
  0x12,0x6D,0x3F,0xC0,0x8B,0xEE,0xF6,0xCF,
  0x1E,0xE1,0xE3,0x1F,0xA3,0x5F,0xF5,0x0F,
  0xF3,0x0F,0xE0,0x1F,0xD8,0x27,0xA0,0x5F,
  0x87,0xA8,0xFF,0x85,0x5A,0xFB,0x83,0x0C,
  0xF9,0xC2,0xDE,0xE1,0xE3,0x88,0x10,0xFD,
  0xDA,0xF8,0xFF,0xF9,0xFE,0x3F,0xFF,0xFE,
  0xFF,0xFD,0xFF,0xFF,0xFF,0xF2,0xFF,0x39,
  0xFF,0x10,0xFF,0x40,0xBF,0xF3,0xFF,0xF4,
  0xFF,0x7D,0xFF,0x5B,0x84,0x50,0xF7,0xC2,
  0x07,0xFF,0x03,0x84,0x81,0xF6,0xD4,0xFC,
  0xFF,0xFB,0xFF,0xF5,0xFF,0xD3,0xFF,0xCC,
  0xFF,0xB3,0xFF,0xF7,0xFF,0xEF,0xFF,0x83,
  0xFF,0x57,0xFF,0x3F,0x84,0x70,0xFC,0xC5,
  0x7F,0xFF,0xFE,0xFE,0xFC,0xFE,0x07,0xFC,
  0x83,0xC4,0xFD,0xD3,0x2C,0x53,0x2C,0x53,
  0x2C,0xD3,0x2C,0xD3,0x13,0xEC,0x13,0xEC,
  0x04,0xFB,0x03,0xFC,0x32,0xCD,0x41,0xBF,
  0x83,0x42,0xFC,0xCA,0x47,0xBF,0x03,0xFF,
  0xC3,0x3F,0x07,0xFF,0x7F,0xFF,0xEA,0x84,
  0x2D,0xF6,0xC6,0xBD,0xFF,0xF3,0xFF,0xFB,
  0xFF,0xBD,0x84,0x2A,0xFC,0x87,0x68,0xFC,
  0xC2,0x7F,0xFF,0x3F,0x42,0xFF,0xF8,0x8A,
  0x30,0xFC,0xCA,0xA0,0x5F,0xC1,0x3E,0x4A,
  0xB5,0x52,0xAD,0x08,0xF7,0xF0,0x84,0xF5,
  0xF5,0x83,0x6C,0xFF,0xC6,0x93,0x6F,0x0F,
  0xFF,0x47,0xBF,0x0F,0x88,0xCC,0xFA,0x42,
  0xFE,0xFF,0xC8,0xFA,0xFF,0xF3,0xFF,0xED,
  0xFF,0xCC,0xFF,0x33,0x84,0x68,0xF7,0x83,
  0x1E,0xF8,0x87,0x30,0xFD,0xC1,0xF0,0xF8,
  0x03,0xF0,0xC0,0xE0,0x84,0x2C,0xFD,0x84,
  0x55,0xFC,0xC2,0x7F,0x00,0x3F,0x84,0xF3,
  0xF8,0xDB,0x07,0x00,0x03,0x05,0xFF,0x00,
  0xFF,0x22,0xDD,0x13,0xEC,0x00,0xFF,0x0D,
  0xFF,0x4F,0xFF,0x17,0xFF,0xEE,0xFF,0x5E,
  0xFF,0x12,0xFF,0x05,0xFF,0x27,0x86,0xD2,
  0xFB,0xC0,0xDF,0x84,0x26,0xF7,0x87,0x7A,
  0xF5,0xC1,0x8F,0x8F,0x88,0x18,0xFE,0xC7,
  0xFF,0xEC,0xFF,0xCD,0xFF,0xFF,0xFF,0xEF,
  0x88,0x5F,0xF5,0xC2,0x4D,0xFF,0x0F,0x86,
  0x32,0xFF,0xC4,0xFF,0xFF,0xCF,0xFF,0x5F,
  0x86,0x50,0xFB,0x87,0x40,0xF5,0xC2,0xF8,
  0xFC,0xE0,0x84,0xF2,0xF6,0x83,0x90,0xF7,
  0x8B,0x0C,0xF5,0xC2,0x0C,0xFF,0x03,0x88,
  0x6C,0xF5,0x83,0xF4,0xF4,0xC5,0xFC,0xFE,
  0x58,0xF8,0x00,0xE0,0x8A,0xCC,0xF6,0x02,
  0x07,0xC1,0x01,0x03,0x89,0x4D,0xFD,0x89,
  0x40,0xFB,0xC5,0x7F,0x7F,0x1F,0x1F,0x07,
  0x0F,0x8D,0xE0,0xF4,0xC1,0x80,0xCC,0x83,
  0x1C,0xFC,0x83,0xCC,0xF4,0x85,0x42,0xFC,
  0x87,0xC0,0xF4,0xC3,0xFC,0xFC,0x00,0x20,
  0x85,0x96,0xF4,0xC0,0xF8,0x87,0xF8,0xFC,
  0x86,0x87,0xF4,0xCA,0x10,0x30,0xD8,0xF0,
  0x6C,0xFE,0x65,0x5E,0x89,0x7C,0x3E,0x84,
  0xDD,0xFF,0xFF,0x3A,0x3A,0xDD,0xF7,0x7C,
  0x7A,0x60,0x96,0xAF,0x78,0x47,0x00,0x46,
  0x00,0x00,0x00,0x08,0x1F,0xD3,0x7C,0xE4,
  0xBE,0x1E,0x68,0x68,0x00,0x40,0x00,0x44,
  0x00,0x00,0x00,0x18,0x00,0x04,0x30,0x34,
  0x38,0x6C,0x38,0xC4,0xF8,0x36,0xE8,0x70,
  0x78,0x48,0x60,0x4C,0x40,0x8E,0xF0,0x6E,
  0x50,0xE8,0xA8,0xE0,0xF8,0xB8,0xE8,0x76,
  0x68,0x48,0x50,0xD0,0x40,0x80,0x50,0xA0,
  0x32,0xE0,0x98,0xF0,0x50,0xE0,0x28,0x70,
  0x6E,0x50,0x60,0x20,0x00,0x02,0x10,0xC9,
  0x1A,0x78,0x77,0xD8,0x7E,0x19,0xEF,0x3D,
  0x3C,0xBD,0x04,0x3C,0xD7,0x3E,0x3C,0x3E,
  0x3E,0x3C,0x3E,0x10,0x3E,0x0C,0x7E,0x00,
  0xDB,0x34,0x00,0x00,0x76,0x52,0x7E,0x08,
  0x10,0x7E,0x42,0x7E,0x2C,0x83,0x25,0xF4,
  0xC0,0x7E,0x83,0x21,0xF4,0xDA,0x01,0xFE,
  0x83,0x7C,0x07,0xF8,0x07,0xF8,0x7F,0xF0,
  0x43,0xC0,0x93,0x6C,0xEB,0x0C,0x75,0x92,
  0xE3,0x04,0xC4,0x03,0xE2,0x21,0xC5,0x06,
  0x82,0x8C,0x80,0xF7,0xD4,0x06,0xFF,0xF6,
  0x37,0x20,0xE0,0x20,0xC0,0x30,0xD0,0x78,
  0x88,0x78,0x80,0x7E,0x80,0x7C,0x80,0x3C,
  0xC0,0x00,0x02,0x02,0x86,0x3E,0xF6,0x84,
  0x19,0xFC,0xC9,0x84,0x87,0x08,0x0F,0x10,
  0x1F,0x20,0x3F,0x20,0x1F,0x83,0x55,0xF4,
  0xD8,0x80,0xFF,0x18,0xE0,0x04,0xFC,0x08,
  0xF8,0x0B,0xFB,0x9C,0x7F,0x9C,0x7F,0xC8,
  0x3F,0x3C,0xC3,0x00,0x00,0x10,0x50,0xCF,
  0xFF,0x87,0x86,0xA9,0xF3,0xCA,0xC0,0x3F,
  0x5C,0x63,0x61,0x7E,0x30,0x2F,0xF0,0xFF,
  0x20,0x8A,0x9F,0xF3,0xCB,0x01,0x01,0x03,
  0x03,0x01,0x07,0x09,0x0F,0x7A,0x7F,0xFF,
  0xFF,0x83,0x6E,0xFE,0x83,0x6C,0xF3,0xE2,
  0xF9,0xFF,0xFB,0xFF,0xFF,0xFF,0xEE,0xFF,
  0x00,0x00,0xF0,0xE0,0x90,0xF8,0x98,0xFC,
  0xCC,0xF8,0x90,0xFC,0x18,0xFC,0x30,0xF8,
  0x03,0x03,0x07,0x07,0x0F,0x0F,0x1F,0x1F,
  0x2F,0x3F,0x38,0x02,0x3F,0xC1,0x3D,0x7F,
  0x83,0xC6,0xFC,0xC8,0xE8,0xFF,0xBD,0xFF,
  0xD8,0xFF,0x07,0xFF,0x96,0x85,0x8C,0xFC,
  0xFF,0xFF,0xC3,0xFF,0xD5,0xEF,0x44,0xFF,
  0x00,0xFF,0x1F,0xFF,0xB9,0xFF,0xC4,0xFE,
  0xCE,0xFE,0x5A,0xFE,0x3E,0xFE,0x24,0xF8,
  0xCC,0xF0,0x5E,0xE0,0xFE,0xE0,0x10,0x7F,
  0x7E,0x7F,0x06,0x7F,0x69,0x76,0x7A,0x75,
  0x2F,0x1C,0x0A,0x35,0x35,0x1A,0x7B,0xFF,
  0x79,0xBF,0xF7,0xFD,0xFE,0x75,0xB4,0xFB,
  0xDF,0x70,0x05,0xFA,0x6D,0xB6,0xA1,0xFE,
  0xE7,0xD0,0xFC,0xEB,0xFC,0xC9,0xFF,0xFB,
  0xCF,0xF7,0x0F,0x9A,0x67,0xFF,0x00,0x3E,
  0xC0,0xEC,0x10,0x42,0xFC,0x00,0xFF,0x78,
  0x80,0xF8,0x00,0xF0,0x00,0x50,0x40,0x50,
  0x40,0x02,0x30,0x42,0x78,0x40,0x3E,0x0C,
  0x3C,0x60,0x3C,0x00,0x38,0x2C,0x5E,0x04,
  0x3C,0x20,0x3C,0x02,0x18,0x10,0x1C,0x30,
  0x1C,0x04,0x1E,0x14,0x1C,0x44,0x1C,0x62,
  0x7E,0x38,0x3C,0x0C,0x3C,0x15,0x1F,0x26,
  0x7C,0x02,0x3E,0x00,0x3C,0x04,0x18,0x14,
  0x38,0x00,0x38,0x3C,0x3C,0x28,0x38,0xF5,
  0x4C,0x7C,0x66,0x1A,0x02,0x3E,0x04,0x3C,
  0x00,0x3C,0x37,0x3F,0x06,0x3C,0x28,0x3E,
  0x00,0x1C,0x0A,0x10,0x1C,0x02,0x20,0x18,
  0x18,0x10,0x10,0x10,0x30,0x12,0x12,0x7E,
  0x53,0x7C,0xD0,0x3E,0x34,0x7C,0x16,0x0F,
  0x1F,0x3F,0x36,0x1B,0x52,0x12,0x50,0x12,
  0xC0,0x12,0x82,0x10,0x92,0x00,0x47,0x05,
  0x03,0x00
};

void init_aquaria_tileset(void) BANKED {
  gb_decompress_bkg_data(0, tileset);

  // Set up the palette
  set_bkg_palette(0, 6, tilesetCGBPal);
  set_bkg_palette(7, 1, tilesetCGBPalrest);
}

/* End of TILESET.C */
