/*

 MIA_HUG_TILES.C

 Tile Source File.

 Info:
  Form                 : All tiles as one unit.
  Format               : Gameboy 4 color.
  Compression          : None.
  Counter              : None.
  Tile size            : 8 x 8
  Tiles                : 0 to 98

  Palette colors       : Included.
  SGB Palette          : None.
  CGB Palette          : Constant per entry.

  Convert to metatiles : No.

 This file was generated by GBTD v2.2

*/
#include <gb/gb.h>
#include <gb/cgb.h>
#include <stdint.h>
#include <gb/gbdecompress.h>

#pragma bank 255

/* Start of tile array. */
const unsigned char mia_hug_tiles[] =
{
  0xFF,0x52,0x00,0xAD,0x00,0x55,0x00,0x57,
  0x00,0x6D,0x00,0xB7,0x00,0xAD,0x00,0xF7,
  0x00,0x5E,0x00,0xA3,0x00,0x75,0x00,0x58,
  0x00,0xDF,0x00,0xFC,0x03,0xBD,0x03,0xDF,
  0x01,0xE5,0x00,0x56,0x01,0xB3,0x0F,0xCF,
  0x3F,0xFF,0x7F,0xFE,0xFF,0xF8,0xFF,0x62,
  0xFD,0x5F,0x00,0xBF,0x40,0xF1,0xFE,0xF8,
  0xFF,0xC0,0xFF,0x04,0xFF,0x01,0xFF,0x00,
  0xFF,0x42,0xFF,0x00,0xC9,0x7F,0x80,0x37,
  0xC0,0x0F,0xF0,0x45,0xF8,0x03,0xFC,0x83,
  0xF0,0xFF,0xC1,0xFD,0x02,0x44,0xFF,0x00,
  0xC6,0xDF,0x20,0xFD,0x02,0xEF,0x10,0xFE,
  0x83,0xD5,0xFF,0xCA,0x00,0xFF,0x00,0xBF,
  0x40,0xDF,0x20,0xFF,0x00,0xED,0x12,0x83,
  0xCA,0xFF,0x83,0xFA,0xFF,0xCD,0x7F,0x80,
  0xFD,0x02,0xBF,0x40,0xEF,0x10,0xFB,0x04,
  0xBF,0x40,0xF6,0x09,0x83,0xB8,0xFF,0xDA,
  0x9A,0x00,0x6F,0x00,0xF5,0x00,0xBE,0x00,
  0xD5,0x00,0xF6,0x00,0x5E,0x00,0xF6,0x00,
  0xFF,0x00,0x48,0x07,0xE3,0x07,0xAB,0x07,
  0xE3,0x07,0xBE,0x84,0xBC,0xFF,0xCF,0x4A,
  0xB5,0x00,0xFF,0x82,0xFD,0xE4,0xFB,0x89,
  0xF7,0x00,0xFF,0xB3,0x4C,0xA7,0x18,0x83,
  0x81,0xFF,0xEA,0x02,0xFF,0x28,0xFF,0x0D,
  0xF2,0x50,0xAF,0xC1,0x3F,0x0F,0xFF,0x03,
  0xFC,0x43,0xFC,0x65,0xFE,0x04,0xFF,0x01,
  0xFE,0x51,0xAE,0x03,0xFC,0xFB,0xFC,0x7F,
  0x00,0xFF,0x00,0x7E,0x00,0xA9,0x00,0x97,
  0x00,0x39,0x07,0x57,0x3F,0x3F,0x84,0x50,
  0xFF,0xC6,0xBF,0x00,0x4B,0x00,0xB7,0x48,
  0xB4,0x05,0xFF,0x88,0x56,0xFF,0xC7,0x7F,
  0x80,0x9F,0xE0,0xC7,0xF8,0xDB,0x24,0x89,
  0xF0,0xFF,0x83,0x24,0xFF,0xFF,0xAF,0x00,
  0xFA,0x00,0xDF,0x00,0xF6,0x00,0xBF,0x00,
  0xEB,0x00,0x7F,0x00,0xDE,0x00,0x7A,0x05,
  0xBE,0x01,0x5E,0x01,0xAF,0x00,0x7F,0x00,
  0xBF,0x00,0xFF,0x00,0xF6,0x01,0x9B,0x00,
  0x8F,0x00,0x17,0xC8,0xB2,0x4D,0x2B,0xDC,
  0x82,0x7D,0x8A,0x7D,0x1C,0xFF,0x07,0xFF,
  0x57,0xFF,0x13,0xEF,0xFC,0x03,0xA6,0x19,
  0x47,0xB8,0x14,0xFB,0x00,0xFF,0xCF,0xFF,
  0xFC,0xF0,0xFF,0xF9,0xFF,0xF1,0xFF,0xE3,
  0xFF,0x6F,0xF7,0x47,0xFF,0xF7,0xEF,0x0D,
  0xFF,0xC0,0xDD,0x10,0xFF,0xCF,0xF3,0xFC,
  0xD3,0xFC,0xE9,0xFE,0xA8,0xFF,0xFC,0xFF,
  0xD4,0xFF,0xF8,0xFF,0xD1,0xFE,0x89,0xB4,
  0xFE,0x83,0x90,0xFF,0xDA,0xFE,0x01,0x77,
  0x00,0xBF,0x00,0xED,0x00,0x7F,0x00,0xAF,
  0x00,0xFF,0x00,0xEF,0x00,0xBD,0x00,0xFF,
  0x00,0xD7,0x00,0xFF,0x00,0xF7,0x00,0xFB,
  0x86,0x8E,0xFE,0xD4,0x1A,0xFD,0x2C,0xFF,
  0x02,0xFD,0xEE,0x11,0xDC,0x01,0xFF,0x00,
  0xE2,0x1D,0xF5,0x08,0x5F,0xFF,0x5F,0xFF,
  0x3F,0x83,0xFC,0xFF,0xFF,0xFF,0x1F,0xFF,
  0x1F,0xFF,0x0C,0xFF,0x6F,0xFF,0xC7,0xFF,
  0xEE,0xFF,0x80,0xFF,0xCF,0xF0,0xE9,0xF0,
  0xF8,0xF1,0x01,0xF8,0xBF,0xDC,0x43,0xBC,
  0x33,0xFC,0x36,0xF9,0x70,0xFF,0x71,0xFE,
  0x39,0xFE,0x3B,0xFC,0xFF,0xFF,0x7F,0xFF,
  0x8F,0x7F,0x1F,0xEF,0x3B,0xC7,0x37,0xC3,
  0x97,0x63,0x4D,0xF3,0xE0,0xFF,0xC7,0xF8,
  0xC3,0xFC,0xEF,0xD0,0xA7,0xCC,0xD8,0x97,
  0xE8,0xAF,0xD0,0x85,0xFA,0xDF,0x00,0xDF,
  0x00,0xFE,0x01,0x83,0x04,0xFF,0xC3,0xFF,
  0x00,0xFB,0x04,0x83,0x02,0xFE,0xCA,0xEF,
  0x00,0xFB,0x00,0xFE,0x00,0xFF,0x00,0x6F,
  0x00,0xF7,0x86,0x0A,0xFE,0x83,0x74,0xFF,
  0xF1,0xFE,0x00,0x7E,0x00,0xFC,0x00,0xF1,
  0x00,0xEC,0x00,0xF5,0x0A,0xF1,0x0E,0xB4,
  0x0F,0xA4,0x1F,0x9C,0x0F,0x54,0x0F,0x1A,
  0x07,0x8C,0x7F,0xC7,0x3F,0xA7,0x1F,0x79,
  0x87,0x3E,0xC1,0x1F,0xE0,0x0F,0xF0,0x4D,
  0xF0,0x0C,0xF0,0x0C,0xF0,0xE8,0xF0,0xDE,
  0xE0,0x1F,0xE0,0x85,0xB6,0xFD,0xEC,0xB9,
  0x7E,0x3C,0x7F,0xBF,0x7F,0xFF,0x7F,0xBF,
  0x7F,0x9F,0x7F,0x87,0x7F,0xC7,0x3F,0x51,
  0xFF,0x78,0xFF,0xF8,0xFF,0xF9,0xFE,0xF8,
  0xFF,0xFE,0xFF,0xFC,0xFF,0xFD,0xFE,0x83,
  0xFC,0x07,0xF8,0x16,0xF8,0x8F,0x70,0x3F,
  0xC0,0xF7,0x00,0x5F,0x84,0x5E,0xFE,0x85,
  0x7A,0xFF,0xC3,0xFF,0x00,0xF7,0x08,0x83,
  0x74,0xFD,0x83,0x76,0xFF,0x84,0xD6,0xFE,
  0xD8,0x00,0xEE,0x00,0xFC,0x00,0xFE,0x00,
  0xF0,0x00,0x81,0x00,0x81,0x00,0x01,0x00,
  0x01,0x00,0x1D,0x00,0x51,0x3E,0x00,0x7F,
  0xAC,0x03,0x83,0xD0,0xFE,0xC4,0xAF,0x00,
  0xFB,0x00,0xB7,0x84,0x46,0xFD,0xCB,0x53,
  0xF8,0x87,0x78,0xF3,0x0C,0xA3,0x5C,0xA7,
  0x58,0xDD,0x20,0x85,0xBC,0xFF,0xD8,0xF5,
  0x0A,0xFF,0x00,0x3D,0xC2,0x1E,0xE1,0x8F,
  0x70,0x8F,0x70,0x8E,0x71,0x8B,0x3F,0xE8,
  0x1F,0xF3,0x0F,0xF8,0x07,0xF7,0x00,0xFA,
  0x83,0x18,0xFF,0xCE,0x01,0xF1,0xFE,0xE4,
  0xFB,0x80,0xFF,0x26,0xDF,0xC8,0x3F,0xB8,
  0x7F,0xB8,0x7F,0x85,0x00,0xFD,0x83,0x22,
  0xFD,0xC7,0x7F,0x80,0x8F,0x70,0x87,0x78,
  0x87,0x78,0x8B,0x04,0xFD,0x83,0xE4,0xFC,
  0x83,0x7C,0xFF,0x42,0xFE,0x00,0xF0,0x6E,
  0x90,0xFC,0x00,0xDE,0x20,0x68,0x3F,0x8A,
  0x7F,0x2B,0x7F,0x16,0x7F,0x4B,0x3F,0x0B,
  0x3F,0x0B,0x3F,0x25,0x1F,0x7F,0x80,0x79,
  0x86,0x34,0xCB,0x39,0xC6,0x1B,0xE7,0xBF,
  0xC3,0x8D,0xF3,0x9E,0xE1,0xC2,0x01,0xE6,
  0x01,0xA8,0x57,0x01,0xFE,0x00,0xFF,0xFD,
  0x84,0x60,0xFD,0xFF,0xE7,0x18,0xC7,0x38,
  0xE3,0x1C,0x0F,0xF0,0x97,0xE8,0x7F,0xC0,
  0xCE,0xF1,0xAF,0xD0,0xFE,0x01,0xFE,0x01,
  0x7F,0x80,0xF7,0x00,0xF9,0x06,0xF1,0x0E,
  0xE0,0x1F,0x98,0x7F,0xA0,0x5F,0x52,0xAD,
  0x18,0xE7,0x5A,0xA7,0xE6,0x1F,0xDD,0x3E,
  0x5D,0xBE,0x3C,0xFF,0x93,0x6C,0x21,0xDE,
  0x21,0xDE,0x00,0xFF,0xC1,0x3E,0xE4,0x1B,
  0xF0,0x0F,0x1C,0xFF,0xC5,0x3F,0x00,0xBF,
  0x00,0x9F,0x00,0x83,0xFA,0xFC,0xE0,0x3F,
  0xC0,0xBF,0x40,0x5F,0xA0,0xFC,0x00,0xF4,
  0x08,0xFC,0x00,0x7C,0x80,0xFC,0x00,0xFC,
  0x00,0xF8,0x00,0xFC,0x00,0x02,0x1F,0x13,
  0x0F,0x11,0x0F,0x01,0x07,0x01,0x03,0x02,
  0x83,0xDB,0xFE,0xFF,0x00,0xCE,0xF1,0x0F,
  0xF0,0xC7,0xF8,0x07,0xF8,0x67,0xF8,0x53,
  0xFC,0x72,0xFC,0x5B,0xFC,0xFF,0xFF,0x73,
  0xFF,0x13,0xFF,0x81,0x7F,0xFE,0x01,0xFE,
  0x00,0x63,0x80,0xC2,0x00,0xCF,0xF0,0x86,
  0xF8,0x87,0xF8,0x59,0xA4,0x9E,0x60,0xF6,
  0x08,0xF7,0x00,0xB7,0x00,0xB4,0x7B,0xF8,
  0x77,0xE8,0x77,0x98,0x67,0xA0,0x4F,0xD9,
  0x06,0x9B,0x44,0x76,0xE4,0x89,0x7F,0xFF,
  0xAF,0xFF,0xFB,0xFF,0xDE,0xFF,0x6B,0xFF,
  0x34,0xFF,0x80,0x7F,0x07,0xF8,0xF0,0xFF,
  0xE0,0xFF,0xE2,0xFF,0xF8,0xFF,0xFB,0xFC,
  0x0F,0xF0,0x3B,0xC0,0x7B,0x80,0x1F,0xE0,
  0x3F,0xC0,0x85,0xA6,0xFC,0x85,0xC6,0xFB,
  0x83,0x7C,0xFF,0xC4,0xF8,0x00,0xF8,0x00,
  0xF0,0x83,0xFC,0xFF,0xC1,0x00,0xE0,0x10,
  0x00,0xFF,0x7D,0xFE,0x3D,0x7E,0x3D,0x7E,
  0x1C,0x3F,0x3E,0x1F,0x0A,0x1F,0x1D,0x0E,
  0x00,0x0F,0x00,0x00,0x24,0x18,0xA3,0x1C,
  0x98,0x07,0x93,0x0F,0xDF,0x3F,0x3F,0xFF,
  0x7F,0xFF,0x5B,0x04,0xE2,0x1C,0x02,0xFC,
  0x42,0xBC,0x53,0xBC,0x77,0x98,0xD4,0xBB,
  0x01,0xFF,0x7F,0x80,0x5A,0x81,0xCE,0x01,
  0x88,0x07,0xA3,0x5F,0x3F,0xFF,0xFF,0xFF,
  0xF8,0xFF,0xC9,0x16,0xE9,0x80,0x7F,0x02,
  0xFF,0x7F,0xFF,0xFF,0xFF,0x83,0x40,0xFB,
  0xD1,0x00,0xFF,0x3F,0xC0,0x3F,0xC0,0xFF,
  0xC0,0xB5,0xC8,0x3F,0xC0,0x66,0x98,0x4F,
  0xB0,0x17,0xE8,0x85,0x42,0xFE,0x87,0x9E,
  0xFC,0xD0,0xEF,0x00,0x60,0x00,0xF0,0x00,
  0x40,0x00,0xA0,0x00,0xC0,0x00,0xA0,0x00,
  0x40,0x00,0x80,0x8A,0x70,0xFF,0xD5,0x04,
  0x00,0x1F,0x00,0x18,0x00,0x08,0x07,0x05,
  0x03,0x0D,0x03,0x12,0x01,0x10,0x00,0x50,
  0x00,0xD8,0x00,0x50,0x00,0x83,0x9C,0xFF,
  0xC4,0xD1,0xFE,0x0E,0xF0,0x46,0x84,0xDE,
  0xFF,0xF7,0x04,0x00,0x88,0xFF,0xE3,0x1C,
  0xE2,0x1C,0x15,0x3E,0x7C,0x3F,0x7F,0x3E,
  0xBE,0x7F,0x3F,0x7E,0x00,0xFF,0xD8,0x07,
  0x33,0x0F,0xD3,0x0F,0x58,0x07,0xCC,0x03,
  0x48,0x07,0x88,0x07,0x02,0xFF,0x17,0xFF,
  0xFF,0xFF,0xBA,0xFF,0xD1,0xFE,0x05,0xFA,
  0xA1,0x5E,0x20,0xFF,0xDC,0xE0,0x9C,0xE0,
  0x2E,0xC0,0x83,0xF8,0xFA,0xD6,0x2B,0xD4,
  0x14,0xEB,0xC3,0xFC,0x3F,0x00,0x77,0x00,
  0x3F,0x00,0x3B,0x00,0x1F,0x00,0xAF,0x00,
  0x97,0x00,0xDF,0x00,0xC0,0x44,0x00,0x80,
  0xD4,0x00,0x81,0x00,0x80,0x00,0x1E,0x00,
  0x13,0x00,0x7F,0x00,0x4A,0x34,0xA9,0x56,
  0xD0,0x2F,0x94,0x6B,0x40,0xBF,0x83,0x5C,
  0xFF,0xC1,0xF8,0x00,0x83,0xBC,0xFA,0xCE,
  0x38,0x80,0x7C,0x80,0x0A,0xE4,0x03,0x00,
  0x0F,0x00,0x7A,0x04,0x46,0xB8,0xFC,0x86,
  0xB6,0xFE,0xFF,0x3E,0x7F,0x3C,0x7F,0xBF,
  0x7E,0x3C,0x7F,0x59,0x36,0x5D,0x22,0x2D,
  0x56,0x47,0x3E,0x43,0x07,0x09,0x07,0x85,
  0x0F,0x16,0x0F,0x96,0x0F,0x9E,0x0F,0x0F,
  0x1F,0x0F,0x1F,0xFC,0xFB,0xFD,0xFB,0xF5,
  0xFB,0xF9,0xF7,0xEB,0xF7,0x63,0xFF,0x13,
  0xEF,0x97,0xEF,0x98,0xE7,0x87,0xF8,0x40,
  0xFF,0x0F,0xF0,0xC3,0xFC,0xE7,0xF8,0xA2,
  0xFC,0xF7,0xF8,0xC5,0xBF,0x00,0xDF,0x00,
  0xFF,0x00,0x83,0x84,0xFA,0x83,0xB6,0xFA,
  0xC0,0x7F,0x48,0x00,0x00,0x00
};

const palette_color_t* const mia_hug_pal[] =
{
  /* Gameboy Color palette 0 */
  12679,
  16906,
  23248,
  28566,
  /* Gameboy Color palette 1 */
  0,
  0,
  0,
  0,
};

void init_mia_hug_tiles(uint8_t tile_start_idx, uint8_t pal_start_idx) BANKED {
  gb_decompress_bkg_data(tile_start_idx, mia_hug_tiles);

  // Set up the palette
  set_bkg_palette(pal_start_idx, 2, mia_hug_pal);
}

/* End of MIA_HUG_TILES.C */
