!cpu 6510
newline			= $aad7				;print a newline and update screen pointers
print_chr		= $f1ca				;print a char, increments print_y ($d3)
screen			= $d1				;screen pointers
const			= $f2				;constant returned by newline ($0d eor $ff)
print_y			= $d3				;y-position on $f1ca call

			* = $032c
			!word entry			;y = $0a, x = $00, a = $00, c = 1 on entry
nextline
			jsr newline			;next line on screen, scroll if needed, c = 0, a = $f2
			adc data,x			;add table to constant $f2, will set carry and give correct val
entry							;enters with a = 0, x = 0 and c = 1, so val is 0 and carry is set, perfect
			ldy #$09			;start pos left side, carry is set, so we will set first '*' always
			sty print_y			;start pos right side
loop
			pha				;store val
			bcs print			;set, so print '*'
			lda #$20			;select ' '
			cpx #$09			;check for line #10?
			bne clear			;not yet, so print ' '
			lda #$ca			;change direction -> opcode for dex, now the bpl nextline hits in after 9 more turns
			sta dir				;modify code, also print always in this case, to have a solid line, by falling through to print now
print
			lda #$2a			;select '*'
clear
			jsr print_chr			;print right side, autoincrements $d3
			sta (screen),y			;print left side, dey decrements later
			pla				;restore val
			lsr				;shift out next bit
			dey				;count down left, (TODO: could also enter code here)
			bpl loop			;not done yet
dir			inx				;inc/dec data index
			bpl nextline			;more lines to come
			;rts				;be nice for now and return instead of jam
data
			!byte <%00000000 - const	;upper left quarter of the snowflake, encoded in bits minus a constant as offset
			!byte <%00000010 - const
			!byte <%01010001 - const
			!byte <%00110000 - const
			!byte <%01110010 - const
			!byte <%00001001 - const
			!byte <%00000100 - const	;$12 -> jam as end condition
			!byte <%10010010 - const
			!byte <%01001001 - const
