* = $2a01
data:		.by %00000010
		.by %01010001
		.by %00110000
		.by %01110010
		.by %00001001
		.by %00000100
		.by %10010010
		.by %01001001
		.by %11111111
		.by %01001001
		.by %10010010
		.by %00000100
		.by %00001001
		.by %01110010
		.by %00110000
		.by %01010001
		.by %00000010
		.by %00000000
data_end:

code_start:
next_bit:	lsr data_ptr:*	// Push LSB of currently processed byte to Carry.
		inx
		dey
		bcc skip	// If C=0, do not print star.
print:		sta $0409-'*',x	// Print right hand side of snowflake...
		sta ($0e),y	// ...and the left side. $0e-$0f contain address $0400.
skip:		bne next_bit	// If Y>0, keep processing bits.
		dec $7f		// Holds value $0a, thus we count down from 10 to 0.
		beq print	// On 10th line, print the left- and rightmost stars.
SYS10789:	jsr $e981	// Scroll screen contents down by a line.
		ldy #9
		lax $15		// A = X = $2a = '*' (hi byte of SYS address).
		dec data_ptr	// Move pointer to previous byte in our data table.
		bpl print	// On branch, always print middle star.
		.by 2		// JAM instruction (halts CPU).
code_end:

/**
This implementation prints the snowflake in three "parts", if you wish:
- The middle star (index 0) is printed on every row.
- The leftmost and rightmost stars (indexes -9 and 9) are printed only on 10th line.
- The snowflake pattern is held as bits in bytes, and printed on right hand side (indexes 1 to 8,
  incremented with X) as well as mirrored on left hand side (indexes -1 to -8, decremented with Y).

Program flow is as follows:
- When entering the program at label 'SYS10789', screen contents are pushed down by a line,
  data pointer decremented so that it points to the last byte in the table, we print the
  middle star, and then as 'dec data_ptr' provided a result >0, we move on to processing
  the bits in the last byte on data table.
- This continues until we reach line 10, on which, after processing the byte, 'dec $7f'
  results to zero and the branch being taken, printing the left- and rightmost stars.
- Then it is again business as usual, until data_ptr reaches zero. When it does, we do branch
  to print the middle star, however as Z flag was set by the aforementioned decrementing  we fall
  through the 'bne next_bit'. This means we do not try to process the non-existing byte at address
  $2a00.
- When the data pointer reaches $ff, 'bpl print' falls through to '.by 2', which is a JAM instruction
  and thus stops the execution of the program. RTS would have been nicer, but the READY. prompt
  could mess up our newly created pretty snowflake. :)

Size-reducing tricks used:
- Program location is chosen so that the value of data_ptr can be used for flow control:
    Value >0 -> business as usual: print middle star, then process the byte data_ptr points to.
    Value 0  -> Print top star and exit printing loop as there is no more data to process
    Value <0 -> Everything is done, stop program execution
  This saves at least two bytes vs. using a suitable value on ZP.
- Using indirect-indexed 'sta ($0e),y' instead of indexed 'sta $0400,y' saves a byte.
- Counting to row 10 uses a value provided for free by kernal's CHRGET routine on ZP, saves two
  bytes (dec nn instead of dec nnnn, and no need to provide the variable byte ourselves).
- Using kernal routine to scroll screen contents down instead of linefeed, this way we can
  keep printing on the 1st screen row. Saves several bytes as it makes the program quite simple.
- 'lax $15' loads the hi byte of the SYS address to both A and X. Hi byte is chosen to be $2a,
  ie. the petscii code for the star character. Using LAX instead of LDA,TAX saves a byte, and
  using the same value for X saves another byte in comparison to initialising X separately. The
  only downside being that when we use X for printing the right hand side of the snowflake,
  we need to offset the printing location by -'*' to compensate.
 */

.print "START WITH: SYS " + toIntString(SYS10789)
.print "CODE SIZE : " + toIntString(code_end - code_start) + " BYTES"
.print "DATA SIZE : " + toIntString(data_end - data) + " BYTES"
.print "TOTAL SIZE: " + toIntString(code_end - code_start + data_end - data) + " BYTES"