; Commodore C64 entry for VCCC 2025 by GeirS, 2025-12-23.
; Size: 65 bytes excl. load address. Assemble using 64tass.
; Requires loading at specific address (e.g. LOAD "SNOWFLAKE",8,1) and SYS 843 to start.

                * = $0341           ; Load address

; Data and code (65 bytes)
BitPatterns     .byte $02,$51,$30,$72,$09,$04,$92,$49,$ff
RowLoop1        inx
Start           jsr PrintRow
                bcc RowLoop1        ; Loop for upper rows and middle row
                dex
RowLoop2        jsr PrintRow
                dex
                bne RowLoop2        ; Loop for remaining rows except bottom row
PrintRow        jsr $aad7           ; Print new line char
                cpx #9              ; Set carry flag if asterisk at start of middle row
                jsr PrintChar       ; Print space or asterisk on screen
                sec                 ; The center column should contain an asterisk
                ldy #$3e            ; Opcode for 'rol abs,x'
                jsr PrintColumns    ; Print remaining left part of row
                dey                 ; Opcode for 'ror abs,x' ($7e)
PrintColumns    sty ColLoop         ; Set rotate instruction (self-modifying code)
                ldy #9+127          ; Number of columns + 127
ColLoop         rol BitPatterns-1,x ; Rotate bit of current pattern into carry flag
                php                 ; Save carry flag
                jsr PrintChar       ; Print space or asterisk on screen
                plp                 ; Restore carry flag for next rotate
                dey
                bmi ColLoop         ; Loop for all columns
                cpx #9              ; Affect carry flag for ending 'RowLoop1' or determining char at end of row
                rts
PrintChar       lda #32             ; Space char
                bcc DoChrOut        ; Branch if a space should be printed
                lda #42             ; Asterisk char
DoChrOut        jmp $ffd2           ; Jump to KERNAL routine to print char
