    processor 6502    
    org $1000
    
cl_byte     .equ $fd


main
    ldx #8
main_loop1
    jsr printSpace
    lda #$06   ; asl zp
    sta shift_addr
    lda treeStruc,x
    pha
    jsr convertLine         ; print left flake
    ;
    jsr printStar
    ;
    lda #$46   ; lsr zp
    sta shift_addr
    pla
    jsr convertLine         ; print right flake
    ;
    jsr printCR
    ;
main_loop1_addr
    .byte $d1, $11          ; dummy "cmp($11),y" ($d1) - is later changed to "bne" ($d0) by a dec-command
    dex
    bpl main_loop1
    ;
    ldy #18
main_loop2
    jsr printStar
    dey
    bpl main_loop2          ; the middle line
    jsr printCR    
    ;
    dec main_loop1_addr     ; this changes the "cmp($11),y" into "bne main_loop3"

main_loop3                  ; now the flake is printed reversed
    inx
    cpx #9
    bne main_loop1
    
    ; save RTS !
;
printSpace
    lda #32
    .byte $2c
printStar
    lda #42
    .byte $2c
printCR
    lda #13
    ;
    jmp $ffd2
    
    

; A = flake
convertLine
    sta cl_byte
    ldy #8
convertLine_loop
shift_addr
    lsr cl_byte         ; lsr / asl, changes the direction of the flake-bits
    lda #32
    bcc *+2+2
convertLine_print
    lda #42 ; *
    jsr $ffd2
    dey
    bne convertLine_loop
    rts
    

treeStruc
    .byte %01001001     ;0
    .byte %10010010     ;1
    .byte %00000100     ;2
    .byte %00001001     ;3
    .byte %01110010     ;4
    .byte %00110000     ;5
    .byte %01010001     ;6
    .byte %00000010     ;7
    .byte %00000000     ;8
    
