org   16514   
        ds   127,$55	; filler to offset origin, untouched by code
bitmap:                 ; prefix the code with the bitmap data
        defb   $fd,$ae,$cf,$8d,$f6,$fb,$6d,$b6
start:			; start = $4109, comes loaded into BC
        ld e, c		; so col C = 9, save the 9 for later
col:
        ld b, e     	; start each col on the 9th row, and immediately
rotate:			; plot an asterisk and its rotations
        push bc     	; save BC as it gets destroyed 
        call $8f5   	; point HL at (col C, row B)
        pop bc      	; retrieve BC
        ld a, 18     	; load rotation constant
        cp (hl)     	; use it to check if all 4 plots are done
        jr c, xloop 	; if all 4 plots already done, x-it the loop
        ld (hl), 23  	; otherwise plot a *
        sub b       	; A = 18-B
        ld b,c      	; B = C and
        ld c,a      	; C = 18-B => rotate 90º clockwise
        ret z	 	; If col = 0 then exit before plotting bitmap
check:
        jr nc, rotate  	; if bit clear then plot it
xloop:
        ld h, $41	; bitmap resides at $4100 + col, load the $41
        ld l, c		; and the col from C
        srl (hl)    	; grab 1 bit from bitmap
        djnz check	; use this bit for next row, until we run out
        dec c       	; otherwise, move on to next col
        jp (hl)      	; print the next col and its rotations
end:
