org   16514   
        ds   127,$55	; filler of $55, untouched by code
        defb   $02,$51,$30,$72,$09,$04,$92,$49
start:              	; Prefix the code with the bitmap data
        push bc     	; At startup “start” is in BC, so C = 9
        pop hl      	; so move it to HL, use as bitmap pointer
row:                	
        ld b, 9     	; start each row on the 9th column, and first
loop:               	; plot 4 asterisks
        push hl     	; save HL as it gets used to print
        push bc     	; save BC as it gets destroyed 
        call $8f5   	; point HL at (c,b)
        pop bc      	; retrieve BC
        ld a,18     	; load rotation constant
        cp (hl)     	; use it to check if all 4 plots are done
        ld (hl),23  	; plot a *
        pop hl      	; retrieve HL
        jr c, xloop 	; if all 4 plots already done, x-it the loop 
        sub b       	; otherwise A = 18-B
        ld b,c      	; B = C and
        ld c,a      	; C = 18-B => rotate 90º
        jr nz, loop 	; If row != 0 then continue rotating
        ret         	; otherwise we are done
xloop:              	
        dec b       	; move on to next column 
        srl (hl)    	; grab 1 bit from bitmap
        jr c, loop  	; if bit set then plot it
        jr nz, xloop	; if more bits remain, keep getting them
        dec c       	; otherwise, move on to next row
        dec hl      	; iterate bitmap pointer
        jr row      	; print the next row
end: