
* VC³ 2025 snowflake in 94 bytes on the Amiga 500
* Coded on Samichlaus day 2025 by Saturnus the Invincible
* of The Mega-Mighty Swiss Cracking Association !

writeoutput	equ     $e8             	; d1:@buf, d2:lwlength
center_y	equ	9
height          equ     19
width           equ     20              	 19 asterisks and a linefeed

_main:		move.l	d2,a0			; there's 380 free bytes for us here
		move.l  a0,d1          	 	; first BCPL param: buffer
		lsr.l	#2,d1			; convert to BCPL pointer
		lea	width*center_y(a0),a0	; center line within buffer
		movea.l a0,a3			; we need two of these

		moveq	#10,d6			; line feed
		moveq	#'*',d0			; center side char: asterisk
		moveq   #center_y,d4           	; Y: 10 lines
		lea     flake(PC),a4		; bit pattern of one quadrant

y_loop:		moveq	#width-2,d3		; offset right to left
		move.b  (a4)+,d2        	; get flake bits of this row
		move.b	d0,d5			; asterisk or space
		bra.b	crystallise		; draw leftmost / rightmost column

x_loop:		moveq   #' ',d5			; default: no asterisk
		lsr.b   #1,d2	 	 	; get next pixel
		bcs.b   crystallise		; carry set = no asterisk
		moveq   #'*',d5         	; carry clear =  asterisk

crystallise:	move.b	d5,(a0,d3.w)		; upper right
		move.b	d5,(a3,d3.w)		; lower right
		move.b  d5,(a0)+		; upper left
		move.b  d5,(a3)+		; lower left
		subq.w	#2,d3			; go one left and compensate for (a)+
		bpl.b	x_loop			; loop until we arrive at center

		move.b  d6,9(a0)		; LF upper line
		move.b  d6,9(a3)		; LF lower line

		suba.w	#width+10,a0		; a0 goes up
		adda.w	#width-10,a3		; a3 goes down

		moveq	#' ',d0			; from now on write spaces to the side chars
		dbf     d4,y_loop

	;;;	suba.l	a0,a0			; BCPL memory base (not needed for this call)
	;;;	moveq   #16,d0			; bcpl stack frame size (not needed, d0 is 32 which is fine)
		moveq	#width*height/4,d2	; output length in longs
		movea.l	writeoutput(a2),a4
		jmp	(a5)			; write string and end program

	; A quarter of the snowflake as an inverted bit field
	; to get the vertical line for free by shifting out "bit 9"

flake:		dc.b	%00000000,%01101101,%10110110,%11011111,%01101111
                dc.b    %10110001,%11110011,%01110101,%10111111,%11111111


