"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["variant", "size", "className", "style", "disabled"];
function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
// Note: import removed for standalone usage. React is expected as a global in the browser.
// Destructure the React hooks from the global React object for convenience in this file.
var _React = React,
  useCallback = _React.useCallback,
  useEffect = _React.useEffect,
  useMemo = _React.useMemo,
  useRef = _React.useRef,
  useState = _React.useState;

/*
PALETKOWO – single-file React build

SEKCJE (Krok 7 – porządek techniczny):
  A) UI PRIMITIVES (Card/Btn/Switch/Slider)
  B) UTILS (math/geometry/theme helpers)
  C) UI STYLES (shared)
  D) ARCADE UI (knobs + mechanical ribs)
  E) GAME CONSTANTS + MODECFG + THEMES
  F) AUDIO ENGINE (WebAudio)
  G) SELF-TESTS (console.assert)
  H) MAIN COMPONENT
     H1) State + refs
     H2) Audio glue (ensureAudio/syncMusic)
     H3) Game state init/reset
     H4) Input + AI
     H5) Physics (ball/paddles/scoring/game over)
     H6) Render (canvas)
     H7) UI (React layout)
*/

// =========================
// Minimal UI primitives (no external deps)
// =========================
function Card(_ref) {
  var children = _ref.children,
    _ref$className = _ref.className,
    className = _ref$className === void 0 ? "" : _ref$className,
    style = _ref.style;
  return /*#__PURE__*/React.createElement("div", {
    className: "rounded-none border backdrop-blur p-0 overflow-hidden " + className,
    style: _objectSpread({
      background: "var(--ui-soft)",
      borderColor: "var(--ui-border)",
      color: "var(--ui-text)",
      fontFamily: "var(--ui-font)"
    }, style)
  }, children);
}
function CardContent(_ref2) {
  var _ref2$className = _ref2.className,
    className = _ref2$className === void 0 ? "" : _ref2$className,
    children = _ref2.children;
  return /*#__PURE__*/React.createElement("div", {
    className: className
  }, children);
}
function Btn(_ref3) {
  var _ref3$variant = _ref3.variant,
    variant = _ref3$variant === void 0 ? "default" : _ref3$variant,
    _ref3$size = _ref3.size,
    size = _ref3$size === void 0 ? "md" : _ref3$size,
    _ref3$className = _ref3.className,
    className = _ref3$className === void 0 ? "" : _ref3$className,
    style = _ref3.style,
    _ref3$disabled = _ref3.disabled,
    disabled = _ref3$disabled === void 0 ? false : _ref3$disabled,
    props = _objectWithoutProperties(_ref3, _excluded);
  var base = "inline-flex items-center justify-center rounded-none font-semibold select-none transition ";
  var sizes = {
    sm: "h-8 px-3 text-base",
    md: "h-9 px-3 text-base",
    lg: "h-10 px-4 text-base"
  };
  var vStyle = function () {
    if (variant === "outline") return {
      background: "transparent",
      color: "var(--ui-text)",
      border: "1px solid var(--ui-border)"
    };
    if (variant === "secondary") return {
      background: "var(--ui-soft)",
      color: "var(--ui-text)",
      border: "1px solid var(--ui-border)"
    };
    return {
      background: disabled ? "var(--ui-border)" : "var(--ui-accent)",
      color: "var(--ui-accentText)",
      border: "1px solid var(--ui-accentBorder)"
    };
  }();
  return /*#__PURE__*/React.createElement("button", _extends({
    className: [base, sizes[size] || sizes.md, className, disabled ? "opacity-40 cursor-not-allowed" : "cursor-pointer"].join(" "),
    style: _objectSpread(_objectSpread({
      fontFamily: "var(--ui-font)"
    }, vStyle), style),
    disabled: disabled
  }, props));
}
function Label(_ref4) {
  var children = _ref4.children;
  return /*#__PURE__*/React.createElement("div", {
    className: "text-base font-medium",
    style: {
      fontFamily: "var(--ui-font)",
      color: "var(--ui-text)"
    }
  }, children);
}
function Switch(_ref5) {
  var checked = _ref5.checked,
    onCheckedChange = _ref5.onCheckedChange,
    _ref5$disabled = _ref5.disabled,
    disabled = _ref5$disabled === void 0 ? false : _ref5$disabled;
  return /*#__PURE__*/React.createElement("button", {
    type: "button",
    onClick: function onClick() {
      if (disabled) return;
      onCheckedChange === null || onCheckedChange === void 0 || onCheckedChange(!checked);
    },
    className: "relative inline-flex h-6 w-11 items-center rounded-none border transition" + (disabled ? " opacity-40 cursor-not-allowed" : ""),
    style: {
      background: checked ? "var(--ui-accent)" : "var(--ui-panel)",
      borderColor: checked ? "var(--ui-accentBorder)" : "var(--ui-border)"
    },
    "aria-pressed": checked
  }, /*#__PURE__*/React.createElement("span", {
    className: "inline-block h-5 w-5 transform rounded-none shadow transition " + (checked ? "translate-x-5" : "translate-x-1"),
    style: {
      background: "var(--ui-knob)"
    }
  }));
}
function Slider(_ref6) {
  var value = _ref6.value,
    min = _ref6.min,
    max = _ref6.max,
    step = _ref6.step,
    onValueChange = _ref6.onValueChange,
    _ref6$disabled = _ref6.disabled,
    disabled = _ref6$disabled === void 0 ? false : _ref6$disabled;
  var v = Array.isArray(value) ? value[0] : value;
  var pct = (v - min) / (max - min) * 100;
  var onChange = function onChange(e) {
    if (disabled) return;
    onValueChange === null || onValueChange === void 0 || onValueChange([Number(e.target.value)]);
  };
  return /*#__PURE__*/React.createElement("div", {
    className: "w-full",
    style: {
      position: "relative",
      height: 18
    }
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      left: 0,
      right: 0,
      top: 4,
      height: 10,
      border: "1px solid var(--ui-border)",
      background: "var(--ui-soft)"
    }
  }), /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      left: 0,
      top: 4,
      height: 10,
      width: "".concat(clamp(pct, 0, 100), "%"),
      background: "var(--ui-accent)"
    }
  }), /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      left: "".concat(clamp(pct, 0, 100), "%"),
      right: 0,
      top: 4,
      height: 10,
      background: "var(--ui-sliderRight)"
    }
  }), /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      top: 1,
      left: "calc(".concat(clamp(pct, 0, 100), "% - 6px)"),
      width: 12,
      height: 16,
      border: "1px solid var(--ui-border)",
      background: "var(--ui-knob)"
    }
  }), disabled && /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      left: 0,
      right: 0,
      top: 0,
      bottom: 0,
      background: "rgba(0,0,0,0.25)",
      pointerEvents: "none"
    }
  }), /*#__PURE__*/React.createElement("input", {
    className: "w-full",
    style: {
      position: "absolute",
      left: 0,
      top: 0,
      height: 18,
      margin: 0,
      opacity: 0,
      cursor: disabled ? "not-allowed" : "pointer"
    },
    type: "range",
    value: v,
    min: min,
    max: max,
    step: step,
    onChange: onChange,
    disabled: disabled
  }));
}

// =========================
// Utils (math, color, geometry)
// =========================
var clamp = function clamp(v, lo, hi) {
  return Math.max(lo, Math.min(hi, v));
};

// AI helper: UI poziom 1..10 -> skill 0..1 (1 = najtrudniej)
var aiSkillFromUiLevel = function aiSkillFromUiLevel(uiLevel) {
  var uiLvl = clamp(Number(uiLevel) || 1, 1, 10);
  // 1 ma dawać NAJWIĘKSZĄ trudność
  return clamp((10 - uiLvl) / 9, 0, 1);
};
var blendHex = function blendHex(hexA, hexB, t) {
  var norm = function norm(h) {
    return String(h || "").replace("#", "");
  };
  var a = norm(hexA);
  var b = norm(hexB);
  var toRgb = function toRgb(h) {
    var hh = h.length === 3 ? h.split("").map(function (c) {
      return c + c;
    }).join("") : h;
    var n = parseInt(hh, 16);
    return {
      r: n >> 16 & 255,
      g: n >> 8 & 255,
      b: n & 255
    };
  };
  if (!a || !b) return hexA || hexB || "#fff";
  var A = toRgb(a);
  var B = toRgb(b);
  var mix = function mix(x, y) {
    return Math.round(x + (y - x) * t);
  };
  return "rgb(".concat(mix(A.r, B.r), " ").concat(mix(A.g, B.g), " ").concat(mix(A.b, B.b), ")");
};
var intersects = function intersects(ax, ay, aw, ah, bx, by, bw, bh) {
  return ax < bx + bw && ax + aw > bx && ay < by + bh && ay + ah > by;
};
var ensureRoundRect = function ensureRoundRect(ctx) {
  if (typeof ctx.roundRect === "function") return;
  ctx.roundRect = function roundRect(x, y, w, h, r) {
    var rr = Math.min(r, w / 2, h / 2);
    this.beginPath();
    this.moveTo(x + rr, y);
    this.arcTo(x + w, y, x + w, y + h, rr);
    this.arcTo(x + w, y + h, x, y + h, rr);
    this.arcTo(x, y + h, x, y, rr);
    this.arcTo(x, y, x + w, y, rr);
    this.closePath();
    return this;
  };
};

// =========================
// UI shared styles
// =========================
var PANEL_TITLE_STYLE = {
  fontFamily: "var(--ui-font)",
  color: "var(--ui-text)",
  fontSize: 19
};
var PANEL_MUTED_STYLE = {
  fontFamily: "var(--ui-font)",
  color: "var(--ui-muted)"
};
var DIVIDER_STYLE = {
  height: 1,
  background: "var(--ui-border)",
  opacity: 0.4,
  margin: "18px 0"
};
var CANVAS_FRAME_STYLE = {
  borderColor: "var(--ui-border)",
  background: "var(--ui-soft)"
};
function Divider(_ref7) {
  var style = _ref7.style;
  return /*#__PURE__*/React.createElement("div", {
    style: _objectSpread(_objectSpread({}, DIVIDER_STYLE), style || {})
  });
}

// =========================
// LED bar component
// =========================
// The LED bar displays a row of small square LEDs that light up from the center outward
// whenever game sounds are played. Each LED uses the current color theme via CSS variables.
// Reduce the LED count by 30 so there are fewer LEDs. We'll adjust the layout to fill the bar.
var LED_COUNT = 34;
function LedBar(_ref) {
  var ledOnCount = _ref.ledOnCount;
  var leds = [];
  var mid = (LED_COUNT - 1) / 2;
  for (var i = 0; i < LED_COUNT; i++) {
    var dist = Math.abs(i - mid);
    var lit = dist < ledOnCount;
    leds.push( /*#__PURE__*/React.createElement("div", {
      key: i,
      style: {
        // height stays small; width will be calculated via CSS grid to fill the bar
        height: 6,
        borderRadius: 2,
        background: "var(--ui-accent)",
        opacity: lit ? 0.9 : 0.2
      }
    }));
  }
  return /*#__PURE__*/React.createElement("div", {
    style: {
      display: "grid",
      gridTemplateColumns: "repeat(" + LED_COUNT + ", 1fr)",
      gap: 2,
      padding: "4px 0",
      width: "100%"
    }
  }, leds);
}

// =========================
// Arcade UI (Krok 2)
// =========================
function ArcadeKnob(_ref8) {
  var _ref8$angle = _ref8.angle,
    angle = _ref8$angle === void 0 ? 0 : _ref8$angle,
    label = _ref8.label;
  return /*#__PURE__*/React.createElement("div", {
    className: "flex flex-col items-center gap-2 select-none",
    style: {
      width: 150
    }
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      width: 126,
      height: 126,
      borderRadius: 9999,
      border: "1px solid var(--ui-border)",
      background: "var(--ui-soft)",
      boxShadow: "inset 0 0 0 2px rgba(0,0,0,0.15)",
      position: "relative",
      overflow: "hidden",
      display: "flex",
      alignItems: "center",
      justifyContent: "center"
    }
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      inset: 2,
      borderRadius: 9999,
      background: "repeating-conic-gradient(from 0deg, rgba(255,255,255,0.10) 0deg 5deg, rgba(0,0,0,0.18) 5deg 10deg)",
      boxShadow: "inset 0 0 0 1px rgba(0,0,0,0.22)",
      opacity: 0.95
    }
  }), /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      inset: 18,
      borderRadius: 9999,
      background: "var(--ui-panel)",
      border: "1px solid rgba(0,0,0,0.22)",
      boxShadow: "inset 0 10px 18px rgba(0,0,0,0.22)"
    }
  }), /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      width: 34,
      height: 34,
      borderRadius: 9999,
      border: "1px solid rgba(255,255,255,0.18)",
      background: "radial-gradient(circle at 35% 30%, rgba(255,255,255,0.75), rgba(170,170,170,0.28) 50%, rgba(70,70,70,0.45) 100%)",
      boxShadow: "inset 0 2px 5px rgba(0,0,0,0.28)"
    }
  }), /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      inset: 0,
      transform: "rotate(".concat(angle, "deg)"),
      transformOrigin: "50% 50%",
      pointerEvents: "none"
    }
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      top: 6,
      left: "50%",
      width: 20,
      height: 8,
      transform: "translateX(-50%)",
      background: "var(--ui-accent)",
      boxShadow: "0 0 0 1px var(--ui-accentBorder)"
    }
  }))), /*#__PURE__*/React.createElement("div", {
    style: {
      fontFamily: "var(--ui-font)",
      color: "var(--ui-muted)",
      fontSize: 14,
      textAlign: "center",
      letterSpacing: "0.05em",
      textTransform: "uppercase",
      display: "none"
    }
  }, label));
}

// Dekoracyjny „radiator” między planszą a panelem arcade (łatwy do edycji)
// Dekoracyjny „radiator” między planszą a panelem arcade (minimalna metalowa faktura, zależna od kolorystyki)
function MechanicalRibs(_ref9) {
  var _ref9$h = _ref9.h,
    h = _ref9$h === void 0 ? 56 : _ref9$h,
    _ref9$ribH = _ref9.ribH,
    ribH = _ref9$ribH === void 0 ? 18 : _ref9$ribH,
    _ref9$sideInset = _ref9.sideInset,
    sideInset = _ref9$sideInset === void 0 ? 14 : _ref9$sideInset,
    _ref9$className = _ref9.className,
    className = _ref9$className === void 0 ? "" : _ref9$className;
  return /*#__PURE__*/React.createElement("div", {
    className: className,
    style: {
      height: h,
      display: "flex",
      alignItems: "center",
      justifyContent: "center"
    }
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      width: "100%",
      height: ribH,
      margin: "0 ".concat(sideInset, "px"),
      // Linia ożebrowania: poziome linie z rosnącymi odstępami; usuwamy imitację siatki
      background: "\n            linear-gradient(180deg,\n              rgba(255,255,255,0.10),\n              rgba(0,0,0,0.25)\n            ),\n            linear-gradient(to bottom,\n              var(--ui-border) 0px 1px,\n              transparent 1px 3px,\n              var(--ui-border) 3px 4px,\n              transparent 4px 7px,\n              var(--ui-border) 7px 8px,\n              transparent 8px 12px,\n              var(--ui-border) 12px 13px,\n              transparent 13px\n            )\n          ",
      boxShadow: "\n            inset 0 1px 0 rgba(255,255,255,0.18),\n            inset 0 -1px 0 rgba(0,0,0,0.35)\n          "
    }
  }));
}

// =========================
// Game constants
// =========================
var GAME = {
  W: 900,
  H: 500,
  INSET_DEFAULT: 30,
  PADDLE_W: 14,
  PADDLE_H_BASE: 110,
  PADDLE_SPEED: 7,
  BALL_SIZE: 14,
  BALL_SPEED_START: 6,
  BALL_SPEED_MAX: 12
};

// =========================
// Color themes
// =========================
var COLOR_THEMES = {
  green: {
    key: "green",
    name: "Green",
    bg: "#06140B",
    fg: "#D9FFE5",
    accent: "#2BB673",
    sliderRight: "#9CFFB0"
  },
  amber: {
    key: "amber",
    name: "Amber",
    bg: "#140F05",
    fg: "#FFE6B8",
    accent: "#FFB000",
    sliderRight: "#FFD08A"
  },
  mono: {
    key: "mono",
    name: "B&W",
    bg: "#0A0A0A",
    fg: "#F2F2F2",
    accent: "#8E8E8E",
    sliderRight: "#CFCFCF"
  }
};
var getColorTheme = function getColorTheme(key) {
  return COLOR_THEMES[key] || COLOR_THEMES.green;
};

// =========================
// Mode rules
// =========================
var MODECFG = {
  pong: {
    key: "pong",
    label: "PONG",
    blurb: ["Klasyk: lewy kontra prawy.", "Punkt, gdy piłka minie przeciwnika.", "Pierwszy do limitu wygrywa."],
    audioTrack: "pong",
    rules: {
      paddles: {
        left: 1,
        right: 1
      },
      rightPlayable: true,
      scoreToWin: true,
      squashWallInset: 0,
      hockey: null,
      leftInset: GAME.INSET_DEFAULT,
      rightInset: GAME.INSET_DEFAULT
    }
  },
  squosh: {
    key: "squosh",
    label: "SQUASH",
    blurb: ["Solo: grasz tylko lewą paletką.", "Punkty za odbicia od prawej ściany.", "Nie ma prawego gracza."],
    audioTrack: "squosh",
    rules: {
      paddles: {
        left: 1,
        right: 0
      },
      rightPlayable: false,
      scoreToWin: false,
      squashWallInset: 26,
      hockey: null,
      leftInset: GAME.INSET_DEFAULT,
      rightInset: GAME.INSET_DEFAULT
    }
  },
  hockey: {
    key: "hockey",
    label: "HOKEY",
    blurb: ["HOKEY: 2 paletki na gracza.", "Poruszają się równocześnie.", "Gole przez środkowe okno."],
    audioTrack: "hockey_techno",
    rules: {
      paddles: {
        left: 2,
        right: 2
      },
      rightPlayable: true,
      scoreToWin: true,
      squashWallInset: 0,
      hockey: {
        goalOpen: 150,
        forwardFrac: 0.75,
        bandInset: 0
      },
      leftInset: GAME.INSET_DEFAULT,
      rightInset: GAME.INSET_DEFAULT
    }
  }
};
var MODELIST = Object.values(MODECFG);
var getModeCfg = function getModeCfg(key) {
  return MODECFG[key] || MODECFG.pong;
};

// =========================
// Ball helpers
// =========================
var serveBall = function serveBall(W, H, dir, speed) {
  var d = dir == null ? Math.random() < 0.5 ? -1 : 1 : dir;
  var angle = (Math.random() * 0.6 - 0.3) * Math.PI;
  var vx = Math.cos(angle) * speed * d;
  var vy = Math.sin(angle) * speed;
  return {
    x: W / 2,
    y: H / 2,
    vx: vx,
    vy: vy
  };
};
var reflectFromPaddle = function reflectFromPaddle(ball, paddleY, paddleH, speedMax) {
  var rel = clamp((ball.y - paddleY) / paddleH, 0, 1);
  var n = rel * 2 - 1;
  var maxAng = 0.75;
  var ang = n * maxAng;
  var speed = clamp(Math.hypot(ball.vx, ball.vy) + 0.25, 5.5, speedMax);
  var dir = ball.vx < 0 ? 1 : -1;
  return _objectSpread(_objectSpread({}, ball), {}, {
    vx: Math.cos(ang) * speed * dir,
    vy: Math.sin(ang) * speed
  });
};

// HUD helper (tekst pomocy na dole)
var getHudHelpText = function getHudHelpText(modeKey, s) {
  if (modeKey === "squosh") {
    return s.squoshTwoPlayers ? "Gracz 1: W/S   |   Gracz 2: ↑/↓ (AI OFF)   |   R: serw   |   Spacja: pauza" : "Lewy: W/S   |   R: serw   |   Spacja: pauza";
  }
  return "Lewy: W/S   |   Prawy: ↑/↓ (AI OFF)   |   R: serw   |   Spacja: pauza";
};

// =========================
// Audio
// =========================
function createAudioEngine() {
  try {
    var AudioCtx = window.AudioContext || window.webkitAudioContext;
    if (!AudioCtx) return null;
    var ctx = new AudioCtx();
    var master = ctx.createGain();
    master.gain.value = 0.55;
    var musicBus = ctx.createGain();
    var sfxBus = ctx.createGain();
    musicBus.gain.value = 1;
    sfxBus.gain.value = 1;
    musicBus.connect(master);
    sfxBus.connect(master);
    master.connect(ctx.destination);
    var semToHz = function semToHz(base, sem) {
      return base * Math.pow(2, sem / 12);
    };
    var TRACKS = {
      pong: {
        bpm: 152,
        baseHz: 220,
        lead: [[0, null, 7, null, 12, null, 7, null, 10, null, 14, null, 12, null, 7, null], [0, 3, 7, 10, 12, 10, 7, 3, 2, null, 9, null, 7, null, 5, null], [12, null, 10, null, 7, null, 5, null, 7, null, 10, null, 12, null, 14, null], [0, null, 5, null, 7, null, 10, null, 12, 10, 7, 5, 3, null, 2, null]],
        bass: [[0, null, null, null, 0, null, null, null, -5, null, null, null, -5, null, null, null], [0, null, null, null, -3, null, null, null, -5, null, null, null, -7, null, null, null], [-5, null, null, null, -5, null, null, null, -2, null, null, null, 0, null, null, null], [0, null, null, null, -7, null, null, null, -5, null, null, null, -3, null, null, null]],
        pad: [[0, 0, 0, 0, -3, -3, -3, -3, -2, -2, -2, -2, -5, -5, -5, -5], [0, 0, 0, 0, -5, -5, -5, -5, -7, -7, -7, -7, -3, -3, -3, -3], [-5, -5, -5, -5, -2, -2, -2, -2, 0, 0, 0, 0, -3, -3, -3, -3], [0, 0, 0, 0, -7, -7, -7, -7, -5, -5, -5, -5, -3, -3, -3, -3]],
        drums: {
          hat: "even",
          snare: "4-12",
          kick: "0-8"
        },
        mix: {
          lead: 1,
          bass: 1,
          pad: 1,
          drums: 1
        }
      },
      squosh: {
        bpm: 176,
        baseHz: 330,
        lead: [[0, null, null, 7, null, null, 12, null, 7, null, null, 10, null, null, 7, null], [12, null, null, 10, null, null, 7, null, 10, null, null, 12, null, null, 14, null], [7, null, null, 5, null, null, 7, null, 10, null, null, 12, null, null, 10, null], [0, null, null, 7, null, null, 10, null, 12, null, null, 10, null, null, 7, null]],
        bass: [[0, null, -5, null, -7, null, -5, null, 0, null, -5, null, -7, null, -5, null], [-5, null, -7, null, -5, null, 0, null, -3, null, -5, null, -7, null, -5, null], [-7, null, -5, null, -3, null, -5, null, -7, null, -5, null, 0, null, -5, null], [-5, null, 0, null, -5, null, -7, null, -5, null, -3, null, -5, null, -7, null]],
        pad: [[0, 0, -7, -7, 0, 0, -7, -7, -5, -5, -7, -7, -5, -5, -7, -7], [-5, -5, -7, -7, -5, -5, -7, -7, 0, 0, -7, -7, 0, 0, -7, -7], [0, 0, -5, -5, 0, 0, -5, -5, -7, -7, -5, -5, -7, -7, -5, -5], [-7, -7, -5, -5, -7, -7, -5, -5, 0, 0, -5, -5, 0, 0, -5, -5]],
        drums: {
          hat: "all",
          snare: "12",
          kick: "0-6-8-14"
        },
        mix: {
          lead: 0.85,
          bass: 0.95,
          pad: 0.45,
          drums: 1.0
        }
      },
      hockey_techno: {
        bpm: 128,
        baseHz: 110,
        lead: [[null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null], [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null], [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null], [null, null, null, null, null, null, null, null, null, null, 0, 2, 3, 2, 0, -2]],
        bass: [[0, null, 0, null, 0, null, 0, null, 0, null, 0, null, 0, null, 0, null], [0, null, 0, null, -2, null, -2, null, 0, null, 0, null, -5, null, -5, null], [0, null, 0, null, 0, null, 0, null, -2, null, -2, null, 0, null, 0, null], [0, null, 0, null, 0, null, 0, null, 0, null, -2, -2, -5, -5, -7, -7]],
        pad: [[0, 0, 0, 0, 0, 0, 0, 0, -2, -2, -2, -2, 0, 0, 0, 0], [-2, -2, -2, -2, 0, 0, 0, 0, -5, -5, -5, -5, -2, -2, -2, -2], [0, 0, 0, 0, -2, -2, -2, -2, 0, 0, 0, 0, -5, -5, -5, -5], [-2, -2, -2, -2, -5, -5, -5, -5, -6, -6, -6, -6, -5, -5, -2, -2]],
        drums: {
          hat: "off",
          snare: "4-12",
          kick: "four",
          fill: true
        },
        mix: {
          lead: 0.25,
          bass: 1.2,
          pad: 0.85,
          drums: 1.15
        }
      }
    };
    var NOISE_HAT = new Float32Array(256);
    var NOISE_SNARE = new Float32Array(512);
    for (var i = 0; i < NOISE_HAT.length; i++) NOISE_HAT[i] = (Math.random() * 2 - 1) * 0.7;
    for (var _i = 0; _i < NOISE_SNARE.length; _i++) NOISE_SNARE[_i] = (Math.random() * 2 - 1) * 0.9;
    var playNoise = function playNoise(bufArr, gain) {
      var hp = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 2000;
      var ms = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 60;
      var b = ctx.createBuffer(1, bufArr.length, ctx.sampleRate);
      b.copyToChannel(bufArr, 0);
      var src = ctx.createBufferSource();
      src.buffer = b;
      var g = ctx.createGain();
      var f = ctx.createBiquadFilter();
      f.type = "highpass";
      f.frequency.value = hp;
      src.connect(f);
      f.connect(g);
      g.connect(sfxBus);
      var t0 = ctx.currentTime;
      var dur = ms / 1000;
      g.gain.setValueAtTime(0.0001, t0);
      g.gain.exponentialRampToValueAtTime(Math.max(0.0001, gain), t0 + 0.004);
      g.gain.exponentialRampToValueAtTime(0.0001, t0 + Math.max(0.01, dur));
      src.start();
      src.stop(t0 + dur + 0.02);
      // Dispatch a custom event whenever a noise plays to pulse the LED bar
      try {
        // scale gain so that quieter sounds light fewer LEDs and the loudest sounds light the whole bar
        var _level = typeof gain === "number" && !isNaN(gain) ? Math.min(1, Math.max(0, gain * 10)) : 1;
        window.dispatchEvent(new CustomEvent('paletkowo-sound', { detail: { level: _level, duration: ms } }));
      } catch (e) {}
    };
    var playTone = function playTone(freq, ms, type, gain) {
      var o = ctx.createOscillator();
      o.type = type;
      o.frequency.value = freq;
      var g = ctx.createGain();
      g.gain.value = 0.0001;
      o.connect(g);
      g.connect(sfxBus);
      var t0 = ctx.currentTime;
      var dur = ms / 1000;
      g.gain.setValueAtTime(0.0001, t0);
      g.gain.exponentialRampToValueAtTime(Math.max(0.0001, gain), t0 + 0.008);
      g.gain.exponentialRampToValueAtTime(0.0001, t0 + Math.max(0.01, dur));
      o.start();
      o.stop(t0 + dur + 0.03);
      // Dispatch a custom event whenever a tone plays to pulse the LED bar
      try {
        // scale gain so that quieter sounds light fewer LEDs and the loudest sounds light the whole bar
        var _level2 = typeof gain === "number" && !isNaN(gain) ? Math.min(1, Math.max(0, gain * 10)) : 1;
        window.dispatchEvent(new CustomEvent('paletkowo-sound', { detail: { level: _level2, duration: ms } }));
      } catch (e) {}
    };
    var drumHat = function drumHat(i, mode) {
      if (mode === "all") return true;
      if (mode === "even") return i % 2 === 0;
      if (mode === "off") return i === 2 || i === 6 || i === 10 || i === 14;
      return i % 2 === 0;
    };
    var drumKick = function drumKick(i, mode) {
      if (mode === "0-6-8-14") return i === 0 || i === 6 || i === 8 || i === 14;
      if (mode === "0-8") return i === 0 || i === 8;
      if (mode === "four") return i === 0 || i === 4 || i === 8 || i === 12;
      return i === 0 || i === 8;
    };
    var drumSnare = function drumSnare(i, mode) {
      if (mode === "12") return i === 12;
      if (mode === "4-12") return i === 4 || i === 12;
      if (mode === "none") return false;
      return i === 4 || i === 12;
    };
    var music = {
      enabled: true,
      playing: false,
      timer: null,
      step: 0,
      trackKey: "pong",
      bpm: 152,
      baseHz: 220,
      leadOsc: null,
      bassOsc: null,
      padOsc: null,
      leadGain: ctx.createGain(),
      bassGain: ctx.createGain(),
      padGain: ctx.createGain(),
      lvlLead: 0.05,
      lvlBass: 0.032,
      lvlPad: 0.012,
      lvlDrums: 1.0,
      pendingStart: null,
      startToken: 0
    };
    music.leadGain.gain.value = 0;
    music.bassGain.gain.value = 0;
    music.padGain.gain.value = 0;
    music.leadGain.connect(musicBus);
    music.bassGain.connect(musicBus);
    music.padGain.connect(musicBus);
    var stopInternal = function stopInternal() {
      var fadeSec = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0.16;
      music.startToken++;
      if (music.pendingStart) {
        clearTimeout(music.pendingStart);
        music.pendingStart = null;
      }
      if (!music.playing) return;
      music.playing = false;
      if (music.timer) clearInterval(music.timer);
      music.timer = null;
      var t = ctx.currentTime;
      [music.leadGain, music.bassGain, music.padGain].forEach(function (gg) {
        var current = Math.max(0.0001, gg.gain.value);
        gg.gain.cancelScheduledValues(t);
        gg.gain.setValueAtTime(current, t);
        gg.gain.exponentialRampToValueAtTime(0.0001, t + fadeSec);
      });
      var stopAt = t + fadeSec + 0.02;
      try {
        var _music$leadOsc;
        (_music$leadOsc = music.leadOsc) === null || _music$leadOsc === void 0 || _music$leadOsc.stop(stopAt);
      } catch (_unused) {}
      try {
        var _music$bassOsc;
        (_music$bassOsc = music.bassOsc) === null || _music$bassOsc === void 0 || _music$bassOsc.stop(stopAt);
      } catch (_unused2) {}
      try {
        var _music$padOsc;
        (_music$padOsc = music.padOsc) === null || _music$padOsc === void 0 || _music$padOsc.stop(stopAt);
      } catch (_unused3) {}
      music.leadOsc = music.bassOsc = music.padOsc = null;
    };
    var _startInternal = function startInternal(trackKey) {
      if (!music.enabled || ctx.state !== "running") return;
      if (music.pendingStart) {
        clearTimeout(music.pendingStart);
        music.pendingStart = null;
      }
      var key = trackKey || music.trackKey;
      if (!TRACKS[key]) key = "pong";
      if (music.playing && music.trackKey === key) return;
      if (music.playing && music.trackKey !== key) {
        var myToken = ++music.startToken;
        stopInternal(0.09);
        music.pendingStart = setTimeout(function () {
          if (myToken !== music.startToken) return;
          music.pendingStart = null;
          _startInternal(key);
        }, 110);
        return;
      }
      var tr = TRACKS[key];
      music.trackKey = key;
      music.bpm = tr.bpm;
      music.baseHz = tr.baseHz;
      music.step = 0;
      var mix = tr.mix || {
        lead: 1,
        bass: 1,
        pad: 1,
        drums: 1
      };
      music.lvlLead = 0.05 * mix.lead;
      music.lvlBass = 0.032 * mix.bass;
      music.lvlPad = 0.012 * mix.pad;
      music.lvlDrums = 1.0 * mix.drums;
      music.playing = true;
      var lead = ctx.createOscillator();
      var bass = ctx.createOscillator();
      var pad = ctx.createOscillator();
      lead.type = "square";
      bass.type = "triangle";
      pad.type = "sawtooth";
      lead.connect(music.leadGain);
      bass.connect(music.bassGain);
      pad.connect(music.padGain);
      lead.start();
      bass.start();
      pad.start();
      music.leadOsc = lead;
      music.bassOsc = bass;
      music.padOsc = pad;
      var t = ctx.currentTime;
      music.leadGain.gain.setValueAtTime(0.0001, t);
      music.bassGain.gain.setValueAtTime(0.0001, t);
      music.padGain.gain.setValueAtTime(0.0001, t);
      music.leadGain.gain.exponentialRampToValueAtTime(Math.max(0.0001, music.lvlLead), t + 0.22);
      music.bassGain.gain.exponentialRampToValueAtTime(Math.max(0.0001, music.lvlBass), t + 0.22);
      music.padGain.gain.exponentialRampToValueAtTime(Math.max(0.0001, music.lvlPad), t + 0.35);
      var stepSec = 60 / music.bpm / 4;
      music.timer = setInterval(function () {
        var _tr2$drums;
        if (!music.playing || !music.leadOsc || !music.bassOsc || !music.padOsc) return;
        var tr2 = TRACKS[music.trackKey] || TRACKS.pong;
        var pat = Math.floor(music.step / 16) % 4;
        var i = music.step % 16;
        var barStep = music.step % 64;
        var wantsFill = !!((_tr2$drums = tr2.drums) !== null && _tr2$drums !== void 0 && _tr2$drums.fill);
        var isFillWindow = wantsFill && barStep >= 48;
        var usePat = isFillWindow ? 3 : pat;
        var duckPad = function duckPad() {
          var amt = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0.55;
          var rel = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0.14;
          var t0 = ctx.currentTime;
          var base = Math.max(0.0001, music.lvlPad);
          var low = Math.max(0.0001, base * (1 - amt));
          music.padGain.gain.cancelScheduledValues(t0);
          music.padGain.gain.setValueAtTime(low, t0);
          music.padGain.gain.exponentialRampToValueAtTime(Math.max(0.0001, base), t0 + rel);
        };
        var padSem = tr2.pad[usePat][i];
        if (padSem != null) music.padOsc.frequency.setValueAtTime(semToHz(music.baseHz, padSem), ctx.currentTime);
        var leadSem = tr2.lead[usePat][i];
        if (leadSem == null) {
          music.leadGain.gain.setTargetAtTime(0.0001, ctx.currentTime, 0.01);
        } else {
          music.leadOsc.frequency.setValueAtTime(semToHz(music.baseHz, leadSem), ctx.currentTime);
          var t0 = ctx.currentTime;
          music.leadGain.gain.cancelScheduledValues(t0);
          music.leadGain.gain.setValueAtTime(0.0001, t0);
          music.leadGain.gain.exponentialRampToValueAtTime(Math.max(0.0001, music.lvlLead), t0 + 0.01);
          music.leadGain.gain.exponentialRampToValueAtTime(0.0001, t0 + stepSec * 0.92);
        }
        var bassSem = tr2.bass[usePat][i];
        if (bassSem == null) {
          music.bassGain.gain.setTargetAtTime(0.0001, ctx.currentTime, 0.02);
        } else {
          music.bassOsc.frequency.setValueAtTime(semToHz(music.baseHz, bassSem), ctx.currentTime);
          var tb = ctx.currentTime;
          music.bassGain.gain.cancelScheduledValues(tb);
          music.bassGain.gain.setValueAtTime(0.0001, tb);
          music.bassGain.gain.exponentialRampToValueAtTime(Math.max(0.0001, music.lvlBass), tb + 0.02);
          music.bassGain.gain.exponentialRampToValueAtTime(0.0001, tb + stepSec * 1.6);
        }
        var d = tr2.drums;
        if (drumHat(i, d.hat)) playNoise(NOISE_HAT, 0.012 * music.lvlDrums, 3200);
        if (drumSnare(i, d.snare)) playNoise(NOISE_SNARE, 0.018 * music.lvlDrums, 1400);
        var kickNow = drumKick(i, d.kick);
        if (kickNow) playTone(78, 70, "square", 0.034 * music.lvlDrums);
        if (isFillWindow && (i === 13 || i === 14 || i === 15)) playNoise(NOISE_HAT, 0.016 * music.lvlDrums, 3600);
        if (kickNow || drumSnare(i, d.snare)) duckPad(0.45, 0.12);
        music.step++;
        // Dispatch an aggregated music event so the LED bar responds to all channels (lead, bass, pad)
        try {
          var agg = music.leadGain.gain.value + music.bassGain.gain.value + music.padGain.gain.value;
          // scale the aggregated gain so that louder combined levels light more LEDs
          var levelMusic = Math.min(1, Math.max(0, agg * 20));
          var durationMusic = stepSec * 1000;
          window.dispatchEvent(new CustomEvent('paletkowo-sound', { detail: { level: levelMusic, duration: durationMusic } }));
        } catch (err) {}
      }, stepSec * 1000);
    };
    var setEnabled = function setEnabled(on) {
      music.enabled = !!on;
      if (!music.enabled) stopInternal(0.12);
    };
    var setTrack = function setTrack(key) {
      if (!key) return;
      music.trackKey = key;
      if (music.playing) _startInternal(key);
    };
    var duckMusic = function duckMusic() {
      var amount = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0.35;
      var rel = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0.18;
      var t0 = ctx.currentTime;
      var base = 1;
      var low = Math.max(0.05, base * (1 - amount));
      musicBus.gain.cancelScheduledValues(t0);
      musicBus.gain.setValueAtTime(low, t0);
      musicBus.gain.exponentialRampToValueAtTime(base, t0 + rel);
    };
    return {
      ctx: ctx,
      resume: function resume() {
        return ctx.state !== "running" ? ctx.resume() : Promise.resolve();
      },
      sfx: {
        paddle: function paddle() {
          return playTone(420, 55, "square", 0.07);
        },
        wall: function wall() {
          return playTone(240, 45, "square", 0.05);
        },
        score: function score() {
          duckMusic(0.32, 0.2);
          playTone(180, 70, "square", 0.06);
          setTimeout(function () {
            return playTone(300, 70, "square", 0.05);
          }, 60);
        },
        ui: function ui() {
          return playTone(520, 35, "square", 0.04);
        },
        gameOverSquosh: function gameOverSquosh() {
          duckMusic(0.78, 0.85);
          playTone(196, 120, "square", 0.065);
          setTimeout(function () {
            return playTone(262, 130, "square", 0.062);
          }, 140);
          setTimeout(function () {
            return playTone(330, 140, "square", 0.058);
          }, 300);
          setTimeout(function () {
            return playTone(392, 160, "square", 0.055);
          }, 470);
          setTimeout(function () {
            return playTone(330, 140, "square", 0.052);
          }, 660);
          setTimeout(function () {
            return playTone(262, 180, "square", 0.05);
          }, 820);
        },
        gameOverPong: function gameOverPong() {
          duckMusic(0.72, 0.7);
          playTone(262, 110, "square", 0.06);
          setTimeout(function () {
            return playTone(330, 120, "square", 0.058);
          }, 140);
          setTimeout(function () {
            return playTone(392, 130, "square", 0.056);
          }, 300);
          setTimeout(function () {
            return playTone(523, 160, "square", 0.05);
          }, 520);
        },
        gameOverHockey: function gameOverHockey() {
          duckMusic(0.75, 0.8);
          playTone(196, 140, "square", 0.062);
          setTimeout(function () {
            return playTone(220, 140, "square", 0.06);
          }, 170);
          setTimeout(function () {
            return playTone(262, 150, "square", 0.058);
          }, 340);
          setTimeout(function () {
            return playTone(330, 180, "square", 0.052);
          }, 520);
          setTimeout(function () {
            return playTone(262, 200, "square", 0.05);
          }, 740);
        }
      },
      music: {
        start: function start(trackKey) {
          return _startInternal(trackKey);
        },
        stop: function stop() {
          return stopInternal(0.16);
        },
        setTrack: setTrack,
        setEnabled: setEnabled,
        isPlaying: function isPlaying() {
          return !!music.playing;
        }
      }
    };
  } catch (_unused4) {
    return null;
  }
}

// =========================
// Lightweight self-tests
// =========================
function runSelfTests() {
  console.assert(Number.isFinite(GAME.W) && GAME.W > 0, "GAME.W should be > 0");
  console.assert(Number.isFinite(GAME.H) && GAME.H > 0, "GAME.H should be > 0");
  console.assert(Number.isFinite(GAME.PADDLE_W) && GAME.PADDLE_W > 0, "GAME.PADDLE_W should be > 0");
  console.assert(Number.isFinite(GAME.BALL_SIZE) && GAME.BALL_SIZE > 0, "GAME.BALL_SIZE should be > 0");
  console.assert(getColorTheme("green").key === "green", "Theme green should exist");
  console.assert(getColorTheme("amber").key === "amber", "Theme amber should exist");
  console.assert(getColorTheme("mono").key === "mono", "Theme mono should exist");
  console.assert(getColorTheme("nope").key === "green", "Unknown theme should fall back to green");
  console.assert(getModeCfg("pong").key === "pong", "Mode pong should exist");
  console.assert(getModeCfg("squosh").key === "squosh", "Mode squosh should exist");
  console.assert(getModeCfg("hockey").key === "hockey", "Mode hockey should exist");
  console.assert(getModeCfg("nope").key === "pong", "Unknown mode should fall back to pong");
  console.assert(clamp(5, 0, 10) === 5, "Clamp in range");
  console.assert(clamp(-1, 0, 10) === 0, "Clamp low");
  console.assert(clamp(99, 0, 10) === 10, "Clamp high");
  console.assert(aiSkillFromUiLevel(1) === 1, "AI lvl 1 should be hardest (skill=1)");
  console.assert(aiSkillFromUiLevel(10) === 0, "AI lvl 10 should be easiest (skill=0)");
}

// =========================
// MAIN COMPONENT (H)
// =========================
function Paletkowo() {
  // -------------------------
  // H1) State + refs
  // -------------------------
  var canvasRef = useRef(null);
  var ctxRef = useRef(null);
  var rafRef = useRef(0);
  var lastTRef = useRef(0);
  var keysRef = useRef(new Set());
  var audioRef = useRef(null);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    paused = _useState2[0],
    setPaused = _useState2[1];

  // Krok 2: pokrętła (wizualizacja ruchu paletek)
  var _useState3 = useState(0),
    _useState4 = _slicedToArray(_useState3, 2),
    knobL = _useState4[0],
    setKnobL = _useState4[1];
  var _useState5 = useState(0),
    _useState6 = _slicedToArray(_useState5, 2),
    knobR = _useState6[0],
    setKnobR = _useState6[1];
  var knobRef = useRef({
    aL: 0,
    aR: 0,
    lastYL: null,
    lastYR: null,
    lastUiT: 0
  });

  // Krok 2: podświetlenie przycisków (klik + klawisze)
  var _useState7 = useState({
      pause: false,
      start: false,
      serve: false
    }),
    _useState8 = _slicedToArray(_useState7, 2),
    arcadeActive = _useState8[0],
    setArcadeActive = _useState8[1];
  var pulseArcade = useCallback(function (key) {
    setArcadeActive(function (s) {
      return _objectSpread(_objectSpread({}, s), {}, _defineProperty({}, key, true));
    });
    window.setTimeout(function () {
      setArcadeActive(function (s) {
        return _objectSpread(_objectSpread({}, s), {}, _defineProperty({}, key, false));
      });
    }, 120);
  }, []);
  var _useState9 = useState(false),
    _useState0 = _slicedToArray(_useState9, 2),
    started = _useState0[0],
    setStarted = _useState0[1];
  var _useState1 = useState(10),
    _useState10 = _slicedToArray(_useState1, 2),
    scoreToWin = _useState10[0],
    setScoreToWin = _useState10[1];
  var _useState11 = useState(1),
    _useState12 = _slicedToArray(_useState11, 2),
    speedScale = _useState12[0],
    setSpeedScale = _useState12[1];
  var _useState13 = useState(true),
    _useState14 = _slicedToArray(_useState13, 2),
    aiEnabled = _useState14[0],
    setAiEnabled = _useState14[1];
  var _useState15 = useState(false),
    _useState16 = _slicedToArray(_useState15, 2),
    squoshTwoPlayers = _useState16[0],
    setSquoshTwoPlayers = _useState16[1];
  var _useState17 = useState(6),
    _useState18 = _slicedToArray(_useState17, 2),
    aiLevel = _useState18[0],
    setAiLevel = _useState18[1];
  var _useState19 = useState(1),
    _useState20 = _slicedToArray(_useState19, 2),
    paddleScale = _useState20[0],
    setPaddleScale = _useState20[1];
  var _useState21 = useState("pong"),
    _useState22 = _slicedToArray(_useState21, 2),
    mode = _useState22[0],
    setMode = _useState22[1];
  var _useState23 = useState(function () {
      try {
        var v = localStorage.getItem("paletkowo_theme");
        if (!v) return "green";
        return getColorTheme(v).key;
      } catch (_unused5) {
        return "green";
      }
    }),
    _useState24 = _slicedToArray(_useState23, 2),
    colorTheme = _useState24[0],
    setColorTheme = _useState24[1];

  // LED bar animation state.  ledOnCount controls how many LEDs on each side of
  // the center are lit.  ledActiveRef prevents overlapping animations.
  var _useStateLED = useState(0),
    _useStateLED2 = _slicedToArray(_useStateLED, 2),
    ledOnCount = _useStateLED2[0],
    setLedOnCount = _useStateLED2[1];
  var ledActiveRef = useRef(false);
  // Pulse the LED bar based on the provided sound level (0..1).  When called,
  // LEDs light up from the centre outward; louder sounds light more LEDs.
  var pulseLedBar = useCallback(function (level, duration) {
    // Default level of 1 if not supplied or invalid
    var lvl = typeof level === "number" && !isNaN(level) ? level : 1;
    if (lvl < 0) lvl = 0;
    if (lvl > 1) lvl = 1;
    // Duration in ms (undefined defaults to 200ms)
    var dur = typeof duration === "number" && !isNaN(duration) ? duration : 200;
    if (ledActiveRef.current) return;
    ledActiveRef.current = true;
    var maxSteps = Math.ceil(LED_COUNT / 2 * lvl);
    // Impact sounds: very short durations light up immediately and fade quickly
    if (dur < 120) {
      // For quick impact sounds, light only a portion of the bar (half of maxSteps)
      var lightSteps = maxSteps < 1 ? 1 : Math.max(1, Math.floor(maxSteps * 0.5));
      setLedOnCount(lightSteps);
      window.setTimeout(function () {
        ledActiveRef.current = false;
        setLedOnCount(0);
      }, Math.max(100, dur));
      return;
    }
    // For longer sounds, animate lighting over the duration
    var step = 1;
    // Spread the lighting over roughly half the duration to leave time for fade
    var stepInterval = Math.max(20, dur / (maxSteps * 2));
    var advance = function advance() {
      setLedOnCount(step);
      step += 1;
      if (step <= maxSteps) {
        window.setTimeout(advance, stepInterval);
      } else {
        window.setTimeout(function () {
          ledActiveRef.current = false;
          setLedOnCount(0);
        }, stepInterval);
      }
    };
    if (maxSteps > 0) {
      advance();
    } else {
      ledActiveRef.current = false;
      setLedOnCount(0);
    }
  }, []);
  useEffect(function () {
    // Listen for custom audio events and pass through the level to the pulse function
    var handler = function handler(e) {
      var level = e && e.detail && typeof e.detail.level === "number" ? e.detail.level : 1;
      var duration = e && e.detail && typeof e.detail.duration === "number" ? e.detail.duration : undefined;
      pulseLedBar(level, duration);
    };
    window.addEventListener('paletkowo-sound', handler);
    return function () {
      window.removeEventListener('paletkowo-sound', handler);
    };
  }, [pulseLedBar]);
  var _useState25 = useState(function () {
      try {
        var v = localStorage.getItem("paletkowo_music");
        if (v === null) return true;
        return v === "1";
      } catch (_unused6) {
        return true;
      }
    }),
    _useState26 = _slicedToArray(_useState25, 2),
    musicEnabled = _useState26[0],
    setMusicEnabled = _useState26[1];
  var settingsRef = useRef(null);
  settingsRef.current = {
    paused: paused,
    started: started,
    scoreToWin: scoreToWin,
    speedScale: speedScale,
    aiEnabled: aiEnabled,
    aiLevel: aiLevel,
    squoshTwoPlayers: squoshTwoPlayers,
    paddleScale: paddleScale,
    mode: mode,
    musicEnabled: musicEnabled,
    colorTheme: colorTheme
  };
  var G = GAME;
  var W = G.W;
  var H = G.H;
  var uiVars = useMemo(function () {
    var th = getColorTheme(colorTheme);
    var blend = function blend(c1, c2, t) {
      return blendHex(c1, c2, t);
    };
    var uiBg = blend(th.bg, "#ffffff", 0.06);
    var uiPanel = blend(th.bg, "#ffffff", 0.12);
    var uiBorder = blend(th.accent, th.fg, 0.62);
    var uiText = th.fg;
    var uiMuted = blend(th.fg, th.bg, 0.55);
    var uiSoft = blend(th.accent, th.bg, 0.82);
    var uiAccent = th.accent;
    var uiAccentBorder = blend(th.accent, th.fg, 0.35);
    var uiAccentText = th.key === "mono" ? blend(th.fg, th.bg, 0.15) : blend(th.bg, th.fg, 0.15);
    var uiKnob = th.key === "mono" ? blend(th.fg, th.bg, 0.35) : blend(th.fg, "#ffffff", 0.1);
    return {
      "--ui-bg": uiBg,
      "--ui-panel": uiPanel,
      "--ui-border": uiBorder,
      "--ui-text": uiText,
      "--ui-muted": uiMuted,
      "--ui-soft": uiSoft,
      "--ui-accent": uiAccent,
      "--ui-accentBorder": uiAccentBorder,
      "--ui-accentText": uiAccentText,
      "--ui-knob": uiKnob,
      "--ui-sliderRight": th.sliderRight || blend(th.fg, "#ffffff", 0.12),
      "--ui-font": '"Tiny5", "Press Start 2P", "VT323", monospace'
    };
  }, [colorTheme]);
  var themeRef = useRef(getColorTheme(colorTheme));
  useEffect(function () {
    themeRef.current = getColorTheme(colorTheme);
  }, [colorTheme]);
  var TITLE_UI = useMemo(function () {
    return {
      fontFamily: '"Tiny5", "Press Start 2P", "VT323", monospace',
      titleSize: 90,
      modeSize: 54,
      blurbSize: 21,
      hintSize: 20,
      gapTitleToMode: 22,
      gapModeToBlurb: 18,
      gapBlurbToBtn: 26,
      gapBtnToHint: 26,
      btnW: 260,
      btnH: 56,
      btnRadius: 0,
      btnTextSize: 30
    };
  }, []);
  var HUD_UI = useMemo(function () {
    return {
      fontFamily: TITLE_UI.fontFamily,
      scoreSize: 51,
      helpSize: 23,
      overlaySize: 32,
      gameOverSize: 34
    };
  }, [TITLE_UI]);
  var PADDLE_W = G.PADDLE_W;
  var PADDLE_H_BASE = G.PADDLE_H_BASE;
  var PADDLE_SPEED = G.PADDLE_SPEED;
  var BALL_SIZE = G.BALL_SIZE;
  var BALL_SPEED_START = G.BALL_SPEED_START;
  var BALL_SPEED_MAX = G.BALL_SPEED_MAX;
  var getPaddleH = function getPaddleH() {
    return Math.round(PADDLE_H_BASE * settingsRef.current.paddleScale);
  };

  // -------------------------
  // H2) Audio glue (ensureAudio/syncMusic)
  // -------------------------
  var ensureAudio = useCallback(/*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
    var a, o, g, t0, _t;
    return _regenerator().w(function (_context) {
      while (1) switch (_context.p = _context.n) {
        case 0:
          // WebAudio bywa "zablokowane" dopóki nie nastąpi gest użytkownika.
          // Dodatkowo (zwłaszcza na iOS) pomaga krótki, prawie niesłyszalny "tick" po resume.
          if (!audioRef.current) audioRef.current = createAudioEngine();
          a = audioRef.current;
          if (a !== null && a !== void 0 && a.ctx) {
            _context.n = 1;
            break;
          }
          return _context.a(2, false);
        case 1:
          _context.p = 1;
          if (!(a.ctx.state !== "running")) {
            _context.n = 2;
            break;
          }
          _context.n = 2;
          return a.ctx.resume();
        case 2:
          // "unlock tick" – bardzo krótki i bardzo cichy
          o = a.ctx.createOscillator();
          g = a.ctx.createGain();
          o.type = "sine";
          o.frequency.value = 60;
          g.gain.value = 0.00001;
          o.connect(g);
          g.connect(a.ctx.destination);
          t0 = a.ctx.currentTime;
          o.start(t0);
          o.stop(t0 + 0.01);
          return _context.a(2, true);
        case 3:
          _context.p = 3;
          _t = _context.v;
          return _context.a(2, false);
      }
    }, _callee, null, [[1, 3]]);
  })), []);
  var syncMusic = useCallback(function (modeOverride) {
    var s = settingsRef.current;
    var a = audioRef.current;
    if (!(a !== null && a !== void 0 && a.music)) return;
    var desiredMode = modeOverride || s.mode || "pong";
    var track = getModeCfg(desiredMode).audioTrack;
    a.music.setEnabled(!!s.musicEnabled);
    if (!s.musicEnabled) return a.music.stop();
    a.music.start(track);
  }, []);

  // -------------------------
  // H3) Game state init/reset
  // -------------------------

  var aiLastUpdateRef = useRef(0);
  var aiAimRef = useRef(0);
  var gameRef = useRef({
    left: {
      x: 30,
      y: H / 2 - PADDLE_H_BASE / 2
    },
    right: {
      x: W - 30 - PADDLE_W,
      y: H / 2 - PADDLE_H_BASE / 2
    },
    left2: {
      x: 30,
      y: H / 2 - PADDLE_H_BASE / 2 + 140
    },
    right2: {
      x: W - 30 - PADDLE_W,
      y: H / 2 - PADDLE_H_BASE / 2 + 140
    },
    ball: serveBall(W, H, null, BALL_SPEED_START),
    leftScore: 0,
    rightScore: 0,
    gameOver: false,
    __lastPaddleH: PADDLE_H_BASE,
    fx: {
      goalFlashUntil: 0,
      goalFlashSide: 0
    },
    lastTouch: 0
  });
  var makeInitialState = function makeInitialState(mKey) {
    var _hockey$forwardFrac;
    var cfg = getModeCfg(mKey);
    var paddleH = getPaddleH();
    var leftX = cfg.rules.leftInset;
    var rightX = W - cfg.rules.rightInset - PADDLE_W;
    var baseY = H / 2 - paddleH / 2;
    var hockey = cfg.rules.hockey;
    var f = (_hockey$forwardFrac = hockey === null || hockey === void 0 ? void 0 : hockey.forwardFrac) !== null && _hockey$forwardFrac !== void 0 ? _hockey$forwardFrac : 0.75;
    var midL = clamp(Math.floor(W * f - PADDLE_W / 2), 0, W - PADDLE_W);
    var midR = clamp(Math.floor(W * (1 - f) - PADDLE_W / 2), 0, W - PADDLE_W);
    return {
      left: {
        x: leftX,
        y: baseY
      },
      right: {
        x: rightX,
        y: baseY
      },
      left2: {
        x: hockey ? midL : leftX,
        y: baseY
      },
      right2: {
        x: hockey ? midR : rightX,
        y: baseY
      },
      ball: serveBall(W, H, null, BALL_SPEED_START),
      leftScore: 0,
      rightScore: 0,
      gameOver: false,
      __lastPaddleH: paddleH,
      fx: {
        goalFlashUntil: 0,
        goalFlashSide: 0
      },
      lastTouch: 0
    };
  };
  var resetGame = useCallback(function () {
    var m = settingsRef.current.mode;
    gameRef.current = makeInitialState(m);
    lastTRef.current = 0;
    aiLastUpdateRef.current = 0;
    aiAimRef.current = 0;
  }, []);
  var newRound = function newRound(dir) {
    return gameRef.current.ball = serveBall(W, H, dir, BALL_SPEED_START);
  };
  var isInHockeyGoalMouth = function isInHockeyGoalMouth(y, goalOpen) {
    var top = H / 2 - goalOpen / 2;
    var bot = H / 2 + goalOpen / 2;
    return y >= top && y <= bot;
  };
  var flashGoal = function flashGoal(side) {
    var g = gameRef.current;
    var now = performance.now();
    g.fx.goalFlashSide = side;
    g.fx.goalFlashUntil = now + 220;
  };
  useEffect(function () {
    runSelfTests();

    // Awaryjny "unlock" audio: jeśli środowisko wymaga bezpośredniego gestu,
    // pierwszy pointerdown uruchomi resume (raz).
    var onFirstGesture = function onFirstGesture() {
      ensureAudio().then(function () {
        // Muzyka ma działać także na planszy startowej (po pierwszym geście użytkownika).
        if (settingsRef.current.musicEnabled) syncMusic();
      });
    };
    window.addEventListener("pointerdown", onFirstGesture, {
      once: true
    });
    return function () {
      return window.removeEventListener("pointerdown", onFirstGesture);
    };
  }, []);
  useEffect(function () {
    var _g$__lastPaddleH;
    var g = gameRef.current;
    var newH = Math.round(PADDLE_H_BASE * paddleScale);
    var lastH = (_g$__lastPaddleH = g.__lastPaddleH) !== null && _g$__lastPaddleH !== void 0 ? _g$__lastPaddleH : newH;
    var recenter = function recenter(p) {
      return p.y = clamp(p.y + lastH / 2 - newH / 2, 0, H - newH);
    };
    recenter(g.left);
    recenter(g.right);
    recenter(g.left2);
    recenter(g.right2);
    g.__lastPaddleH = newH;
  }, [paddleScale]);
  useEffect(function () {
    // Zmiana trybu nie powinna ucinać muzyki.
    // Jeśli gra była już uruchomiona, zostajemy w stanie STARTED i tylko resetujemy stan gry.
    var wasStarted = !!settingsRef.current.started;
    resetGame();
    setPaused(false);
    setStarted(wasStarted);
    ensureAudio().then(function () {
      return syncMusic(mode);
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [mode]);
  useEffect(function () {
    // Persist ustawień UI
    try {
      localStorage.setItem("paletkowo_music", musicEnabled ? "1" : "0");
      localStorage.setItem("paletkowo_theme", colorTheme);
    } catch (_unused8) {}
  }, [musicEnabled, colorTheme]);
  useEffect(function () {
    // Muzyka ma działać i w grze, i na planszy startowej.
    // AudioContext wystartuje dopiero po geście użytkownika — ensureAudio() może wtedy zadziałać.
    if (!musicEnabled) {
      try {
        var _audioRef$current, _audioRef$current$set, _audioRef$current2, _audioRef$current2$st;
        (_audioRef$current = audioRef.current) === null || _audioRef$current === void 0 || (_audioRef$current = _audioRef$current.music) === null || _audioRef$current === void 0 || (_audioRef$current$set = _audioRef$current.setEnabled) === null || _audioRef$current$set === void 0 || _audioRef$current$set.call(_audioRef$current, false);
        (_audioRef$current2 = audioRef.current) === null || _audioRef$current2 === void 0 || (_audioRef$current2 = _audioRef$current2.music) === null || _audioRef$current2 === void 0 || (_audioRef$current2$st = _audioRef$current2.stop) === null || _audioRef$current2$st === void 0 || _audioRef$current2$st.call(_audioRef$current2);
      } catch (_unused9) {}
      return;
    }
    ensureAudio().then(function () {
      syncMusic();
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [musicEnabled, mode]);
  useEffect(function () {
    var onKeyDown = function onKeyDown(e) {
      var isGameOver = gameRef.current.gameOver;
      var isSpace = e.key === " " || e.code === "Space";
      if (isGameOver && !isSpace) return;
      keysRef.current.add(e.key);
      if (isSpace) {
        e.preventDefault();
        ensureAudio().then(function () {
          var _audioRef$current5, _audioRef$current5$ui;
          syncMusic();
          if (gameRef.current.gameOver) {
            var _audioRef$current3, _audioRef$current3$ui;
            // KROK 1: po game-over SPACJA wraca do planszy startowej (nie restartuje meczu)
            gameRef.current = makeInitialState(settingsRef.current.mode);
            gameRef.current.lastTouch = 0;
            lastTRef.current = 0;
            aiLastUpdateRef.current = 0;
            aiAimRef.current = 0;
            setPaused(false);
            setStarted(false);
            (_audioRef$current3 = audioRef.current) === null || _audioRef$current3 === void 0 || (_audioRef$current3 = _audioRef$current3.sfx) === null || _audioRef$current3 === void 0 || (_audioRef$current3$ui = _audioRef$current3.ui) === null || _audioRef$current3$ui === void 0 || _audioRef$current3$ui.call(_audioRef$current3);
            return;
          }
          if (!settingsRef.current.started) {
            var _audioRef$current4, _audioRef$current4$ui;
            pulseArcade("start");
            setStarted(true);
            setPaused(false);
            (_audioRef$current4 = audioRef.current) === null || _audioRef$current4 === void 0 || (_audioRef$current4 = _audioRef$current4.sfx) === null || _audioRef$current4 === void 0 || (_audioRef$current4$ui = _audioRef$current4.ui) === null || _audioRef$current4$ui === void 0 || _audioRef$current4$ui.call(_audioRef$current4);
            return;
          }

          // pauza / wznowienie
          pulseArcade("pause");
          setPaused(function (p) {
            return !p;
          });
          (_audioRef$current5 = audioRef.current) === null || _audioRef$current5 === void 0 || (_audioRef$current5 = _audioRef$current5.sfx) === null || _audioRef$current5 === void 0 || (_audioRef$current5$ui = _audioRef$current5.ui) === null || _audioRef$current5$ui === void 0 || _audioRef$current5$ui.call(_audioRef$current5);
        });
      }
      if (!isGameOver && String(e.key).toLowerCase() === "r") {
        pulseArcade("serve");
        ensureAudio().then(function () {
          var _audioRef$current6, _audioRef$current6$ui;
          gameRef.current.ball = serveBall(W, H, null, BALL_SPEED_START);
          (_audioRef$current6 = audioRef.current) === null || _audioRef$current6 === void 0 || (_audioRef$current6 = _audioRef$current6.sfx) === null || _audioRef$current6 === void 0 || (_audioRef$current6$ui = _audioRef$current6.ui) === null || _audioRef$current6$ui === void 0 || _audioRef$current6$ui.call(_audioRef$current6);
        });
      }
    };
    var onKeyUp = function onKeyUp(e) {
      return keysRef.current["delete"](e.key);
    };
    window.addEventListener("keydown", onKeyDown, {
      passive: false
    });
    window.addEventListener("keyup", onKeyUp);
    return function () {
      window.removeEventListener("keydown", onKeyDown);
      window.removeEventListener("keyup", onKeyUp);
    };
  }, []);

  // -------------------------
  // H4) Input + AI
  // -------------------------

  var stepAI = function stepAI(paddleH) {
    var g = gameRef.current;
    var s = settingsRef.current;
    var skill = aiSkillFromUiLevel(s.aiLevel);
    var now = performance.now();
    var reactionMs = 220 - skill * 190;
    if (now - aiLastUpdateRef.current > reactionMs) {
      aiLastUpdateRef.current = now;
      var lookAhead = 10 + skill * 55;
      var aimY = g.ball.y + g.ball.vy * lookAhead;
      var r = BALL_SIZE / 2;
      while (aimY < r || aimY > H - r) {
        aimY = aimY < r ? r + (r - aimY) : H - r - (aimY - (H - r));
      }
      aimY += (Math.random() * 2 - 1) * (1 - skill) * 24;
      aiAimRef.current = clamp(aimY - paddleH / 2, 0, H - paddleH);
    }
    var maxSpeed = PADDLE_SPEED * s.speedScale * (0.65 + 0.55 * skill);
    var diff = aiAimRef.current - g.right.y;
    var dead = 2 + (1 - skill) * 6;
    if (Math.abs(diff) <= dead) return;
    g.right.y = clamp(g.right.y + clamp(diff, -maxSpeed, maxSpeed), 0, H - paddleH);
    if (s.mode === "hockey") g.right2.y = g.right.y;
  };
  var stepAISquoshMate = function stepAISquoshMate(paddleH) {
    var g = gameRef.current;
    var s = settingsRef.current;
    var skill = aiSkillFromUiLevel(s.aiLevel);
    var now = performance.now();
    var reactionMs = 220 - skill * 190;
    if (now - aiLastUpdateRef.current > reactionMs) {
      aiLastUpdateRef.current = now;
      var lookAhead = 10 + skill * 55;
      var aimY = g.ball.y + g.ball.vy * lookAhead;
      var r = BALL_SIZE / 2;
      while (aimY < r || aimY > H - r) {
        aimY = aimY < r ? r + (r - aimY) : H - r - (aimY - (H - r));
      }
      aimY += (Math.random() * 2 - 1) * (1 - skill) * 24;
      aiAimRef.current = clamp(aimY - paddleH / 2, 0, H - paddleH);
    }
    var maxSpeed = PADDLE_SPEED * s.speedScale * (0.65 + 0.55 * skill);
    var diff = aiAimRef.current - g.left2.y;
    var dead = 2 + (1 - skill) * 6;
    if (Math.abs(diff) <= dead) return;
    g.left2.y = clamp(g.left2.y + clamp(diff, -maxSpeed, maxSpeed), 0, H - paddleH);
  };
  var applyInput = function applyInput(cfg) {
    if (gameRef.current.gameOver) return;
    var s = settingsRef.current;
    var g = gameRef.current;
    var paddleH = getPaddleH();
    var keys = keysRef.current;
    var paddleSpeed = PADDLE_SPEED * s.speedScale;
    if (keys.has("w") || keys.has("W")) g.left.y -= paddleSpeed;
    if (keys.has("s") || keys.has("S")) g.left.y += paddleSpeed;
    g.left.y = clamp(g.left.y, 0, H - paddleH);
    if (cfg.key === "hockey" && cfg.rules.paddles.left === 2) g.left2.y = g.left.y;
    if (cfg.key === "squosh" && s.squoshTwoPlayers) {
      g.left2.x = g.left.x + PADDLE_W + 10;
      if (!g.lastTouch) g.lastTouch = 1;
      if (s.aiEnabled) {
        stepAISquoshMate(paddleH);
      } else {
        if (keys.has("ArrowUp")) g.left2.y -= paddleSpeed;
        if (keys.has("ArrowDown")) g.left2.y += paddleSpeed;
        g.left2.y = clamp(g.left2.y, 0, H - paddleH);
      }
    }
    if (cfg.rules.rightPlayable) {
      if (s.aiEnabled) stepAI(paddleH);else {
        if (keys.has("ArrowUp")) g.right.y -= paddleSpeed;
        if (keys.has("ArrowDown")) g.right.y += paddleSpeed;
        g.right.y = clamp(g.right.y, 0, H - paddleH);
        if (cfg.rules.paddles.right === 2) g.right2.y = g.right.y;
      }
    }

    // -- Aktualizacja kątów pokręteł na podstawie położenia paletek (potencjometr zakresowy) --
    // Dla lewego pokrętła: mapuj aktualne Y paletki na przedział 0–360°.
    {
      var range = H - paddleH;
      if (range > 0) {
        var fracL = g.left.y / range;
        var angleL = fracL * 360;
        knobRef.current.aL = Math.max(0, Math.min(360, angleL));
        setKnobL(knobRef.current.aL);
      }
    }
    // Dla prawego pokrętła: analogicznie mapuj pozycję odpowiedniej paletki.
    // W trybie "squosh" z dwoma graczami prawa paletka to w istocie lewa2; inaczej używamy g.right.
    {
      var _range = H - paddleH;
      if (_range > 0) {
        // Wybierz źródło Y dla prawego pokrętła w zależności od trybu.
        var sourceY;
        if (cfg.key === 'squosh' && s.squoshTwoPlayers) {
          var _g$left;
          sourceY = (_g$left = g.left2) === null || _g$left === void 0 ? void 0 : _g$left.y;
        } else {
          var _g$right;
          sourceY = (_g$right = g.right) === null || _g$right === void 0 ? void 0 : _g$right.y;
        }
        if (typeof sourceY === 'number') {
          var fracR = sourceY / _range;
          var angleR = fracR * 360;
          knobRef.current.aR = Math.max(0, Math.min(360, angleR));
          setKnobR(knobRef.current.aR);
        }
      }
    }
  };

  // -------------------------
  // H5) Physics (ball/paddles/scoring/game over)
  // -------------------------

  var advanceBall = function advanceBall(dt) {
    var s = settingsRef.current;
    var g = gameRef.current;
    var frameScale = s.speedScale * (dt / (1000 / 60));
    g.ball.x += g.ball.vx * frameScale;
    g.ball.y += g.ball.vy * frameScale;
    var r = BALL_SIZE / 2;
    if (g.ball.y - r <= 0) {
      var _audioRef$current7, _audioRef$current7$wa;
      g.ball.y = r;
      g.ball.vy *= -1;
      (_audioRef$current7 = audioRef.current) === null || _audioRef$current7 === void 0 || (_audioRef$current7 = _audioRef$current7.sfx) === null || _audioRef$current7 === void 0 || (_audioRef$current7$wa = _audioRef$current7.wall) === null || _audioRef$current7$wa === void 0 || _audioRef$current7$wa.call(_audioRef$current7);
    } else if (g.ball.y + r >= H) {
      var _audioRef$current8, _audioRef$current8$wa;
      g.ball.y = H - r;
      g.ball.vy *= -1;
      (_audioRef$current8 = audioRef.current) === null || _audioRef$current8 === void 0 || (_audioRef$current8 = _audioRef$current8.sfx) === null || _audioRef$current8 === void 0 || (_audioRef$current8$wa = _audioRef$current8.wall) === null || _audioRef$current8$wa === void 0 || _audioRef$current8$wa.call(_audioRef$current8);
    }
  };
  var resolveScoringAndWalls = function resolveScoringAndWalls(cfg) {
    var g = gameRef.current;
    var r = BALL_SIZE / 2;
    if (cfg.key === "pong") {
      if (g.ball.x + r < 0) {
        var _audioRef$current9, _audioRef$current9$sc;
        g.rightScore++;
        flashGoal(-1);
        newRound(-1);
        (_audioRef$current9 = audioRef.current) === null || _audioRef$current9 === void 0 || (_audioRef$current9 = _audioRef$current9.sfx) === null || _audioRef$current9 === void 0 || (_audioRef$current9$sc = _audioRef$current9.score) === null || _audioRef$current9$sc === void 0 || _audioRef$current9$sc.call(_audioRef$current9);
      } else if (g.ball.x - r > W) {
        var _audioRef$current0, _audioRef$current0$sc;
        g.leftScore++;
        flashGoal(1);
        newRound(1);
        (_audioRef$current0 = audioRef.current) === null || _audioRef$current0 === void 0 || (_audioRef$current0 = _audioRef$current0.sfx) === null || _audioRef$current0 === void 0 || (_audioRef$current0$sc = _audioRef$current0.score) === null || _audioRef$current0$sc === void 0 || _audioRef$current0$sc.call(_audioRef$current0);
      }
    }
    if (cfg.key === "squosh") {
      var wallX = W - cfg.rules.squashWallInset;
      if (g.ball.x + r >= wallX) {
        var _audioRef$current1, _audioRef$current1$wa;
        g.ball.x = wallX - r;
        g.ball.vx *= -1;
        if (settingsRef.current.squoshTwoPlayers) {
          var lt = g.lastTouch || 1;
          if (lt === 1) g.leftScore++;else if (lt === 2) g.rightScore++;
        } else {
          g.leftScore++;
        }
        (_audioRef$current1 = audioRef.current) === null || _audioRef$current1 === void 0 || (_audioRef$current1 = _audioRef$current1.sfx) === null || _audioRef$current1 === void 0 || (_audioRef$current1$wa = _audioRef$current1.wall) === null || _audioRef$current1$wa === void 0 || _audioRef$current1$wa.call(_audioRef$current1);
      }
      if (g.ball.x - r <= 0) {
        var _audioRef$current10, _audioRef$current10$s;
        if (settingsRef.current.squoshTwoPlayers) {
          var _lt = g.lastTouch;
          if (_lt === 1) g.rightScore++;else if (_lt === 2) g.leftScore++;
          g.lastTouch = 0;
          g.ball = serveBall(W, H, 1, BALL_SPEED_START);
        } else {
          g.leftScore = 0;
          g.ball = serveBall(W, H, 1, BALL_SPEED_START);
        }
        (_audioRef$current10 = audioRef.current) === null || _audioRef$current10 === void 0 || (_audioRef$current10 = _audioRef$current10.sfx) === null || _audioRef$current10 === void 0 || (_audioRef$current10$s = _audioRef$current10.score) === null || _audioRef$current10$s === void 0 || _audioRef$current10$s.call(_audioRef$current10);
      }
      if (!settingsRef.current.squoshTwoPlayers) g.rightScore = 0;
    }
    if (cfg.key === "hockey") {
      var goalOpen = cfg.rules.hockey.goalOpen;
      var hitLeft = g.ball.x - r <= 0;
      var hitRight = g.ball.x + r >= W;
      if (hitLeft) {
        if (isInHockeyGoalMouth(g.ball.y, goalOpen)) {
          var _audioRef$current11, _audioRef$current11$s;
          g.rightScore++;
          flashGoal(-1);
          newRound(1);
          (_audioRef$current11 = audioRef.current) === null || _audioRef$current11 === void 0 || (_audioRef$current11 = _audioRef$current11.sfx) === null || _audioRef$current11 === void 0 || (_audioRef$current11$s = _audioRef$current11.score) === null || _audioRef$current11$s === void 0 || _audioRef$current11$s.call(_audioRef$current11);
        } else {
          var _audioRef$current12, _audioRef$current12$w;
          g.ball.x = r;
          g.ball.vx *= -1;
          (_audioRef$current12 = audioRef.current) === null || _audioRef$current12 === void 0 || (_audioRef$current12 = _audioRef$current12.sfx) === null || _audioRef$current12 === void 0 || (_audioRef$current12$w = _audioRef$current12.wall) === null || _audioRef$current12$w === void 0 || _audioRef$current12$w.call(_audioRef$current12);
        }
      }
      if (hitRight) {
        if (isInHockeyGoalMouth(g.ball.y, goalOpen)) {
          var _audioRef$current13, _audioRef$current13$s;
          g.leftScore++;
          flashGoal(1);
          newRound(-1);
          (_audioRef$current13 = audioRef.current) === null || _audioRef$current13 === void 0 || (_audioRef$current13 = _audioRef$current13.sfx) === null || _audioRef$current13 === void 0 || (_audioRef$current13$s = _audioRef$current13.score) === null || _audioRef$current13$s === void 0 || _audioRef$current13$s.call(_audioRef$current13);
        } else {
          var _audioRef$current14, _audioRef$current14$w;
          g.ball.x = W - r;
          g.ball.vx *= -1;
          (_audioRef$current14 = audioRef.current) === null || _audioRef$current14 === void 0 || (_audioRef$current14 = _audioRef$current14.sfx) === null || _audioRef$current14 === void 0 || (_audioRef$current14$w = _audioRef$current14.wall) === null || _audioRef$current14$w === void 0 || _audioRef$current14$w.call(_audioRef$current14);
        }
      }
    }
  };
  var resolvePaddles = function resolvePaddles(cfg) {
    var g = gameRef.current;
    var paddleH = getPaddleH();
    var r = BALL_SIZE / 2;
    var ballX = g.ball.x - r;
    var ballY = g.ball.y - r;
    var hitPaddle = function hitPaddle(p, dir) {
      var _audioRef$current15, _audioRef$current15$p;
      if (dir < 0) g.ball.x = p.x + PADDLE_W + r;else g.ball.x = p.x - r;
      g.ball = reflectFromPaddle(g.ball, p.y, paddleH, BALL_SPEED_MAX);
      if (cfg.key === "squosh" && settingsRef.current.squoshTwoPlayers) {
        if (p === g.left) g.lastTouch = 1;else if (p === g.left2) g.lastTouch = 2;
      }
      (_audioRef$current15 = audioRef.current) === null || _audioRef$current15 === void 0 || (_audioRef$current15 = _audioRef$current15.sfx) === null || _audioRef$current15 === void 0 || (_audioRef$current15$p = _audioRef$current15.paddle) === null || _audioRef$current15$p === void 0 || _audioRef$current15$p.call(_audioRef$current15);
    };
    if (g.ball.vx < 0) {
      if (intersects(ballX, ballY, BALL_SIZE, BALL_SIZE, g.left.x, g.left.y, PADDLE_W, paddleH)) hitPaddle(g.left, -1);else if ((cfg.rules.paddles.left === 2 || cfg.key === "squosh" && settingsRef.current.squoshTwoPlayers) && intersects(ballX, ballY, BALL_SIZE, BALL_SIZE, g.left2.x, g.left2.y, PADDLE_W, paddleH)) hitPaddle(g.left2, -1);
    } else if (cfg.rules.rightPlayable) {
      if (intersects(ballX, ballY, BALL_SIZE, BALL_SIZE, g.right.x, g.right.y, PADDLE_W, paddleH)) hitPaddle(g.right, 1);else if (cfg.rules.paddles.right === 2 && intersects(ballX, ballY, BALL_SIZE, BALL_SIZE, g.right2.x, g.right2.y, PADDLE_W, paddleH)) hitPaddle(g.right2, 1);
    }
  };
  var resolveGameOver = function resolveGameOver(cfg) {
    var s = settingsRef.current;
    var g = gameRef.current;
    if (g.gameOver) return;
    if (cfg.rules.scoreToWin && s.scoreToWin && (g.leftScore >= s.scoreToWin || g.rightScore >= s.scoreToWin)) {
      var _audioRef$current16, _audioRef$current16$s, _audioRef$current17, _audioRef$current17$g, _audioRef$current18, _audioRef$current18$g;
      g.gameOver = true;
      // KROK 5: wyraźne zakończenie rundy – wygaszenie muzyki + jingle
      (_audioRef$current16 = audioRef.current) === null || _audioRef$current16 === void 0 || (_audioRef$current16 = _audioRef$current16.music) === null || _audioRef$current16 === void 0 || (_audioRef$current16$s = _audioRef$current16.stop) === null || _audioRef$current16$s === void 0 || _audioRef$current16$s.call(_audioRef$current16);
      if (cfg.key === "pong") (_audioRef$current17 = audioRef.current) === null || _audioRef$current17 === void 0 || (_audioRef$current17 = _audioRef$current17.sfx) === null || _audioRef$current17 === void 0 || (_audioRef$current17$g = _audioRef$current17.gameOverPong) === null || _audioRef$current17$g === void 0 || _audioRef$current17$g.call(_audioRef$current17);else if (cfg.key === "hockey") (_audioRef$current18 = audioRef.current) === null || _audioRef$current18 === void 0 || (_audioRef$current18 = _audioRef$current18.sfx) === null || _audioRef$current18 === void 0 || (_audioRef$current18$g = _audioRef$current18.gameOverHockey) === null || _audioRef$current18$g === void 0 || _audioRef$current18$g.call(_audioRef$current18);
      return;
    }
    if (cfg.key === "squosh" && s.scoreToWin) {
      var target = s.scoreToWin;
      var reached = s.squoshTwoPlayers ? g.leftScore >= target || g.rightScore >= target : g.leftScore >= target;
      if (reached) {
        var _audioRef$current19, _audioRef$current19$s, _audioRef$current20, _audioRef$current20$g;
        g.gameOver = true;
        // KROK 5: wyraźne zakończenie rundy – wygaszenie muzyki + jingle
        (_audioRef$current19 = audioRef.current) === null || _audioRef$current19 === void 0 || (_audioRef$current19 = _audioRef$current19.music) === null || _audioRef$current19 === void 0 || (_audioRef$current19$s = _audioRef$current19.stop) === null || _audioRef$current19$s === void 0 || _audioRef$current19$s.call(_audioRef$current19);
        (_audioRef$current20 = audioRef.current) === null || _audioRef$current20 === void 0 || (_audioRef$current20 = _audioRef$current20.sfx) === null || _audioRef$current20 === void 0 || (_audioRef$current20$g = _audioRef$current20.gameOverSquosh) === null || _audioRef$current20$g === void 0 || _audioRef$current20$g.call(_audioRef$current20);
        return;
      }
    }
  };
  var step = function step(dt) {
    var s = settingsRef.current;
    if (!s.started) return;
    var g = gameRef.current;
    if (g.gameOver) return;
    var cfg = getModeCfg(s.mode);
    applyInput(cfg);
    advanceBall(dt);
    resolveScoringAndWalls(cfg);
    resolvePaddles(cfg);
    resolveGameOver(cfg);
  };

  // -------------------------
  // H6) Render (canvas)
  // -------------------------

  var drawField = function drawField(ctx, mKey) {
    var th = themeRef.current;
    var cfg = getModeCfg(mKey);
    ctx.fillStyle = th.bg;
    ctx.fillRect(0, 0, W, H);
    if (cfg.key !== "squosh") {
      ctx.fillStyle = th.accent;
      for (var y = 0; y < H; y += 28) ctx.fillRect(W / 2 - 2, y, 4, 16);
    }
    if (cfg.key === "squosh") {
      var wallX = W - cfg.rules.squashWallInset;
      ctx.fillRect(wallX - 3, 0, 3, H);
    }
    if (cfg.key === "hockey") {
      var top = H / 2 - cfg.rules.hockey.goalOpen / 2;
      var bot = H / 2 + cfg.rules.hockey.goalOpen / 2;
      ctx.strokeStyle = th.accent;
      ctx.lineWidth = 4;
      ctx.beginPath();
      ctx.moveTo(0, top);
      ctx.lineTo(22, top);
      ctx.moveTo(0, bot);
      ctx.lineTo(22, bot);
      ctx.moveTo(W, top);
      ctx.lineTo(W - 22, top);
      ctx.moveTo(W, bot);
      ctx.lineTo(W - 22, bot);
      ctx.stroke();
    }
  };
  var getTitleLayout = function getTitleLayout(m) {
    var ui = TITLE_UI;
    var hTitle = ui.titleSize + 10;
    var hMode = ui.modeSize + 10;
    var hBlurb = ui.blurbSize * 2 + 14;
    var hBtn = ui.btnH;
    var hHint = ui.hintSize + 6;
    var total = hTitle + ui.gapTitleToMode + hMode + ui.gapModeToBlurb + hBlurb + ui.gapBlurbToBtn + hBtn + ui.gapBtnToHint + hHint;
    var y = Math.round(H / 2 - total / 2);
    var titleY = y + hTitle - 10;
    y += hTitle + ui.gapTitleToMode;
    var modeY = y + hMode - 10;
    y += hMode + ui.gapModeToBlurb;
    var blurbY1 = y + ui.blurbSize;
    var blurbY2 = y + ui.blurbSize * 2 + 8;
    y += hBlurb + ui.gapBlurbToBtn;
    var btnX = W / 2 - ui.btnW / 2;
    var btnY = y;
    y += hBtn + ui.gapBtnToHint;
    var hintY = y + ui.hintSize;
    return {
      titleY: titleY,
      modeY: modeY,
      blurbY1: blurbY1,
      blurbY2: blurbY2,
      btnX: btnX,
      btnY: btnY,
      btnW: ui.btnW,
      btnH: ui.btnH,
      hintY: hintY
    };
  };
  var drawTitleOnly = function drawTitleOnly(ctx, m) {
    var th = themeRef.current;
    ctx.fillStyle = th.bg;
    ctx.fillRect(0, 0, W, H);
    ctx.textAlign = "center";
    var ui = TITLE_UI;
    var pix = ui.fontFamily;
    var L = getTitleLayout(m);
    ctx.font = "900 ".concat(ui.titleSize, "px ").concat(pix);
    ctx.fillStyle = th.accent;
    ctx.fillText("PALETKOWO", W / 2 + 3, L.titleY + 3);
    ctx.fillStyle = th.fg;
    ctx.fillText("PALETKOWO", W / 2, L.titleY);
    ctx.fillStyle = th.accent;
    ctx.font = "700 ".concat(ui.modeSize, "px ").concat(pix);
    ctx.fillText(getModeCfg(m).label || String(m).toUpperCase(), W / 2, L.modeY);
    var bl = getModeCfg(m).blurb || ["", ""];
    ctx.fillStyle = th.fg;
    ctx.font = "".concat(ui.blurbSize, "px ").concat(pix);
    ctx.fillText(bl[0], W / 2, L.blurbY1);
    ctx.fillText(bl[1], W / 2, L.blurbY2);
    ctx.fillStyle = th.accent;
    ctx.roundRect(L.btnX, L.btnY, L.btnW, L.btnH, ui.btnRadius);
    ctx.fill();
    ctx.fillStyle = th.bg;
    ctx.font = "bold ".concat(ui.btnTextSize, "px ").concat(pix);
    ctx.fillText("START", W / 2, L.btnY + 38);
    ctx.fillStyle = th.fg;
    ctx.font = "bold ".concat(ui.hintSize, "px ").concat(pix);
    ctx.fillText("Kliknij START lub naciśnij SPACJĘ", W / 2, L.hintY);
  };
  var drawOverlayPause = function drawOverlayPause(ctx, th) {
    ctx.fillStyle = "rgba(0,0,0,0.35)";
    ctx.fillRect(0, 0, W, H);
    ctx.fillStyle = th.fg;
    ctx.textAlign = "center";
    ctx.font = "".concat(HUD_UI.overlaySize, "px ").concat(HUD_UI.fontFamily);
    ctx.fillText("Pauza", W / 2, H / 2);
  };
  var drawOverlayGameOver = function drawOverlayGameOver(ctx, th, m, s, g) {
    ctx.fillStyle = "rgba(0,0,0,0.5)";
    ctx.fillRect(0, 0, W, H);
    ctx.fillStyle = th.fg;
    ctx.textAlign = "center";
    ctx.font = "".concat(HUD_UI.gameOverSize + 22, "px ").concat(HUD_UI.fontFamily);
    ctx.fillText("GAME OVER", W / 2, H / 2 - 24);
    ctx.font = "".concat(HUD_UI.gameOverSize + 18, "px ").concat(HUD_UI.fontFamily);
    var scoreLine = m === "squosh" ? s.squoshTwoPlayers ? "".concat(g.leftScore, ":").concat(g.rightScore) : String(g.leftScore) : "".concat(g.leftScore, ":").concat(g.rightScore);
    ctx.fillText(scoreLine, W / 2, H / 2 + 28);
    ctx.fillStyle = th.accent;
    ctx.font = "".concat(HUD_UI.helpSize, "px ").concat(HUD_UI.fontFamily);
    ctx.fillText("SPACJA → MENU", W / 2, H / 2 + 70);
  };
  var draw = function draw() {
    var ctx = ctxRef.current;
    if (!ctx) return;
    var s = settingsRef.current;
    var g = gameRef.current;
    var m = s.mode;
    ctx.clearRect(0, 0, W, H);
    if (!s.started) return drawTitleOnly(ctx, m);
    drawField(ctx, m);
    var paddleH = getPaddleH();
    var r = BALL_SIZE / 2;
    var th = themeRef.current;
    var p1Col = th.fg;
    var p2Col = blendHex(th.accent, th.fg, 0.35);
    var rr = function rr(x, y) {
      return ctx.fillRect(x, y, PADDLE_W, paddleH);
    };
    ctx.fillStyle = p1Col;
    rr(g.left.x, g.left.y);
    if (m === "hockey") rr(g.left2.x, g.left2.y);
    if (m === "squosh" && s.squoshTwoPlayers) {
      ctx.fillStyle = p2Col;
      rr(g.left2.x, g.left2.y);
      ctx.fillStyle = p1Col;
    }
    if (m !== "squosh") {
      ctx.fillStyle = p2Col;
      rr(g.right.x, g.right.y);
      if (m === "hockey") rr(g.right2.x, g.right2.y);
      ctx.fillStyle = p1Col;
    }
    ctx.fillRect(g.ball.x - r, g.ball.y - r, BALL_SIZE, BALL_SIZE);
    ctx.font = "bold ".concat(HUD_UI.scoreSize, "px ").concat(HUD_UI.fontFamily);
    ctx.textAlign = "center";
    if (m === "squosh") {
      if (s.squoshTwoPlayers) {
        ctx.fillStyle = p1Col;
        ctx.fillText(String(g.leftScore), W / 2 - 70, 56);
        ctx.fillStyle = p2Col;
        ctx.fillText(String(g.rightScore), W / 2 + 70, 56);
      } else {
        ctx.fillStyle = p1Col;
        ctx.fillText(String(g.leftScore), W / 2, 56);
      }
    } else {
      ctx.fillStyle = p1Col;
      ctx.fillText(String(g.leftScore), W / 2 - 70, 56);
      ctx.fillStyle = p2Col;
      ctx.fillText(String(g.rightScore), W / 2 + 70, 56);
    }
    ctx.fillStyle = th.accent;
    ctx.font = "".concat(HUD_UI.helpSize, "px ").concat(HUD_UI.fontFamily);
    var help = getHudHelpText(m, s);
    ctx.fillText(help, W / 2, H - 12);
    if (g.gameOver) {
      drawOverlayGameOver(ctx, th, m, s, g);
    } else if (s.paused) {
      drawOverlayPause(ctx, th);
    }
  };
  useEffect(function () {
    var canvas = canvasRef.current;
    if (!canvas) return;
    var ctx = canvas.getContext("2d");
    if (!ctx) return;
    ensureRoundRect(ctx);
    ctxRef.current = ctx;
    var _loop = function loop(t) {
      var _k$lastYL, _k$lastYR;
      if (!lastTRef.current) lastTRef.current = t;
      var dt = t - lastTRef.current;
      lastTRef.current = t;
      if (!settingsRef.current.paused) step(dt);
      draw();

      // Krok 2: aktualizacja pokręteł na podstawie ruchu paletek (również gdy AI steruje prawą)
      // - PONG/HOKEY: prawa paletka = g.right
      // - SQUASH 2P: "prawy" gracz = g.left2
      // - SQUASH solo: prawe pokrętło stoi
      var g = gameRef.current;
      var k = knobRef.current;
      var yL = g.left.y;
      var yR = settingsRef.current.mode === "squosh" && settingsRef.current.squoshTwoPlayers ? g.left2.y : settingsRef.current.mode === "squosh" ? 0 : g.right.y;
      if (k.lastYL == null) {
        k.lastYL = yL;
        k.lastYR = yR;
      }
      var dyL = yL - ((_k$lastYL = k.lastYL) !== null && _k$lastYL !== void 0 ? _k$lastYL : yL);
      var dyR = yR - ((_k$lastYR = k.lastYR) !== null && _k$lastYR !== void 0 ? _k$lastYR : yR);
      k.lastYL = yL;
      k.lastYR = yR;
      k.aL = (k.aL + dyL * 1.4) % 360;
      k.aR = (k.aR + dyR * 1.4) % 360;
      if (t - (k.lastUiT || 0) > 50) {
        k.lastUiT = t;
        setKnobL(k.aL);
        setKnobR(k.aR);
      }
      rafRef.current = requestAnimationFrame(_loop);
    };
    rafRef.current = requestAnimationFrame(_loop);
    return function () {
      cancelAnimationFrame(rafRef.current);
      ctxRef.current = null;
      try {
        var _audioRef$current21, _audioRef$current21$s;
        (_audioRef$current21 = audioRef.current) === null || _audioRef$current21 === void 0 || (_audioRef$current21 = _audioRef$current21.music) === null || _audioRef$current21 === void 0 || (_audioRef$current21$s = _audioRef$current21.stop) === null || _audioRef$current21$s === void 0 || _audioRef$current21$s.call(_audioRef$current21);
      } catch (_unused0) {}
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  var onCanvasPointerDown = useCallback(function (e) {
    var s = settingsRef.current;
    if (!s.started) {
      var canvas = canvasRef.current;
      if (!canvas) return;
      var rect = canvas.getBoundingClientRect();
      var scaleX = W / rect.width;
      var scaleY = H / rect.height;
      var x = (e.clientX - rect.left) * scaleX;
      var y = (e.clientY - rect.top) * scaleY;
      var L = getTitleLayout(s.mode);
      if (x >= L.btnX && x <= L.btnX + L.btnW && y >= L.btnY && y <= L.btnY + L.btnH) {
        ensureAudio().then(function () {
          var _audioRef$current22, _audioRef$current22$u;
          setStarted(true);
          setPaused(false);
          (_audioRef$current22 = audioRef.current) === null || _audioRef$current22 === void 0 || (_audioRef$current22 = _audioRef$current22.sfx) === null || _audioRef$current22 === void 0 || (_audioRef$current22$u = _audioRef$current22.ui) === null || _audioRef$current22$u === void 0 || _audioRef$current22$u.call(_audioRef$current22);
          syncMusic();
        });
        return;
      }
    }
    ensureAudio().then(function () {
      return syncMusic();
    });
  }, [W, ensureAudio, syncMusic]);
  var onTogglePause = useCallback(function () {
    pulseArcade("pause");
    ensureAudio().then(function () {
      var _audioRef$current23, _audioRef$current23$u;
      syncMusic();
      if (!settingsRef.current.started) setStarted(true);
      setPaused(function (p) {
        return !p;
      });
      (_audioRef$current23 = audioRef.current) === null || _audioRef$current23 === void 0 || (_audioRef$current23 = _audioRef$current23.sfx) === null || _audioRef$current23 === void 0 || (_audioRef$current23$u = _audioRef$current23.ui) === null || _audioRef$current23$u === void 0 || _audioRef$current23$u.call(_audioRef$current23);
    });
  }, [ensureAudio, syncMusic, pulseArcade]);
  var onStart = useCallback(function () {
    pulseArcade("start");
    ensureAudio().then(function () {
      var _audioRef$current25, _audioRef$current25$u;
      syncMusic();
      if (!settingsRef.current.started) {
        var _audioRef$current24, _audioRef$current24$u;
        setStarted(true);
        setPaused(false);
        (_audioRef$current24 = audioRef.current) === null || _audioRef$current24 === void 0 || (_audioRef$current24 = _audioRef$current24.sfx) === null || _audioRef$current24 === void 0 || (_audioRef$current24$u = _audioRef$current24.ui) === null || _audioRef$current24$u === void 0 || _audioRef$current24$u.call(_audioRef$current24);
        return;
      }
      // START = wznów (nie pauzuje)
      setPaused(false);
      (_audioRef$current25 = audioRef.current) === null || _audioRef$current25 === void 0 || (_audioRef$current25 = _audioRef$current25.sfx) === null || _audioRef$current25 === void 0 || (_audioRef$current25$u = _audioRef$current25.ui) === null || _audioRef$current25$u === void 0 || _audioRef$current25$u.call(_audioRef$current25);
    });
  }, [ensureAudio, syncMusic, pulseArcade]);
  var onServe = useCallback(function () {
    pulseArcade("serve");
    ensureAudio().then(function () {
      var _audioRef$current26, _audioRef$current26$u;
      syncMusic();
      var g = gameRef.current;
      if (g.gameOver) return;
      if (!settingsRef.current.started) {
        setStarted(true);
        setPaused(false);
      }
      g.ball = serveBall(W, H, null, BALL_SPEED_START);
      (_audioRef$current26 = audioRef.current) === null || _audioRef$current26 === void 0 || (_audioRef$current26 = _audioRef$current26.sfx) === null || _audioRef$current26 === void 0 || (_audioRef$current26$u = _audioRef$current26.ui) === null || _audioRef$current26$u === void 0 || _audioRef$current26$u.call(_audioRef$current26);
    });
  }, [ensureAudio, syncMusic, W, H, BALL_SPEED_START, pulseArcade]);
  var onReset = useCallback(function () {
    ensureAudio().then(function () {
      var _audioRef$current27, _audioRef$current27$u;
      resetGame();
      setStarted(false);
      setPaused(false);
      (_audioRef$current27 = audioRef.current) === null || _audioRef$current27 === void 0 || (_audioRef$current27 = _audioRef$current27.sfx) === null || _audioRef$current27 === void 0 || (_audioRef$current27$u = _audioRef$current27.ui) === null || _audioRef$current27$u === void 0 || _audioRef$current27$u.call(_audioRef$current27);
      syncMusic();
    });
  }, [ensureAudio, resetGame, syncMusic]);

  // -------------------------
  // H7) UI (React layout)
  // -------------------------

  return /*#__PURE__*/React.createElement("div", {
    className: "min-h-[100vh]",
    style: _objectSpread({
      background: "var(--ui-bg)"
    }, uiVars)
  }, /*#__PURE__*/React.createElement("style", null, "@import url('https://fonts.googleapis.com/css2?family=Tiny5&display=swap');"), /*#__PURE__*/React.createElement("div", {
    className: "p-4 max-w-6xl mx-auto"
  }, /*#__PURE__*/React.createElement("div", {
    className: "grid gap-4 md:grid-cols-[1fr_360px]"
  }, /*#__PURE__*/React.createElement(Card, {
    className: "h-full"
  }, /*#__PURE__*/React.createElement(CardContent, {
    className: "p-3 flex flex-col h-full"
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      display: "flex",
      flexDirection: "column",
      flex: 1,
      minHeight: 0
    }
  }, /*#__PURE__*/React.createElement("div", {
    onPointerDown: onCanvasPointerDown,
    className: "select-none border rounded-none overflow-hidden",
    style: CANVAS_FRAME_STYLE
  }, /*#__PURE__*/React.createElement("canvas", {
    ref: canvasRef,
    width: W,
    height: H,
    className: "block",
    style: {
      width: "100%",
      height: "auto"
    }
  }))), /*#__PURE__*/React.createElement("div", {
    style: {
      // shift the LED bar downward by 4px by increasing the top margin and decreasing the bottom margin
      marginTop: 16,
      marginBottom: 8
    }
  }, /*#__PURE__*/React.createElement(LedBar, {
    ledOnCount: ledOnCount
  })), /*#__PURE__*/React.createElement("div", {
    className: "mt-3 border rounded-none overflow-hidden",
    style: {
      borderColor: "var(--ui-border)",
      background: "var(--ui-panel)",
      height: 190,
      position: "relative",
      display: "flex",
      flexDirection: "column",
      justifyContent: "space-between",
      padding: "12px 14px",
      gap: 10
    }
  }, 
  /* dekoracyjne śrubki w narożnikach */
  /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      top: 4,
      left: 4,
      width: 12,
      height: 12,
      borderRadius: "50%",
      border: "1px solid rgba(0,0,0,0.4)",
      background: "radial-gradient(circle at 30% 30%, rgba(255,255,255,0.7), rgba(150,150,150,0.4) 60%, rgba(60,60,60,0.6) 100%)",
      boxShadow: "inset 1px 1px 2px rgba(255,255,255,0.3)"
    }
  }), /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      top: 4,
      right: 4,
      width: 12,
      height: 12,
      borderRadius: "50%",
      border: "1px solid rgba(0,0,0,0.4)",
      background: "radial-gradient(circle at 30% 30%, rgba(255,255,255,0.7), rgba(150,150,150,0.4) 60%, rgba(60,60,60,0.6) 100%)",
      boxShadow: "inset 1px 1px 2px rgba(255,255,255,0.3)"
    }
  }), /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      bottom: 4,
      left: 4,
      width: 12,
      height: 12,
      borderRadius: "50%",
      border: "1px solid rgba(0,0,0,0.4)",
      background: "radial-gradient(circle at 30% 30%, rgba(255,255,255,0.7), rgba(150,150,150,0.4) 60%, rgba(60,60,60,0.6) 100%)",
      boxShadow: "inset 1px 1px 2px rgba(255,255,255,0.3)"
    }
  }), /*#__PURE__*/React.createElement("div", {
    style: {
      position: "absolute",
      bottom: 4,
      right: 4,
      width: 12,
      height: 12,
      borderRadius: "50%",
      border: "1px solid rgba(0,0,0,0.4)",
      background: "radial-gradient(circle at 30% 30%, rgba(255,255,255,0.7), rgba(150,150,150,0.4) 60%, rgba(60,60,60,0.6) 100%)",
      boxShadow: "inset 1px 1px 2px rgba(255,255,255,0.3)"
    }
  }), /*#__PURE__*/React.createElement("div", {
    style: {
      display: "none"
    }
  }, /*#__PURE__*/React.createElement("div", {
      style: {
        flex: 1,
        textAlign: "center",
        fontWeight: 600,
        letterSpacing: "0.1em",
        color: "var(--ui-accent)",
        fontSize: 22,
        textShadow: "0 1px 1px rgba(0,0,0,0.4)"
      }
    }, ""), /*#__PURE__*/React.createElement("div", {
      style: { display: "flex", gap: 6, marginLeft: 12 }
    }, /*#__PURE__*/React.createElement("div", {
      style: {
        width: 12,
        height: 12,
        borderRadius: "50%",
        background: started && !paused && !(gameRef.current && gameRef.current.gameOver) ? "#00ff88" : "var(--ui-border)",
        boxShadow: started && !paused && !(gameRef.current && gameRef.current.gameOver) ? "0 0 6px #00ff88" : "none",
        border: "1px solid " + (started && !paused && !(gameRef.current && gameRef.current.gameOver) ? "#00ff88" : "var(--ui-border)")
      }
    }), /*#__PURE__*/React.createElement("div", {
      style: {
        width: 12,
        height: 12,
        borderRadius: "50%",
        background: started && paused && !(gameRef.current && gameRef.current.gameOver) ? "#ffd800" : "var(--ui-border)",
        boxShadow: started && paused && !(gameRef.current && gameRef.current.gameOver) ? "0 0 6px #ffd800" : "none",
        border: "1px solid " + (started && paused && !(gameRef.current && gameRef.current.gameOver) ? "#ffd800" : "var(--ui-border)")
      }
    }), /*#__PURE__*/React.createElement("div", {
      style: {
        width: 12,
        height: 12,
        borderRadius: "50%",
        background: !started || (gameRef.current && gameRef.current.gameOver) ? "#ff5555" : "var(--ui-border)",
        boxShadow: !started || (gameRef.current && gameRef.current.gameOver) ? "0 0 6px #ff5555" : "none",
        border: "1px solid " + (!started || (gameRef.current && gameRef.current.gameOver) ? "#ff5555" : "var(--ui-border)")
      }
    }))), /*#__PURE__*/React.createElement("div", {
    style: {
      display: "flex",
      alignItems: "center",
      justifyContent: "space-between",
      width: "100%",
      gap: 10,
      flexWrap: "wrap",
      flex: 1
    }
  }, /*#__PURE__*/React.createElement(ArcadeKnob, {
    angle: knobL
  }), /*#__PURE__*/React.createElement("div", {
    className: "flex flex-col items-center gap-2",
    style: {
      minWidth: 240,
      flex: 1
    }
  }, /*#__PURE__*/React.createElement("div", {
    className: "flex items-center gap-2"
  }, /*#__PURE__*/React.createElement(Btn, {
    variant: paused || arcadeActive.pause ? "default" : "secondary",
    size: "md",
    onClick: onTogglePause,
    style: {
      minWidth: 92
    }
  }, "PAUZA"), /*#__PURE__*/React.createElement(Btn, {
    variant: started && !paused || arcadeActive.start ? "default" : "outline",
    size: "md",
    onClick: onStart,
    style: {
      minWidth: 92
    }
  }, "START"), /*#__PURE__*/React.createElement(Btn, {
    variant: arcadeActive.serve ? "default" : "outline",
    size: "md",
    onClick: onServe,
    style: {
      minWidth: 92
    }
  }, "SERW"))), /*#__PURE__*/React.createElement(ArcadeKnob, {
    angle: knobR
  }))))), /*#__PURE__*/React.createElement(Card, {
    className: "h-full"
  }, /*#__PURE__*/React.createElement(CardContent, {
    className: "p-4 space-y-4"
  }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", {
    className: "font-semibold",
    style: PANEL_TITLE_STYLE
  }, "TRYB GRY"), /*#__PURE__*/React.createElement("div", {
    className: "grid gap-2 mt-2",
    style: {
      gridTemplateColumns: "repeat(3, minmax(0, 1fr))"
    }
  }, MODELIST.map(function (mIt) {
    return /*#__PURE__*/React.createElement(Btn, {
      key: mIt.key,
      variant: mode === mIt.key ? "default" : "outline",
      size: "sm",
      onClick: function onClick() {
        var nextMode = mIt.key;
        setMode(nextMode);
        // KROK 2: na planszy startowej przełączanie trybu nie może ucinać muzyki.
        if (!settingsRef.current.started && settingsRef.current.musicEnabled) {
          ensureAudio().then(function () {
            return syncMusic(nextMode);
          });
        }
      },
      style: {
        width: "100%"
      }
    }, mIt.label);
  })), /*#__PURE__*/React.createElement("div", {
    className: "mt-2 text-sm",
    style: PANEL_MUTED_STYLE
  }, (getModeCfg(mode).blurb || []).slice(0, 3).map(function (line, idx) {
    return /*#__PURE__*/React.createElement("div", {
      key: idx
    }, line);
  }))), /*#__PURE__*/React.createElement(Divider, null), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", {
    className: "font-semibold",
    style: PANEL_TITLE_STYLE
  }, "KOLORYSTYKA"), /*#__PURE__*/React.createElement("div", {
    className: "grid gap-2 mt-2",
    style: {
      gridTemplateColumns: "repeat(3, minmax(0, 1fr))"
    }
  }, Object.values(COLOR_THEMES).map(function (t) {
    return /*#__PURE__*/React.createElement(Btn, {
      key: t.key,
      variant: colorTheme === t.key ? "default" : "outline",
      size: "sm",
      onClick: function onClick() {
        return setColorTheme(t.key);
      },
      style: {
        width: "100%"
      }
    }, t.name);
  }))), /*#__PURE__*/React.createElement(Divider, null), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", {
    className: "flex items-center justify-between mt-2"
  }, /*#__PURE__*/React.createElement(Label, null, "Muzyka ON/OFF"), /*#__PURE__*/React.createElement(Switch, {
    checked: musicEnabled,
    onCheckedChange: function onCheckedChange(v) {
      setMusicEnabled(!!v);
      ensureAudio().then(function () {
        return syncMusic();
      });
    }
  })), /*#__PURE__*/React.createElement("div", {
    className: "flex items-center justify-between mt-2",
    style: mode === "squosh" ? undefined : {
      visibility: "hidden"
    },
    "aria-hidden": mode === "squosh" ? undefined : true
  }, /*#__PURE__*/React.createElement(Label, null, "Gra dla dw\xF3ch"), /*#__PURE__*/React.createElement(Switch, {
    checked: squoshTwoPlayers,
    disabled: mode !== "squosh",
    onCheckedChange: function onCheckedChange(v) {
      if (mode !== "squosh") return;
      setSquoshTwoPlayers(!!v);
      if (!v) setAiEnabled(false);
    }
  })), /*#__PURE__*/React.createElement(Divider, null), /*#__PURE__*/React.createElement("div", {
    className: "flex items-center justify-between mt-2"
  }, /*#__PURE__*/React.createElement(Label, null, "Gra z komputerem"), /*#__PURE__*/React.createElement(Switch, {
    checked: aiEnabled,
    disabled: mode === "squosh" && !squoshTwoPlayers,
    onCheckedChange: function onCheckedChange(v) {
      return setAiEnabled(!!v);
    }
  })), /*#__PURE__*/React.createElement("div", {
    className: "mt-3"
  }, /*#__PURE__*/React.createElement(Label, null, "Poziom inteligencji komputera: ", aiLevel), /*#__PURE__*/React.createElement(Slider, {
    value: [aiLevel],
    min: 1,
    max: 10,
    step: 1,
    disabled: mode === "squosh" && !squoshTwoPlayers,
    onValueChange: function onValueChange(v) {
      return setAiLevel(v[0]);
    }
  }), /*#__PURE__*/React.createElement(Divider, null)), /*#__PURE__*/React.createElement("div", {
    className: "mt-3"
  }, /*#__PURE__*/React.createElement(Label, null, "D\u0142ugo\u015B\u0107 paletek: ", paddleScale.toFixed(2)), /*#__PURE__*/React.createElement(Slider, {
    value: [paddleScale],
    min: 0.7,
    max: 1.5,
    step: 0.05,
    onValueChange: function onValueChange(v) {
      return setPaddleScale(v[0]);
    }
  })), /*#__PURE__*/React.createElement("div", {
    className: "mt-3"
  }, /*#__PURE__*/React.createElement(Label, null, "Szybko\u015B\u0107: ", speedScale.toFixed(2)), /*#__PURE__*/React.createElement(Slider, {
    value: [speedScale],
    min: 0.6,
    max: 1.8,
    step: 0.05,
    onValueChange: function onValueChange(v) {
      return setSpeedScale(v[0]);
    }
  })), /*#__PURE__*/React.createElement("div", {
    className: "mt-3"
  }, /*#__PURE__*/React.createElement(Label, null, "Limit punkt\xF3w: ", scoreToWin), /*#__PURE__*/React.createElement(Slider, {
    value: [scoreToWin],
    min: 3,
    max: 25,
    step: 1,
    onValueChange: function onValueChange(v) {
      return setScoreToWin(v[0]);
    }
  }))))))));
}