/*
                                                              /\
                                                          ___/  \___
_______________________  >> dEMONIC pRODUCTIONZ // 2022  /___ o0 ___\__________
\_______         _____/_______________        _____________/__/\__\   /_______/
  /    /    /   ___/__\______        /________\________    /____\    /     /jp
 /    /    /   /            /  /    /   _________/   /    /     /   '     /
/_________/___________/    /  /    /    /     /     /    /_____/_________/
                     /____/__/_____    /     ______/____/
                                  \_________/


*/

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
    
   READ THE INCLUDED GPL3 LICENSE FILE FOR MORE INFORMATION
*/


uses cfg;
uses user;

// you can alter these constants to customize a bit the mod.
const
  sysop            = 'sysop'; // put sysops username here. use undescope if it
                              // contains spaces like: best_sysop
  footer           = ' |04|16DEM0N1C |07// |08LightBar Login Menu, v|151|07.|1500 |08by xqtr // 2022 ';
                              // change it to customize your bbs
  getfile          = '';      // full path for file to download from 'commands'
                              // menu. you can use a text file with BBS info
  mmbg             = 'dmlm1.ans'; // background image/ansi file
                                  // use an ansi editor and make your own. 
 
// do not alter these
 
  keyHome          = #71;      
  keyCursorUp      = #72;     
  keyPgUp          = #73;
  keyCursorLeft    = #75;      
  KeyNum5          = #76;     
  keyCursorRight   = #77;
  keyEnd           = #79;
  keyCursorDown    = #80;
  keyPgDn          = #81;
  
type
  menuitem = record
    x:byte;
    y:byte;
    on : string;
    off: string;
  end;
  
var
  menu : array[1..10] of menuitem;
  idx  : byte = 1;
  c    : char;
  done : boolean = false;
  d    : byte;
  hg   : boolean = false;
  mi   : byte = 6; // menu items
  
procedure clear;
var i : byte;
begin
  for i:=0 to mi do writexy(1,17+i,7,STRREP(' ',79));
end;

procedure center(y:byte; str:string);
begin
  gotoxy(((80-length(stripmci(str))) / 2),y);
  write(str);
end;

// custom command to display ansi files using the builtin GD command
Procedure DispANSI(A:String);
Begin
  If FileExist(A) Then MenuCMD('GD','@0@false@'+A)
    Else If FileExist(CfgMPEPath+A) Then MenuCMD('GD','@115000@false@'+CfgMPEPath+A);
End;

// you can customize the text for the menu entries. it may seem a bit hard,
// but it is more like a try and error thing.

procedure drawmainmenu;
const
  mx = 23;
var
  y : byte = 17;
begin
  menu[1].x:=mx;
  menu[1].y:=y;
  menu[1].on :='|23|00 LOGIN          //   enter the realm ';
  menu[1].off:='|16|04 L|07OGIN          |04//   |08enter the realm ';
  y:=y+1;
  
  menu[2].x:=mx;
  menu[2].y:=y;
  menu[2].on :='|23|00 INFO           //   bbs information ';
  menu[2].off:='|16|04 I|07NFO           |04//   |08bbs information ';
  y:=y+1;
  menu[3].x:=mx;
  menu[3].y:=y;
  menu[3].on :='|23|00 APPLY          // create an account ';
  menu[3].off:='|16|04 A|07PPLY          |04// |08create an account ';
  y:=y+1;
  menu[4].x:=mx;
  menu[4].y:=y;
  menu[4].on :='|23|00 MSG. SYSOP     //    better be good ';
  menu[4].off:='|16|04 M|07SG. SYSOP     |04//    |08better be good ';
  y:=y+1;
  menu[5].x:=mx;
  menu[5].y:=y;
  menu[5].on :='|23|00 COMMANDS       //    check this out ';
  menu[5].off:='|16|04 C|07OMMANDS       |04//    |08check this out ';
  y:=y+1;
  menu[6].x:=mx;
  menu[6].y:=y;
  menu[6].on :='|20|00 HANG UP        //            begone ';
  menu[6].off:='|16|04 H|07ANG UP        |04//            |08begone ';
  
  mi:=6;
  for d:=1 to mi do writexypipe(menu[d].x,menu[d].y,8,40,menu[d].off);
  center(24,footer);
  writexypipe(menu[idx].x,menu[idx].y,8,40,menu[idx].on);
end;

// same here...

procedure drawcmdmenu;
const
  mx = 23;
var
  y : byte = 17;
begin
  menu[1].x:=mx;
  menu[1].y:=y;
  menu[1].on :='|23|00 WHOs ONLINE    //       online users ';
  menu[1].off:='|16|04 W|07HOs ONLINE    |04//       |08online users ';
  y:=y+1;
  
  menu[2].x:=mx;
  menu[2].y:=y;
  menu[2].on :='|23|00 LAST CALLERS   //    last 10 callers ';
  menu[2].off:='|16|04 L|07AST CALLERS   |04//    |08last 10 callers ';
  y:=y+1;
  menu[3].x:=mx;
  menu[3].y:=y;
  menu[3].on :='|23|00 CALL HISTORY   //       call history ';
  menu[3].off:='|16|04 C|07ALL HISTORY   |04//       |08call history ';
  y:=y+1;
  menu[4].x:=mx;
  menu[4].y:=y;
  menu[4].on :='|23|00 GET FILE       // download info file ';
  menu[4].off:='|16|04 G|07ET FILE       |04// |08download info file ';
  y:=y+1;
  menu[5].x:=mx;
  menu[5].y:=y;
  menu[5].on :='|23|00 DOOR           //       play a game? ';
  menu[5].off:='|16|04 D|07OOR           |04//       |08play a game? ';
  y:=y+1;
  menu[6].x:=mx;
  menu[6].y:=y;
  menu[6].on :='|20|00 BACK           //  back to main menu ';
  menu[6].off:='|16|04 B|07ACK           |04//  |08back to main menu ';
  
  mi:=6;
  for d:=1 to mi do writexypipe(menu[d].x,menu[d].y,8,40,menu[d].off);
  center(24,footer);
  writexypipe(menu[idx].x,menu[idx].y,8,40,menu[idx].on);
end;

// this is the function to display some BBS info. with a little tweaking you
// could make something better.

procedure info;
var
  y:byte = 17
  x:byte = 31;
begin
  clear;
  writexypipe(x,y,8,30,'SYSOP : |15'+strmci('|SN'));y:=y+1;
  writexypipe(x,y,8,30,'DATE  : |15'+strmci('|DA'));y:=y+1;
  writexypipe(x,y,8,30,'TIME  : |15'+strmci('|TI'));y:=y+1;
  writexypipe(x,y,8,30,'IP    : |15'+strmci('|UY'));y:=y+1;
  writexypipe(x,y,8,30,'HOST  : |15'+strmci('|UX'));y:=y+1;
  
  y:=y+1;
  center(y,'|16|07Press key|08...');
  readkey;
  y:=10;
  clear;
  drawmainmenu;
end;

procedure hangupb;
begin
  hg:=true;
  done:=true;
end;

procedure apply;
begin
  clear;
  textcolor(8);
  gotoxy(20,17);if INPUTNY('Register for new account?') then begin
    UserLoginNew:=true;
    done:=true;
  end;
  clear;
  drawmainmenu;
end;

procedure msgsys;
begin
  textcolor(7);clrscr;
  write('|#B#1#8#Notice#If you need a new password, write down your username and email.#')
  menucmd('MW','/to:'+sysop+' /subj:feedback');
  textcolor(7);clrscr;
  dispansi(cfgtextpath+mmbg);
  clear;
  drawmainmenu;
end;  

procedure login;
var
  user:string;
  pass:string;
begin
  clear;
  done:=true;
end;

procedure online;
begin menucmd('NW','');clrscr;dispansi(cfgtextpath+mmbg);end;

procedure lastcallers;
begin menucmd('GL','');clrscr;dispansi(cfgtextpath+mmbg);end;

procedure callhistory;
begin menucmd('G1','');clrscr;dispansi(cfgtextpath+mmbg);end;

procedure getfile;
begin menucmd('F3',getfile);clrscr;dispansi(cfgtextpath+mmbg);end;

procedure executescript(fn:string);
begin menucmd('GX',fn);clrscr;dispansi(cfgtextpath+mmbg);end;

procedure commands;
var
  cdone:boolean = false;
begin
  textcolor(7);clrscr;
  dispansi(cfgtextpath+mmbg);
  clear;
  drawcmdmenu;
  repeat
      c:=readkey;
      if isarrow then begin
        case c of 
          keyhome,keypgup: idx:=1;
          keyend,keypgdn : idx:=mi;
          keycursordown : begin
                          idx:=idx+1;
                          if idx>mi then idx:=1;
                        end;
          keycursorup : begin
                          if idx=1 then idx:=mi else idx:=idx-1;
                        end;
        end;
      end else begin
        case c of
          #27 : begin idx:=1;cdone:=true;end;
          #13 : case idx of
                  1: online;
                  2: lastcallers;
                  3: callhistory;
                  4: getfile;
                  5: executescript('blackjack');
                  6: begin idx:=1;cdone:=true;end;
                end;
          'w','W': online;
          'l','L': lastcallers;
          'c','C': callhistory;
          'g','G': getfile;
          'd','D': executescript('blackjack');
          'b','B': begin idx:=1;cdone:=true;end;
        end;
      end;
      drawcmdmenu;
  until cdone;
  clear;
end;

begin
  textcolor(7);clrscr;
  dispansi(cfgtextpath+mmbg);
  clear;

  drawmainmenu;
  repeat
      c:=readkey;
      if isarrow then begin
        case c of 
          keyhome,keypgup: idx:=1;
          keyend,keypgdn : idx:=mi;
          keycursordown : begin
                          idx:=idx+1;
                          if idx>mi then idx:=1;
                        end;
          keycursorup : begin
                          if idx=1 then idx:=mi else idx:=idx-1;
                        end;
        end;
      end else begin
        case c of
          #27 : begin hg:=true;done:=true;end;
          #13 : case idx of
                  6: hangupb;
                  5: commands;
                  4: msgsys;
                  1: login;
                  2: info;
                  3: apply;
                end;
          'i','I': info;
          'h','H': hangupb;
          'a','A': apply;
          'l','L': login;
          'm','M': msgsys;
          'c','C': begin
                     idx:=1;
                     commands;
                     textcolor(7);
                     clrscr;write('|CL');
                     dispansi(cfgtextpath+mmbg);
                     drawmainmenu;
                   end;
        end;
      end;
      drawmainmenu;
  until done;
  if hg then menucmd('GH','');
  delay(500);
  clrscr;
end;
