/****************************************************************************
* hiNews v.0.0.1d (drunken)
* A half-intelligent (hi) news display door for DayDream/Linux
*
* Coded by rezine of drunken.
*
* Learn from it, laugh 'bout it but damn fuck don't rip my credz off it!
*
* Don't email or ask me about my damn coding slang,  for any other
* comments, deathwishes or else put mail to <drunken@criminology.de>
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <dirent.h>
#include "mydd.h"

void die(void);
int readinconfig(void);
int get_news(void);
int show_news(void);
char *stripcrlf(char *string);

struct dif *d;
char homedir[256], newsdir[256];
int opmode;
int last_login, last_file;
struct stat filestat;
char buf[512], buf2[80];
char newsfile[160][256];
char newsdate[160][80];
int news = 0;
int date_x, date_y, cur_x, cur_y, pages_x, pages_y, text_x, text_y, maxlen, maxline;

int main(int argc, char *argv[])
{
    if (argc == 1)
    {
        fprintf(stderr, "Usage: %s <socket>\n", argv[0]);
        return EXIT_FAILURE;
    }

    d = dd_initdoor(argv[1]);
    if (d == NULL)
    {
        fprintf(stderr, "Couldn't find socket!\n");
        return EXIT_FAILURE;
    }
    atexit(die);

    if (getenv("DAYDREAM") == NULL)
    {
        fprintf(stderr, "Environment variable DAYDREAM not set.\n");
        return EXIT_FAILURE;
    }
    strncpy(homedir, getenv("DAYDREAM"), sizeof(homedir) - 1);

    if (readinconfig() != 0)
        return EXIT_FAILURE;

    get_news();

    if (news > 0)
        show_news();

    return EXIT_SUCCESS;
}

void die(void)
{
    dd_close(d);
}

int readinconfig(void)
{
    FILE *f;
    snprintf(buf, sizeof(buf), "%s/configs/hinews.cfg", homedir);
    f = fopen(buf, "r");
    if (!f)
    {
        dd_sendstring(d, "The configfile is missing. Please contact sysop.\nhiNews 0.1d by rezine of dps.\n");
        return 1;
    }

    if (fgets(buf, sizeof(buf), f) == NULL)
        goto error;

    opmode = atoi(buf);
    last_login = dd_getintval(d, USER_LASTCALL);

    if (fgets(buf, sizeof(buf), f) == NULL)
        goto error;

    strncpy(newsdir, stripcrlf(buf), sizeof(newsdir) - 1);

    #define READ_CONFIG_FIELD(field) \
        if (fgets(buf, sizeof(buf), f) == NULL) goto error; \
        field = atoi(buf)

    READ_CONFIG_FIELD(date_x);
    READ_CONFIG_FIELD(date_y);
    READ_CONFIG_FIELD(cur_x);
    READ_CONFIG_FIELD(cur_y);
    READ_CONFIG_FIELD(pages_x);
    READ_CONFIG_FIELD(pages_y);
    READ_CONFIG_FIELD(text_x);
    READ_CONFIG_FIELD(text_y);
    READ_CONFIG_FIELD(maxlen);
    READ_CONFIG_FIELD(maxline);

    fclose(f);
    return 0;

error:
    fclose(f);
    dd_sendstring(d, "Error reading config file.\n");
    return 1;
}

int get_news(void)
{
    DIR *dp;
    struct dirent *ep;

    dd_sendstring(d, "Checking for news... ");
    dp = opendir(newsdir);
    if (dp == NULL)
    {
        dd_sendstring(d, "Failed to open news directory.\n");
        return 1;
    }

    while ((ep = readdir(dp)) != NULL)
    {
        snprintf(buf, sizeof(buf), "%s/%s", newsdir, ep->d_name);
        if (strcmp(ep->d_name, ".") && strcmp(ep->d_name, ".."))
        {
            if (stat(buf, &filestat) == -1)
                continue;

            if (last_login < filestat.st_mtime)
            {
                news++;
                strncpy(newsfile[news], ep->d_name, sizeof(newsfile[news]) - 1);
                strncpy(newsdate[news], ctime(&filestat.st_mtime), sizeof(newsdate[news]) - 1);
            }
        }
    }
    closedir(dp);

    if (news >= 1)
        dd_sendstring(d, "found some!\n");
    else
        dd_sendstring(d, "none found!\n");

    return 0;
}

char *stripcrlf(char *string)
{
    char *p = strrchr(string, '\n');
    if (p) *p = '\0';
    return string;
}

int clear_news(void)
{
    memset(buf, ' ', maxlen);
    buf[maxlen] = '\0';

    for (int i = text_y; i < text_y + maxline; i++)
    {
        dd_ansipos(d, text_x, i);
        dd_sendstring(d, buf);
    }
    return 0;
}

int show_news(void)
{
    int i = 0, key = 0, cur = 1, changed = 1;
    FILE *f;

    dd_typefile(d, "hinews", TYPE_MAKE | TYPE_WARN);

    while (key != 27) // ESC key
    {
        if (changed)
        {
            snprintf(buf, sizeof(buf), "%s/%s", newsdir, newsfile[cur]);
            f = fopen(buf, "r");
            if (!f)
            {
                dd_sendstring(d, "Oooh... some *strange* error occured...\n");
                return 1;
            }

            dd_ansipos(d, date_x, date_y);
            dd_sendstring(d, newsdate[cur]);
            dd_ansipos(d, cur_x, cur_y);
            snprintf(buf, sizeof(buf), "%.2i", cur);
            dd_sendstring(d, buf);
            dd_ansipos(d, pages_x, pages_y);
            snprintf(buf, sizeof(buf), "%.2i", news);
            dd_sendstring(d, buf);

            i = 0;
            while (i < maxline && fgets(buf, sizeof(buf), f) != NULL)
            {
                dd_ansipos(d, text_x, text_y + i);
                dd_sendstring(d, buf);
                i++;
            }
            fclose(f);
            changed = 0;
        }

        key = dd_hotkey(d, HOT_CURSOR);
        switch (key)
        {
            case 252: // Next page
            case 13:  // Enter
                if (cur < news)
                {
                    clear_news();
                    cur++;
                    changed = 1;
                }
                else
                {
                    key = 27; // ESC
                }
                break;
            case 253: // Previous page
                if (cur > 1)
                {
                    clear_news();
                    cur--;
                    changed = 1;
                }
                break;
            case 27: // ESC
                break;
            default:
                changed = 0;
                break;
        }
    }
    dd_ansipos(d, 1, 24);
    _center(d, " ==> hiNews 0.1d by rezine^drunken (drunken@criminology.de) <==\n");
    return 0;
}
