/*
**	last 1oo ULs grouped / flower^project-deedee.
**
**	feel free to mod sources for your own special use, but dont
**	distribute your own version without asking me first!
**
**	take care, Flower <davidsen@a.sol.dk>
**
*/

#include <stdio.h>
#include <iostream>
#include <dd.h>
#include <cstring>
#include "newmacro.h"

// hydras (in)famous fgetsnolfs modded a bit.
char *fgetsnolfs(char *buf, int n, FILE *fh) {
        char *in;
        char *tmp;

        in=fgets(buf,n,fh);
        if (!in) return 0;
        tmp=buf;
        while (*tmp) {
                if ((*tmp==10)||(*tmp==13)) {
                        *tmp=0;
                        break;
                }
                tmp++;
        }
        return in;
};

class f_list {
	DD_UploadLog *log[MAXUPLOADS];
	const char *diz[MAXUPLOADS];
	userbase *ulby[MAXUPLOADS];
	int COUNT;
	int longdirs;
public:
	// constructor, puts last MAXUPLOADS entries of uploadlog.dat in *log[].
	f_list(char *ddpath,int longdirs) {
		char buf[300];
		FILE *lf;
		COUNT=0;
		DD_UploadLog *tmp=new DD_UploadLog;

		// init the ptr arrays.
		bzero(log,MAXUPLOADS);
		const char *nodizmsg="No diz available in selected file-dirs";
		for (int z=0;z<MAXUPLOADS;diz[z++]=nodizmsg);
		this->longdirs=longdirs;

		// load last MAXUPLOADS entries from uploadlog.
		sprintf(buf,"%s/logfiles/uploadlog.dat",ddpath);
		if (lf=fopen(buf,"r")) {
			fseek(lf,0,SEEK_END);
			if (ftell(lf)>(MAXUPLOADS*sizeof(struct DD_UploadLog)))
				fseek(lf,-(MAXUPLOADS*sizeof(struct DD_UploadLog)),SEEK_END);
			else
				fseek(lf,0,SEEK_SET);

			while (fread(tmp,sizeof(struct DD_UploadLog),1,lf)) {
				log[COUNT++]=tmp;
				tmp=new DD_UploadLog;
			}
			fclose(lf);
		}
		log[COUNT]=0;
		delete tmp;
	}

	// loads the uploadernames.
	int loadUL(char *ddpath) {
		FILE *uf;
		char buf[300];

		sprintf(buf,"%s/data/userbase.dat",ddpath);
		if (uf=fopen(buf,"r")) {
			for (int i=0;i<COUNT;i++) {
				if (log[i]) {
					fseek(uf,log[i]->UL_SLOT*sizeof(struct userbase),SEEK_SET);
					ulby[i]=new userbase;
					fread(ulby[i],sizeof(struct userbase),1,uf);
				}
			}
			fclose(uf);
		}
		return 0;
	}

	// groups up the files in the list.
	int groupUp() {
		for (int i=0;i<COUNT;i++) {
			if (log[i]) {
				for (int a=0;a<COUNT;a++) {
					if ((a!=i)&&(!strcmp(diz[i],diz[a]))&&(diz[i]!=diz[a])) {
						delete log[a];
						log[a]=0;
					}
				}
			} // else, grouped already.
		}
		return 0;
	}

	// checks if we got a logentry for a dizline, and update if true.
	int updateList(char *b) {
		int i=0;
		while (log[i]) {
			if (!strncasecmp(b,log[i]->UL_FILENAME,strlen(log[i]->UL_FILENAME))) {
				diz[i]=new char[50];
				strncpy(const_cast<char*>(diz[i]), b+35, 50);
				const_cast<char*>(diz[i])[45]=0;
				break;
			}
			i++;
		}
		return 0;
	}

	// loads dizs for log entries.
	int loadDiz(char *fn) {
		FILE *df;
		char buf[300],buf2[300];

		if (df=fopen(fn,"r")) {
			while (fgetsnolfs((char*)&buf,255,df)) {
				if (buf[0]!=' ') {
					if (longdirs) {
						fgetsnolfs((char*)&buf2,255,df);
						strcpy((char*)&buf+35,(char*)&buf2+35);
					}
					updateList(buf);
				}
			}
			fclose(df);
		}
		return 0;
	}
	int getCount() { return COUNT; }
	DD_UploadLog *getLog(int n) { return log[n]; }
	const char *getDiz(int n) { return diz[n]; }
	userbase *getUL(int n) { return ulby[n]; }
};

char *getuldir(int confnum) {
        FILE *cf;
        char *buf=(char*)malloc(1024);
        DayDream_MsgBase useless;
	DayDream_Conference confcfg;

        sprintf(buf,"%s/data/conferences.dat",getenv("DAYDREAM"));
        cf=fopen(buf,"r");
        while (1) {
                fread(&confcfg,sizeof(struct DayDream_Conference),1,cf);
                if (confcfg.CONF_NUMBER==confnum)
                        break;
                else
                        for (int a=0;a<confcfg.CONF_MSGBASES;a++)
                                fread(&useless,sizeof(struct DayDream_MsgBase),1,cf);
        }
        fclose(cf);
	sprintf(buf,"%s/data/directory.%03d",confcfg.CONF_PATH,confcfg.CONF_UPLOADAREA);
	return buf;
}

int main(int argc,char *argv[]) {
	FILE *cf;
	char buf[1000], *output[1000];
	int longdirs;

	if (!getenv("DAYDREAM")) {
		std::cout << "!! You need to set you DAYDREAM environment\n";
		exit(0);
	}
	if (argc<3) {
		std::cout << "!! Syntax: " << argv[0] << " YES|NO [directory list]\n";
		exit(0);
	}

	if (!strcasecmp(argv[1],"yes"))
		longdirs=1;
	else
		longdirs=0;

	f_list *l=new f_list(getenv("DAYDREAM"),longdirs);
	int c=l->getCount();

	for (int argnum=1;argnum<argc;argnum++) {
		l->loadDiz(argv[argnum]);
	}

	l->groupUp();
	l->loadUL(getenv("DAYDREAM"));

	// do the header.
	fgets(buf, sizeof(buf), stdin);
	while (buf[0]!='~') {
		std::cout << buf;
		fgets(buf, sizeof(buf), stdin);
	}

	// do the middle-part.
	int cnt=0;
	fgets(buf, sizeof(buf), stdin);
	while (buf[0]!='~') {
		output[cnt]=new char[strlen(buf)+1];
		strcpy(output[cnt++],buf);
		fgets(buf, sizeof(buf), stdin);
	}
	output[cnt]=0;
	
	for (int i=0;i<c;i++) {
		DD_UploadLog *e=l->getLog(i);
		if (e) {
			char parsestr[500];
			cnt=0;
			while (output[cnt]) {
				strcpy(parsestr,output[cnt]);
				parse(parsestr,"@FN",e->UL_FILENAME);
				parse(parsestr,"@FD",l->getDiz(i));
				parse(parsestr,"@FU",l->getUL(i)->user_handle);
				std::cout << parsestr;
				cnt++;
			}
		}
	}

	// do the end-part.
	fgets(buf, sizeof(buf), stdin);
	while (buf[0]!='~') {
		std::cout << buf << "\n";
		fgets(buf, sizeof(buf), stdin);
	}
}
