#!/bin/bash

#                                                              /\
#                                                           ___/  \___
# _______________________  >> dEMONIC pRODUCTIONZ // 2023  /___ o0 ___\__________
# \_______         _____/_______________        _____________/__/\__\   /_______/
#   /    /    /   ___/__\______        /________\________    /____\    /     /jp
#  /    /    /   /            /  /    /   _________/   /    /     /   '     /
# /_________/___________/    /  /    /    /     /     /    /_____/_________/
#                      /____/__/_____    /     ______/____/
#                                   \_________/

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
   
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
   
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#  MA 02110-1301, USA.
   
#  READ THE INCLUDED GPL3 LICENSE FILE FOR MORE INFORMATION

bbsmail='adbbs@gmx.com'
subjectid="bbs"
fromuser='You'
touser='All'

email="$(yad --form \
--height="600" --width="1000" \
--button="gtk-save:0" --button="gtk-close:1" \
--title='BBS Email Post' \
--separator="~" \
--field=From:CBE \
--field=To:CBE \
--field=Subject \
--field=Text:TXT \
"$fromuser" "$touser" "" "")"

if [ $? -ne 0 ];
then
  exit
fi

ff=$(echo "$email" | cut -f 1 -d'~')
tt=$(echo "$email" | cut -f 2 -d'~')
ss=$(echo "$email" | cut -f 3 -d'~')
bb=$(echo "$email" | cut -f 4 -d'~')

if [ -z "$ff" ] || [ -z "$tt" ] || [ -z "$ss" ] || [ -z "$bb" ]
then
   echo "All fields should be filled. Try again."
   notify-send -u critical \
   -i "notification-message-IM" \
  "Error" \
  "All fields should be filled. Try again."
   exit
fi

areas="$(yad --title="Select EchoAreas to post Message..." --center --height="600" --width="1000" \
--list --checklist --multiple \
--column=Select:CHK --column="Network" --column="EchoArea" --column="Description" \
--separator="~" \
--print-column="3" \
FALSE "ZeroNet" "0N-ANARC" "anarchy/chaos/drug" \
FALSE "ZeroNet" "0N-BBS" "bbs/art scene" \
FALSE "ZeroNet" "0N-CHAT" "general chat" \
FALSE "ZeroNet" "0N-CODE" "coding/demos" \
FALSE "ZeroNet" "0N-DPRI" "INVISIBLE" \
FALSE "ZeroNet" "0N-DPUB" "Demonic Group Public" \
FALSE "ZeroNet" "0N-ENTRT" "entertainment" \
FALSE "ZeroNet" "0N-HACKN" "hacking/security" \
FALSE "ZeroNet" "0N-INFO" "zer0net info" \
FALSE "ZeroNet" "0N-NEWS" "scene/world news" \
FALSE "ZeroNet" "0N-PHRKN" "phreaking/telephony" \
FALSE "ZeroNet" "0N-SYSOP" "Sysops Only" \
FALSE "ZeroNet" "0N-WAREZ" "warez/crack scene" \
FALSE "Agora" "AGN_ADSS" "Base and Network Adsg" \
FALSE "Agora" "AGN_ARTS" "Art/Demo Scene" \
FALSE "Agora" "AGN_BBSS" "BBS Discussion" \
FALSE "Agora" "AGN_DEVS" "Soft. Development" \
FALSE "Agora" "AGN_GENS" "General Chaton" \
FALSE "Agora" "AGN_HUBS" "Hub Statstedon" \
FALSE "Agora" "AGN_NETMAIL" "AGR:Netmail" \
FALSE "Agora" "AGN_NIXS" "Unix Relate" \
FALSE "Agora" "AGN_SYSS" "Sysopselatedon" \
FALSE "Agora" "AGN_TSTS" "Testing" \
FALSE "DoreNet" "DN-ADDS" "BBS Adds" \
FALSE "DoreNet" "DN-ADMI" "Admin" \
FALSE "DoreNet" "DN-ART" "ANSI/ASCII Art" \
FALSE "DoreNet" "DN-BBS" "BBS Software" \
FALSE "DoreNet" "DN-CHAT" "General Discussion" \
FALSE "DoreNet" "DN-CODE" "Programming" \
FALSE "DoreNet" "DN-DOORS" "DOORs" \
FALSE "DoreNet" "DN-FILE" "File Announcements" \
FALSE "DoreNet" "DN-HTML" "Web Design" \
FALSE "DoreNet" "DN-INET" "BBSes And Internet" \
FALSE "DoreNet" "DN-MODD" "Software MODs" \
FALSE "DoreNet" "DN-MPL" "Mystic Progr. Lang. (MPL)" \
FALSE "DoreNet" "DN-MYSTIC" "Mystic BBS (Software)" \
FALSE "DoreNet" "DN-NIXPI" "Linux & RaspberryPi" \
FALSE "DoreNet" "DN-OS" "Operating Systems" \
FALSE "FSX" "FSX_ADS" "BBS Ads" \
FALSE "FSX" "FSX_ARTS" "ArtsARTS" \
FALSE "FSX" "FSX_BBS" "BBS Support and Develop." \
FALSE "FSX" "FSX_BOT" "BOTs And Advertisements" \
FALSE "FSX" "FSX_CRY" "Cryptography" \
FALSE "FSX" "FSX_DAT" "FsxNet DAT" \
FALSE "FSX" "FSX_DIY" "Do It Yourself (DIY)" \
FALSE "FSX" "FSX_ENG" "Enigma BBS Software" \
FALSE "FSX" "FSX_ESP" "Spanish" "General Chat" \
FALSE "FSX" "FSX_FIL" "File Announcements" \
FALSE "FSX" "FSX_FOOD" "Food and Drinks" \
FALSE "FSX" "FSX_GAMING" "GamingMING" \
FALSE "FSX" "FSX_GARDENING" "GardeningNING" \
FALSE "FSX" "FSX_GEN" "General Chat" \
FALSE "FSX" "FSX_HAM" "HAM Radio" \
FALSE "FSX" "FSX_MAG" "Magica BBS (Software)" \
FALSE "FSX" "FSX_MUSIC" "MusicUSIC" \
FALSE "FSX" "FSX_MYS" "Mystic BBS (Software)" \
FALSE "FSX" "FSX_NET" "FSX Network Troubleshooting" \
FALSE "FSX" "FSX_PKT" "Packet Radio / Read Only!" \
FALSE "FSX" "FSX_RETRO" "Retro Computing/Gaming" \
FALSE "FSX" "FSX_SPACE" "Space and Science" \
FALSE "FSX" "FSX_SPORTS" "SportsORTS" \
FALSE "FSX" "FSX_STA" "Net Statistics" \
FALSE "FSX" "FSX_TRANSPORT" "Cars, Bikes and Planes..." \
FALSE "FSX" "FSX_TST" "Test Area" \
FALSE "FSX" "FSX_VIDEO" "Movies, TV Series, Shows" \
--button="gtk-save:0" --button="gtk-close:1")"

if [ $? -ne 0 ];
then
  exit
fi

if [ -z "$areas" ] 
then
   echo "You have to select an area to post the message! Try again."
   notify-send -u critical \
   -i "notification-message-IM" \
  "Error" \
  "You have to select an area to post the message! Try again."
   exit
fi

postareas=$(for i in $areas; do
echo +$i|cut -f1 -d'~'
done)

body="=post
$postareas
$ff
$tt
$ss
$bb"
tmail=$(echo "$email" | cut -f 3 -d'~')


thunderbird -compose "subject='$subjectid',to='$bbsmail',body=$body"


