
#include <Windows.h>

#define TXGEN_BLEND_NORMAL      0x00
#define TXGEN_BLEND_MULTIPLY    0x01
#define TXGEN_BLEND_SCREEN      0x02
#define TXGEN_BLEND_OVERLAY     0x03
#define TXGEN_BLEND_DARKEN      0x04
#define TXGEN_BLEND_LIGHTEN     0x05
#define TXGEN_BLEND_DIFFERENCE  0x06
#define TXGEN_BLEND_EXCLUSION   0x07
#define TXGEN_BLEND_HUE         0x08
#define TXGEN_BLEND_SATURATION  0x09
#define TXGEN_BLEND_COLOR       0x0A
#define TXGEN_BLEND_LUMINOSITY  0x0B

#define TXGEN_BLEND_ADD 0x0C
#define TXGEN_BLEND_CUSTOM 0x0F

typedef struct _TXGEN_LAYER
  {
    int Width, Height;
    DWORD *Ptr;
   } TXGEN_LAYER;

int TxGen_Initialize( void );
void TxGen_Cleanup( void );

TXGEN_LAYER *TxGen_LayerInitialize( DWORD Width, DWORD Height );
void TxGen_LayerCleanup( TXGEN_LAYER *Layer );

void TxGen_LayerBlend( TXGEN_LAYER *Dest, TXGEN_LAYER *Src1, TXGEN_LAYER *Src2, BYTE Opacity, BYTE Mode );

void TxGen_Cells( TXGEN_LAYER *Layer, DWORD Color1, DWORD Color2, int RSeed, int CellNum, int Strength );
void TxGen_SubPlasma( TXGEN_LAYER *Layer, DWORD Color1, DWORD Color2, int RSeed, int Size );
void TxGen_EnvMap( TXGEN_LAYER *Layer, DWORD Color1, DWORD Color2, int Size );

void TxGen_DistortSine( TXGEN_LAYER *Layer, int FreqX, int OfsX, int AmplX, int FreqY, int OfsY, int AmplY );

void TxGen_BrightnessContrast( TXGEN_LAYER *Layer, char Brightness, char Contrast );

void TxGen_SetTexture( LPDIRECT3DTEXTURE8 TextureMap, TXGEN_LAYER *Layer );

DWORD TxGen_ColorBlend( DWORD Color1, DWORD Color2, DWORD Blend );
DWORD TxGen_Vec3RGBA( D3DVECTOR *pVec, FLOAT Alpha );

int TxGen_LoadTGA( LPDIRECT3DTEXTURE8 TextureMap, char *FileName );
void TxGen_SaveLayerTGA( TXGEN_LAYER *Layer, char *FileName );

void TxGen_CreateNormalMap( LPDIRECT3DTEXTURE8 NormalMap, char *FileName );
