
// --- Knot.cpp - Torus Knot Morph.
//  Copyright (c) 2000. Remage / Fresh!mindworkz.

Object Knot;

#define KNOT1 256
#define KNOT2 32

float kR1 = 12.0f, kR2 = 3.0f;
float kX0, kY0, kZ0, kDX, kDY, kDZ, kCDist, kVlight;

void Knot_Init( void )
  {
    int I, J;
    
    Knot.NumVects = KNOT1*KNOT2;
    if (( Knot.Vects = (Vect*) malloc( Knot.NumVects * sizeof( Vect ))) == NULL )
      PostQuitMessage( 0 );
    Knot.NumFaces = KNOT1*KNOT2;
    if (( Knot.Faces = (Face*) malloc( Knot.NumFaces * sizeof( Face ))) == NULL )
      PostQuitMessage( 0 );

    for ( I = 0; I < KNOT1; I++ )
      for ( J = 0; J < KNOT2; J++ )
        {
          kX0 = ( kR1 * ( 0.65f + 0.35f * Fcos( I*10*Pi / KNOT1 )) + kR2 * ( 1.0f + 0.3f * Fcos( I*10*Pi / KNOT1 )) * Fsin( J*2*Pi / KNOT2 )) * Fsin( I*4*Pi / KNOT1 );
          kY0 = ( kR1 * ( 0.65f + 0.35f * Fcos( I*10*Pi / KNOT1 )) + kR2 * ( 1.0f + 0.3f * Fcos( I*10*Pi / KNOT1 )) * Fsin( J*2*Pi / KNOT2 )) * Fcos( I*4*Pi / KNOT1 );
          kZ0 = kR1 * 0.6f * Fsin( I*10*Pi / KNOT1 ) + kR2 * ( 1.0f + 0.3f * Fsin( I*10*Pi / KNOT1 )) * Fcos( J*2*Pi / KNOT2 );

          Vertex( &(Knot.Vects[ I*KNOT2+J ]), kX0, kY0, kZ0 );
         }

    F=0;
    for ( I = 0; I < KNOT1; I++ )
      for ( J = 0; J < KNOT2; J++ )
        {
          Knot.Faces[ F ].Type = 4;
          Knot.Faces[ F ].A = I * KNOT2 + J;
          Knot.Faces[ F ].B = I * KNOT2 + (( J+1 ) & ( KNOT2-1 ));
          Knot.Faces[ F ].C = (( I+1 ) & ( KNOT1-1 ))* KNOT2 + (( J+1 ) & ( KNOT2-1 ));
          Knot.Faces[ F ].D = (( I+1 ) & ( KNOT1-1 )) * KNOT2 + J;
          Knot.Faces[ F ].pA = &Knot.Vects[ I * KNOT2 + J ];
          Knot.Faces[ F ].pB = &Knot.Vects[ I * KNOT2 + (( J+1 ) & ( KNOT2-1 )) ];
          Knot.Faces[ F ].pC = &Knot.Vects[ (( I+1 ) & ( KNOT1-1 ))* KNOT2 + (( J+1 ) & ( KNOT2-1 )) ];
          Knot.Faces[ F ].pD = &Knot.Vects[ (( I+1 ) & ( KNOT1-1 )) * KNOT2 + J ];
/*
            kDX = Knot.Faces[ F ].pA->X - Knot.Faces[ F ].pD->X;
            kDY = Knot.Faces[ F ].pA->Y - Knot.Faces[ F ].pD->Y;
            kDZ = Knot.Faces[ F ].pA->Z - Knot.Faces[ F ].pD->Z;
              kCDist = 1.0f / Fsqrt( kDX*kDX + kDY*kDY + kDZ*kDZ );
              kDX *= kCDist;
              kDY *= kCDist;
              kDZ *= kCDist;
            kVlight =  ( 0.7f + 0.3f * (( kDZ * 0.866f + kDX * 0.5f ) * Fsin( Timer * 0.02f ) + kDY * Fcos( Timer * 0.02f )));
*/
            kVlight = 0.7f + 0.2f * Fsin( J*2*Pi / KNOT2 + 0.45f );
            kVlight *= 0.00392f;
          Knot.Faces[ F ].ColR = kVlight * 65;
          Knot.Faces[ F ].ColG = kVlight * 47;
          Knot.Faces[ F++ ].ColB = kVlight * 92;
         }
   }

void Knot_Draw( float Timer, float R1, float R2 )
  {
    int I, J;

    Camp.X = 4.3f * Fsin( Timer*0.00032f );
    Camp.Y = 0.2f + 4.3f * Fsin( Timer*0.00029f );
    Camp.Z = ( Timer - 384.0f ) * 0.02f;

    F = 0;
    for ( I = 0; I < KNOT1; I++ )
      for ( J = 0; J < KNOT2; J++ )
        {
//          Shd = 1.0f - Fabs( i - 15.0f ) * 0.0667f;
            kDX = Knot.Faces[ F ].pA->X - Camp.X;
            kDY = Knot.Faces[ F ].pA->Y - Camp.Y;
            kDZ = Knot.Faces[ F ].pA->Z - Camp.Z;
            kCDist = Fsqrt( kDX*kDX + kDY*kDY + kDZ*kDZ ) * 0.04f;
            if ( kCDist > 1.0f ) kCDist = 1.0f;
//          Shd *= 1.0f - CDist;
//          if ( Shd > 0.8f ) Shd = 0.8f;
          Knot.Faces[ F++ ].Shade = ( 1.0f - kCDist )* 0.5f;
         }

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    gluPerspective( 90.0f, 640.0f / 360.0f, 0.01f, 10.0f ); 
    glScalef( 0.2f, 0.2f, 0.2f );

    gluLookAt( Camp.X, Camp.Y, Camp.Z, 1.0f*Fsin( Timer*0.005f ), 1.0f*Fcos( Timer*0.0037f ), 2.0f*Fsin( Timer*0.0031f ), 0.0f, Fsin( Timer*0.0003f), Fcos( Timer*0.0003f ));
    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();

    DrawObject( &Knot, 0.0f, 0.0f, 0.0f );
   }
