;   


           ORG PgnAdr      ;   

SetUpOVRL    ld (.spp),sp

             ld ix,WSetUp
             ld a,%1111
.n1          ld ix,WSetUp
             ld (ix+6),a
             ld sp,0
.spp    EQU $-2

             ld a,(ExtMem_)
             cp WSetUp.Opdrv
            jr c,2F
             cp #FF
            jr nz,1F           ;   
             ld hl,WSetUp.ram255
             ld (WSetUp.aRAM),hl
            jr 3F
1            xor a
             ld (ExtMem_),a
2            ld hl,WsRAM.txt+1
             ld c,a
             add a,a
             add a,c
             ld c,a
             ld b,0
             add hl,bc
             ld a,(hl)
             ld (WSetUp.aRAM),a
             inc hl
             ld a,(hl)
             ld (WSetUp.aRAM+1),a

3            call ReSetUp

             ld a,(v_rgbdef)
             ld de,WSetUp.rgbdefault
             call PDEC   ; Get_NumC0_
             ld a,(v_rgbdef+1)
             ld de,WSetUp.borderdef
             call PDEC   ; Get_NumC0_

             ld de,WSetUp.keyString
             push ix
             ld ix,RUS_TAB+#40
             ld a,(ix+#11)  ; q
             ld (de),a
             inc de
             ld a,(ix+#17)  ; w
             ld (de),a
             inc de
             ld a,(ix+#05)  ; e
             ld (de),a
             inc de
             ld a,(ix+#12)  ; r
             ld (de),a
             inc de
             ld a,(ix+#14)  ; t
             ld (de),a
             inc de
             ld a,(ix+#19)  ; y
             ld (de),a
             pop ix
             ld hl,WSetUp.StrKey_Default
             ld a,(v_keyboard)
             or a
            jr z,1F
             ld hl,v_keybfile
1            ld bc,8
             ld de,WSetUp.StrRusKeys
             ldir

             call .kmp_btnm          ;    

             call Win_
             cp #FF
            jp z,setEXIT
             ld bc,.tab
             ld e,a
             call TAB_JP
.n2          call IniSetUp
             ld a,%1101
            jp .n1


.kmp_btnm    call guiRAM
             ld b,"0"
             ld a,(KJOY)
             or a
            jr z,1F
             ld a,(joy_bsmsk)
             ld b,a
             xor a
             ld c,a
             rl b
             adc a,c
             rl b
             adc a,c
             rl b
             adc a,c
             add a,"0"
             ld b,a
1            ld c,"0"
             ld a,(v_joy_buts)
             or a
            jr z,1F
             ld c,"3"
1            ld hl,WSetUp.NJoiBut
             ld (hl),b
             inc hl
             inc hl
             ld (hl),c
            ret




.tab         DW  .sRAM      ; 0   RAM:
             DW  .DefRGB    ; 1
             DW  .Ret       ; 2   Mouse
             DW  .Ret       ; 3   2rd mouse button to Fire-2
             DW  .Ret       ; 4   3rd mouse button
             DW  .Ret       ; 5   Scroller
             DW  .Ret       ; 6   Swap buttons
             DW  .Ret       ; 7   Slow mouse
             DW  .Ret       ; 8   kempston joystick
             DW  Joy_BUTS   ; 9   joistick buttons
             DW  S_Curs     ; 10  Cursor
             DW  KeybLa     ; 11  keyboard locals
             DW  Sloupe     ; 12  Loupe ___
             DW  .Ret       ; 13  Loupe x8
             DW  .Ret       ; 14  Old grig x4
             DW  .Ret       ; 15  main menu
             DW  .Ret       ; 16  slots on bge disk
             DW  .TrbDrvs_  ; 17  Turbo drives
             DW  SvConfig   ; 19  Save

.TrbDrvs_
             ld ix,WSetUp.WturboDrives
             ld (ix+6),%1110
             call POPUPdr
             call Win_
            jp CLOSE




.DefRGB      ld a,(REALRGB)
             ld c,a
             ld a,(MASKRGB)
             ld b,a
             ld a,(RGBdefault)
             ld (REALRGB),a
             xor a
             ld (MASKRGB),a
             push bc
             call PRGB2
             ld a,(REALRGB)
             ld (v_rgbdef),a
             ld a,(BORDER)
             ld (v_rgbdef+1),a
             pop bc
             ld a,c
             ld (REALRGB),a
             ld a,b
             ld (MASKRGB),a
            ret

.sRAM        ld ix,WsRAM
             call POPUP
             ld hl,CLOSENK_
             push hl
             ld (ix+6),%1110
.sW          call Win_
             cp #FF
            ret z
             cp WSetUp.Opdrv
            jr z, 1F            ;   
            ret nc
.extRet      ld (v_ext),a
.Ret        ret
1            push ix
             ld hl,.sortDrv
             call FilerE
            jr c,1F
             ld a,SearchSrtF11
             call GUI
1            pop ix
            jr nc,1F
             ld (ix+6),%1100
            jr .sW
1             ld hl,(BYTES_LEN)
              ld a,h
              or a
             jr nz,.sW
              ld a,l
              cp 65
             jr nc,.sW
              ld a,(SEC_LEN)
              cp 2
             jr nc,.sW

              ld hl,FILE_NAME
              ld de,v_ramDRVname
              ld bc,8
              ldir
              ld a,#FF
             jr .extRet


.sortDrv   DB %0001,"ram",#00
           DB %1011,2,254,#FF







WSetUp      DB 4,0,18,24,7,6*8,%00001111
; Bit 0 -   /
; Bit 1 - ""  /
; Bit 2 -     /
; Bit 3 -   -     (CANCEL)
           DB 0
           DW .txt             ; -
           DW .sel             ; - ()
           DW 2                ;   ; - ()
           DW .flags           ; -
           DW #FFFF


.txt    MSG_SETUP_Head : DB 13     ; 
        DB "RAM:                     "
        DB #17,3,#0A                   ; RAM: -
.aRAM   DW .ram0
        DB "RGB: "
.rgbdefault DB "007  Border: "
.borderdef  DB "000",13
        MSG_SETUP_Mouse : DB 13," "    ; 
        MSG_SETUP_2btFr2 : DB 13," "   ; 2-   FIRE-2
        MSG_SETUP_3bt : DB 13," "      ; 3- 
        MSG_SETUP_Scroll : DB 13," "   ; 
        MSG_SETUP_SMB : DB 13," "      ;  
        MSG_SETUP_Slow_M : DB 13       ;  
        MSG_SETUP_Joi : DB 13," "      ; Kempstone 
        MSG_SETUP_JoiBut : DB #17,13
.NJoiBut        DB "1/4",13
        MSG_SETUP_Cursor : DB 13   ; _
        MSG_SETUP_Keyboard : DB " "
.keyString  DB "-"       ; 6 bytes from keys    WSetUp.keyString
.StrRusKeys DB "Standart",13   ; 8 bytes
        MSG_SETUP_Loup : DB 13," "     ; _
        MSG_SETUP_Loup8 : DB 13," "    ;  x8
        MSG_SETUP_LpGRD4 :DB 13    ;   x4
        MSG_SETUP_HideMenu : DB 13
        MSG_SETUP_SltsInDsk : DB 13
        MSG_SETUP_Turbo : DB #17,12   ;   -
.tDISKS_  DB "ABCD",13
        DB 15,13                       ; -----------------
        MSG_DISK_Save : DB 13      ; 
        DB 0

.StrKey_Default   DB "default ",0

.ram0        DB  "128 K",0                    ; 0
.ram1        DB  "-AUTO-",0                   ; 1
.ram2        DB  "KAY 256 K",0                ; 2
.ram3        DB  "Scorpion 256 K",0           ; 3
.ram4        DB  "KAY-1024 K",0               ; 4
.ram5        DB  "Scorpion ZS-1024 K",0       ; 5
.ram6        DB  "PROFI 256-1024 K",0         ; 6
.ram7        DB  "Pentagon 512 K",0           ; 7
.ram8        DB  "Pentagon-1024SL",0          ; 8
.ram9        DB  "ATM TURBO 256-512 K",0      ; 9
.ram10       DB  "ATM TURBO 2+ 512 K",0       ; 10  rev 6.40
.ram11       DB  "ATM TURBO 2+ 1024 K",0      ; 11 rev 7.10

.Opdrv EQU 12
.ram255      DB  "Driver: "                   ; 11  
.ramDRVname  DB  "RAMdrv  ",0                 ;   8    ( ram)


.sel       DB 1,3,16,128+18,%11
           DB 1,22,16,1,%11
          DB #FF

    ; x, y,  ,  (#00/#FF)
.flags
            DB 16,5,2,#FF         ; kempston mouse
.fkmouse  EQU $-1
             DW .rflgflgsMs
            DB 16,6,3,0
.f2btnF2  EQU $-1                 ; 2rd mouse button -> Fire2
             DW .rflgflgsf2
            DB 16,7,4,0
.f3btn    EQU $-1                 ; 3rd mouse button
             DW .rflgflgsf3
            DB 16,8,5,0
.fscrlr   EQU $-1                 ; scroller
             DW .rflgflgsWh
            DB 16,9,6,0
.fswpBTN  EQU $-1                 ; swap buttons
             DW .rflgs
            DB 16,10,7,0
.fslowMs  EQU $-1                 ; slow mouse
             DW .rflgsSLm
            DB 16,11,8,#FF
.fkjoist  EQU $-1                 ; kempston joistick
             DW .rflgflgsJoi
            DB 16,16,13,0
.floupX8 EQU $-1                  ; loupe x8
             DW .rflgs
            DB 16,17,14,0
.flOldx4 EQU $-1                  ; old grid 4x
             DW .rflgs
            DB 16,18,15,0
.hidemenu  EQU $-1                ; hide main menu
             DW .rflgs
            DB 16,19,16,0
.slotindisk EQU $-1               ; Use slots on bge disk
             DW .rflgSlots


            DB #FF

.rflgflgsJoi ld a,(.fkjoist)
             ld (v_joy),a
             or a
             call nz,ch_kemps.joi
             ld a,STOP_ARW
             call GUI_
            jp SetUpOVRL.n2
.rflgflgsWh  ld a,(.fscrlr)
             ld (v_mscroller),a
             or a
             call nz,ch_kemps.msWhl
            jr .rflgs

.rflgflgsf2  ld a,(.f2btnF2)
             ld (v_2butFR2),a
            jr .rflgs
.rflgflgsf3  ld a,(.f3btn)
             ld (v_3but),a
             or a
             call nz,ch_kemps.ms3btn
            jr .rflgs
.rflgflgsMs  ld a,(.fkmouse)
             ld (v_mouse),a
             or a
             call nz,ch_kemps.mouse
.rflgs
             ld a,(.hidemenu)
             ld (v_hidemenu),a
             ld a,(.fswpBTN)
             ld (v_rever),a
             ld a,(.floupX8)
             ld (v_mgnX8),a
             ld a,(.flOldx4)
             ld (v_mgnG4),a
             call IniSetUp
            ret
.rflgsSLm    ld a,(.fslowMs)
             ld (v_mslow),a
             call guiRAM
            jp MOUSDR.speed ;   

.rflgSlots    ld a,(.slotindisk)
              ld (v_slt_dsk),a
              ld c,a
              or a
             jr nz,3F
              ld a,(SlotsInDisk)
              or a
             jr z,.rflgs
              ld a,(SlotsOnDISK)
              ld b,a
              or a
             jr z,.rflgs
              ld hl,T_ASK
              call .ASKQ_
             jr nc,1F
              ld a,#FF
             jr 2F
1             xor a
              ld (SlotsInDisk),a
              ld a,(SlotsNUMS)
              sub b
              ld (SlotsNUMS),a
              xor a
2             ld (.slotindisk),a
              ld (v_slt_dsk),a
              call setSlotsInt
             jp SetUpOVRL.n2

3             ld hl,.SltWarn_
              call .ASKQ_
              call nc,iniSLTSscrPLD
              ld a,(SlotsNUMS)
              or a
4             ld a,(SlotsInDisk)
             jr nz,2B
              xor a
              ld (SlotsInDisk),a
             jr 2B

.ASKQ_        push bc
              push hl
              ld a,STOP_ARW
              call GUI_
              pop hl
              call AskQ
              pop bc
             ret


.WturboDrives   DB 0,0,4,6,7*8,7,%1110
; Bit 0 -   /
; Bit 1 - ""  /
; Bit 2 -     /
; Bit 3 -   -     (CANCEL)
           DB 0
           DW .txtABCD         ; -
           DW .selABCD         ; - ()
           DW 2                ;   ; - ()
           DW .flagsABCD       ; -
           DW #FFFF

.txtABCD    DB "A",13,"B",13,"C",13,"D",0

.selABCD    DB 1,1,2,128+4,%11
           DB #FF

.flagsABCD
            DB 2,1,0,0
.ftdA  EQU $-1
             DW .sf_dTurbo
            DB 2,2,1,0
.ftdB  EQU $-1
             DW .sf_dTurbo
            DB 2,3,2,0
.ftdC  EQU $-1
             DW .sf_dTurbo
            DB 2,4,3,0
.ftdD  EQU $-1
             DW .sf_dTurbo

            DB #FF

.sf_dTurbo    ;  
             ld a,(.ftdA)
             and %0001
             ld c,a
             ld a,(.ftdB)
             and %0010
             or c
             ld c,a
             ld a,(.ftdC)
             and %0100
             or c
             ld c,a
             ld a,(.ftdD)
             and %1000
             or c
             ld (MODE),a
             ld (v_turbofs),a
            ret

.SltWarn_   MSG_SETUP_SltsWarn : DB 0




WsRAM      DB 0,0,16,15,7*8,7*8,%1110
           DB 0
           DW .txt
           DW .sel
           DW #FFFF

.txt        DB #0A : DW WSetUp.ram0
            DB #0A : DW WSetUp.ram1
            DB #0A : DW WSetUp.ram2
            DB #0A : DW WSetUp.ram3
            DB #0A : DW WSetUp.ram4
            DB #0A : DW WSetUp.ram5
            DB #0A : DW WSetUp.ram6
            DB #0A : DW WSetUp.ram7
            DB #0A : DW WSetUp.ram8
            DB #0A : DW WSetUp.ram9
            DB #0A : DW WSetUp.ram10
            DB #0A : DW WSetUp.ram11
            DB "Load RAM driver"
            DB 0

.sel        DB 1,1,14,128+13,%11
            DB #FF


;----------------------------------------

IniSetUp_chk  ld a,(v_joy)  ;     kempston mouse and joistick
              or a
              call nz,ch_kemps.joi
              ld a,(v_mouse)
              or a
              call nz,ch_kemps.mouse
              ld hl,IniSetUp
              ld (AddIniSetUp_),hl
             jp (hl)

setEXIT       call CLOSE

IniSetUp      ld hl,s_var     ;      
              ld a,(hl)    ; v_mouse
              inc hl
              ld (MICE),a
              ld a,(hl)  ; v_2butFR2
              inc hl
              ld (MBut2toFire2),a
              inc hl     ; v_3but  
              ld a,(hl)  ; v_rever
              inc hl
              ld (MB),a
              ld a,(hl)  ; v_joy
              inc hl
              ld (KJOY),a
              ld a,(hl)  ; v_turbofs
              inc hl
              ld (MODE),a
              ld a,(hl)  ; v_ext for new  started
              ld (ExtMem_),a
              inc hl
              ld a,(hl)  ; v_mscroller
              inc hl
              call guiRAM
              or a
              ld a,#C9    ; [ret] for 0
             jr z,1F
              xor a
1             ld (MO4),a
              ld a,(v_3but)
              or a
              ld a,#1F  ;  [ rra ]
             jr nz,1F
              ld a,#37  ;  [ scf ]
1             ld (MO4_),a
             push hl
              ld a,TEST     ;     ( )  
              call GUI
             pop hl
              ld a,(hl)  ; v_step
              inc hl
              ld (STEP),a
              ld (STEPN),a
              ld a,(hl)  ; v_level
              inc hl
              ld (LEVEL),a
              ld (LEVELN),a
              ld a,(hl)  ; v_speed
              inc hl
              ld (SPEED),a
              ld (SPEEDN),a

              call guiRAM
              ld a,(hl)  ; v_antiInvis
              inc hl
              call set_Nntrance

              ld a,(hl)       ; vmgnX8  /DA
              inc hl
              ld (Magnify_x8),a
              ld a,(hl)       ; v_mgnG4
              inc hl
              ld (OldGrd4_set_fl),a   ; (OldGrd4.set_),a
              call OldGrd4
              ld a,(hl)        ; v_mslow
              inc hl
              push hl           ; slow mouse
              call guiRAM
              call MOUSDR.speed ;   
              pop hl
              ld a,(hl)        ; v_mgncur
              inc hl
              ld (RadiMgn_CUR.CURview),a
              ld a,(hl)        ; v_mgn2bt
              inc hl
              ld (RadiMgn_CUR.CURrmb),a
              ld a,(hl)        ; v_mgnsm
              inc hl
              ld (FlagsMgn_CUR.PixSmooth),a
              ld a,(hl)        ; v_mgnfs
              inc hl
              ld (FlagsMgn_CUR.FireScroll),a
              ld a,(hl)        ; v_mgnsa
        ;      ld (FlagsMgn_CUR.ArwScroll),a
              ld hl,v_ramDRVname
              ld de,ramDRVname
              ld bc,8
              ldir
              inc hl : inc hl : inc hl : inc hl     ;    0
              ld a,(hl)             ; v_rgbdef
              ld (RGBdefault),a
              inc hl
              ld a,(hl)
              ld (BORDER),a        ; border
              call RetBorder
              inc hl
              ld a,(hl)            ; v_hidemenu
              ld (Fl_hide_menu),a
              inc hl
              ld a,(hl)            ; v_slt_dsk
              ld (SlotsInDisk),a
              inc hl
              ld a,(hl)            ; v_keyboard
              ld (keyboardL),a
              inc hl
              ld bc,11             ;  v_keybfile
              ld de,keybfileL
              ldir
              inc hl
              ld de,joy_buts       ; v_joy_buts  4 bytes
              ld bc,4
              ldir

             ret

;----------------    
LdConfig      call SvConfig.nilbuf
              ld hl,Fn_Sup
              call FromName
              ld hl,FBUFF
              ld de,256
              ld bc,#01AE
              call guiRAM
              ld a,DOS_FUNC
              call GUI_
             jr c,1F
              ld de,s_var
              ld bc,e_var-s_var
              ld hl,FBUFF
              ldir
1             call IniSetUp
AddIniSetUp_ EQU $-2          ;    InitBGE
ReSetUp       ld hl,s_var     ;      
              ld a,(MICE)
              ld (WSetUp.fkmouse),a
              ld (hl),a    ; v_mouse
              inc hl
              ld a,(MBut2toFire2)
              ld (WSetUp.f2btnF2),a
              ld (hl),a    ; v_2butFR2
              inc hl
              inc hl
              ld a,(MB)
              ld (WSetUp.fswpBTN),a
              ld (hl),a    ; v_rever
              inc hl
              ld a,(KJOY)
              ld (WSetUp.fkjoist),a
              ld (hl),a    ; v_joy
              inc hl
              ld a,(MODE)
              ld (hl),a    ; v_turbofs
              inc hl
              ld c,a
              bit 0,c
              ld b,"A"
              ld de,WSetUp.tDISKS_
              call .stMODE_
              ld (WSetUp.ftdA),a
              bit 1,c
              call .stMODE_
              ld (WSetUp.ftdB),a
              bit 2,c
              call .stMODE_
              ld (WSetUp.ftdC),a
              bit 3,c
              call .stMODE_
              ld (WSetUp.ftdD),a
              ld a,(ExtMem_)
              ld (hl),a    ; v_ext
              inc hl
              call guiRAM
              ld a,(MO4_)
              cp #1F   ; [ rra ]
              ld a,#FF
             jr z,1F
              xor a
1             ld (WSetUp.f3btn),a
              ld (v_3but),a
              ld a,(MO4)
              or a
              ld a,#FF
             jr z,1F
              xor a
1             ld (WSetUp.fscrlr),a
              ld (hl),a    ; v_mscroller
              inc hl
              ld a,(STEP)
              ld (hl),a    ; v_step
              inc hl
              ld a,(LEVEL)
              ld (hl),a    ; v_level
              inc hl
              ld a,(SPEED)
              ld (hl),a    ; v_speed
              inc hl

              call guiRAM
              ld a,(Nntrance.flag_)
              or a
             jr z,1F
              ld a,#FF
1             ld (hl),a    ; v_antiInvis
              inc hl
              ld a,(Magnify_x8)
              ld (WSetUp.floupX8),a
              ld (hl),a   ; vmgnX8
              inc hl
              ld a,(OldGrd4_set_fl)  ; (OldGrd4.set_)
              ld (WSetUp.flOldx4),a
              ld (hl),a   ; v_mgnG4
              inc hl
              call guiRAM
              ld a,(M_slowX)   ; (MOUSDR.speed+1)
              or a
             jr z,1F
              ld a,#FF
1             ld (WSetUp.fslowMs),a
              ld (hl),a    ; v_mslow
              inc hl
              ld a,(RadiMgn_CUR.CURview)
              ld (hl),a    ; v_mgncur
              inc hl
              ld a,(RadiMgn_CUR.CURrmb)
              ld (hl),a    ; v_mgn2bt
              inc hl
              ld a,(FlagsMgn_CUR.PixSmooth)
              ld (hl),a    ; v_mgnsm
              inc hl
              ld a,(FlagsMgn_CUR.FireScroll)
              ld (hl),a    ; v_mgnfs
              inc hl
              ld hl,ramDRVname
              ld de,v_ramDRVname
              push hl
              ld bc,8
              ldir
              pop hl
              push de
              ld c,8
              ld de,WSetUp.ramDRVname
              ldir
              pop hl
              inc hl : inc hl : inc hl : inc hl     ;    0
              ld a,(RGBdefault)
              ld (hl),a             ; v_rgbdef
              inc hl
              ld a,(BORDER)
              ld (hl),a
              inc hl
              ld a,(Fl_hide_menu)
              ld (WSetUp.hidemenu),a
              ld (hl),a                ; v_hidemenu
              inc hl
              ld a,(SlotsInDisk)
              ld (WSetUp.slotindisk),a
              ld (hl),a                ; v_slt_dsk
              inc hl
              ld a,(keyboardL)         ;    v_keyboard
              ld (hl),a
              inc hl
              ex de,hl
              ld hl,keybfileL
              ld bc,11
              ldir
              inc de                  ; de = v_joy_buts
              ld hl,joy_buts
              ld c,4
              ldir

             ret

.stMODE_
              ld a,b
              ld (de),a
              ld a,#FF
             jr nz,1F
              ld a,"-"
              ld (de),a
              xor a
1             inc de
              inc b
             ret

;-----------------------   
S_Curs  ld a,%1110
.l0     ld ix,W_Cur
        ld (ix+6),a
        call POPUPdr

        ld a,(v_step)
        ld de,s_w
        call GetNumA
        ld a,(v_level)
        ld de,l_w
        call GetNumA
        ld a,(v_speed)
        ld de,p_w
        call GetNumA

        call Win_
        cp #FF
       jp z,CLOSE
        ld e,a
        sub 3
       jr nc,1F
        ld a,e
1       ld hl,v_step ;  v_step, v_level, v_speed
        ld c,a
        ld b,0
        add hl,bc
        ld a,e
        cp 3
        ld a,(hl)
       jr c,1F
        dec a
       jr nz,2F
1       inc a
2       ld (hl),a
        ld a,%1100
       jr .l0

; - (switch)
; x, y,  ,  (#00/#FF)
;       ,  
;     

W_Cur   DB 0,0,15,7,4*8,4,%1110,0
        DW T_Cur
        DW S_Cur
        DW 2
        DW F_Cur
        DW #FFFF

T_Cur   MSG_SETUP_Step : DB #17,8,"000",13
s_w     EQU $-4

        MSG_SETUP_Level : DB #17,8,"000",13
l_w     EQU $-4

        MSG_SETUP_Speed : DB  #17,8,"000",13,13
p_w     EQU $-5


        MSG_SETUP_SeeInvis  : DB 13

        DB 22,12,1,"+ -",13,"+ -",13,"+ -",0

S_Cur   DB 12,1,1,128+3,%11
        DB 13,1,1,128+3,%11
        DB 1,5,13,1,%11
        DB #FF

F_Cur     DB 13,5,6,#FF
          DW .antiInvis
         DB #FF

.antiInvis    ld a,(F_Cur+3)
              ld (v_antiInvis),a
set_Nntrance  and 1
1             ld (Nntrance.flag_),a        ;       'ArrGUI.asm'
             ret

;------------------------------------------------

Fn_Sup   DB "bgesys  sup"

SvConfig   call .nilbuf
           ld hl,s_var
           ld bc,e_var-s_var
           ld de,FBUFF
           push de
           ldir
           ld hl,Fn_Sup
           call FromName
           pop hl
           ld de,256
           ld bc,#010B
           ld a,DOS_FUNC
          jp GUI_

.nilbuf    call guiRAM
           ld hl,FBUFF
           ld de,FBUFF+1
          ; ld (hl),0
           ld bc,255
           ld (hl),b  ; b=0
           ldir
          ret

;--------------------------------------------------------------------

ch_kemps  ;   kempston joistick  mouse   .
.mouse   halt
         ld bc,#FFDF   ; y
         in a,(c)
         ld b,#FB      ; x
         in e,(c)
         dec b         ; #FA
         in d,(c)
         cp e
        jr nz,1F
         cp d
        jr z,.nms
1        ld de,#0800
         ld bc,#FADF      ;     
1        in a,(c)
         or #FC        ;    2008.  3- 
         inc a
        jr nz,.nms       ;  
         dec de
         ld a,d
         or e
        jr nz,1B
         call .ms3btn   ;  3- 
         call .msWhl    ;  
        ret

.ms3btn      halt             ;  3 
             ld de,#0800
             ld bc,#FADF      ;     
1            in a,(c)
             or #FB
             inc a
            jr nz,2F
             dec de
             ld a,d
             or e
            jr nz,1B
            ret
2            xor a
             ld (v_3but),a       ;  3- 
            ret

.msWhl       halt             ;  
             ld de,#0800
             ld bc,#FADF      ;    
             in a,(c)
             and #F0
             ld l,a
1            in a,(c)
             and #F0
             cp l
            jr nz,2F
             dec de
             ld a,d
             or e
            jr nz,1B
            ret
2            xor a                ;  
             ld (v_mscroller),a
            ret


.nms          xor a            ;  
              ld (v_mouse),a
             ret


.joi     call guiRAM
         ld bc,#0010
         ld e,b        ; e=0
1        xor a         ;    0 (    )
         in a,(#1F)
         or e
         ld e,a
        djnz 1B
         dec c
        jr nz,1B
         ld a,e
         and #1F
        jr nz,.nj
         ld a,e
         xor %11100000
         and %11100000
         ld e,a             ;     
         ld (joy_bsmsk),a
         ld a,(v_joy_buts)
         or a
        jr z,1F
         ld a,e
1        ld (KEMPST.msk),a
        ret

.nj      xor a
         ld (v_joy),a    ;  
         ld (WSetUp.fkjoist),a
        jr 1B

;--------------------------------------------------------------------

Joy_BUTS     ;    
             ld ix,WJoy_BUTS
             call POPUP
.n0          ld a,%1110
.n1          ld ix,WJoy_BUTS
             ld (ix+6),a
             ld a,(v_joy_but1)
             ld hl,WJoy_BUTS.tb1_
             ld bc,WJoy_BUTS.tLetter1+2
             call .prnBtn_
             ld a,(v_joy_but2)
             ld hl,WJoy_BUTS.tb2_
             ld bc,WJoy_BUTS.tLetter2+2
             call .prnBtn_
             ld a,(v_joy_but3)
             ld hl,WJoy_BUTS.tb3_
             ld bc,WJoy_BUTS.tLetter3+2
             call .prnBtn_

             call Win_
             cp #FF
            jp z,CLOSE
             ld b,0
             ld c,a
             ld hl,v_joy_buts
             add hl,bc
             call .opt

             ld a,%1100
            jr .n1

.prnBtn_     call 1F
             ld (hl),e
             inc hl
             ld (hl),d
            ret
1            ld de,WJoy_BUTS.tFire    ; 0
             or a
            ret z
             ld de,WJoy_BUTS.t2btn    ; 1
             cp 1
            ret z
             ld de,WJoy_BUTS.tCancel  ; 2
             cp 2
            ret z
             ld de,WJoy_BUTS.tSS      ; 3
             cp 3
            ret z
             ld de,WJoy_BUTS.tEnter   ; 13 ENTER
             cp 13
            ret z
             cp 32
            jr nc,2F
             xor a
            jr 1B
2            ld (bc),a
             dec bc
             dec bc   ; WJoy_BUTS.tLetter*
             ld d,b
             ld e,c
            ret

.opt         or a                  ; in: hl - addres of button id ,
            ret z                  ;     a - option, if a=0 then return
             push hl
             ld ix,WJoy_SelBt
             call POPUP
             ld (ix+6),%1110
             call Win_
             call CLOSE_
             pop hl
             cp #FF
            ret z
             cp 4
            jr c,3F
            jr nz,1F
             ld a,13  ; ENTER
            jr 3F
1            sub 5
             ld c,a
             add a,a
             add a,c  ; *3
             ld c,a
             ld b,0
             ex de,hl
             ld hl,WJoy_SelBt.t_lett
             add hl,bc
             ld a,(hl)
             ex de,hl
3            ld (hl),a
           ret

;--------------------------------------------------------------------

WJoy_BUTS    DB 0,0,14,6,7*8,7,%1110

           DB 0
           DW .Txt        ; -
           DW .Sel        ; - ()
           DW 2           ;   ; - ()
           DW .flags      ; -
           DW #FFFF

.Txt         MSG_SETUP_joiUsBt : DB 13
             MSG_SETUP_Btn1
             DB ":",#17,8,#0A : DW.sss_ : DB #17,8,#0A
.tb1_        DW .t2btn   : DB 13
             MSG_SETUP_Btn2
             DB ":",#17,8,#0A : DW.sss_ : DB #17,8,#0A
.tb2_        DW .tCancel : DB 13
             MSG_SETUP_Btn3
             DB ":",#17,8,#0A : DW.sss_ : DB #17,8,#0A
.tb3_        DW .tEnter  : DB 13
            DB 0

.sss_       DB "      ",#FF


.tFire      DB "Fire",#FF
.t2btn      DB "Fire2",#FF
.tCancel    DB "CANCEL",#FF
.tEnter     DB "ENTER",#FF
.tSS        DB "   SS",#FF

.tLetter1    DB #17,10,"U",#FF
.tLetter2    DB #17,10,"U",#FF
.tLetter3    DB #17,10,"U",#FF

.Sel        DB 1,1,12,128+4,%11
           DB #FF

; x, y,  ,  (#00/#FF)
.flags      DB 12,1,0,#FF
             DW .flags_
            DB #FF

.flags_      ld a,(WJoy_BUTS.flags+3)
             ld (v_joy_buts),a
             ld a,(KJOY)
             or a
            ret z
             ld a,(joy_bsmsk)
             ld (KEMPST.msk),a
            ret


WJoy_SelBt  DB 0,0,17,11,6*8,6,%1110
            ; Bit 0 -   /
            ; Bit 1 - ""  /
            ; Bit 2 -     /
            ; Bit 3 -   -     (CANCEL)
            DB 0
            DW .Txt        ; -
            DW .Sel        ; - ()
           DW #FFFF



.Txt        DB #0A: DW WJoy_BUTS.tFire : DB #17,4,#0A
            DW WJoy_BUTS.t2btn : DB #17,8,#0A
            DW WJoy_BUTS.tCancel : DB #17,13,"SS",13,13,#17,11,#0A
            DW WJoy_BUTS.tEnter : DB #17,0
.t_lett     DB "1",#17,2,"2",#17,4,"3",#17,6,"4",#17,8,"5",13,13
            DB "W",#17,2,"E",#17,4,"R",#17,6,"T",#17,8,"Y",#17,10,"U",#17,12,"I",13,13
            DB "S",#17,2,"D",#17,4,"F",#17,6,"G",#17,8,"H",#17,10,"J",#17,12,"K",#17,14,"L",13,13
            DB "Z",#17,2,"X",#17,4,"C",#17,6,"V",#17,8,"B",#17,10,"N",#17,12,"M",13,13
           DB 0

.Sel        DB 1,1,3,1,%11    ; 0 - Fire
            DB 5,1,3,1,%11    ; 1 - Fire-2
            DB 9,1,4,1,%11    ; 2 - CANCEL
            DB 14,1,2,1,%11   ; 3 - SS
            DB 12,3,4,1,%11   ; 4 - ENTER

              ; >=5 keys codes
            DB 1,3,128+10,1,%11    ; tab. 12345
             DB 2,1,1,1,5
            DB 1,5,128+14,1,%11    ; tab. WERTYUI
             DB 2,1,1,1,7
            DB 1,7,128+16,1,%11    ; tab. SDFGHJKL
             DB 2,1,1,1,8
            DB 1,9,128+14,1,%11    ; tab. ZXCVBNM
             DB 2,1,1,1,7
           DB #FF

;   :
; x,y, 128+   ,    , 
;  ,  ,   ,   ,   


 ;      .  :
     ; 0 - fire, 1 - 2-  , 2 - Cancel, 3 - SS
     ; 13 - ENTER
     ;      "wertyuisdfghjklzxcvbnm"


;--------------------------------------------------------------------

;    

SlotsID_          DB "SLOT"

CPstrHLDEB       ;    HL    DE  B ; nz - false
                  ld a,(de)
                  cp (hl)
                 ret nz
                  inc de
                  inc hl
                 djnz CPstrHLDEB
                 ret

iniSLTSscrPLD     ld a,#FF
                  ld (SlotsInDisk),a

iniSLOTSscrs      call .i_
                  ld a,(SlotsOnRAM)
                  ld c,a
                  ld a,(SlotsOnDISK)
                  add a,c
                  cp 2
                 jr nc,1F
                  xor a
                  ld (SlotsInDisk),a
                  ld (SlotsOnDISK),a
1                 ld (SlotsNUMS),a
                  call setSlotsInt
                 ret
.i_               ld (.sp),sp
                  ld a,5
                  ld (.dsnum),a
                  xor a
                  ld (SlotsOnRAM),a
                  ld (SlotsOnDISK),a
                  ld a,(ovADDpages)  ;   c -    
                  sub ovAnumsVARpgs  ;   
                 jr c,2F
                 jr z,2F
                  ld c,a             ;     
                  ld a,(SlotsInDisk)
                  or a               ;            
                 jr nz,1F            ;         
                  ld a,c
                  dec a
                 jr nz,1F
                  ld c,a
                  ld a,(OVRLpages)
                  dec a
                  ld (OVRLpages),a
                  ld a,(ovADDpages)
                  dec a
                  ld (ovADDpages),a

1                 ld a,c
                  ld (SlotsOnRAM),a ;     
                  or a
                 ret z         ;  0      
                  ld b,a
                  call .cleanSLOTS
                  ld a,5
                  sub c
                 ret z
                  ld (.dsnum),a            ;    

2                 ld a,(SlotsInDisk)
                  or a
                 ret z
                  call SetSYSTEMDISK
                  call CheckBGEdisk
                 jr nc,1F
.err              xor a
                  ld (SlotsInDisk),a
                 jr .exit
1
.dsnum  EQU $+1 : ld b,5     ;      SlotName.N
                  ld c,0
1                 push bc
                  ld a,c
                  ld (.dsna),a
                  add a,"1"
                  ld (SlotName.N),a
                  ld hl,SlotName
                  call FromName
                  ld a,SEARCHFILE11
                  call GUI
                  pop bc
                  ld e,a
                 jr c,.crfile         ;  
                  ld a,(SEC_LEN)
                  cp 54
                 jr nz,.delFile       ;    
.conti            inc c
                 djnz 1B
                  ld a,c
                 jr 1F
.exit_            ld a,0
.dsna    EQU $-1
1                 ld (SlotsOnDISK),a
                  or a
                 jr z,.err

.exit            call RetCURRENTDISK
.sp   EQU $+1 :  ld sp,#0000
                ret

.delFile         ;     
                 ld a,e
                 ex af,af'
                 push bc
                 ld a,ERASE_NUMFL
                 call GUI
                 pop bc
                jr c,.exit_
.crfile          ;   
                 push bc
                 call GuiRam
                 ld bc,16
                 ld hl,CAT
                 xor a
                 ld e,a
1                cp (hl)
                jr z,2F
                 add hl,bc
                 inc e
                jr 1B
2                ld a,e
                 cp 128
                 pop bc
                jr nc,.exit_    ;  ,  
                 rra : rra : rra : rra
                 and #0F
                 ld (.ctsek_),a
                 ld (.plcat_),hl       ;   
                 ld hl,(CAT+#08E5)  ;   
                 ld a,h
                 or a
                jr nz,1F
                 ld a,l
                 cp 54
                jr c,.exit_    ;  ,  
1                push bc
                 ld a,54
                 ld (SEC_LEN),a
                 ld hl,6912+6912
                 ld (BYTES_LEN),hl
                 ld hl,(CAT+#08E1)
                 ld (START_SEC),hl
                 ld (#5CF4),hl
                 call .svdataOsl
                 call .svdataOsl
                 ld hl,(#5CF4)
                 ld (CAT+#08E1),hl
                 ld hl,(CAT+#08E5)
                 ld bc,54
                 or a
                 sbc hl,bc
                 ld (CAT+#08E5),hl
                 ld a,(CAT+#08E4)
                 inc a
                 ld (CAT+#08E4),a

.plcat_ EQU $+1 :  ld de,0
                   ld hl,FILE_PARAM
                   ld bc,16
                   ldir
                   xor a
                   ld (de),a

.ctsek_  EQU $+1  : ld de,#0000   ; e -sektor
                    ld hl,CAT
                    ld a,h
                    add a,e
                    ld h,a
                    ld bc,#0106
                    call DOS_FUNC_
                   jp c,.exit_
                    ld hl,CAT+#0800
                    ld de,#0008
                    ld bc,#0106
                    call DOS_FUNC_
                   jp c,.exit_
                 pop bc
                 jp .conti

.svdataOsl       xor a
                 call .filboof
                 ld b,24
                 call .savsec
                 ld a,(RGBdefault)
                 call .filboof
                 ld b,3
.savsec          push bc
                 ld hl,NEWCAT
                 ld bc,#0106
                 ld de,(#5CF4)
                 call DOS_FUNC_
                 pop bc
                jp c,.exit_
                djnz .savsec
                 or a
                ret
.filboof         ld hl,NEWCAT   ;   
                 ld de,NEWCAT+1
                 ld bc,256
                 ld (hl),a
                 ldir
                ret

.cleanSLOTS      push bc
1                 ld a,b
                  dec a
                  add a,ovScrSLOTSpg
                  push bc
                  call ONPAGE
                  ld b,4
                  ld hl,UNDOSCR+6912
                  ld de,SlotsID_
                  call CPstrHLDEB
                 jr z,2F
                  ;  
                  ld hl,#C000
                  ld de,#C001
                  ld bc,6144
                  ld (hl),l
                  ldir
                  ld a,(RGBdefault)
                  ld (hl),a
                  ld bc,767
                  ldir
                  ld hl,#C000
                  ld bc,6912
                  ldir
                  ld hl,SlotsID_
                  ld c,4
                  ldir
2                 ld a,ScrPage
                  call EX_RAM
                  pop bc
                 djnz 1B
                 pop bc
                ret


setSlotsInt      call SlotOUTtxt
                 ld hl, WSltSelect.Sel_5+4
                 call .set

        ;         ld a,PgnPage1
        ;         call Ram_
        ;         ld hl,MScreen.Sslts+4-PgnAdr+MScreenPgn
        ;         ld a,(SlotsNUMS)
        ;         or a
        ;         ld a,%100
        ;        jr z,1F
        ;         ld a,%111
1       ;         ld (MScreen.Sslots_+4-PgnAdr+MScreenPgn),a   ; 
        ;         call .set
                jp guiRAM

.set        ld (.hl_),hl
            xor a
            ld b,5
            call .filSslts
            ld a,(SlotsNUMS)
            ld b,a
            or a
           ret z
            ld a,%11
.filSslts   ld hl,WSltSelect.Sel_5+4   ; A saved setSlotsInt.set
.hl_   EQU $-2
            ld de,5
1           ld (hl),a
            add hl,de
           djnz 1B
           ret

;      4x

OldGrd4   push hl,de,bc
     ;     push af
          ld a,PgnPage1|#10
          call Ram
     ;     pop af
          ld hl, Mgn4.tbN-PgnAdr+MgnPgn
          ld a,(OldGrd4_set_fl)   ; #FF
; .set_  EQU $-1          ;   4x4
          or a
         jr z,1F
          ld hl,Mgn4.tbO-PgnAdr+MgnPgn
1         ld de, Mgn4.Gd-PgnAdr+MgnPgn
          ld bc,#03FF
1         ldi:ldi
          inc de
          inc de
         djnz 1B
          pop bc,de,hl
          ret
;---------------------------------------------------------------------
KeybLa     ld ix,WKeybLa
           call POPUP
           ld (ix+6),%1110
           call Win_
           call CLOSENK_
           or a
          jr z,.def
           dec a
          ret nz
 ; load file
           call CallSYSTEMDISK         ; call SetSYSTEMDISK
           ld hl,.sort
           call FilerE
          ret c  ; jr c,.e_
           call .l_
          ret c  ;  jr c,.e_
           ld a,1
           ld (v_keyboard),a
           ld hl,#5CDD
           ld de,v_keybfile
           ld bc,11
           ldir
;.e_        jp RetCURRENTDISK
           ret

.er_        call RetCURRENTDISK
.def        xor a
            ld (v_keyboard),a
.df_        ld hl,KEY_TAB_Default
            ld de,LAT_TAB
            ld bc,#0200
            ldir
            call NOKEY_
            scf
           ret

 ; first load
.loadkbd     ld a,(keyboardL)
             or a
            jr z,.df_
             call CallSYSTEMDISK      ; call SetSYSTEMDISK
             ld hl,keybfileL
             call FromName
             ld a,SEARCHFILE11
             call GUI
         ;    call nc,.l_
         ;   jr .e_
            ret c

.l_        ld de,(#5CEB)
           ld a,(#5CEA)  ; len
           ld b,a
           ld c,5
           ld hl,RUS_TAB
           dec a
          jr z,1F
           dec h
           dec a
           scf
          ret nz
1          call DOS_FUNC_
          jr c,.df_
          ret



.sort       DB %0001,"kbd",#00,%1011,3,255,#FF


WKeybLa     DB 0,0,12,4,7*8,7*8,%1110

           DB 0
           DW .txt             ; -
           DW .sel             ; - ()
           DW #FFFF

.txt       MSG_SETUP_Kdef  : DB 13
           MSG_SETUP_Kload
          DB 0

.sel       DB 1,1,10,128+2,%11
          DB #FF


KEY_TAB_Default               ;       .

    DB "................";0
    DB "................";1
    DB " !"
    DB #22  ;
    DB    "#$%&'()*+,-./";2
    DB "0123456789:;<=>?";3
    DB "@ABCDEFGHIJKLMNO";4           0
    DB "PQRSTUVWXYZ[",#5C,"]^_";5     1
    DB "`abcdefghijklmno";6
    DB "pqrstuvwxyz{|}~",#7F ;7
    DB "................";8
    DB "................";9
    DB "................";A
    DB "................";B
    DB "...|.][....}{",#5C,"..";C
    DB "................";D
    DB "..~.............";E
    DB "................";F
;       0123456789ABCDEF
;RUS_TAB_
  ;  DB "................";0
  ;  DB "................";1
  ;  DB " !"
  ;  DB #22;
  ;  DB    "#$%&'()*+,-./";2
  ;  DB "0123456789:;<=>?";3
  ;  DB "";4
  ;  DB "[",#5C,"]_";5
  ;  DB "";6
  ;  DB "{|}~",#7F ;7
  ;  DB "................";8
  ;  DB "................";9
  ;  DB "................";A
  ;  DB "................";B
  ;  DB "..........";C
  ;  DB "................";D
  ;  DB "...............";E
  ;  DB "................";F

    INCBIN_ADD_L Default.kbd

.len EQU $-KEY_TAB_Default      ; 512 bytes


;---------------------------------------------------------------------

s_var
;     BGE
v_mouse      DB #FF             ; 
v_2butFR2    DB 00              ;  2-   fire 2
v_3but       DB 00              ; 3-  
v_rever      DB #00             ; 
v_joy        DB 00              ; 
v_turbofs    DB %0000           ;   
v_ext        DB #01             ; . 
v_mscroller  DB #FF             ;    (kempston)
v_step       DB #06             ;   
v_level      DB #0A             ;   
v_speed      DB #01             ;   
v_antiInvis  DB #FF             ;       (ink=paper)
v_mgnX8      DB #FF             ;                          ; /DA
v_mgnG4      DB 0               ;      x4
v_mslow      DB 0               ;  
v_mgncur     DB 0               ;   
v_mgn2bt     DB 0               ;  2-  
v_mgnsm      DB #FF             ;  
v_mgnfs      DB #FF             ;    
v_mgnsa      DB #FF             ;       
v_ramDRVname DB "bgeRAMdrram",0 ;     
v_rgbdef     DB 7               ;   
             DB 0               ;   
v_hidemenu   DB 0               ;    
v_slt_dsk    DB 0               ;    BGE   
v_keyboard   DB 0               ;   
v_keybfile   DB "keyboardkbd",0 ;    
v_joy_buts   DB #FF             ;     
v_joy_but1   DB 1               ;    . 1-  (0-  fire)
v_joy_but2   DB 2               ;    . 2- 
v_joy_but3   DB 13              ;    . 3- 

e_var


 ;      .  :
     ; 0 - fire, 1 - 2-  , 2 - Cancel, 3 - SS
     ; 13 - ENTER
     ;      "wertyuisdfghjklzxcvbnm"


          ASSERT  ($-s_var) < 255
          ORG s_var+256
;---------------------------------------------------
LSetUp       EQU $-SetUpOVRL
             ASSERT  $ < #C000

      DISPLAY "SetUp len  :",/a, LSetUp
