        ORG #6000

;DE -     
        LD HL,0
CRDS    EQU $-2
        BIT 7,D
        JR Z,DOWN
        LD A,D
        ADD A,H
        LD H,A
        SBC A,A
        AND H
        LD H,A
        JR NODOWN
DOWN    LD A,D
        ADD A,H
        JR NC,$+4
        LD A,#BF
        CP #C0
        JR C,$+4
        LD A,#BF
        LD H,A
NODOWN  BIT 7,E
        JR Z,RIGHT
        LD A,E
        ADD A,L
        LD L,A
        SBC A,A
        AND L
        LD L,A
        JR NORIGHT
RIGHT   LD A,E
        ADD A,L
        JR NC,$+3
        SBC A,A
        LD L,A
NORIGHT LD (CRDS),HL

;     .
        LD A,C
        RRA 
        RRA 
        RRA 
        RRA 
        AND 3
        OR 0
BATON   EQU $-1
        RET 

; mouse  .C 

;  
MSPD    DB 0,1,2,4,7,10,14,19,25,32,40
MSPDE

DRIVER  JP M_INIT       ; 
                        ;
        JP STOPCUR      ; 

;---------------------------------------
; .   DE  
;  (D-Y, E-X)
; A-    (1 -  )
;0 BIT - FIRE
;1 BIT - CANCEL
;---------------------------------------
GMOUSE  LD A,(MSPDE-1)
        LD D,A
        LD E,A
                        ; DE--
                        ;   
                        ; 
        LD A,#FF        ; 
        IN A,(#DF)      ; Y

        LD C,0          ;   
OLD_FF  EQU $-1         ; Y
        LD (OLD_FF),A
        SUB C           ; A- 
                        ; 

        JP P,M_UP
;  
        NEG 
        CP MSPDE-MSPD
        JR NC,GMDX
        ADD A,MSPD      ;  
        LD L,A          ; Y  
        ADC A,MSPD/256
        SUB L
        LD H,A
        LD D,(HL)
        JR GMDX

M_UP    CP MSPDE-MSPD   ; 
        JR NC,GMU1
        ADD A,MSPD
        LD L,A
        ADC A,MSPD/256
        SUB L
        LD H,A
        LD D,(HL)
GMU1    XOR A
        SUB D
        LD D,A
;   Y  .
GMDX
;       X
        LD A,#FB
        IN A,(#DF)
        LD C,0
OLD_FB  EQU $-1
        LD (OLD_FB),A
        SUB C
        JP M,M_LF
        CP MSPDE-MSPD
        JR NC,MBATON
        ADD A,MSPD
        LD L,A
        ADC A,MSPD/256
        SUB L
        LD H,A
        LD E,(HL)
        JR MBATON
M_LF    NEG 
        CP MSPDE-MSPD
        JR NC,GML1
        ADD A,MSPD
        LD L,A
        ADC A,'MSPD
        SUB L
        LD H,A
        LD E,(HL)
GML1    XOR A
        SUB E
        LD E,A
; DE     
MBATON  ;  
        LD A,0
REVBTN  EQU $-1
        OR A
        LD A,#FA
        IN A,(#DF)
        CPL 
        JR NZ,REVERSE;  
        AND 3
        RET 
REVERSE RRA 
        RL L
        RRA 
        RR L
        LD A,L
        AND 3
        RET 

;---------------------------------------
;  
;  :
; . A:
;  #00 -    
;  #FF -   

;   (    )
; ZF
; 0 -    
; 1 -      

;---------------------------------------
M_INIT  LD (REVBTN),A
        CALL STOPCUR    ; 
        EI              ;
                        ;
                        ;   
                        ; ,
                        ; 
                        ; 
                        ;  
                        ;
                        ;     
                        ; (
                        ;   -
                        ;   #FF
        HALT            ; O 
        LD BC,#FFDF     ; 
        IN A,(C)        ;  
        LD B,#FB        ;   ,
        IN E,(C)        ;, 
        DEC B           ; 
        IN D,(C)        ;.
        CP E
        RET NZ
        SUB D
        RET 
;---------------------------------------
;  
STOPCUR LD A,#FF
        IN A,(#DF)
        LD (OLD_FF),A
        LD A,#FB
        IN A,(#DF)
        LD (OLD_FB),A
        RET 
;---------------------------------------


