PageGUI  EQU 3
BeginGUI EQU #C800

        ORG #C000,3
+       INCBIN "gui"

        ORG #6128

        INCLUDE "GuiVar",#40
        INCLUDE "ResGUI",#08

Runner  LD A,PageGUI+#10
        LD (GUI_PAGE),A
        LD A,4+#10
        LD (STORE_PAGE),A
        LD A,#10
        LD (S_PAGE),A
        LD HL,Resident
        LD (ResAdr),HL

        LD HL,#4000
        LD DE,#C000
        LD BC,6912
        LDIR 

START   LD   HL,NAME001
        CALL INIT_CACHE

        CALL PAGE0

;-WRITING PCX HEADER--------------------

        LD   B,12
        LD   HL,MANUF
WR_HDR0 PUSH BC
        LD   A,(HL)
        CALL WRITE_CACHE
        INC  HL
        POP  BC
        DJNZ WR_HDR0
        LD   B,53
WR_HDR1 PUSH BC
        XOR  A
        CALL WRITE_CACHE
        POP  BC
        DJNZ WR_HDR1
        LD   B,63
        LD   HL,NPLANES
WR_HDR2 PUSH BC
        LD   A,(HL)
        CALL WRITE_CACHE
        INC  HL
        POP  BC
        DJNZ WR_HDR2


;-WRITING PCX DATA----------------------

        DS   3

        LD   DE,0
        LD   B,193
RLE0    PUSH BC
        LD   HX,0
        LD   B,0
RLE1    PUSH BC
        LD   LX,0

RLE2    CALL GETPIX
        LD   (RLEC2+1),A
        INC  DE
        INC  HX
        INC  LX
        LD   L,A
        CALL GETPIX

        EX AF,AF'
        LD   A,HX
        CP   255
        JR   NZ,RLE4

        POP  BC
        LD   B,1
        PUSH BC
        JR   RLE3

RLE4    LD   A,LX
        CP   63
        JR   Z,RLE3
        EX AF,AF'

        CP   L
        JR   Z,RLE2
RLE3    LD   A,LX
        CP   1
        JR   Z,RLEC2
        OR   #C0

RLE5    CALL WRITE_CACHE
        JP   C,0
RLEC2   LD   A,0
RLE6    CALL WRITE_CACHE
        JP   C,0
        POP  BC
        DJNZ RLE1

        POP  BC
        DJNZ RLE0

;-WRITING PCX PALETTE

        LD   A,12
        CALL WRITE_CACHE
        JP   C,0
        LD   B,16*6
        LD   HL,ZX_PAL
WRT_P   LD   A,(HL)
        CALL WRITE_CACHE
        JP   C,0
        INC  HL
        DJNZ WRT_P
        LD   BC,672
WRT_P1  PUSH BC
        XOR  A
        CALL WRITE_CACHE
        JP   C,0
        POP  BC
        DEC  BC
        LD   A,B
        OR   C
        JR   NZ,WRT_P1

;-FLUSHING BUFFER-----------------------

skippal

        CALL FLUSH_CACHE
        JP   C,0
        RET 

;-PCX HEADER DATA-----------------------

MANUF   DB   10
HARD    DB   5
ENCOD   DB   1
BITPX   DB   8
WIN_X1  DW  0
WIN_Y1  DW  0
WIN_X2  DW  255
WIN_Y2  DW  191
NPLANES DB   1
BPLIN   DW  254
PALINFO DB   1
PONTY   DB   "Converted with PCX-WRITER plugin by Craz"
TYPEPAL DB  0

;-ZX PALETTE DATA-----------------------

ZX_PAL  DB   0,0,0       ; DARKEN
        DB   0,0,160
        DB   160,0,0
        DB   160,0,160
        DB   0,160,0
        DB   0,160,160
        DB   160,160,0
        DB   160,160,160

        DB   0,0,0       ; LIGHTEN
        DB   20,20,172
        DB   172,20,20
        DB   172,0,172
        DB   20,172,20
        DB   20,172,172
        DB   168,168,0
        DB   168,168,168

        DB   0,0,0
        DB   32,32,32
        DB   64,64,64
        DB   96,96,96
        DB   128,128,128
        DB   160,160,160
        DB   192,192,192
        DB   224,224,224
        DB   0,0,0
        DB   48,48,48
        DB   80,80,80
        DB   112,112,112
        DB   144,144,144
        DB   168,168,168
        DB   200,200,200
        DB   232,232,232
        DB   252,252,252

;-CONVERTER DATA------------------------

NAME001 DB   "phantis pcx"   ;  11 ᨬ!!!

;-PROCEDURES----------------------------

GETPIX  PUSH    BC
        PUSH    DE
        PUSH    HL
        PUSH    DE
        POP     HL
        SRL     D
        RR      E
        SRL     D
        RR      E
        SRL     D
        RR      E
        PUSH    DE
        SLA     E
        RL      D
        SLA     E
        RL      D
        SLA     E
        RL      D
        AND     A
        SBC     HL,DE
        LD      A,L
        AND     7
        LD      B,A
        INC     B
        LD      A,254
        RRCA 
        DJNZ    $-1
        CPL 
        EX AF,AF'

        POP     DE
        LD      HL,#C000
        ADD     HL,DE
        LD      B,H
        LD      C,L

        EX      DE,HL

        LD   A,L
        AND  #1F
        LD   E,A
        SRL  H
        RR L
        SRL  H
        RR L
        SRL  H
        RR L
        LD   A,L
        AND  %11100000
        OR   E
        LD   L,A

        LD      DE,#D800
        ADD     HL,DE

        LD      A,(BC)
        LD      B,A
        EX AF,AF'
        LD      C,A
        LD      A,B
        LD      B,C
        AND     B
        JR      NZ,NOPIXEL
        LD      A,(HL)
        AND     %01111111
        SRL     A
        SRL     A
        SRL     A

GETEXIT LD      C,A
        LD      A,(TYPEPAL)
        ADD     A,C

        POP     HL
        POP     DE
        POP     BC
        RET 

NOPIXEL LD      A,(HL)
        AND     %00000111
        JR      GETEXIT



;-init cache----------------------------

INIT_CACHE
        LD DE,23773
        LD BC,11
        LDIR 

        LD A,LOAD_CAT
        CALL GUI

        LD HL,(END_DISK)
        LD (TEK_SEC),HL

;       LD   A,1
;       CALL DOS
;       RET  C

        LD   HL,0
        LD   (ALL_LENGHT),HL

INIT_CACHE2
        LD   HL,CACHBUF
        LD   (CACHPTR+1),HL
        LD   HL,0
        LD   (CACHSIZ),HL
        AND  A
        RET 

;-write to cache------------------------

WRITE_CACHE

        PUSH DE,AF,HL,IX

CACHPTR LD   HL,CACHBUF
        LD   (HL),A
        INC  HL
        LD   (CACHPTR+1),HL

        LD   A,H
        CP   #C0
        JR   C,CACHQ1

        CALL INIT_CACHE2

        PUSH BC,DE,IX

        CALL PAGE0

        LD   HL,CACHBUF
;       LD   BC,#800
        LD B,8
        LD C,6
        LD DE,(TEK_SEC)
        LD A,DOS_FUNC
        CALL GUI

;       LD   DE,
;       LD   A,2
;       CALL DOS
        JR   C,ERRCACH

        POP  IX,DE,BC

CACHQ1  LD   HL,(CACHSIZ)
        INC  HL
        LD   (CACHSIZ),HL
        LD   HL,(ALL_LENGHT)
        INC  HL
        LD   (ALL_LENGHT),HL

        LD   A,H
        CP   #FE
        JR   NZ,NOT_EOF
        LD   A,L
        CP   #FF
        JR   NZ,NOT_EOF

        PUSH IX
        CALL FLUSH_CACHE
        POP  IX
        JR   C,ERR_C01

        LD   A,"0"
        LD   (NAME001+9),A
        LD   A,"1"
        LD   (NAME001+10),A

        LD   A,7
        OUT  (254),A

        LD   HL,NAME001
        CALL INIT_CACHE
        JR   C,ERR_C01

NOT_EOF POP  IX,HL,AF,DE
        AND  A
        RET 

ERR_C01 POP  IX,HL,AF,DE
        SCF 
        RET 

ERRCACH POP  IX,DE,BC,HL,AF
        SCF 
        RET 

;-flush cashe---------------------------

FLUSH_CACHE

        CALL PAGE0

        LD   HL,(CACHSIZ)
        LD   A,L
        OR   H
        JR   Z,CLOSE_CACHE

        LD   A,L
        AND  A
        JR   Z,ZRCACHL
        INC  H

ZRCACHL LD   B,H

        LD   HL,CACHBUF
;       LD   C,0
;       LD   A,2

        LD C,6
        LD DE,(TEK_SEC)
        LD A,DOS_FUNC
        CALL GUI
;       CALL DOS
        RET  C

CLOSE_CACHE

        LD   DE,(ALL_LENGHT)
        LD C,#FF
        LD A,DOS_FUNC
        CALL GUI

;       LD   A,3
 ;      CALL DOS
        RET 

;-variables-----------------------------

ALL_LENGHT  DW  0
CACHSIZ     DW  0

;-OTHERS--------------------------------

PAGE0   PUSH AF,BC
        LD   BC,#7FFD
        LD   A,#10
        LD (S_PAGE),A
        OUT  (C),A
        POP  BC,AF
        RET 

;-cache buffer--------------------------

        ORG #B800
CACHBUF  DS  #800

        ORG Runner

