
startCONF
           ld hl,mDf_
           call Print_

           ld (.sp_),sp
           ld sp,#BFFE
           ld ix,ZXtype

           ld hl,.prns
           push hl    ;  

           ld hl,#0001 ; 128 K set
           ld (ZXtype),hl
           xor a
           ld (PG_NOTUSED),a

           ld a,(ExtMem_)  ;   
           push af
           ld hl,mDf_auto
           cp 1
          jr z,1F
           ld hl,mDf_ld
1          call Print_
           pop af
           cp 1
          jp z,.zAuto     ; 1 - auto
           cp 255
          jr nz,.idr
            ; load memory driver
              ld hl,ramDRVname
              call FromName
              ld c,#0A
              ld a,DOS_FUNC
              call GUI_
             jr c,.idr0
              ld de,FILE_PARAM
              ld bc,#10
              ldir
              ld hl,(BYTES_LEN)
              ld a,h
              or a
             jr nz,.idr0
              ld a,l
              cp 65
             jr nc,.idr0
              ld (.iBC_),hl
              ld de,(START_SEC)
              ld hl,FBUFF
              ld bc,#0105
              ld a,DOS_FUNC
              call GUI_
             jr c,.idr0
              ld hl,#0101
              ld (ZXtype),hl
              ld de,FBUFF
              ld hl,memRAMdrv
              ld bc,64
.iBC_  EQU $-2
             ret

.idr0       xor a    ; 128
.idr
           ld hl,.setRconf
           push hl
           dec a
           ld bc,#0005    ; 2 - Kay 256K
           dec a
          ret z
           ld bc,#000D    ; 3 - Scorp 256K
           dec a
          ret z
           ld bc,#0021    ; 4 - KAY-1024 K
           dec a
          ret z
           ld bc,#0011    ; 5 - Scorpion ZS-1024
           dec a
          ret z
           ld bc,#1001    ; 6 - PROFI 256-1024
           dec a
          ret z
           ld bc,#0041    ; 7 - Pentagon 512 K
           dec a
          ret z
           ld bc,#0081    ; 8 - Pentagon-1024SL
           dec a
          ret z
           ld bc,#0201    ; 9 - ATM TURBO 256-512 K
           dec a
          ret z
           ld bc,#0401   ; 10 - ATM TURBO 2+ 512 K
           dec a
          ret z
           ld bc,#0601   ; 11 - ATM TURBO 2+ 1024 K
           dec a
          ret z
           ld bc,#0001   ; zx-128 -
          ret
.setRconf  ld (ZXtype),bc
          jr .zNauto

;    Byte 0 :
; 0 - Spectrum 128 K port #7FFD
; 1 - port #1FFD at ZX Spectrum +3,+2A - not extended memory at this port
; 2 - Scorpion/KAY 256K port #1FFD bit 4
; 3 - #C3 at addres #0008 (scorpion monitor) - also flag for reserved page number 8
; 4 - Scorpion 1024K port #1FFD bits 6,7
; 5 - KAY 1024K ports #7FFD bit 7 , #1FFD bit 7
; 6 - Pentagon 512K port #7FFD bits 6,7
; 7 - Pentagon 1024 port #EFF7 present, port #7FFD bit 5 used

;    Byte 1 :
; 0 - Loading RAM driver
; 1 - ATM1 port #FDFD
; 2 - ATM TURBO 2 port #FFF7 + tr-dos 512 K
; 3 - ATM TURBO 2 port #FFF7 + tr-dos 1024 K
; 4 - PROFI port #DFFD
; 5 - ; reserved
; 6 - ; reserved
; 7 - ; reserved


.zAuto     call AutoConf   ; ix= ZXtype

.zNauto    call blnk__
           ld hl,memPlus2A
           bit 1,(ix+0)
          jp nz,.z128k_
     ;      inc a    ; for calculated memory
           ld hl,memProfi
           ld de,rPROFI
           ld bc,lPROFI
           bit 4,(ix+1)
          ret nz
           ld a,%011111   ; turbo 2+ rev 6.40
           bit 3,(ix+1)
          jr z,1F
           ld a,%111111   ; turbo 2+ rev 7.10
1          ld (rTURBO2.r640_710),a  ;   
           ld hl,memTurbo2p
           ld de,rTURBO2
           ld bc,lTURBO2
           bit 2,(ix+1)
          ret nz
           ld hl,memATM1
           ld de,rATM1
           ld bc,lATM1
           bit 1,(ix+1)
          ret nz
           ld hl,memP1024sl
           ld de,rPen1024
           ld bc,lPen1024
           bit 7,(ix+0)
          ret nz
           ld hl,memPent
           ld de,rPen512
           ld bc,lPen512
           bit 6,(ix+0)
          ret nz
           ld hl,memKAY1M
           ld de,rKAY1024
           ld bc,lKAY1024
           bit 5,(ix+0)
          ret nz
           ld hl,memScorp1M
           ld de,rScorp1024
           ld bc,lScorp1024
           bit 4,(ix+0)
          ret nz
           ld hl,memScorp256
           bit 3,(ix+0)
          jr nz,1F
           ld hl,memKAY256
1          ld de,rKAY256
           ld bc,lKAY256
           bit 2,(ix+0)
          ret nz
.z128k     ld hl,mem128k
.z128k_    ld de,rS128
           ld bc,lS128
           pop af    ;    
.prns
            push hl
            ld hl,EXRAM_DRV
            ex de,hl
            ldir            ;  
            call memcount
            pop hl
            call Print_
            ld a,#0D
            rst #10
            call blnk__
       ; calculated out
            ld a,(FullPage)
            ld l,a
            ld h,0
            add hl,hl
            add hl,hl
            add hl,hl
            add hl,hl  ; *16 - memory for Kb
            call PrintHL
            ld hl,memfound
            call Print_
            ld a,#0D
            rst #10
            ld hl,tStart_
            call Print_
            ld a,2
            call ONPAGE
            ld sp,0
.sp_ EQU $-2
            ei
           ret


Print_      ld a,(hl)
            inc hl
            cp #FF
           ret z
            rst #10
           jr Print_


blnk__    ld b,3
1          ld a," "
           rst #10
          djnz 1B
          ret

PrintHL      ld e,"0"     ;    HL
             ld bc,10000
             call 3F
             ld bc,1000
             call 3F
2            ld bc,100
             call 3F
             ld c,10
             call 3F
             ld a,l
             inc a
            jr 5F
3             xor a
4             inc a
              or a
              sbc hl,bc
             jr nc,4B
              add hl,bc
5             add a,"0"-1
              cp e
             ret z
              dec e
              rst #10
             ret

mDf_            DB "Memory definition ",#FF  ; 22 chars
mDf_ld          DB "loading",13,#FF
mDf_auto        DB "...",13,#FF

mem128k         DB "ZX-Spectrum standart",#FF
memPlus2A       DB "Spectrum +2A(+3)",#FF
memScorp256     DB "Scorpion ZS-256",#FF
memScorp1M      DB "Scorpion ZS-1024",#FF
memKAY256       DB "KAY-256",#FF
memKAY1M        DB "KAY-1024",#FF
memTurbo2p      DB "ATM TURBO 2+",#FF
memATM1         DB "ATM TURBO",#FF
memProfi        DB "PROFI",#FF
memPent         DB "Pentagon",#FF
memP1024sl      DB "Pentagon-1024SL",#FF
memRAMdrv       DB "RAM driver",#FF

memfound        DB " kb memory found",#FF

tStart_         DB "Load modules & start ...",#FF


FullPage        DB 0    ;       (  63 : 1024 K)


BINprint      ld l,a
              ld b,8
1             xor a
              rl l
              adc a,48
              rst #10
             djnz 1B
              ld a,32
              rst #10
             ret

OUTC_A      ld (.hl),hl
            ld hl,#2A53   ; 10835
            push hl
            ld hl,0
.hl  EQU $-2
           jp #3D2F       ; 15663



ZXtype  DB 0,0  ; 2 bytes for configure

;    Byte 0 :
; 0 - Spectrum 128 K port #7FFD
; 1 - port #1FFD at ZX Spectrum +3,+2A - not extended memory at this port
; 2 - Scorpion/KAY 256K port #1FFD bit 4
; 3 - #C3 at addres #0008 (scorpion monitor)
; 4 - Scorpion 1024K port #1FFD bits 6,7
; 5 - KAY 1024K ports #7FFD bit 7 , #1FFD bit 7
; 6 - Pentagon 512K port #7FFD bits 6,7
; 7 - Pentagon 1024 port #EFF7 present, port #7FFD bit 5 used

;    Byte 1 :
; 0 - Loading RAM driver
; 1 - ATM1 port #FDFD
; 2 - ATM TURBO 2 port #FFF7 + tr-dos 512 K
; 3 - ATM TURBO 2 port #FFF7 + tr-dos 1024 K
; 4 - PROFI port #DFFD
; 5 - ; reserved
; 6 - ; reserved
; 7 - ; reserved

AutoConf    ; Code based of AUTOCONF and TST procedures in old 'init.asm' file
            ; 128 k  ,   

             call zx_test
             ld bc,#7FFD
             ld a,#10
             out (c),a
             ld (#5B5C),a
             ei
           ret


zx_test
             ld hl,#C000
             ld bc,#7FFD
             ld a,#10
             out (c),a

            di

.turbo2              ; Turbo 2+ - #FFF7 + TR-DOS
        ;   ld hl,#C000
        ;  jr .profi

            ld a,#17 ; 7 -bank to #C000
            out (c),a
            ld hl,0
            ld (#C000+1111),hl
            ld hl,(1111)
            ld a,%00011111 ; rom48 to #C000
            call t2tstOUT
            ld de,(#C000+1111)
            or a
            sbc hl,de      ; rom48 present in #C000 ?
           push af
            ld a,#FF
            call t2tstOUT
           pop af
           ld hl,#C000
          jr nz,.profi
            set 2,(ix+1)  ;  turbo 2+ 512K
            ;   6.xx  7.xx
            ld a,%01100000   ;    6.40
            call OUTC_A
            ld e,(hl)
            ld (hl),a
            ld d,a
            ld a,%01000000   ;    7.10     6.40
            call OUTC_A
            push bc
            ld c,(hl)
            ld (hl),a
            cp (hl)
            ld (hl),c
            pop bc
           jr nz,1F
            ld a,d
            call OUTC_A
            ld a,(hl)
            cp d
            ld (hl),e
           jr nz,1F
            set 3,(ix+1)   ; turbo 2+ 1024 K (rev7.10)
1           ld a,#FF
           jp OUTC_A           ; 0 - bank

.profi      ld bc,#DFFD
            ld de,#0007
            call tstM
           jr nz, .kay__
            set 4,(ix+1)  ;  profi
           ret

.kay__      ;    #1FFD  +2A,+2B,+3   KAY & SCORPION & PHOENIX
          ld b,#7F
          ld a,#11
          out (c),a  ; 1 seg
          ld (hl),a
          ld a,#10
          out (c),a  ; 0 seg
          xor a
          ld (hl),a
          ld (#4000),a
          ld b,#1F
          out (c),a    ; rom set
          ld a,(0) ; rdlow-ok
          or a
         ret z     ;  
          ld a,1
          out (c),a    ; swap rom to ram
          ld a,(0) ; rdlow-ok
          or a
         jr nz,.atm1        ; not present port #1FFD

          ld a,(#4000)  ; #11 for +2A/+3  or #00 for others
          add a,a
          add a,a
          and 4       ;      +2A/+3  0  
          out (c),a   ; return rom to #0000
         jr z,.kay_scorp
          set 1,(ix+0); spectrum +2A / +2B / +3
         ret

.kay_scorp
          ld de,#0010
          ld b,#1F
          call tstM
         jr nz,.atm1  ;   #1FFD
          set 2,(ix+0)  ; scorpion/kay 256K
          ld a,(#0008)  ; rdlow-ok
          cp #C3
         jr nz,1F
          set 3,(ix+0)   ;   rst 8 ( Scorpion ? )
          ld a,8
          ld (PG_NOTUSED),a ;  8- 
1      ;   scorpion or kay 1024
          ld de,#0080
          call tstM  ;    7-   #1FFD (scorp1024/KAY1024)
         ret nz   ; 256 K only or non standart
          ld b,#7F
          ld de,#1090
          call tstM  ;    7-   #7FFD (KAY1024)
         jr nz,.sc1024
          set 5,(ix+0)  ; KAY1024 ports
         ret
.sc1024   set 4,(ix+0) ;scorpion 1024
         ret


.atm1      ld b,c    ; #FDFD
           ld de,#0110
           call tstM
          jr nz,.penta
           set 1,(ix+1)
          ret

.penta     ld b,#7F
           ld de,#10D0
           call tstM  ;     256/512
          ret nz  ;  
           set 6,(ix+0) ;   512
           ;    #EFF7 (Pentagon1024sl)
           ld a,(0) ; rdlow-ok
           cpl
           ld e,a
           ld (#C000),a  ; RAM-0 after tstM
           ld a,8
           ld bc,#EFF7
           out (c),a  ;  set RAM-0 to ROM #0000
           ld a,(0) ; rdlow-ok
           ex af,af'
           xor a
           out (c),a  ; return ROM #0000
           ex af,af'
           cp e
          ret nz         ; not pentagon1024sl
           set 7,(ix+0)  ; pentagon 1024 sl
          ret

t2tstOUT   ld bc,#FFF7  ; turbo2 test
           call OUTC_A  ;  ATM   trdos port #FF
           ld a,(23830) ;   FF  trdos
           ld c,#FF     ; port #FF trdos
           call OUTC_A
           ld a,#D0
           ld c,#1F
          jp OUTC_A

tstM       out (c),e    ; z - , nz - 
           call .tst1
           ld a,(hl)
           ex af,af'
           ld (hl),e
           out (c),d
           call .tst1
           ld a,(hl)
           push af
           ld (hl),d
           out (c),e
           call .tst1
           ld a,(hl)
           ex af,af'
           ld (hl),a
           out (c),d
           call .tst1
           pop af
           ld (hl),a
           ex af,af'
           cp e
          ret
.tst1
           ld a,b
           cp #7F
          ret z
           push bc
           ld b,#7F
           ld a,#10
           out (c),a
           pop bc
          ret

   ;  

memcount   ld hl,TABL_PG
           ld bc,64
           ld de,TABL_PG+1
           ld (hl),b
           ldir             ;    0-

           ld hl,#C000
           ld de,RSCT+63   ;   #5B00+63 (0-63)-64 
           ld b,64         ;   
1          ld a,b
           dec a
           call EX_RAM
           ld a,(hl)
           ld (de),a
           dec de
          djnz 1B    ;     

           ld b,64
1        ld a,b
           dec a
           call EX_RAM
           ld (hl),a
           ld a,c
          djnz 1B    ;    

           ld de,TABL_PG+63   ;    
           ld bc,#4000   ; b -   , c -   
1          ld a,b
           dec a
           call EX_RAM
           cp (hl)
          jr nz,2F
           ld (de),a
           inc c
2          dec de
          djnz 1B
           ld a,c
           ld (ExtPage),a
           ld (FullPage),a
;           ld b,a
;           cp 24
;           ld a,#FF
;          jr nc,1F
;           xor a
;1          ld (ExtPgns),a
;           ld a,b
           cp 9
           ld a,#FF
          jr nc,1F
           xor a
1          ld (ExtMem),a    ;   . 

           ld b,64
           ld hl,RSCT+63
1          ld a,b
           dec a
           call EX_RAM
           ld a,(hl)
           ld (#C000),a
           dec hl
          djnz 1B    ;  ,  0- 

           ld a,(ZXtype)
           and 8
          jr z,1F
           ld a,(PG_NOTUSED)
           or a
           call nz,DelPage    ;  ,   
1          ld a,2          ;  2-  5-   .
           call DelPage
           ld a,5
     ;      (  0-)
DelPage    ld hl,TABL_PG
           ld b,64
.l1        cp (hl)
          jr z,1F    ;    
           inc hl
          djnz .l1
           scf
          ret        ;    
1          ld de,TABL_PG+63
           ex de,hl
           or a
           sbc hl,de
           ld b,h
           ld c,l     ; bc -   
           ld h,d
           ld l,e
           inc hl
           ldir
           ld hl,ExtPage
           dec (hl)
          ret





;---------------------------------------
         DISPLAY " "
         DISPLAY "RAM drivers for modeles"
         DISPLAY " "


rScorp1024                 ; Scorpion 1024
            DISP EXRAM_DRV
;              ld d,a
;              rlca
;              and %10000
;              ld e,a
;              ld a,d
;              rlca
;              rlca
;              and %11000000
;              or e
;              ld bc,#1FFD
;              out (c),a
;              nop
;              ld b,#7F
;              ld a,d
;              and 7
;              or #10
;              out (c),a
;              nop
;             ret

              ld d,a
              rlca
              ld e,a
              rlca
              and %11000000
              xor e
              and %11101111
              xor e
              ld bc,#1FFD
              out (c),a
              nop
              ld b,#7F
              ld a,d
              and 7
              or #10
              out (c),a
              nop
             ret

            ENT
lScorp1024  EQU $-rScorp1024

   DISPLAY "lScorp1024  :",/a,lScorp1024


rKAY256                 ; KAY 256 / Scorpion 256
             DISP EXRAM_DRV

              ld d,a
              and %1000
              add a,a
              ld bc,#1FFD
              out (c),a
              nop
              ld b,#7F
              ld a,d
              and 7
              or #10
              out (c),a
              nop
             ret

            ENT
lKAY256 EQU $-rKAY256

    DISPLAY "lKAY256  :",/a, lKAY256


rKAY1024                    ; KAY 1024
             DISP EXRAM_DRV

               add a,a
               ld d,a
               add a,a
               ld e,a
               and %10000000
               xor d
               and %11101111
               xor d
               ld bc,#1FFD
               out (c),a
               nop
               ld b,#7F
               ld a,e
               add a,a
               add a,a
               ld a,d
               rra
               and %10000111
               or #10
               out (c),a
               nop
              ret

            ENT
lKAY1024   EQU $-rKAY1024

       DISPLAY "lKAY1024  :",/a,lKAY1024


rS128                   ; Spectrum 128
            DISP EXRAM_DRV

              and 7
              or #10
              ld bc,#7FFD
              out (c),a
             ret

            ENT
lS128  EQU $-rS128

    DISPLAY "lS128  :",/a, lS128


rPen512                 ; pentagon 256/512
            DISP EXRAM_DRV

              ld d,a
              and %00011000
              add a,a
              add a,a
              add a,a
              xor d
              and %11111000
              xor d
              or #10
              ld bc,#7FFD
              out (c),a
              nop
             ret

            ENT
lPen512 EQU $-rPen512

    DISPLAY "lPen512  :",/a, lPen512


rPen1024                ; pentagon 1024   #7ffd c bit 5
            DISP EXRAM_DRV

              ld d,a
              and %00011000
              add a,a
              add a,a
              add a,a
              xor d
              and %11011000
              xor d
              or #10
              ld d,a
              and %11000000
              ld a,d
             jr z,1F            ;    REAL COMMANDER (   512 K )
              xor %00100000     ;   ram-  pentagon-512
1             ld bc,#7FFD
              out (c),a
              nop
             ret

           ENT
lPen1024  EQU $-rPen1024

    DISPLAY "lPen1024  :",/a,lPen1024



 ; out #FDFD (: %1nnnnn0n nnnnnn0n) - :

 ;D0-D1 -     512

rATM1           ; ATM-turbo 1  512 K
            DISP EXRAM_DRV
              ld d,a
              rrca
              rrca
              rrca
              and 3
              ld bc,#FDFD
              out (c),a
              nop
              ld a,d
              and 7
              or #10
              ld b,#7F
              out (c),a
              nop
             ret
           ENT
lATM1  EQU $-rATM1

          DISPLAY "lATM1  :",/a,lATM1


rTURBO2       ; ATM TURBO 2+  EVO BASE CONF
            DISP EXRAM_DRV
              ld d,a
              and %111111
.r640_710 EQU $-1-EXRAM_DRV+rTURBO2    ; %11111 for 6.40 & %111111 for 7.10
              cpl
              call .outc
              ld a,d
              and 7
              or #10
              ld bc,#7FFD
              out (c),a
              nop
             ret
.outc         ld bc,#2A53
              push bc
              ld bc,#FFF7
             jp #3D2F
            ENT
lTURBO2  EQU $-rTURBO2

         DISPLAY "lTURBO2  :",/a,lTURBO2


rPROFI        ; PROFI 256-1024
           DISP EXRAM_DRV
              ld d,a
              rrca
              rrca
              rrca
              and 7
              ld bc,#DFFD
              out (c),a
              nop
              ld a,d
              and 7
              or #10
              ld b,#7F
              out (c),a
              nop
             ret
           ENT
lPROFI   EQU $-rPROFI

         DISPLAY "lPROFI  :",/a,lPROFI


;--------------------------------------------

;RAM_EXTENTION    INCBIN "exram.bin"
;LRAM_EXTENT  EQU $-RAM_EXTENTION

;--------------------------------
         DISPLAY " "

         DISPLAY "LEN AUTOCONF :",/a,$-startCONF
