; [Overlay] Plug-in module for BGE /    BGE

;  !      BGE        /DA

;Brush for BGE

           ORG PgnAdr      ;   

BrushOvb   LD (.RETAD+1),HL
           CALL MBrs
           XOR A
.RETAD    JP 0

BRbuff  EQU #BA00           ;          768 (#0300) 
BYbuff  EQU #BD00           ;     Y
BXbuff  EQU #BE00           ;     X ( Bbuff)
Bbuff   EQU #BF40           ;   


MBrs       call SV_UNDO
           ld (BBrs.spp),sp

          ;   BRS_at_PAGES          ;      macro in 'Bge.asm'
             xor a
             call BBrs.LS_data  
              
             call BBrs.n_5
           call EraseAllw     ; BBrs.eraseallw
           call BBrs.P_svBF   ;.saveSCR
BBrs       call ReWin.i
.n_        ld a,%1111
.n0        ld ix,WBrush
           ld (ix+6),a
           call .Tmode
           ld a,(REALRGB)
           ld (WBrush.dtcol),a
           call Win_
           cp #FF
          jr nz,.n1
.exit
           call CLOSE

          ;  BRS_to_PAGES    ;     macro in 'Bge.asm'
           ld a,1
           call BBrs.LS_data

           ld sp,0
.spp     EQU $-2
          ret

.n1        ld c,a
           sub 23
          jr c,.n3          ;  
           ld bc,.TBbrush
           call TAB_JP
.n2        ld a,%1101
          jr .n0

.n3        ld a,c
           sub 8
          jr nc,.n4
           ld de,Brs_ne       ;   
           ld l,c
           ld h,0
           add hl,hl
           add hl,hl
           add hl,hl
           add hl,hl
           add hl,hl  ; *32
           add hl,de
           ld de,BrsBOOF.spr
           ld bc,32
           ldir
           ld b,32
           ld a,#FF
1          ld (de),a
           inc de
          djnz 1B
           ld hl,BrsBOOF.sx
           xor a
           ld (hl),a
           inc hl
           ld (hl),a
           inc hl
           ld a,7
           ld (hl),a
           inc hl
           ld (hl),a
          jr 1F
.n4        call .bmul68
           ldir
1          call .n_5
          jr .n2

.n_5       ld hl,BrsBOOF.msk
           ld b,32
            ld a,#FF
2           and (hl)
           djnz 2B
            cpl
            or a
           jr z,3F
            ld a,#FF
3           ld (WBrush.FLMsk),a
           ret

.bmul68    ld l,a           ;   
           ld h,0
           ld de,Brs_64
           add hl,hl
           add hl,hl    ; *4
           ld b,h
           ld c,l
           add hl,hl
           add hl,hl
           add hl,hl
           add hl,hl    ; *64
           add hl,bc    ; *68
           add hl,de
           ld de,BrsBOOF.sx
           ld bc,68
          ret

             ;    DithCAN

;.eraseallw   ld hl,#C000+6912
;             jp ERASE_ALLW.hl

    ; /    Pgn2
.LS_data        ld c,a  ; a=0 - read , a=1 - write data
                ld a,PgnPage2
                call RAM
                ld hl,Brs_Psv
                ld de,BrsBOOF
                dec c
               jr nz,1F
                ex de,hl
1               ld bc,Brs_All_len
                ldir
               jp RAM_GUI

.P_svBF      ld de, BUFF
             ld hl,.P_strt
             ld bc,.P_len
             ldir
            jp BUFF

.P_strt    ld a,ScrPage
           call RAM
           ld hl,SCREEN
           ld de,#A500
           ld bc,6912
           call SwapSCRS.swp
           push hl,de,bc
           ld a, SuxPage
           ex de,hl
           call RAM
           ldir
           pop bc,de,hl
           ld a,ScrPage
           call RAM
          jp SwapSCRS.swp
.P_len  EQU  $-.P_strt

.saveSCR_    xor a
             ld (.fl_undo),a
.saveSCR     call .P_svBF
            jp SAVESCR


.exSundo     ld a,0
.fl_undo   EQU $-1
             or a
             call nz,.saveSCR_
             call OSP
             call SWAP_SCR.T
            jp SAVESCR




.TBbrush  DW   .load        ; 0 open   (+23 for real number)
          DW   .save        ; 1 save
          DW   Ret          ; 2 smooth
          DW   .StDp        ; 3 steps / distances
          DW   .to_set        ; 4 to set                 ;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
          DW   Ret          ; 5 msk +/-
          DW   .S_mode      ; 6 mode
          DW   .Draw        ; 7 draw
              ;  
          DW   .Draw        ; 8   brush
          DW   .noRGB       ; 9   no rgb
          DW   PRGB2        ; 10  rgb
          DW   PRGB2        ; 11  dt
         ; DW   PMask        ; 12  Pmask
          DW   .PMask       ; 12  Pmask
          DW   .Bedit       ; 13  edit brush
          DW   .Bedit       ; 14  edit mask

          DW   .md_xor      ; 15  xor
          DW   .md_or       ; 16  or
          DW   .md_and      ; 17  and
          DW   .md_nop      ; 18  nop

.PMask        call CLOSE
              pop af
              call PMask
             jp .n_


.noRGB     ld hl,WBrush.norgbC
          jp SwBut

.Tmode      ld a,(Sieve)
            or a
            ld a,6
           jr z,1F
            dec a
1           ld (WBrush.pmskCol),a
            ld hl,WBrush.Tmods
            ld a,1
.Mode   EQU $-1                  ;   (1-or)
            ld e,a
            add a,a
            add a,a
            ld c,a
            ld b,0
            add hl,bc
            ld a,e
            ld de,WBrush.Tmode
            ld bc,3
            ldir
           ret

.md_xor    xor a
          jr 1F
.md_or     ld a,1
          jr 1F
.md_and    ld a,2
          jr 1F
.md_nop    ld a,3
          jr 1F
.S_mode    ld ix,WBrush.Wmods
           call .WIN
           cp 4       ;  
          ret nc
1          ld (.Mode),a
          ret

.WIN       call POPUP
           ld a,%1110
           ld (ix+6),a
           call Win_
           push af
           call CLOSE
           pop af
          ret


.load       call .adrset
            push de,bc
            call FilerE
            pop bc,hl
           ret c
            ld a,(SEC_LEN)
            cp b
           jr nz,.load
            ld c,#05
            ld de,(START_SEC)
            call DOS_FUNC_
           ret c
            ld de,.ToName
            call ToName
           ret


.save       call .adrset
            push de,bc
            ld hl,.ToName
            call FNEdit
            pop bc,de
           ret c
            push de,bc
            ld hl,.ToName
            call FromName
            pop de,hl
            ld b,d
            ld c,#0B
            call DOS_FUNC_
           ret

.adrset     ld de,Brs_sv   ;  de -  , bc - , hl -  
            ld bc,#0400
            ld hl,.brsort
           ret

.brsort      DB #01,"brs",#FF
.ToName      DB "bgebrs  brs",0


.Bedit                                  ;  
              push ix
.edt0          call .toBUFF
               ld hl,.WbrsED
               call SPEdit
               ld c,a
               call .atBUFF
               ld a,c
               cp #FF
              jr nz,1F
               call CLOSE
              pop ix
              ret
1              ld bc,.TBbrED
               call TAB_JP
.Enext         ld a,%1101
               ld (ix+6),a
              jr .edt0

.atBUFF       ld hl, #771A    ; hl = [ ld a,(de) : ld (hl),a ]  ; reg C not used
             jr 1F
.toBUFF       ld hl, #127E    ; hl = [ ld a,(hl) : ld (de),a ]
1             ld (.Bhd__),hl
              ld hl,BrsBOOF.msk
             push hl
              ld hl,BrsBOOF.spr
              ld de,BUFF
              ld b,16
1             call .Bhd__
              call .Bhd__
             ex (sp),hl
              call .Bhd__
              call .Bhd__
             ex (sp),hl
             djnz 1B
              pop hl
             ret
.Bhd__        ld a,(hl) : ld (de),a   ;   ld a,(de) : ld (hl),a
              inc de
              inc hl
              ret
.BtoM         ld hl,BrsBOOF.spr
              ld de,BrsBOOF.msk
.btom__       ld bc,32
             push de
              ldir
             pop hl
.inv__        ld b,32
1             ld a,(hl)
              cpl
              ld (hl),a
              inc hl
             djnz 1B
             ret
.MtoB         ld de,BrsBOOF.spr
              ld hl,BrsBOOF.msk
             jr .btom__
.Binv         ld hl,BrsBOOF.spr
             jr .inv__
.Minv         ld hl,BrsBOOF.msk
             jr .inv__
.Bcln          ld hl,BrsBOOF.spr
               xor a
.cln__         ld b,32
1              ld (hl),a
               inc hl
              djnz 1B
              ret
.Mcln          ld hl,BrsBOOF.msk
               ld a,#FF
              jr .cln__
.Btake          ld de,BrsBOOF.spr
.take__         push ix
                call .ramka
               jr c,.t__e
                call SaveWS
.t__e           call SWAP_SCR
                pop ix
               ret
.Mtake          ld de,BrsBOOF.msk
               jr .take__
.Btoscr         ld de,BrsBOOF.spr
.toscr__        push ix
                call .ramka
               jr c,.t__e
                call LoadWS
               jr .t__e
.Mtoscr         ld de,BrsBOOF.msk
               jr .toscr__

.ramka          push de
                call SWAP_SCR
                ld ix,WBrush.ixedbox
                xor a
                call Ramka8
                pop de
               ret

.TBbrED      DW  .BtoM        ; 0 >>i
             DW  .MtoB        ; 1 i<<
             DW  .Bcln        ; 2 clean b
             DW  .Binv        ; 3 inv b
             DW  .Btake       ; 4 take b
             DW  .Btoscr      ; 5 to scr b
             DW  .Mcln        ; 6 clean m
             DW  .Minv        ; 7 inv m
             DW  .Mtake       ; 8 take m
             DW  .Mtoscr      ; 9 to scr m
             DW  Ret          ; prev button

.WbrsED   DB 0,0  ; X,Y  (X,Y of window)
          DB 18       ;  (width)
          DB 17       ;  (height)
.EdAdr    DW BUFF     ;    
          DW #0103    ; X,Y   (X,Y of editor window)
.EdTSize  DW #0402    ;   (sprite size)
          DW #070C    ; X,Y preview
          DW .EdText  ;  (text)
          DW .EdSel   ;  (highlighting)
          DW Nil      ;   (hotkeys)


.EdText   MSG_BRUSH_headED : DB 13
          DB 22,6,11,"Brs | Msk",13,22,8,14,">>i",13,"i<<",13
          DB 22,1,12
          MSG_EDITS_Clean : DB 13
          MSG_EDITS_Invert : DB 13
          MSG_EDITS_Take : DB 13
          MSG_EDITS_Put : DB 13
          DB 22,12,12
          MSG_EDITS_Clean : DB 13
          MSG_EDITS_Invert : DB 13
          MSG_EDITS_Take : DB 13
          MSG_EDITS_Put
          DB 0

.EdSel    DB 8,14,2,1,%11  ; 0 >>i
          DB 8,15,2,1,%11  ; 1 i<<
          DB 1,12,5,128+4,%11  ; 2 clean b ; 3 inv b ; 4 take b ; 5 to scr b
          DB 12,12,5,128+4,%11 ; 6 clean m ; 7 inv m ; 8 take m ; 9 to scr m
          DB #FF


.StDp       ld ix,WBrush.WStDp                  ;  / 
            call POPUP
            ld a,%1110
.StDp_      ld ix,WBrush.WStDp
            ld (ix+6),a
            call WBrush.cnvTsd
            ld hl,(WBrush.stX+1)
            ld (WBrush.T_stX),hl
            ld hl,(WBrush.stY+1)
            ld (WBrush.T_stY),hl
            ld hl,(WBrush.dsX+1)
            ld (WBrush.T_dsX),hl
            ld hl,(WBrush.dsY+1)
            ld (WBrush.T_dsY),hl
            call Win_
            cp #FF
           jp z,CLOSE
            cp 4
           jr nc,1F
            ld c,a
            ld b,0
            push bc
            call .StDpS
            pop bc
            cp 16
           jr nc,2F
            ld hl,BrsBOOF.sx
            add hl,bc
            ld (hl),a             ;  Z  ,    jr nz,2F
1          jr nz,2F
            ld hl,BrsBOOF.sx     ; 
            xor a
            ld (hl),a
            inc hl
            ld (hl),a
            inc hl
            ld a,7
            ld (hl),a
            inc hl
            ld (hl),a
2           ld a,%1100
           jr .StDp_

.StDpS      ld ix,WBrush.WStDpS
           jp .WIN

.to_set
           call .IFbrs
          ret c
           ld a,%1111
           ld ix,WBrush.Wsel15
           ld (ix+6),a
           call POPUP
           call Win_
           cp #FF
          jr z,1F
            call .bmul68   ;    
            ex de,hl
            ldir
1          jp CLOSE


.IFbrs                                   ;   
          ld a,#0C           ; 'inc c'
          ld (.IFbrsY0),a
          ld hl,BrsBOOF.spr
          ld de, 0            ; de - OR  
          ld bc,#1000         ; b=16 -   ,c=0 ; c - 1-   
1          ld a,(hl)
           inc hl
           or e
           ld e,a
           ld a,(hl)
           inc hl
           or d
           ld d,a
           or e
          jr z,.IFbrsY0
           xor a            ; 'nop'
           ld (.IFbrsY0),a
           ld a,c
           ld (.startY),a   ;      Y
.IFbrsY0   inc c            ; inc c  /or/  nop
         djnz 1B
           ld h,c           ; h = .startY
           ld a,d
           or e
         jr nz,1F
          ld ix,.er_Embrs    ;  -  
          ld a,%1111
          ld (ix+6),a
          call Win_
          call CLOSE
          scf
         ret
1         ld a,d
          ld c,e
          ld b,16            ;      X
1         rla
          rl c
         jr c,2F
         djnz 1B
2         ld a,16
          sub b
          ld (.startX),a
          ld l,a             ; l = .startX
          ld a,e
          ld c,d
          ld b,16            ;      X
1         rra
          rr c
         jr c,2F
         djnz 1B             ;     
2         dec b
          ld a,b
          ld (.endX),a
          ld e,a             ; e = .endX
          and 7
          neg
          add a,8
          ld (.codeX8),a
         push hl
          ld hl,BrsBOOF.spr+31
          ld b,16
1         ld a,(hl)
          dec hl
          or (hl)
         jr nz,2F
          dec hl
         djnz 1B          ;     
2        pop hl
          dec b
          ld a,b
          ld (.endY),a     ;     Y
          sub h            ; .endY-.startY
          ld (.szY),a
          ld a,e
          sub l            ; .endX-.startX
          ld (.szX),a
          xor a            ; erase c-flag
         ret


;                     

.startX    DB 0   ;     X
.startY    DB 0   ;     Y

.colset     ld a,(MASKRGB)      ;    
            ld (.drwcol1),a
            ld c,a
            ld a,(REALRGB)
            or c
            xor c
            ld (.drwcol2),a
            ld a,(WBrush.norgbC)
            cp 7
            ld a,#1A             ;  a=ld a,(de)   ; rgb
           jr z,1F
            ld a,#C9             ;  a=ret         ; norgb
1           ld (.drwNOrgb),a
           ret


.stepset    ld de,BYbuff+1      ;   
            ld hl,BYbuff        ;    X  Y
            ld (hl),#00
            ld bc,Bbuff-BYbuff-1
            ldir
.stepsetY   ld a,(ARWYMX)
            inc a
            ld (.stepYmax),a
            ld a,(BrsBOOF.sy)
            ld h, high BYbuff
            ld c,a             ; c - 
            inc c
            ld a,(BrsBOOF.dy)  ; 
            ld b,a
            ld a,(.endY)
            sub b              ; 1- . = (.endY)-(BrsBOOF.dy)
            ld e,a
           jr nc,2F
1           add a,c
            bit 7,a
           jr nz,1B
2           ld l,a
            ld (hl),#FF
            add a,c
            cp 0
.stepYmax  EQU $-1
           jr c,2B
            ld a,e               ;   
            ld h, high BYbuff
1           sub c
            bit 7,a
           jr nz,.stepsetX
            ld l,a
            ld (hl),#FF
           jr 1B

.stepsetX   ld a,(DarwXM)
            inc a
            ld (.stepXmax),a
            ld hl,BXbuff
            ld a,(BrsBOOF.sx)

1           ld c,a             ; c - 
            inc c
            ld a,(BrsBOOF.dx)  ; 
            ld b,a
            ld a,(.endX)
            sub b              ; 1- . = (.endX)-(BrsBOOF.dx)
            ld e,a
           jr nc,2F
1           add a,c
            bit 7,a
           jr nz,1B
2           ld l,a
            ld (hl),#FF
            add a,c
           jr nc,2B
            inc h
3           cp 0
.stepXmax  EQU $-1
           jr nc,4F
            ld l,a
            ld (hl),#FF
            add a,c
           jr 3B
4           ld a,e              ;   
            ld h, high BXbuff
1           sub c
            bit 7,a
           ret nz
            ld l,a
            ld (hl),#FF
           jr 1B

.Brotate                        ;      
              ld hl,BrsBOOF.spr
              ld de,BRbuff
              ld a,8
1             push af
              call .Brot0
              pop af
              dec a
             jr nz,1B
             ret

.Brot0        ld (.curBBB),a
              ld (.curBBB_),a
              push de
              ld hl,BrsBOOF.spr

              ld c,16            ;   
1             ld b,0
.curBBB  EQU $-1
              xor a
              ld e,(hl)
              inc hl
              ld d,(hl)
              inc hl
2              or a
               rl d
               rl e
               rla
             djnz 2B
               ex (sp),hl
               ld (hl),a
               inc hl
               ld (hl),e
               inc hl
               ld (hl),d
               inc hl
               ex (sp),hl
              dec c
             jr nz,1B

              ld c,16         ;    hl=BrsBOOF.msk , (sp)=BRbuff+16*3+ {?*(16*3)}
1             ld b,0
.curBBB_ EQU $-1
              ld a,#FF
              ld e,(hl)
              inc hl
              ld d,(hl)
              inc hl
2              scf
               rl d
               rl e
               rla
             djnz 2B
               ex (sp),hl
               ld (hl),a
               inc hl
               ld (hl),e
               inc hl
               ld (hl),d
               inc hl
               ex (sp),hl
              dec c
             jr nz,1B
               pop de
              ret

.arwRES      ld hl,Ret        ;    
             ld d,h
             ld e,l
             ld a,ARW_NEW
            jp GUI

.Draw
            call .IFbrs
           ret c
            ld a,(BrsBOOF.sx)    ;   
            inc a
            or a
            rra
1           ld (.stpXmg_),a
            ld a,(BrsBOOF.sx)
            inc a
            or a
            rra
1           ld (.stpYmg_),a

            ex (sp),hl
            ld hl, BBrs
            ex (sp),hl      ;    
.Draw_      call EraseAllw  ; .eraseallw
            call LOADSCR
            call .arwRES
            call .DrInt_X

.LpDraw_      ld a,(.fl_undo)
              or a
              call nz,.saveSCR_

.LpDraw       call .colset
              call .stepset
              call .Brotate

              ld a,(.Mode)
              ld bc,.TBdraw
              call TAB_JP
              call .setSmooth

             ld (.DrawSP),sp
             ld ix,.DBrush
             ld a,%11000
             ld (ix+6),a
             call .DrIntXY
             ld hl,(LINE.plotADR)
             ld (.rplotADR),hl
             ld hl,.Bplot
             ld (LINE.plotADR),hl
             call Win_
             ld hl,0
.rplotADR   EQU $-2
             ld (LINE.plotADR),hl
              push af
              call .resCUR
              pop af
             cp #FF
            jr z,.Draw_QUIT

             ld hl,.LpDraw
             ld c,a
             push hl
               or a       ; 0 Color
              jr z,.Drgb
               dec a      ; 1 NO RGB
              jp z,.noRGB
               dec a      ; 2 K Color
              jp z,Col
               dec a      ; 3  last cancel
              jp z,.exSundo
               dec a      ; 4  Smooth +/-
              jp z,.exSmooth
             ld hl,.LpDraw_
             ex (sp),hl
               dec a      ; 5 - 8 -> xor , or , and , nop
               cp 4
              jr nc,1F
               ld (.Mode),a
              ret
1              push af          ;   
               call .saveSCR_
               pop af
               ld hl, LOADSCR
              push hl
               sub 4           ; 9 load Undo
              jp z,LOADUNDO
               dec a           ; 10 swap Undo
              jp z,LD_UNDO
               dec a           ; 11 save Undo
              jp z,SV_UNDO
              pop hl
               dec a           ; 12 Mask+/-
              jr z,.exMsk
             ret               ;   analog => [pop hl : jp (hl)] ->.LpDraw_

.Draw_QUIT  ld sp,0
.DrawSP   EQU $-2
            call .resDarw
           jp SAVESCR

.resDarw    ld hl,(DarwX)
            ld a,h
            or a
            ld a,l
           jr z,1F
            xor a
            ld (DarwXM),a
            cpl
1           ld (ARW_X),a
            ld hl,ARWXMN
            xor a
            ld (hl),a
            inc hl
            ld (hl),255
            inc hl
            ld (hl),a
            inc hl
            ld (hl),191
            ld a,(ARW_Y)
            cp 192
           jr c,1F
            ld a,191
            ld (ARW_Y),a
1           ld a,ARW_OLD
           jp GUI

.Drgb       call .resDarw
            call PRGB2
           jp .arwRES

.exSmooth   ld a,(WBrush.FlSmooth)
            cpl
            ld (WBrush.FlSmooth),a
.setSmooth   ld a,(WBrush.FlSmooth)      ; 
             ld hl,.notSmooth
             or a
            jr z,1F
             ld hl,.yesSmooth
1            ld (.csmoothA),hl
           ret
.exMsk      ld a,(WBrush.FLMsk)
            cpl
            ld (WBrush.FLMsk),a
           ret




.Ddisp_
              ld hl,0
.teX     EQU $-2
              ld b,h
              ld c,l
              ld de,0           ;  X
.lastX   EQU $-2
              or a
              sbc hl,de
              ld (.LdX),hl          ;    X
              ld a,h
              or l
              ex af,af'

              ex de,hl
              ld de,#0000
.codeX8    EQU $-2
              add hl,de
              ld a,l
              rr h
              rra
              rra
              rra
              and #3F
              ld l,c
              ld c,a
              ld h,b
              add hl,de
              ld a,l
              rr h
              rra
              rra
              rra
              and #3F
              sub c
              ld (.LdX8),a         ;    X   

              ld a,0
.teY      EQU $-1
              ld d,0
.lastY    EQU $-1
              sub d
              ld (.LdY),a           ;    Y
              ld d,a
              ex af,af'
              or d
             ret

.DrawInt    ;    -      
             di               ; di -   !    -   ))

              ld a,(DIRECT)
              and #10
              ld (.Pfire),a
             jr nz,1F
              ld (.flnewFr),a
              ld (.fireL_),a
1
              call .endINTlt
              call .Ddisp_
              ld (.notMV),a
             jr z,1F            ;    
              xor a
              ld (.fireL_),a
1             ld a,0
.Pfire   EQU $-1
              or a
             jr nz,2F
              or 0
.notMV    EQU $-1
             jr z,.endINT
              call .resCUR
             jr .endINTc

2             call .resCUR
              ld a,0
.fireL_   EQU $-1         ;        
              or a
             jr nz,.endINTc
              inc a
              ld (.fireL_),a

              call .CURnorm
              call .drWork

.endINTc      call .endINTst
              call .endINTlt
              call .curOut
              ei
             ret

.endINT       call .endINTst
              ei
             ret

.endINTlt     ld hl,(DarwX)
              ld (.teX),hl
              ld a,(ARW_Y)
              ld (.teY),a
             ret
.endINTst     ld hl,(.teX)
              ld (.lastX),hl
              ld a,(.teY)
              ld (.lastY),a
             ret

.CURnorm
              ld hl,(.teX)
             push hl
              ld a,(.endX)
              neg
              add a,l
              ld (.codeX),a
              and #07
              rrca
              rrca
              rrca       ; *32
              ld l,a
              ld h,0
              ld b,h
              or a
              rla
              rl b       ; *64
              ld c,a
              add hl,bc  ; *96
              ld bc,BRbuff
              add hl,bc
              ld (.tecBuf),hl
              ld bc,16*3-3
              add hl,bc
              ld (.drMSKtec),hl

             pop hl           ; (.teX)
              ld bc,#1000
              ld a,(.teY)
              sub 0
.endY  EQU $-1
              ld (.codeY),a
              ld d,a
             jr nc,1F
              neg
              ld d,c
              ld c,a       ;   Y
1             ld a,192
              sub d
              cp 16
             jr c,1F
              ld a,b
              sub c
1             ld (.curSZY),a
              ld a,c
              ld (.curLMY),a

              ld bc,#0000
.endX  EQU $-2
              xor a
              sbc hl,bc
             jr nc,2F
              inc b
              ld a,8
              add a,l
             jr c,1F
              inc b
1             ld hl,0
             jr  3F
2
              ld a,255
              sub l
              cp 15
             jr nc,3F
              ld b,3
              cp 8
             jr nc,3F
              inc b
3
             ld a,b
              ld (.curLMX),a

             ld a,d
             and 7
             ld h,a
             ld a,l
             rrca
             rrca
             rrca
             and #1F
             ld l,a
             ld a,d
             rlca
             rlca
             ld d,a
             and #E0
             or l
             ld l,a
             ld a,d
             rlca
             rlca
             rlca
             and #18
             or #40
             or h
             ld h,a
             ld (.curAdr),hl
            ret

.TBdraw       DW .drwXOR   ; 0 - XOR
              DW .drwOR    ; 1 - OR
              DW .drwAND   ; 2 - AND
              DW .drwNOP   ; 3 - nop

.Pmask                            ;   
             ld a,(Sieve)
             or a
             call nz,.Psieve
.Pmask1      ld de,DMSKbuff       ; Pixel mask /  
             ld a,0
.codeY   EQU $-1                  ;  Y-  
             and #0F              ;    
             ld b,a
             add a,a
             add a,e
             ld e,a
             ld a,b
             ex af,af'
             ld a,16
             sub b
             ld b,a
             ld hl,Bbuff
             ld a,0
.codeX   EQU $-1                  ;  X-  
             bit 3,a              ;   
            jr nz,.Pmsk_1o

.Pmsk_0o     call .Pmsk_0oo
             ld de,DMSKbuff
             ex af,af'
             ld b,a
             ex af,af'
.Pmsk_0oo    inc b
             dec b
            ret z
1
             ld a,(de)
             ld c,a
             and (hl)
             ld (hl),a
             inc l
             inc e

             ld a,(de)
             and (hl)
             ld (hl),a
             inc l

             ld a,c
             and (hl)
             ld (hl),a
             inc l
             inc e
            djnz 1B
            ret

.Pmsk_1o     call .Pmsk_1oo
             ld de,DMSKbuff
             ex af,af'
             ld b,a
             ex af,af'
.Pmsk_1oo    inc b
             dec b
            ret z
1
             ld a,(de)
             ld c,a
             inc e
             ld a,(de)
             and (hl)
             ld (hl),a
             inc l

             ld a,c
             and (hl)
             ld (hl),a
             inc l

             ld a,(de)
             inc e
             and (hl)
             ld (hl),a
             inc l
            djnz 1B
            ret


.Psieve      call .Psieve_
             ld hl,#00A6         ;  hl = [ and (hl) : nop ]
             ld de,Bbuff+(16*3)-3
            jp .drMSK__

.Psieve_     ld de,DMSKbuff      ; Sieve / 
             ld a,(.codeY)       ;  Y-  
             and #0F              ;    
             ld b,a
             add a,a
             add a,e
             ld e,a
             ld a,b
             ex af,af'
             ld a,16
             sub b
             ld b,a
             ld hl,Bbuff+(16*3)
             ld a,(.codeX)      ;  X-  
             bit 3,a              ;   
            jr nz,.Psiev_1o


.Psiev_0o     call .Psiev_0oo
             ld de,DMSKbuff
             ex af,af'
             ld b,a
             ex af,af'
.Psiev_0oo   inc b
             dec b
            ret z
1
             ld a,(de)
             ld c,a
             or (hl)
             ld (hl),a
             inc l
             inc e

             ld a,(de)
             or (hl)
             ld (hl),a
             inc l

             ld a,c
             or (hl)
             ld (hl),a
             inc l
             inc e
            djnz 1B
            ret

.Psiev_1o     call .Psiev_1oo
             ld de,DMSKbuff
             ex af,af'
             ld b,a
             ex af,af'
.Psiev_1oo   inc b
             dec b
            ret z
1
             ld a,(de)
             ld c,a
             inc e
             ld a,(de)
             or (hl)
             ld (hl),a
             inc l

             ld a,c
             or (hl)
             ld (hl),a
             inc l

             ld a,(de)
             inc e
             or (hl)
             ld (hl),a
             inc l
            djnz 1B
            ret


.drMSK       ld a,(WBrush.FLMsk)
             or a
            ret z
             ld de,BRbuff+(16*3)-3              ; mask
.drMSKtec   EQU $-2
.drMSK__     ld hl,#00A6           ; hl = [ and (hl) : nop ]  /or/  hl = [ cpl : or (hl) ]
.drMSK_1     ld (.drwmd),hl
            jp .curOTM



.drwAND     ld hl,#A62F          ; hl = [ cpl : and (hl) ]
            ld bc,.drMSK
            ld de,#B62F          ; de = [ cpl : or (hl) ]
           jr 3F
.drwXOR     ld bc,Ret
            ld hl,#00AE          ; hl = [ xor (hl) : nop ]
           jr 2F
.drwOR      ld hl,#00B6          ; hl = [ or (hl) : nop ]
           jr 1F
.drwNOP     ld hl,#007E          ; hl = [ ld a,(hl) : nop ]

1             ld bc,.drMSK
2             ld de,#00A6        ; de = [ and (hl) : nop ]
3             ld (.drwCOM),hl
              ld (.drMSK__+1),de
              ld (.mskXORStop),bc
              ld hl,.clnMxor
              ld de,.defBufXOR
              ld bc,.bplxor

              ld a,(.Mode)
              or a
             jr z,1F

              ld hl,.clnPor
              ld d,h
              ld e,l
              ld bc,.bplor
1             ld (.clnADDR),hl
              ld (.defBufA),de
              ld (.bplADDR),bc
           ret


.stepCH       ld hl,(.teX)      ;   ,      +- 1   
              ld bc,BXbuff
              add hl,bc
              ld a,(hl)
              or a
             jr nz, .stepCHy
              ld b,16
.stpXmg_  EQU $-1
              inc b
              dec b
             ret z
              ld d,h
              ld e,l
1             inc hl
              ld a,(hl)
              or a
             jr nz,3F
              dec de
              ld a,(de)
              or a
             jr nz,2F
            djnz 1B
.stepCHz      xor a     ; set Z flag
             ret
2             ex de,hl
3             ld bc,BXbuff
              xor a
              sbc hl,bc
             jr c,.stepCHz
              ld (.teX),hl

.stepCHy      ld h, high BYbuff
              ld a,(.teY)
              ld l,a
              ld a,(hl)
              or a
             ret nz

              ld b,16
.stpYmg_  EQU $-1
              inc b
              dec b
             ret z
              ld d,h
              ld e,l
1             inc l
              ld a,(hl)
              or a
             jr nz,3F
              dec e
              ld a,(de)
              or a
             jr nz,2F
            djnz 1B
             xor a
            ret
2             ld l,e
3             ld a,l
              cp 224
             jr nc,.stepCHz
              ld (.teY),a
              ld a,#FF
              or a
             ret





.drWork
             ld a,1            ;     .
             ld (.fl_undo),a

              ld a,0
.flnewFr  EQU $-1    ;    
             or a
            jp nz,.notSmooth
.csmoothA  EQU $-2
             inc a
             ld (.flnewFr),a
             call .stepCH
            ret z
             call .Ddisp_
             call .CURnorm
             call .clnMxor  ; .clnPor
.clnADDR   EQU $-2
            jp .drwPlot_

.yesSmooth   call .defLine_
            jr c, 1F

             call  MOUSDR.res           ;   
             ld hl,(.lastX)

             ld (DarwX),hl
             ld (.teX),hl

             ld a,(.lastY)
             ld (ARW_Y),a
             ld (.teY),a
            ret
1
             ld hl,(.lastX)
             ld (.teX),hl
             ld (.lt0X),hl
             ld a,(.lastY)
             ld (.teY),a
             ld (.lt0Y),a

             ld de,#6080
             ld a,(.LdX)
             add a,e
             ld l,a
             ld a,(.LdY)
             add a,d
             ld h,a
            jp LINE.lineN

.bplxor       call .stepCH
             ret nz
              pop af           ;  
              ld a,#C9         ; ret
              ld (.drwMxor),a
              call .Ddisp_
              call .CURnorm
              call .defBufXOR
              ld a,#21         ; ld hl,**
              ld (.drwMxor),a
             ret
.bplor        call .stepCH
             ret nz
              pop af           ;  
             ret

.Bplot       ; e- xd, d - yd
              ld a,(.teY)
              ld (.lastY),a

              ld a,d
              sub #60
              add a,0
.lt0Y     EQU $-1
              ld (.teY),a

              ld hl,(.teX)
              ld b,h
              ld c,l

              ld d,0
              ld hl,0
.lt0X     EQU $-2
              ld a,e
              sub #80
              ld e,a
             jr nc,1F
              dec d
1             add hl,de
              ld (.teX),hl
              ld (.lastX),bc
.notSmooth
              call .bplxor    ; / call .bplor -   or/and
.bplADDR    EQU $-2
              call .Ddisp_
             ret z
              call .CURnorm

.drwPlot
              call .defBufXOR
.defBufA    EQU $-2

.drwPlot_

            call .drMSK
.mskXORStop   EQU $-2
            call .Pmask

            ld hl,0
.drwCOM    EQU $-2
            ld (.drwmd),hl
            ld a,#1A             ;  a=ld a,(de) or a=ret  define norgb mode
.drwNOrgb  EQU $-1
            ld (.drwcolret),a
           jp .curOt__



.defLine_   ld c,24
            jr .defLine_0
.defLine     ld c,16
.defLine_0   ld hl,0
.LdX   EQU $-2              ;      X
             ld a,h
             or a
             ld a,l
            jr z,2F
             bit 7,h
           jr nz,1F
             or a
            ret
1            neg
2            cp c
            ret nc

             ld a,0
.LdY   EQU $-1              ;      Y
             ld b,a
             bit 7,a
            jr z,1F
             neg
1            cp c
            ret nc
             ld c,a
            ret    ; out nc - if >=16 or b - dy , c- |dy| , l - dx


.clnPor     ld hl,(.tecBuf)            ;  or,and,nop    
            ld de,Bbuff+(16*3)         ;  Pmask
            ld bc,Bbuff
            exx
            ld b,16*3
1             exx
              ld a,(hl)
              ld (bc),a
              cpl
              ld (de),a
              inc hl
              inc e
              inc c
              exx
             djnz 1B
            exx
           ret

.clnMxor    ld hl,Bbuff+(16*6)       ;  ;   
            ld (hl),0
            ld de,Bbuff+(16*6)+1
            ld bc,16*3-1
            ldir
           jp .drwMxor

.defBufXOR    call .defLine
             jr nc,.clnMxor

              ld a,c
              add a,a
              add a,c       ; *3
              ld c,a
              dec a
              ex af,af'
              ld a,16*3
              sub c
              bit 7,b
               ld b,0
               push af
             jr nz, 1F

              ld hl,Bbuff+(16*6)     ;   
              ld d,h
              ld e,l
              add hl,bc
               pop af
               ld c,a
              ldir
               ex af,af'
              ld c,a
              ld l,e
              inc e
              ld (hl),b
              ldir
             jr 2F

1             ld hl,Bbuff+(16*6)+47   ;   
              ld d,h
              ld e,l
              or a
              sbc hl,bc
               pop af
               ld c,a
              lddr
               ex af,af'
              ld c,a
              ld l,e
              dec e
              ld (hl),b
              lddr
2

             ld a,0
.LdX8  EQU $-1
             or a
            jr z,.drwMxor
             bit 7,a
            jr z, 3F
              neg             ; x1<x0   ; -->
              ld c,a
1             ld b,16
              ld hl,Bbuff+(16*6)+47   ;    
              ld de,Bbuff+(16*6)+46

2             ld a,(de)
              ld (hl),a
              dec l
              dec e
              ld a,(de)
              ld (hl),a
              dec l
              dec e
              ld (hl),0
              dec l
              dec e
             djnz 2B
              dec c
             jr nz,1B
             jr .drwMxor

3
              ld c,a     ; x1>x0   ; <--
1             ld b,16
              ld hl,Bbuff+(16*6)     ;    
              ld de,Bbuff+(16*6)+1

2             ld a,(de)
              ld (hl),a
              inc l
              inc e
              ld a,(de)
              ld (hl),a
              inc l
              inc e
              ld (hl),0
              inc l
              inc e
             djnz 2B
              dec c
             jr nz,1B


.drwMxor    ld hl,Bbuff      ; / ret  ; .      ;   
            ld de,Bbuff+(16*6) ;  
            ld bc,Bbuff+(16*3) ;   
            exx
            ld b,16*3
            ld hl,(.tecBuf)       ;  
1           exx
              ld a,(de)
              cpl
             exx
              and (hl)
              inc hl
             exx
              ld (hl),a
              cpl
              ld (bc),a
              ld a,(de)
              or (hl)
              ld (de),a
              inc e
              inc l
              inc c
            exx
           djnz 1B
            exx
           ret


.resCUR       ld a,0
.curFl    EQU $-1
              or a
             ret z
.curOut       ld a,(.curFl)
1             cpl
              ld (.curFl),a
              or a
              call nz,.CURnorm
              ld a,#C9             ; a=ret
              ld (.drwcolret),a
              ld hl,#00AE          ; hl = [ xor (hl) : nop ]
              ld (.drwmd),hl
              ld de,BRbuff
.tecBuf    EQU $-2
              dec de
              dec de
              dec de
            jr .curOTM

.curOt__     ld de,Bbuff-3
.curOTM      ld hl,0
.curAdr    EQU $-2
             ld b,0
.curLMY    EQU $-1     ;   
             inc b
1            inc de
             inc de
             inc de
            djnz 1B

             ld b,0
.curSZY    EQU $-1

             ld a,0
.curLMX    EQU $-1
             or a
            jr nz,2F

1            call .drawpx       ;   0
             inc de
             inc l

             call .drawpx
             inc de
             inc l

             call .drawpx
             inc de
             dec l
             dec l
             call INC_Y
            djnz 1B
            ret

2           dec a
           jr nz,2F

1            inc de       ;     1
             call .drawpx
             inc de
             inc l

             call .drawpx
             inc de
             dec l
             call INC_Y
            djnz 1B
            ret

2            dec a
            jr nz,2F

1            inc de       ;  2-   2
             inc de
             call .drawpx
             inc de
             call INC_Y
            djnz 1B
            ret

2            dec a
            jr nz,2F

1            call .drawpx       ;     3
             inc de
             inc l

             call .drawpx
             inc de
             dec l
             inc de
             call INC_Y
            djnz 1B
            ret
2
1            call .drawpx       ;  2-   4
             inc de
             inc de
             inc de
             call INC_Y
            djnz 1B
            ret


.drawpx
             ld a,(de)
.drwmd       xor (hl)   ;     
             nop
             ld (hl),a
.drwcolret  ret             ; ret / ld a,(de)
             or a
            ret z
             ld c,h
             ld a,h
             rrca
             rrca
             rrca
             and #03
             or #58
             ld h,a
             ld a,(hl)
             and 0
.drwcol1  EQU  $-1    ;   MASKRGB
             or 0
.drwcol2  EQU $-1     ;   REALRGB or MASKRGB xor MASKRGB
             ld (hl),a
             ld h,c
            ret


.DrInt_X          ;  
             ld a,(ARW_X)     ;   2-  
             ld l,a
             ld b,0
             ld h,b
             ld a,(.szX)
             or a
             rra
             add a,l
             rl h
             ld l,a
             ld a,(.startX)
             ld c,a
             or a
             sbc hl,bc
            jr nc,1F
             ld h,b
             ld l,b
1            ld (DarwX),hl
.DrIntXY                        ;    
             xor a
             ld (.curFl),a
             ld (DIRECT),a
             xor a
             ld (.flnewFr),a  ;   
             inc a
             ld (.notMV),a    ;  
             ld hl,(DarwX)
             ld (.teX),hl
             ld a,0
.szY     EQU $-1
             add a,191
             ld (ARWYMX),a
             ld a,(ARW_Y)
             ld (.teY),a
             ld a,0
.szX     EQU $-1
             dec a
             ld (DarwXM),a
             call .CURnorm
            ret




.DBrush    DB 0,0,32,24,0,0,%11000    ;    
           DB 0
           DW Nil              ; -
           DW Nil              ; - ()
           DW .HDraw           ;  
           DW #0005            ;   5 
           DW .DrawInt         ;   ""
           DW #FFFF

; -  (hotkeys object)
.HDraw
        DB "C",0           ; C - RGB Colour
         DW 0
        DB "N",0           ; N - No RGB
         DW 1
        DB "K",0           ; K - miniRGB
         DW 2

        DB "L",0           ; L - last  (cancel last do)
         DW 3
        DB "Z",0           ; Z - last  (cancel last do)
         DW 3
        DB "S",0            ;   - Smooth +/-
         DW 4

        DB "1",0           ; 1 - xor
         DW 5
        DB "2",0           ; 2 - or
         DW 6
        DB "3",0           ; 3 - and
         DW 7
        DB "4",0           ; 4 - nop
         DW 8
        DB CS,"U"          ; Cs/U - load Undo
         DW 9
        DB "U",0           ; U - swap at Undo
         DW 10
        DB CS,"Y"          ; CS/Y - Save to Undo
         DW 11

        DB "M",0            ;   - Mask +/-
         DW 12

        DB #FF




.er_Embrs    DB 8,9,16,5,2*8+6,6,%1111
             DB 0
             DW .T_emBrs           ; 
             DW #FFFF

.T_emBrs     MSG_ERROR : DB 13
             MSG_BRUSH_emptyER
             DB 0



WBrush       DB 6,2,25,19,5*8,5,%1111
             DB 0
             DW .TBrs              ; 
             DW .SBrs              ; 
             DW .HBrs              ;  
             DW .BBrs              ; - ()
             DW .FlBrs             ; -
             DW Nil                ; - 
             DW Nil                ; 
             DW .BrsCr             ;   
  ;           DW .BrsInt            ;   ""
             DW #FFFF


.TBrs        MSG_BRUSH_head : DB 13,13,13,15,13,13,13,13,13,13,15,13,13,15,13,22,1,12
             MSG_DISK_Load  : DB 13,22,8,12 : MSG_DISK_Save : DB 13,22,16,12 : MSG_LOUPE_Smooth
             DB 13,22,6,17
             MSG_EDITS_Slot : DB 13
             DB 22,1,17,"Msk",13,22,11,17 : MSG_WIN_Mode
.Tmode       DB "012"
             DB 13,22,19,17
             MSG_BRUSH_Draw
             DB 0

.SBrs        DB 1,3,128+24,2,%11,3,2,2,2,8      ;    () [0-7]
             DB 1,6,128+24,6,%11,3,3,2,2,15     ;    () [8-22]
             DB 1,12,6,1,%11   ; 0 open
             DB 8,12,7,1,%11   ; 1 save
             DB 16,12,8,1,%11  ; 2 smooth +/-
             DB 6,14,4,2,%11   ; 3 steps / distances
             DB 6,17,4,1,%11   ; 4 to set
             DB 1,17,4,1,%11   ; 5 msk +/-
             DB 11,17,7,1,%11  ; 6 mode
             DB 19,17,5,1,%11  ; 7 draw
             DB #FF

.HBrs
         DB "C",0           ; C - RGB Colour
          DW 33
         DB "1",0           ; 1 - xor
          DW 38
         DB "2",0           ; 2 - or
          DW 39
         DB "3",0           ; 3 - and
          DW 40
         DB "4",0           ; 4 - nop
          DW 41
         DB #FF

.BBrs
          DB 22,14,2,2,6,%11  ; brush
          DW BRUSHS

          DB 11,14,2,2,7,%11  ; no rgb
.norgbC  EQU $-2
          DW NORGBS

          DB 14,14,2,2,6,%11    ; rgb
          DW RGBS
          DB 16,14,2,2,7,%00    ; dt
.dtcol  EQU $-2
          DW  DTRS
          DB 19,14,2,2,6,%11    ; Pmask
.pmskCol EQU $-2
          DW PMSKBUFF
          DB 1,14,2,2,7,%11       ; Edit brush
          DW BrsBOOF.spr
          DB 3,14,2,2,7,%11       ; Edit msk
          DW BrsBOOF.msk

        DB #FF

.FlBrs      DB 4,17,5+23,#00
.FLMsk    EQU $-1
            DW Nil
            DB 23,12,2+23,#00
.FlSmooth EQU $-1
            DW Nil
           DB #FF

.ixedbox   DB 0,0,2,2

.stX       DB "000/"
.stY       DB "000/"
.dsX       DB "000/"
.dsY       DB "000"

.cnvTsd    ld hl,BrsBOOF.sx  ;    
           ld de,.stX
           ld b,4
1          push hl,de,bc
           ld a,(hl)
           call PDEC
           pop bc,de,hl
           inc hl
           inc de
           inc de
           inc de
           inc de
          djnz 1B
          ret


.BrsCr     call .cnvTsd
           ld bc,#0103
           ld de,Brs_ne
           ld hl,0
           ld a,8
           call .otSbrs

           ld bc,#0106
           ld de,Brs_64+4
           ld hl,36
           ld a,15
           call .otSbrs

           ld de,#010E
           call RealWin
           ld h,e
           ld l,d
           push hl       ;    /
           ld d,h
           ld e,l
           call RASCH_
           ld (.prnSD),hl
           call DEC_Y
           call DEC_Y
           dec l
           call .rmEud
           ld b,18
1          ld e,l
           ld a,(hl)
           or %00000010
           ld (hl),a
           ld a,5
           add a,l
           ld l,a
           ld (hl),%01000000
           ld l,e
           call INC_Y
          djnz 1B
           call .rmEud
           pop hl
           ld bc,5
           add hl,bc
           ld (.sd_ix),hl
           ld hl,0
.prnSD  EQU $-2
           add hl,bc
           push hl
           ld bc,#1000
1          push hl
           ld (hl),c
           inc l
           ld (hl),c
           inc l
           ld (hl),c
           inc l
           ld (hl),c
           pop hl
           call INC_Y
          djnz 1B
           push ix
           ld ix,.sd_ix
           ld de,.sd_spr
           call LoadWS
           pop ix
           pop hl
           inc h
           push hl
           ld de,.stX
           call OFC.evry   ; in 'Coord1.asm'
           pop hl
           ld a,l
           add a,32
           ld l,a
          jr nc,1F
           ld a,h
           add a,8
           ld h,a
1          ld de,.dsX
           call OFC.evry   ; in 'Coord1.asm'
          ret

.rmEud     push hl
           ld a,(hl)
           or %00000011
           ld (hl),a
           inc l
           ld (hl),#FF
           inc l
           ld (hl),#FE
           inc l
           ld (hl),#7F
           inc l
           ld (hl),#FF
           inc l
           ld (hl),%11000000
           pop hl
           call INC_Y
          ret

.otSbrs    push hl       ; in bc - xy, de - addr sprts, hl - empty bytes, a numbers of sprts
           push de
        ;   push af
           ld d,b
           ld e,c
           call RealWin
           ld h,e
           ld l,d
           ld (.bix),hl
        ;   pop af
           pop de
           pop hl
           push ix
           ld ix,.bix
           ld c,a
           ld a,8
           call WSseries
           pop ix
          ret

.bix    DB 0,0,2,2,3,3,7    ;   
.sd_ix   DB 0,0,1,2
.sd_spr  DB 0,0,0,96,192,96,192,0     ;   s,d
         DB 0,0,0,192,160,160,192,0

.Wsel15      DB 0,0,25,9,5*8,5,%1111
             DB 0
             DW .Tsel15              ; 
             DW .Ssel15              ; 
             DW #0005                ;  5 
             DW .sel15Cr             ;   
             DW #FFFF

.Tsel15      MSG_BRUSH_storeIn : DB 13,0

.Ssel15      DB 1,3,128+24,6,%11,3,3,2,2,15     ;   () [0-14]
             DB #FF

.sel15Cr     ld bc,#0103
             ld de,Brs_64+4
             ld hl,36
             ld a,15
            jp .otSbrs


.WStDp  DB 0,0,7,11,6*8,6,%00001110
        DB 0
        DW .TStDp         ; -
        DW .SStDp         ; - ()
        DW .HStDp         ;  
        DW #FFFF

.TStDp   MSG_BRUSH_Step : DB 13,13
         DB "SX: "
.T_stX   DB "00",13
         DB "SY: "
.T_stY   DB "00",13,15,13
         MSG_BRUSH_Disp : DB 13,13
         DB "DX: "
.T_dsX   DB "00",13
         DB "DY: "
.T_dsY   DB "00"
         DB 0

.SStDp       DB 1,3,5,1,%11   ; 0 s x
             DB 1,4,5,1,%11   ; 1 s y
             DB 1,8,5,1,%11   ; 2 d x
             DB 1,9,5,1,%11   ; 3 d y
             DB #FF

.HStDp       DB "Z",0       ; 
              DW 4
             DB #FF

.WStDpS   DB 0,0,4,18,7*8,7,%00001110
          DB 0
          DW .TStDpS        ; -
          DW .SStDpS        ; - ()
          DW #FFFF

.TStDpS   DB "0",13,"1",13,"2",13,"3",13,"4",13,"5",13,"6",13,"7",13
          DB "08",13,"09",13,"10",13,"11",13,"12",13,"13",13,"14",13,"15",0

.SStDpS   DB 1,1,2,128+16,%11
          DB #FF


.Wmods    DB 0,0,4,6,7*8,7,%00001110
          DB 0
          DW .Tmods        ; -
          DW .Smods         ; - ()
          DW #FFFF

.Tmods
         DB  "XOR",13
         DB  "OR ",13
         DB  "AND",13
         DB  "NOP",0

.Smods   DB 1,1,2,128+4,%11
         DB #FF

;-------------------------------------------------------------------------------

Brs_ne     ;  

.b0       DB 0,0,0,0,0,0,0,0
          DB 0,0,0,0,0,0,1,0
          DB 0,0,0,0,0,0,0,0
          DB 0,0,0,0,0,0,0,0
.b1       DB 0,0,0,0,0,0,0,0
          DB 0,0,0,0,0,0,1,128
          DB 1,128,0,0,0,0,0,0
          DB 0,0,0,0,0,0,0,0
.b2       DB 0,0,0,0,0,0,0,0
          DB 0,0,0,0,3,192,3,192
          DB 3,192,3,192,0,0,0,0
          DB 0,0,0,0,0,0,0,0
.b3       DB 0,0,0,0,0,0,0,0
          DB 0,0,7,224,7,224,7,224
          DB 7,224,7,224,7,224,0,0
          DB 0,0,0,0,0,0,0,0
.b4       DB 0,0,0,0,0,0,0,0
          DB 15,240,15,240,15,240,15,240
          DB 15,240,15,240,15,240,15,240
          DB 0,0,0,0,0,0,0,0
.b5       DB 0,0,0,0,0,0,0,0
          DB 0,0,0,0,1,128,3,192
          DB 3,192,1,128,0,0,0,0
          DB 0,0,0,0,0,0,0,0
.b6       DB 0,0,0,0,0,0,0,0
          DB 3,128,7,192,15,224,15,224
          DB 15,224,7,192,3,128,0,0
          DB 0,0,0,0,0,0,0,0
.b7       DB 0,0,0,0,0,0,0,0
          DB 3,192,7,224,15,240,15,240
          DB 15,240,15,240,7,224,3,192
          DB 0,0,0,0,0,0,0,0


BrsBOOF         ;   
.sx        DB 0       ; step X /    
.sy        DB 0       ; step Y
.dx        DB 7       ; dist X /      
.dy        DB 7       ; dist Y

.spr       DB 0,0,0,0,0,0,0,0
           DB 3,192,7,224,15,240,15,240
           DB 15,240,15,240,7,224,3,192
           DB 0,0,0,0,0,0,0,0

.msk       DB #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF
           DB #FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF,#FF


;--------   ----------------

;  
Brs_sv    DB "BRSx"              ; ;    ,       4-  (1024 )
Brs_64                           ;    
                                 ;  :  4  -   , 32 - , 32 - 


LBrs    EQU $-BrushOvb               ; Brs_64-BrushOvb

       DISPLAY "Brush len   :",/a,LBrs
       DISPLAY "Brush Free  :",/a,BRbuff-1020-$
       ASSERT Brs_64 < (BRbuff-1020)  ;    

       ; [>+<]